/*
 * Decompiled with CFR 0.152.
 */
package emasher.packethandling;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import emasher.packethandling.Handlers;
import emasher.packethandling.NetworkUtilities;
import emasher.tileentities.TileSocket;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fluids.FluidStack;

public class SocketFluidMessage
implements IMessage {
    public byte[] msg;
    byte tank;
    TileSocket ts;

    public SocketFluidMessage() {
    }

    public SocketFluidMessage(TileSocket ts, byte tank) {
        this.ts = ts;
        this.tank = tank;
    }

    public void fromBytes(ByteBuf buf) {
        this.msg = new byte[buf.capacity()];
        buf.readBytes(this.msg);
    }

    public void toBytes(ByteBuf buf) {
        buf.capacity(27);
        FluidStack l = this.ts.tanks[this.tank].getFluid();
        int id = -1;
        int meta = 0;
        int amnt = 0;
        byte[] out = new byte[27];
        out[0] = 2;
        if (l != null) {
            id = l.getFluidID();
            meta = 0;
            amnt = l.amount;
        } else {
            id = -1;
            meta = 0;
            amnt = 0;
        }
        NetworkUtilities.toByte(out, this.ts.field_145851_c, 1);
        NetworkUtilities.toByte(out, this.ts.field_145848_d, 5);
        NetworkUtilities.toByte(out, this.ts.field_145849_e, 9);
        NetworkUtilities.toByte(out, id, 13);
        NetworkUtilities.toByte(out, meta, 17);
        NetworkUtilities.toByte(out, amnt, 22);
        out[26] = this.tank;
        buf.writeBytes(out);
        this.msg = out;
    }

    public static class Handler
    implements IMessageHandler<SocketFluidMessage, IMessage> {
        public IMessage onMessage(SocketFluidMessage message, MessageContext ctx) {
            Handlers.onSocketFluidMessage(message, ctx);
            return null;
        }
    }
}

