/*
 * Decompiled with CFR 0.152.
 */
package emasher.tileentities;

import buildcraft.api.transport.IPipeTile;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import emasher.EngineersToolbox;
import emasher.api.IGasReceptor;
import emasher.api.ModuleRegistry;
import emasher.api.SideConfig;
import emasher.api.SocketModule;
import emasher.api.SocketTileAccess;
import emasher.blocks.Blocks;
import emasher.microcontrollers.LuaScript;
import emasher.modules.ModMachineOutput;
import emasher.packethandling.RequestInfoFromServerMessage;
import emasher.packethandling.SocketFluidMessage;
import emasher.packethandling.SocketItemMessage;
import emasher.packethandling.SocketStateMessage;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileSocket
extends SocketTileAccess
implements ISidedInventory,
IFluidHandler,
IEnergyHandler,
IGasReceptor {
    public FluidTank[] tanks = new FluidTank[3];
    public EnergyStorage capacitor;
    public InventoryBasic inventory;
    public boolean[] rsControl = new boolean[3];
    public boolean[] rsLatch = new boolean[3];
    public int[] sides;
    public SideConfig[] configs;
    public boolean[] sideRS;
    public boolean initialized = false;
    public int[] sideID;
    public int[] sideMeta;
    public boolean[] sideLocked = new boolean[6];
    public int[] facID = new int[6];
    public int[] facMeta = new int[6];
    public boolean isRSShared = false;
    private boolean luaInit = false;
    private boolean loaded = false;
    public int scriptStack = 0;
    public LuaScript genericScript = null;
    public LuaScript circuitScript = null;
    public LuaScript latchScript = null;

    public TileSocket() {
        int i;
        for (i = 0; i < 3; ++i) {
            this.tanks[i] = new FluidTank(8000);
            this.rsControl[i] = false;
            this.rsLatch[i] = false;
        }
        this.inventory = new InventoryBasic("socket", true, 3);
        this.sideInventory = new InventoryBasic("socketSide", true, 6);
        this.capacitor = new EnergyStorage(5000);
        this.sides = new int[6];
        this.configs = new SideConfig[6];
        this.sideRS = new boolean[6];
        for (i = 0; i < 6; ++i) {
            this.sides[i] = 0;
            this.configs[i] = new SideConfig();
            this.sideRS[i] = false;
            this.sideLocked[i] = false;
            this.facID[i] = 0;
            this.facMeta[i] = 0;
        }
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            for (int i = 0; i < 6; ++i) {
                ForgeDirection d = ForgeDirection.getOrientation((int)i);
                SocketModule m = this.getSide(d);
                SideConfig c = this.configs[i];
                if (this.loaded && !this.luaInit) {
                    m.onSocketLoad(c, this, d);
                }
                m.updateSide(c, this, d);
            }
            if (this.loaded && !this.luaInit) {
                this.luaInit = true;
            }
        }
        if (!this.initialized && this.field_145850_b != null) {
            if (!this.field_145850_b.field_72995_K) {
                this.sideID = new int[6];
                this.sideMeta = new int[6];
                for (int i = 0; i < 6; ++i) {
                    this.sideID[i] = -1;
                    this.sideMeta[i] = -1;
                    this.checkSideForChange(i);
                }
            }
            this.initialized = true;
        }
    }

    public void updateAllAdj() {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection d = ForgeDirection.getOrientation((int)i);
            this.updateAdj(d);
        }
    }

    @Override
    public void updateAdj(ForgeDirection d) {
        Block nblock = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        int xo = this.field_145851_c + d.offsetX;
        int yo = this.field_145848_d + d.offsetY;
        int zo = this.field_145849_e + d.offsetZ;
        Block b = this.field_145850_b.func_147439_a(xo, yo, zo);
        if (b != null) {
            b.func_149695_a(this.field_145850_b, xo, yo, zo, nblock);
        }
    }

    public void resetConfig(int side) {
        this.configs[side] = new SideConfig();
        this.sideLocked[side] = false;
        this.sideInventory.func_70299_a(side, null);
        EngineersToolbox.network().sendToDimension((IMessage)new SocketStateMessage(this, (byte)side), this.field_145850_b.field_73011_w.field_76574_g);
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (this.field_145850_b.field_72995_K) {
            int i;
            for (i = 0; i < 6; ++i) {
                EngineersToolbox.network().sendToServer((IMessage)new RequestInfoFromServerMessage(this, (byte)i, 0));
            }
            for (i = 0; i < 3; ++i) {
                EngineersToolbox.network().sendToServer((IMessage)new RequestInfoFromServerMessage(this, (byte)i, 1));
                EngineersToolbox.network().sendToServer((IMessage)new RequestInfoFromServerMessage(this, (byte)i, 2));
            }
        } else {
            int i;
            for (i = 0; i < 6; ++i) {
                this.sendClientSideState(i);
            }
            for (i = 0; i < 3; ++i) {
                this.sendClientInventorySlot(i);
                this.sendClientTankSlot(i);
            }
        }
    }

    public void func_145839_a(NBTTagCompound data) {
        int slot;
        int i;
        super.func_145839_a(data);
        if (data.func_74764_b("shareRS")) {
            this.isRSShared = data.func_74767_n("shareRS");
        }
        for (int i2 = 0; i2 < 3; ++i2) {
            if (data.func_74764_b("tankCap" + i2)) {
                this.tanks[i2] = new FluidTank(data.func_74762_e("tankCap" + i2));
            }
            if (data.func_74764_b("Fluid" + i2)) {
                this.tanks[i2].setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)data.func_74775_l("Fluid" + i2)));
            }
            if (data.func_74764_b("rsControl" + i2)) {
                this.rsControl[i2] = data.func_74767_n("rsControl" + i2);
            }
            if (!data.func_74764_b("rsLatch" + i2)) continue;
            this.rsLatch[i2] = data.func_74767_n("rsLatch" + i2);
        }
        NBTTagList itemList = data.func_150295_c("items", 10);
        for (i = 0; i < itemList.func_74745_c(); ++i) {
            NBTTagCompound itemCompound = itemList.func_150305_b(i);
            slot = itemCompound.func_74762_e("slot");
            this.inventory.func_70299_a(slot, ItemStack.func_77949_a((NBTTagCompound)itemCompound));
        }
        for (i = 0; i < 6; ++i) {
            if (data.func_74764_b("side" + i)) {
                int loadedSide = data.func_74762_e("side" + i);
                this.sides[i] = loadedSide != 11 && loadedSide != 12 ? loadedSide : 0;
            }
            if (data.func_74764_b("config" + i)) {
                this.configs[i] = new SideConfig();
                this.configs[i].readFromNBT(data.func_74775_l("config" + i));
            }
            if (data.func_74764_b("rs" + i)) {
                this.sideRS[i] = data.func_74767_n("rs" + i);
            }
            if (data.func_74764_b("lock" + i)) {
                this.sideLocked[i] = data.func_74767_n("lock" + i);
            }
            if (data.func_74764_b("facID" + i)) {
                this.facID[i] = data.func_74762_e("facID" + i);
            }
            if (!data.func_74764_b("facMeta" + i)) continue;
            this.facMeta[i] = data.func_74762_e("facMeta" + i);
        }
        itemList = data.func_150295_c("sideItems", 10);
        for (i = 0; i < itemList.func_74745_c(); ++i) {
            NBTTagCompound itemCompound = itemList.func_150305_b(i);
            slot = itemCompound.func_74762_e("slot");
            this.sideInventory.func_70299_a(slot, ItemStack.func_77949_a((NBTTagCompound)itemCompound));
        }
        this.capacitor.readFromNBT(data);
        int power = this.capacitor.getEnergyStored();
        if (data.func_74764_b("powerCap2")) {
            this.setMaxEnergyStored(data.func_74762_e("powerCap2"));
        }
        if (data.func_74764_b("realPower")) {
            power = data.func_74762_e("realPower");
        }
        this.capacitor.setEnergyStored(power);
        this.loaded = true;
    }

    public void func_145841_b(NBTTagCompound data) {
        NBTTagCompound itemCompound;
        int i;
        super.func_145841_b(data);
        for (int i2 = 0; i2 < 6; ++i2) {
            ForgeDirection side = ForgeDirection.getOrientation((int)i2);
            SocketModule m = this.getSide(side);
            SideConfig config = this.configs[i2];
            m.onSocketSave(config, this, side);
        }
        NBTTagList itemList = new NBTTagList();
        NBTTagList sideItemList = new NBTTagList();
        data.func_74757_a("shareRS", this.isRSShared);
        for (i = 0; i < 3; ++i) {
            if (this.inventory.func_70301_a(i) != null) {
                itemCompound = new NBTTagCompound();
                itemCompound.func_74768_a("slot", i);
                this.inventory.func_70301_a(i).func_77955_b(itemCompound);
                itemList.func_74742_a((NBTBase)itemCompound);
            }
            if (this.tanks[i].getFluid() != null) {
                data.func_74768_a("tankCap" + i, this.tanks[i].getCapacity());
                data.func_74782_a("Fluid" + i, (NBTBase)this.tanks[i].getFluid().writeToNBT(new NBTTagCompound()));
            }
            data.func_74757_a("rsControl" + i, this.rsControl[i]);
            data.func_74757_a("rsLatch" + i, this.rsLatch[i]);
        }
        data.func_74782_a("items", (NBTBase)itemList);
        for (i = 0; i < 6; ++i) {
            data.func_74768_a("side" + i, this.sides[i]);
            NBTTagCompound configData = new NBTTagCompound();
            this.configs[i].writeToNBT(configData);
            data.func_74782_a("config" + i, (NBTBase)configData);
            data.func_74757_a("rs" + i, this.sideRS[i]);
            data.func_74757_a("lock" + i, this.sideLocked[i]);
            data.func_74768_a("facID" + i, this.facID[i]);
            data.func_74768_a("facMeta" + i, this.facMeta[i]);
            if (this.sideInventory.func_70301_a(i) == null) continue;
            itemCompound = new NBTTagCompound();
            itemCompound.func_74768_a("slot", i);
            this.sideInventory.func_70301_a(i).func_77955_b(itemCompound);
            sideItemList.func_74742_a((NBTBase)itemCompound);
        }
        data.func_74782_a("sideItems", (NBTBase)sideItemList);
        if (this.capacitor != null) {
            data.func_74768_a("realPower", this.capacitor.getEnergyStored());
            this.capacitor.writeToNBT(data);
            data.func_74768_a("powerCap2", this.capacitor.getMaxEnergyStored());
        }
    }

    @Override
    public SocketModule getSide(ForgeDirection direction) {
        SocketModule result = ModuleRegistry.getModule(0);
        SocketModule temp = null;
        if (direction.ordinal() < 6) {
            temp = ModuleRegistry.getModule(this.sides[direction.ordinal()]);
        }
        if (temp != null) {
            result = temp;
        }
        return result;
    }

    @Override
    public SideConfig getConfigForSide(ForgeDirection direction) {
        if (direction != ForgeDirection.UNKNOWN) {
            return this.configs[direction.ordinal()];
        }
        return null;
    }

    public void lockSide(int side) {
        this.sideLocked[side] = !this.sideLocked[side];
        EngineersToolbox.network().sendToDimension((IMessage)new SocketStateMessage(this, (byte)side), this.field_145850_b.field_73011_w.field_76574_g);
    }

    public void checkSideForChange(int side) {
        ForgeDirection d = ForgeDirection.getOrientation((int)side);
        SocketModule m = this.getSide(d);
        int xo = this.field_145851_c + d.offsetX;
        int yo = this.field_145848_d + d.offsetY;
        int zo = this.field_145849_e + d.offsetZ;
        boolean result = false;
        Block block = this.field_145850_b.func_147439_a(xo, yo, zo);
        int id = Block.func_149682_b((Block)block);
        int meta = this.field_145850_b.func_72805_g(xo, yo, zo);
        if (id != this.sideID[side] && this.sideID[side] != 1 || meta != this.sideMeta[side] && this.sideMeta[side] != -1) {
            m.onAdjChangeSide(this, this.configs[side], d);
        }
        this.sideID[side] = id;
        this.sideMeta[side] = meta;
    }

    public int tankIndicatorIndex(int side) {
        SideConfig c = this.configs[side];
        int temp = c.tank == -1 ? 3 : c.tank;
        return temp;
    }

    public int inventoryIndicatorIndex(int side) {
        SideConfig c = this.configs[side];
        int temp = c.inventory == -1 ? 3 : c.inventory;
        return temp;
    }

    public int rsIndicatorIndex(int side) {
        SideConfig c = this.configs[side];
        int temp = 0;
        if (c.rsControl[0]) {
            temp |= 1;
        }
        if (c.rsControl[1]) {
            temp |= 2;
        }
        if (c.rsControl[2]) {
            temp |= 4;
        }
        return temp;
    }

    public int latchIndicatorIndex(int side) {
        SideConfig c = this.configs[side];
        int temp = 0;
        if (c.rsLatch[0]) {
            temp |= 1;
        }
        if (c.rsLatch[1]) {
            temp |= 2;
        }
        if (c.rsLatch[2]) {
            temp |= 4;
        }
        return temp;
    }

    @Override
    public void nextTank(int side) {
        ++this.configs[side].tank;
        if (this.configs[side].tank == 3) {
            this.configs[side].tank = -1;
        }
        this.getSide(ForgeDirection.getOrientation((int)side)).indicatorUpdated(this, this.configs[side], ForgeDirection.getOrientation((int)side));
        EngineersToolbox.network().sendToDimension((IMessage)new SocketStateMessage(this, (byte)side), this.field_145850_b.field_73011_w.field_76574_g);
    }

    @Override
    public void nextInventory(int side) {
        ++this.configs[side].inventory;
        if (this.configs[side].inventory == 3) {
            this.configs[side].inventory = -1;
        }
        this.getSide(ForgeDirection.getOrientation((int)side)).indicatorUpdated(this, this.configs[side], ForgeDirection.getOrientation((int)side));
        EngineersToolbox.network().sendToDimension((IMessage)new SocketStateMessage(this, (byte)side), this.field_145850_b.field_73011_w.field_76574_g);
    }

    @Override
    public void nextRS(int side) {
        boolean reset = false;
        SideConfig c = this.configs[side];
        if (c.rsControl[0]) {
            if (c.rsControl[1]) {
                c.rsControl[1] = false;
                if (c.rsControl[2]) {
                    reset = true;
                    c.rsControl[0] = false;
                    c.rsControl[2] = false;
                } else {
                    c.rsControl[2] = true;
                }
            } else {
                c.rsControl[1] = true;
            }
        }
        if (!reset) {
            this.configs[side].rsControl[0] = !this.configs[side].rsControl[0];
        }
        this.getSide(ForgeDirection.getOrientation((int)side)).indicatorUpdated(this, this.configs[side], ForgeDirection.getOrientation((int)side));
        EngineersToolbox.network().sendToDimension((IMessage)new SocketStateMessage(this, (byte)side), this.field_145850_b.field_73011_w.field_76574_g);
    }

    @Override
    public void nextLatch(int side) {
        boolean reset = false;
        SideConfig c = this.configs[side];
        if (c.rsLatch[0]) {
            if (c.rsLatch[1]) {
                c.rsLatch[1] = false;
                if (c.rsLatch[2]) {
                    reset = true;
                    c.rsLatch[0] = false;
                    c.rsLatch[2] = false;
                } else {
                    c.rsLatch[2] = true;
                }
            } else {
                c.rsLatch[1] = true;
            }
        }
        if (!reset) {
            this.configs[side].rsLatch[0] = !this.configs[side].rsLatch[0];
        }
        this.getSide(ForgeDirection.getOrientation((int)side)).indicatorUpdated(this, this.configs[side], ForgeDirection.getOrientation((int)side));
        EngineersToolbox.network().sendToDimension((IMessage)new SocketStateMessage(this, (byte)side), this.field_145850_b.field_73011_w.field_76574_g);
    }

    @Override
    public void modifyRS(int cell, boolean on) {
        if (this.rsControl[cell] != on) {
            this.rsControl[cell] = on;
            for (int i = 0; i < 6; ++i) {
                SocketModule m = this.getSide(ForgeDirection.getOrientation((int)i));
                m.onRSInterfaceChange(this.configs[i], cell, this, ForgeDirection.getOrientation((int)i), on);
                if (!this.dead) continue;
                return;
            }
        }
    }

    @Override
    public void modifyLatch(int cell, boolean on) {
        if (this.rsLatch[cell] != on) {
            this.rsLatch[cell] = on;
            for (int i = 0; i < 6; ++i) {
                SocketModule m = this.getSide(ForgeDirection.getOrientation((int)i));
                m.onRSLatchChange(this.configs[i], cell, this, ForgeDirection.getOrientation((int)i), on);
            }
        }
    }

    @Override
    public boolean getRSControl(int channel) {
        return this.rsControl[channel];
    }

    @Override
    public boolean getRSLatch(int channel) {
        return this.rsLatch[channel];
    }

    @Override
    public boolean getSideRS(ForgeDirection side) {
        return this.sideRS[side.ordinal()];
    }

    public int func_70302_i_() {
        return 3;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amnt) {
        return this.extractItemInternal(true, slot, amnt);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public void func_70299_a(int slot, ItemStack item) {
        this.inventory.func_70299_a(slot, item);
        for (int i = 0; i < 6; ++i) {
            SocketModule m = this.getSide(ForgeDirection.getOrientation((int)i));
            m.onInventoryChange(this.configs[i], slot, this, ForgeDirection.getOrientation((int)i), true);
        }
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public String func_145825_b() {
        return "socket";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public int[] func_94128_d(int side) {
        int[] result = new int[1];
        SocketModule m = this.getSide(ForgeDirection.getOrientation((int)side));
        if (m != null && (m.canDirectlyExtractItems(this.configs[side], this) || m.canDirectlyInsertItems(this.configs[side], this))) {
            SideConfig config = this.configs[side];
            if (config.inventory >= 0 && config.inventory <= 2) {
                result[0] = config.inventory;
            } else {
                result = new int[]{};
            }
        } else {
            result = new int[]{};
        }
        return result;
    }

    public boolean func_102007_a(int slot, ItemStack is, int side) {
        int[] slots;
        SocketModule m = this.getSide(ForgeDirection.getOrientation((int)side));
        return m != null && m.canDirectlyInsertItems(this.configs[side], this) && (slots = this.func_94128_d(side)).length > 0 && slots[0] == slot;
    }

    public boolean func_102008_b(int slot, ItemStack is, int side) {
        int[] slots;
        SocketModule m = this.getSide(ForgeDirection.getOrientation((int)side));
        return m != null && m.canDirectlyExtractItems(this.configs[side], this) && (slots = this.func_94128_d(side)).length > 0 && slots[0] == slot;
    }

    @Override
    public ItemStack pullItem(ForgeDirection side, boolean doPull) {
        block4: {
            int xo = this.field_145851_c + side.offsetX;
            int yo = this.field_145848_d + side.offsetY;
            int zo = this.field_145849_e + side.offsetZ;
            TileEntity t = this.field_145850_b.func_147438_o(xo, yo, zo);
            if (!(t instanceof IInventory)) break block4;
            if (t instanceof ISidedInventory) {
                ISidedInventory isi = (ISidedInventory)t;
                int[] slots = isi.func_94128_d(side.getOpposite().ordinal());
                for (int i = 0; i < slots.length; ++i) {
                    ItemStack pulled = isi.func_70301_a(slots[i]);
                    if (pulled == null || !isi.func_102008_b(slots[i], pulled, side.getOpposite().ordinal())) continue;
                    ItemStack result = null;
                    result = doPull ? isi.func_70298_a(slots[i], 1) : pulled.func_77946_l().func_77979_a(1);
                    return result;
                }
            } else {
                IInventory ii = (IInventory)t;
                for (int i = 0; i < ii.func_70302_i_(); ++i) {
                    ItemStack pulled = ii.func_70301_a(i);
                    if (pulled == null) continue;
                    ItemStack result = null;
                    result = doPull ? ii.func_70298_a(i, 1) : pulled.func_77946_l().func_77979_a(1);
                    return result;
                }
            }
        }
        return null;
    }

    @Override
    public int addItemInternal(ItemStack stack, boolean doAdd, int inv) {
        if (inv > -1 && inv < 3) {
            ItemStack currStack = this.inventory.func_70301_a(inv);
            if (currStack == null) {
                if (doAdd) {
                    this.inventory.func_70299_a(inv, stack.func_77946_l());
                    for (int i = 0; i < 6; ++i) {
                        SocketModule m = this.getSide(ForgeDirection.getOrientation((int)i));
                        m.onInventoryChange(this.configs[i], inv, this, ForgeDirection.getOrientation((int)i), true);
                    }
                }
                return stack.field_77994_a;
            }
            if (currStack.func_77969_a(stack)) {
                int temp = Math.min(currStack.field_77994_a + stack.field_77994_a, currStack.func_77973_b().func_77639_j());
                int amntAdded = temp == currStack.field_77994_a + stack.field_77994_a ? stack.field_77994_a : currStack.func_77973_b().func_77639_j() - currStack.field_77994_a;
                if (doAdd && amntAdded > 0) {
                    currStack.field_77994_a += amntAdded;
                    for (int i = 0; i < 6; ++i) {
                        SocketModule m = this.getSide(ForgeDirection.getOrientation((int)i));
                        m.onInventoryChange(this.configs[i], inv, this, ForgeDirection.getOrientation((int)i), true);
                    }
                }
                return amntAdded;
            }
        }
        return 0;
    }

    @Override
    public ItemStack extractItemInternal(boolean doRemove, int inv, int maxItemCount) {
        ItemStack currStack;
        if (inv > -1 && inv < 3 && (currStack = this.inventory.func_70301_a(inv)) != null) {
            ItemStack newStack = currStack.func_77946_l();
            newStack.field_77994_a = Math.min(currStack.field_77994_a, maxItemCount);
            if (doRemove) {
                currStack.field_77994_a -= newStack.field_77994_a;
                if (currStack.field_77994_a <= 0) {
                    this.inventory.func_70299_a(inv, null);
                }
                for (int i = 0; i < 6; ++i) {
                    SocketModule m = this.getSide(ForgeDirection.getOrientation((int)i));
                    m.onInventoryChange(this.configs[i], inv, this, ForgeDirection.getOrientation((int)i), false);
                }
            }
            return newStack;
        }
        return null;
    }

    @Override
    public ItemStack getStackInInventorySlot(int inv) {
        return this.inventory.func_70301_a(inv);
    }

    @Override
    public void setInventoryStack(int inv, ItemStack stack) {
        if (stack == null || stack.field_77994_a <= 0) {
            this.inventory.func_70299_a(inv, null);
        } else {
            this.inventory.func_70299_a(inv, stack);
        }
        for (int i = 0; i < 6; ++i) {
            ForgeDirection d = ForgeDirection.getOrientation((int)i);
            this.getSide(d).onInventoryChange(this.configs[i], inv, this, d, false);
        }
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection direction) {
        if (direction.ordinal() >= 0 && direction.ordinal() < 6) {
            SocketModule m = this.getSide(direction);
            SideConfig c = this.configs[direction.ordinal()];
            if (m.isItemInterface() && m.canInsertItems()) {
                return m.itemFill(stack, doAdd, c, this, direction);
            }
        }
        return 0;
    }

    public ItemStack[] extractItem(boolean doRemove, ForgeDirection direction, int maxItemCount) {
        if (direction.ordinal() > 0 && direction.ordinal() < 6) {
            ItemStack temp;
            SocketModule m = this.getSide(direction);
            SideConfig c = this.configs[direction.ordinal()];
            if (m.isItemInterface() && m.canExtractItems() && (temp = m.itemExtract(maxItemCount, doRemove, c, this)) != null) {
                return new ItemStack[]{temp};
            }
        }
        return new ItemStack[0];
    }

    @Override
    public boolean tryInsertItem(ItemStack stack, ForgeDirection side) {
        int res;
        IPipeTile p;
        int xo = this.field_145851_c + side.offsetX;
        int yo = this.field_145848_d + side.offsetY;
        int zo = this.field_145849_e + side.offsetZ;
        TileEntity t = this.field_145850_b.func_147438_o(xo, yo, zo);
        if (stack == null) {
            return false;
        }
        if (t instanceof IInventory) {
            ItemStack inSlot;
            int i;
            if (t instanceof ISidedInventory) {
                ItemStack inSlot2;
                int i2;
                ISidedInventory isi = (ISidedInventory)t;
                ItemStack ghost = stack.func_77946_l().func_77979_a(1);
                int[] slots = isi.func_94128_d(side.getOpposite().ordinal());
                for (i2 = 0; i2 < slots.length; ++i2) {
                    if (!isi.func_102007_a(slots[i2], ghost, side.getOpposite().ordinal()) || (inSlot2 = isi.func_70301_a(slots[i2])) == null || !inSlot2.func_77969_a(ghost) || inSlot2.field_77994_a >= inSlot2.func_77976_d() || inSlot2.field_77994_a >= isi.func_70297_j_()) continue;
                    ++inSlot2.field_77994_a;
                    return true;
                }
                for (i2 = 0; i2 < slots.length; ++i2) {
                    if (!isi.func_102007_a(slots[i2], ghost, side.getOpposite().ordinal()) || (inSlot2 = isi.func_70301_a(slots[i2])) != null) continue;
                    isi.func_70299_a(slots[i2], ghost);
                    return true;
                }
                return false;
            }
            IInventory ii = (IInventory)t;
            ItemStack ghost = stack.func_77946_l().func_77979_a(1);
            for (i = 0; i < ii.func_70302_i_(); ++i) {
                if (!ii.func_94041_b(i, ghost) || (inSlot = ii.func_70301_a(i)) == null || !inSlot.func_77969_a(ghost) || inSlot.field_77994_a >= inSlot.func_77976_d() || inSlot.field_77994_a >= ii.func_70297_j_()) continue;
                ++inSlot.field_77994_a;
                return true;
            }
            for (i = 0; i < ii.func_70302_i_(); ++i) {
                if (!ii.func_94041_b(i, ghost) || (inSlot = ii.func_70301_a(i)) != null) continue;
                ii.func_70299_a(i, ghost);
                return true;
            }
            return false;
        }
        if (Loader.isModLoaded((String)"BuildCraft|Core") && t != null && stack != null && t instanceof IPipeTile && (p = (IPipeTile)t).getPipeType() == IPipeTile.PipeType.ITEM && p.isPipeConnected(side.getOpposite()) && (res = p.injectItem(stack, false, side.getOpposite())) == stack.field_77994_a) {
            p.injectItem(stack, true, side.getOpposite());
            stack.field_77994_a = 0;
            return true;
        }
        return false;
    }

    public int fill(ForgeDirection direction, FluidStack resource, boolean doFill) {
        SocketModule m = this.getSide(direction);
        SideConfig c = this.configs[direction.ordinal()];
        if (m.isFluidInterface() && m.canInsertFluid()) {
            return m.fluidFill(resource, doFill, c, this, direction);
        }
        return 0;
    }

    @Override
    public int fillInternal(int tank, FluidStack resource, boolean doFill) {
        if (tank >= 0 && tank < 3) {
            int result = this.tanks[tank].fill(resource, doFill);
            if (result > 0 && doFill) {
                for (int i = 0; i < 6; ++i) {
                    SocketModule m = this.getSide(ForgeDirection.getOrientation((int)i));
                    m.onTankChange(this.configs[i], tank, this, ForgeDirection.getOrientation((int)i), true);
                }
            }
            return result;
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection direction, int maxDrain, boolean doDrain) {
        SocketModule m = this.getSide(direction);
        SideConfig c = this.configs[direction.ordinal()];
        if (m.isFluidInterface() && m.canExtractFluid()) {
            return m.fluidExtract(maxDrain, doDrain, c, this);
        }
        return null;
    }

    @Override
    public FluidStack drainInternal(int tank, int maxDrain, boolean doDrain) {
        if (tank >= 0 && tank < 3) {
            FluidStack result = this.tanks[tank].drain(maxDrain, doDrain);
            if (result != null && doDrain) {
                for (int i = 0; i < 6; ++i) {
                    SocketModule m = this.getSide(ForgeDirection.getOrientation((int)i));
                    m.onTankChange(this.configs[i], tank, this, ForgeDirection.getOrientation((int)i), false);
                }
            }
            return result;
        }
        return null;
    }

    @Override
    public void tryInsertFluid(int tank, ForgeDirection side) {
        int xo = this.field_145851_c + side.offsetX;
        int yo = this.field_145848_d + side.offsetY;
        int zo = this.field_145849_e + side.offsetZ;
        TileEntity t = this.field_145850_b.func_147438_o(xo, yo, zo);
        if (this.tanks[tank].getFluid() != null && t != null && t instanceof IFluidHandler) {
            IFluidHandler tn = (IFluidHandler)t;
            int amnt = tn.fill(side.getOpposite(), this.tanks[tank].getFluid(), true);
            this.drainInternal(tank, amnt, true);
        }
    }

    @Override
    public void tryExtractFluid(int tank, ForgeDirection side, int volume) {
        int xo = this.field_145851_c + side.offsetX;
        int yo = this.field_145848_d + side.offsetY;
        int zo = this.field_145849_e + side.offsetZ;
        TileEntity t = this.field_145850_b.func_147438_o(xo, yo, zo);
        if (t != null && t instanceof IFluidHandler) {
            IFluidHandler tn = (IFluidHandler)t;
            FluidStack ghost = tn.drain(side.getOpposite(), volume, false);
            int amnt = this.fillInternal(tank, ghost, true);
            tn.drain(side.getOpposite(), amnt, true);
        }
    }

    @Override
    public void sendClientSideState(int side) {
        EngineersToolbox.network().sendToDimension((IMessage)new SocketStateMessage(this, (byte)side), this.field_145850_b.field_73011_w.field_76574_g);
    }

    @Override
    public void sendClientInventorySlot(int inv) {
        EngineersToolbox.network().sendToDimension((IMessage)new SocketItemMessage(this, (byte)inv), this.field_145850_b.field_73011_w.field_76574_g);
    }

    @Override
    public void sendClientTankSlot(int tank) {
        EngineersToolbox.network().sendToDimension((IMessage)new SocketFluidMessage(this, (byte)tank), this.field_145850_b.field_73011_w.field_76574_g);
    }

    @Override
    public void outputEnergy(int amount, ForgeDirection side) {
        int xo = this.field_145851_c + side.offsetX;
        int yo = this.field_145848_d + side.offsetY;
        int zo = this.field_145849_e + side.offsetZ;
        TileEntity t = this.field_145850_b.func_147438_o(xo, yo, zo);
        if (t != null && t instanceof IEnergyHandler) {
            IEnergyHandler ieh = (IEnergyHandler)t;
            int amnt = ieh.receiveEnergy(side.getOpposite(), this.capacitor.extractEnergy(1000, true), false);
            this.capacitor.extractEnergy(amnt, false);
        }
    }

    @Override
    public int getMaxEnergyStored() {
        return this.capacitor.getMaxEnergyStored();
    }

    @Override
    public void setMaxEnergyStored(int newMax) {
        this.capacitor.setCapacity(newMax);
    }

    @Override
    public int getEnergyStored() {
        return this.capacitor.getEnergyStored();
    }

    @Override
    public int useEnergy(int toUse, boolean simulate) {
        return this.capacitor.extractEnergy(toUse, simulate);
    }

    @Override
    public int addEnergy(int energy, boolean simulate) {
        return this.capacitor.receiveEnergy(energy, simulate);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.drain(from, resource.amount, false))) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.getSide(from).canInsertFluid();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.getSide(from).canExtractFluid();
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tanks[0].getInfo(), this.tanks[1].getInfo(), this.tanks[2].getInfo()};
    }

    @Override
    public FluidStack getFluidInTank(int tank) {
        if (tank < 0 || tank >= 3) {
            return null;
        }
        return this.tanks[tank].getFluid();
    }

    @Override
    public int forceOutputItem(ItemStack stack, boolean doOutput) {
        int origAmnt = stack.field_77994_a;
        for (int i = 0; i < 6; ++i) {
            ForgeDirection d = ForgeDirection.getOrientation((int)i);
            if (!(this.getSide(d) instanceof ModMachineOutput)) continue;
            SideConfig mConfig = this.configs[i];
            if (mConfig.inventory < 0 || mConfig.inventory >= 3) continue;
            int amnt = this.addItemInternal(stack, doOutput, mConfig.inventory);
            if (doOutput) {
                stack.field_77994_a -= amnt;
            }
            this.getSide(d).updateSide(this.configs[i], this, d);
            return amnt;
        }
        return 0;
    }

    @Override
    public int forceOutputFluid(FluidStack stack, boolean doOutput) {
        int origAmnt = stack.amount;
        for (int i = 0; i < 6; ++i) {
            ForgeDirection d = ForgeDirection.getOrientation((int)i);
            if (!(this.getSide(d) instanceof ModMachineOutput)) continue;
            SideConfig mConfig = this.configs[i];
            if (mConfig.tank < 0 || mConfig.tank >= 3) continue;
            int amnt = this.fillInternal(mConfig.tank, stack, doOutput);
            if (doOutput) {
                stack.amount -= amnt;
            }
            this.getSide(d).updateSide(this.configs[i], this, d);
            return amnt;
        }
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getTexture(int texture, int moduleID) {
        return Blocks.socket().textures[moduleID][texture];
    }

    @Override
    public int recieveGas(FluidStack gas, ForgeDirection direction, boolean doFill) {
        return this.fill(direction, gas, doFill);
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (from == ForgeDirection.UNKNOWN) {
            return 0;
        }
        SocketModule m = this.getSide(from);
        return m.receiveEnergy(maxReceive, simulate, this.configs[from.ordinal()], this);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (from == ForgeDirection.UNKNOWN) {
            return 0;
        }
        SocketModule m = this.getSide(from);
        return m.extractEnergy(maxExtract, simulate, this.configs[from.ordinal()], this);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        if (from == ForgeDirection.UNKNOWN) {
            return false;
        }
        SocketModule m = this.getSide(from);
        return m.isEnergyInterface(this.configs[from.ordinal()]);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.capacitor.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.capacitor.getMaxEnergyStored();
    }
}

