/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.signals;

import java.util.Locale;

public enum SignalAspect {
    GREEN(0, "railcraft.gui.aspect.green.name"),
    BLINK_YELLOW(1, "railcraft.gui.aspect.blink.yellow.name"),
    YELLOW(1, "railcraft.gui.aspect.yellow.name"),
    BLINK_RED(2, "railcraft.gui.aspect.blink.red.name"),
    RED(2, "railcraft.gui.aspect.red.name"),
    OFF(3, "railcraft.gui.aspect.off.name");

    private final int textureIndex;
    private final String localizationTag;
    private static boolean blinkState;
    private static final int SIGNAL_BRIGHTNESS = 210;
    public static final SignalAspect[] VALUES;

    private SignalAspect(int textureIndex, String localizationTag) {
        this.textureIndex = textureIndex;
        this.localizationTag = localizationTag;
    }

    public int getTextureIndex() {
        return this.textureIndex;
    }

    public int getTextureBrightness() {
        if (this == OFF) {
            return -1;
        }
        return 210;
    }

    public boolean isBlinkAspect() {
        return this == BLINK_YELLOW || this == BLINK_RED;
    }

    public boolean isLit() {
        if (this == OFF) {
            return false;
        }
        if (this.isBlinkAspect()) {
            return SignalAspect.isBlinkOn();
        }
        return true;
    }

    public static boolean isBlinkOn() {
        return blinkState;
    }

    public static void invertBlinkState() {
        blinkState = !blinkState;
    }

    public static SignalAspect fromOrdinal(int ordinal) {
        if (ordinal < 0 || ordinal >= VALUES.length) {
            return RED;
        }
        return VALUES[ordinal];
    }

    public static SignalAspect mostRestrictive(SignalAspect first, SignalAspect second) {
        if (first == null && second == null) {
            return RED;
        }
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        if (first.ordinal() > second.ordinal()) {
            return first;
        }
        return second;
    }

    public String getLocalizationTag() {
        return this.localizationTag;
    }

    public String toString() {
        String[] sa = this.name().split("_");
        String out = "";
        for (String s : sa) {
            out = out + s.substring(0, 1) + s.substring(1).toLowerCase(Locale.ENGLISH) + " ";
        }
        out = out.trim();
        return out;
    }

    static {
        VALUES = SignalAspect.values();
    }
}

