/*
 * Decompiled with CFR 0.152.
 */
package org.mod.luaj.vm2.lib;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.mod.luaj.vm2.Buffer;
import org.mod.luaj.vm2.LuaClosure;
import org.mod.luaj.vm2.LuaFunction;
import org.mod.luaj.vm2.LuaString;
import org.mod.luaj.vm2.LuaTable;
import org.mod.luaj.vm2.LuaValue;
import org.mod.luaj.vm2.Varargs;
import org.mod.luaj.vm2.compiler.DumpState;
import org.mod.luaj.vm2.lib.OneArgFunction;
import org.mod.luaj.vm2.lib.TwoArgFunction;
import org.mod.luaj.vm2.lib.VarArgFunction;

public class StringLib
extends TwoArgFunction {
    private static final String FLAGS = "-+ #0";
    private static final int L_ESC = 37;
    private static final LuaString SPECIALS = StringLib.valueOf("^$*+?.([%-");
    private static final int MAX_CAPTURES = 32;
    private static final int CAP_UNFINISHED = -1;
    private static final int CAP_POSITION = -2;
    private static final byte MASK_ALPHA = 1;
    private static final byte MASK_LOWERCASE = 2;
    private static final byte MASK_UPPERCASE = 4;
    private static final byte MASK_DIGIT = 8;
    private static final byte MASK_PUNCT = 16;
    private static final byte MASK_SPACE = 32;
    private static final byte MASK_CONTROL = 64;
    private static final byte MASK_HEXDIGIT = -128;
    private static final byte[] CHAR_TABLE = new byte[256];

    @Override
    public LuaValue call(LuaValue modname, LuaValue env) {
        LuaTable string = new LuaTable();
        string.set("byte", (LuaValue)new byte_());
        string.set("char", (LuaValue)new char_());
        string.set("dump", (LuaValue)new dump());
        string.set("find", (LuaValue)new find());
        string.set("format", (LuaValue)new format());
        string.set("gmatch", (LuaValue)new gmatch());
        string.set("gsub", (LuaValue)new gsub());
        string.set("len", (LuaValue)new len());
        string.set("lower", (LuaValue)new lower());
        string.set("match", (LuaValue)new match());
        string.set("rep", (LuaValue)new rep());
        string.set("reverse", (LuaValue)new reverse());
        string.set("sub", (LuaValue)new sub());
        string.set("upper", (LuaValue)new upper());
        LuaTable mt = LuaValue.tableOf(new LuaValue[]{INDEX, string});
        env.set("string", (LuaValue)string);
        env.get("package").get("loaded").set("string", (LuaValue)string);
        if (LuaString.s_metatable == null) {
            LuaString.s_metatable = mt;
        }
        return string;
    }

    private static void addquoted(Buffer buf, LuaString s) {
        buf.append((byte)34);
        int n = s.length();
        block3: for (int i = 0; i < n; ++i) {
            int c = s.luaByte(i);
            switch (c) {
                case 10: 
                case 34: 
                case 92: {
                    buf.append((byte)92);
                    buf.append((byte)c);
                    continue block3;
                }
                default: {
                    if (c <= 31 || c == 127) {
                        buf.append((byte)92);
                        if (i + 1 == n || s.luaByte(i + 1) < 48 || s.luaByte(i + 1) > 57) {
                            buf.append(Integer.toString(c));
                            continue block3;
                        }
                        buf.append((byte)48);
                        buf.append((byte)(48 + c / 10));
                        buf.append((byte)(48 + c % 10));
                        continue block3;
                    }
                    buf.append((byte)c);
                }
            }
        }
        buf.append((byte)34);
    }

    static Varargs str_find_aux(Varargs args, boolean find2) {
        boolean fastMatch;
        LuaString s = args.checkstring(1);
        LuaString pat = args.checkstring(2);
        int init2 = args.optint(3, 1);
        if (init2 > 0) {
            init2 = Math.min(init2 - 1, s.length());
        } else if (init2 < 0) {
            init2 = Math.max(0, s.length() + init2);
        }
        boolean bl = fastMatch = find2 && (args.arg(4).toboolean() || pat.indexOfAny(SPECIALS) == -1);
        if (fastMatch) {
            int result = s.indexOf(pat, init2);
            if (result != -1) {
                return StringLib.varargsOf(StringLib.valueOf(result + 1), (Varargs)StringLib.valueOf(result + pat.length()));
            }
        } else {
            MatchState ms = new MatchState(args, s, pat);
            boolean anchor = false;
            int poff = 0;
            if (pat.luaByte(0) == 94) {
                anchor = true;
                poff = 1;
            }
            int soff = init2;
            do {
                ms.reset();
                int res = ms.match(soff, poff);
                if (res == -1) continue;
                if (find2) {
                    return StringLib.varargsOf(StringLib.valueOf(soff + 1), StringLib.valueOf(res), ms.push_captures(false, soff, res));
                }
                return ms.push_captures(true, soff, res);
            } while (soff++ < s.length() && !anchor);
        }
        return NIL;
    }

    private static int posrelat(int pos, int len2) {
        return pos >= 0 ? pos : len2 + pos + 1;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            char c = (char)i;
            StringLib.CHAR_TABLE[i] = (byte)((Character.isDigit(c) ? 8 : 0) | (Character.isLowerCase(c) ? 2 : 0) | (Character.isUpperCase(c) ? 4 : 0) | (c < ' ' || c == '\u007f' ? 64 : 0));
            if (c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' || c >= '0' && c <= '9') {
                int n = i;
                CHAR_TABLE[n] = (byte)(CHAR_TABLE[n] | 0xFFFFFF80);
            }
            if (c >= '!' && c <= '/' || c >= ':' && c <= '@') {
                int n = i;
                CHAR_TABLE[n] = (byte)(CHAR_TABLE[n] | 0x10);
            }
            if ((CHAR_TABLE[i] & 6) == 0) continue;
            int n = i;
            CHAR_TABLE[n] = (byte)(CHAR_TABLE[n] | 1);
        }
        StringLib.CHAR_TABLE[32] = 32;
        CHAR_TABLE[13] = (byte)(CHAR_TABLE[13] | 0x20);
        CHAR_TABLE[10] = (byte)(CHAR_TABLE[10] | 0x20);
        CHAR_TABLE[9] = (byte)(CHAR_TABLE[9] | 0x20);
        CHAR_TABLE[12] = (byte)(CHAR_TABLE[12] | 0x20);
        CHAR_TABLE[12] = (byte)(CHAR_TABLE[12] | 0x20);
    }

    static class MatchState {
        final LuaString s;
        final LuaString p;
        final Varargs args;
        int level;
        int[] cinit;
        int[] clen;

        MatchState(Varargs args, LuaString s, LuaString pattern) {
            this.s = s;
            this.p = pattern;
            this.args = args;
            this.level = 0;
            this.cinit = new int[32];
            this.clen = new int[32];
        }

        void reset() {
            this.level = 0;
        }

        private void add_s(Buffer lbuf, LuaString news, int soff, int e) {
            int l = news.length();
            for (int i = 0; i < l; ++i) {
                byte b = (byte)news.luaByte(i);
                if (b != 37) {
                    lbuf.append(b);
                    continue;
                }
                if (!Character.isDigit((char)(b = (byte)news.luaByte(++i)))) {
                    lbuf.append(b);
                    continue;
                }
                if (b == 48) {
                    lbuf.append(this.s.substring(soff, e));
                    continue;
                }
                lbuf.append(this.push_onecapture(b - 49, soff, e).strvalue());
            }
        }

        public void add_value(Buffer lbuf, int soffset, int end, LuaValue repl) {
            switch (repl.type()) {
                case 3: 
                case 4: {
                    this.add_s(lbuf, repl.strvalue(), soffset, end);
                    return;
                }
                case 6: {
                    repl = repl.invoke(this.push_captures(true, soffset, end)).arg1();
                    break;
                }
                case 5: {
                    repl = repl.get(this.push_onecapture(0, soffset, end));
                    break;
                }
                default: {
                    LuaValue.error("bad argument: string/function/table expected");
                    return;
                }
            }
            if (!repl.toboolean()) {
                repl = this.s.substring(soffset, end);
            } else if (!repl.isstring()) {
                LuaValue.error("invalid replacement value (a " + repl.typename() + ")");
            }
            lbuf.append(repl.strvalue());
        }

        Varargs push_captures(boolean wholeMatch, int soff, int end) {
            int nlevels = this.level == 0 && wholeMatch ? 1 : this.level;
            switch (nlevels) {
                case 0: {
                    return LuaValue.NONE;
                }
                case 1: {
                    return this.push_onecapture(0, soff, end);
                }
            }
            LuaValue[] v = new LuaValue[nlevels];
            for (int i = 0; i < nlevels; ++i) {
                v[i] = this.push_onecapture(i, soff, end);
            }
            return LuaValue.varargsOf(v);
        }

        private LuaValue push_onecapture(int i, int soff, int end) {
            if (i >= this.level) {
                if (i == 0) {
                    return this.s.substring(soff, end);
                }
                return LuaValue.error("invalid capture index");
            }
            int l = this.clen[i];
            if (l == -1) {
                return LuaValue.error("unfinished capture");
            }
            if (l == -2) {
                return LuaValue.valueOf(this.cinit[i] + 1);
            }
            int begin = this.cinit[i];
            return this.s.substring(begin, begin + l);
        }

        private int check_capture(int l) {
            if ((l -= 49) < 0 || l >= this.level || this.clen[l] == -1) {
                LuaValue.error("invalid capture index");
            }
            return l;
        }

        private int capture_to_close() {
            int level = this.level;
            --level;
            while (level >= 0) {
                if (this.clen[level] == -1) {
                    return level;
                }
                --level;
            }
            LuaValue.error("invalid pattern capture");
            return 0;
        }

        int classend(int poffset) {
            switch (this.p.luaByte(poffset++)) {
                case 37: {
                    if (poffset == this.p.length()) {
                        LuaValue.error("malformed pattern (ends with %)");
                    }
                    return poffset + 1;
                }
                case 91: {
                    if (this.p.luaByte(poffset) == 94) {
                        ++poffset;
                    }
                    do {
                        if (poffset == this.p.length()) {
                            LuaValue.error("malformed pattern (missing ])");
                        }
                        if (this.p.luaByte(poffset++) != 37 || poffset == this.p.length()) continue;
                        ++poffset;
                    } while (this.p.luaByte(poffset) != 93);
                    return poffset + 1;
                }
            }
            return poffset;
        }

        static boolean match_class(int c, int cl) {
            boolean res;
            char lcl = Character.toLowerCase((char)cl);
            byte cdata = CHAR_TABLE[c];
            switch (lcl) {
                case 'a': {
                    res = (cdata & 1) != 0;
                    break;
                }
                case 'd': {
                    res = (cdata & 8) != 0;
                    break;
                }
                case 'l': {
                    res = (cdata & 2) != 0;
                    break;
                }
                case 'u': {
                    res = (cdata & 4) != 0;
                    break;
                }
                case 'c': {
                    res = (cdata & 0x40) != 0;
                    break;
                }
                case 'p': {
                    res = (cdata & 0x10) != 0;
                    break;
                }
                case 's': {
                    res = (cdata & 0x20) != 0;
                    break;
                }
                case 'w': {
                    res = (cdata & 9) != 0;
                    break;
                }
                case 'x': {
                    res = (cdata & 0xFFFFFF80) != 0;
                    break;
                }
                case 'z': {
                    res = c == 0;
                    break;
                }
                default: {
                    return cl == c;
                }
            }
            return lcl == cl ? res : !res;
        }

        boolean matchbracketclass(int c, int poff, int ec) {
            boolean sig = true;
            if (this.p.luaByte(poff + 1) == 94) {
                sig = false;
                ++poff;
            }
            while (++poff < ec) {
                if (!(this.p.luaByte(poff) == 37 ? MatchState.match_class(c, this.p.luaByte(++poff)) : (this.p.luaByte(poff + 1) == 45 && poff + 2 < ec ? this.p.luaByte((poff += 2) - 2) <= c && c <= this.p.luaByte(poff) : this.p.luaByte(poff) == c))) continue;
                return sig;
            }
            return !sig;
        }

        boolean singlematch(int c, int poff, int ep) {
            switch (this.p.luaByte(poff)) {
                case 46: {
                    return true;
                }
                case 37: {
                    return MatchState.match_class(c, this.p.luaByte(poff + 1));
                }
                case 91: {
                    return this.matchbracketclass(c, poff, ep - 1);
                }
            }
            return this.p.luaByte(poff) == c;
        }

        int match(int soffset, int poffset) {
            block16: while (poffset != this.p.length()) {
                int ep;
                switch (this.p.luaByte(poffset)) {
                    case 40: {
                        if (++poffset < this.p.length() && this.p.luaByte(poffset) == 41) {
                            return this.start_capture(soffset, poffset + 1, -2);
                        }
                        return this.start_capture(soffset, poffset, -1);
                    }
                    case 41: {
                        return this.end_capture(soffset, poffset + 1);
                    }
                    case 37: {
                        if (poffset + 1 == this.p.length()) {
                            LuaValue.error("malformed pattern (ends with '%')");
                        }
                        switch (this.p.luaByte(poffset + 1)) {
                            case 98: {
                                soffset = this.matchbalance(soffset, poffset + 2);
                                if (soffset == -1) {
                                    return -1;
                                }
                                poffset += 4;
                                continue block16;
                            }
                            case 102: {
                                int previous;
                                if (this.p.luaByte(poffset += 2) != 91) {
                                    LuaValue.error("Missing [ after %f in pattern");
                                }
                                ep = this.classend(poffset);
                                int n = previous = soffset == 0 ? -1 : this.s.luaByte(soffset - 1);
                                if (this.matchbracketclass(previous, poffset, ep - 1) || this.matchbracketclass(this.s.luaByte(soffset), poffset, ep - 1)) {
                                    return -1;
                                }
                                poffset = ep;
                                continue block16;
                            }
                        }
                        int c = this.p.luaByte(poffset + 1);
                        if (Character.isDigit((char)c)) {
                            if ((soffset = this.match_capture(soffset, c)) == -1) {
                                return -1;
                            }
                            return this.match(soffset, poffset + 2);
                        }
                    }
                    case 36: {
                        if (poffset + 1 != this.p.length()) break;
                        return soffset == this.s.length() ? soffset : -1;
                    }
                }
                ep = this.classend(poffset);
                boolean m = soffset < this.s.length() && this.singlematch(this.s.luaByte(soffset), poffset, ep);
                int pc = ep < this.p.length() ? this.p.luaByte(ep) : 0;
                switch (pc) {
                    case 63: {
                        int res;
                        if (m && (res = this.match(soffset + 1, ep + 1)) != -1) {
                            return res;
                        }
                        poffset = ep + 1;
                        continue block16;
                    }
                    case 42: {
                        return this.max_expand(soffset, poffset, ep);
                    }
                    case 43: {
                        return m ? this.max_expand(soffset + 1, poffset, ep) : -1;
                    }
                    case 45: {
                        return this.min_expand(soffset, poffset, ep);
                    }
                }
                if (!m) {
                    return -1;
                }
                ++soffset;
                poffset = ep;
            }
            return soffset;
        }

        int max_expand(int soff, int poff, int ep) {
            int i = 0;
            while (soff + i < this.s.length() && this.singlematch(this.s.luaByte(soff + i), poff, ep)) {
                ++i;
            }
            while (i >= 0) {
                int res = this.match(soff + i, ep + 1);
                if (res != -1) {
                    return res;
                }
                --i;
            }
            return -1;
        }

        int min_expand(int soff, int poff, int ep) {
            while (true) {
                int res;
                if ((res = this.match(soff, ep + 1)) != -1) {
                    return res;
                }
                if (soff >= this.s.length() || !this.singlematch(this.s.luaByte(soff), poff, ep)) break;
                ++soff;
            }
            return -1;
        }

        int start_capture(int soff, int poff, int what) {
            int level = this.level;
            if (level >= 32) {
                LuaValue.error("too many captures");
            }
            this.cinit[level] = soff;
            this.clen[level] = what;
            this.level = level + 1;
            int res = this.match(soff, poff);
            if (res == -1) {
                --this.level;
            }
            return res;
        }

        int end_capture(int soff, int poff) {
            int l = this.capture_to_close();
            this.clen[l] = soff - this.cinit[l];
            int res = this.match(soff, poff);
            if (res == -1) {
                this.clen[l] = -1;
            }
            return res;
        }

        int match_capture(int soff, int l) {
            l = this.check_capture(l);
            int len2 = this.clen[l];
            if (this.s.length() - soff >= len2 && LuaString.equals(this.s, this.cinit[l], this.s, soff, len2)) {
                return soff + len2;
            }
            return -1;
        }

        int matchbalance(int soff, int poff) {
            int slen;
            int plen = this.p.length();
            if (poff == plen || poff + 1 == plen) {
                LuaValue.error("unbalanced pattern");
            }
            if (soff >= (slen = this.s.length())) {
                return -1;
            }
            int b = this.p.luaByte(poff);
            if (this.s.luaByte(soff) != b) {
                return -1;
            }
            int e = this.p.luaByte(poff + 1);
            int cont = 1;
            while (++soff < slen) {
                if (this.s.luaByte(soff) == e) {
                    if (--cont != 0) continue;
                    return soff + 1;
                }
                if (this.s.luaByte(soff) != b) continue;
                ++cont;
            }
            return -1;
        }
    }

    static final class upper
    extends OneArgFunction {
        upper() {
        }

        @Override
        public LuaValue call(LuaValue arg) {
            return upper.valueOf(arg.checkjstring().toUpperCase());
        }
    }

    static final class sub
    extends VarArgFunction {
        sub() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            LuaString s = args.checkstring(1);
            int l = s.length();
            int start = StringLib.posrelat(args.checkint(2), l);
            int end = StringLib.posrelat(args.optint(3, -1), l);
            if (start < 1) {
                start = 1;
            }
            if (end > l) {
                end = l;
            }
            if (start <= end) {
                return s.substring(start - 1, end);
            }
            return EMPTYSTRING;
        }
    }

    static final class reverse
    extends OneArgFunction {
        reverse() {
        }

        @Override
        public LuaValue call(LuaValue arg) {
            LuaString s = arg.checkstring();
            int n = s.length();
            byte[] b = new byte[n];
            int i = 0;
            int j = n - 1;
            while (i < n) {
                b[j] = (byte)s.luaByte(i);
                ++i;
                --j;
            }
            return LuaString.valueUsing(b);
        }
    }

    static final class rep
    extends VarArgFunction {
        rep() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            LuaString s = args.checkstring(1);
            int n = args.checkint(2);
            byte[] bytes = new byte[s.length() * n];
            int len2 = s.length();
            for (int offset = 0; offset < bytes.length; offset += len2) {
                s.copyInto(0, bytes, offset, len2);
            }
            return LuaString.valueUsing(bytes);
        }
    }

    static final class match
    extends VarArgFunction {
        match() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            return StringLib.str_find_aux(args, false);
        }
    }

    static final class lower
    extends OneArgFunction {
        lower() {
        }

        @Override
        public LuaValue call(LuaValue arg) {
            return lower.valueOf(arg.checkjstring().toLowerCase());
        }
    }

    static final class len
    extends OneArgFunction {
        len() {
        }

        @Override
        public LuaValue call(LuaValue arg) {
            return arg.checkstring().len();
        }
    }

    static final class gsub
    extends VarArgFunction {
        gsub() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            LuaString src = args.checkstring(1);
            int srclen = src.length();
            LuaString p = args.checkstring(2);
            LuaValue repl = args.arg(3);
            int max_s = args.optint(4, srclen + 1);
            boolean anchor = p.length() > 0 && p.charAt(0) == 94;
            Buffer lbuf = new Buffer(srclen);
            MatchState ms = new MatchState(args, src, p);
            int soffset = 0;
            int n = 0;
            while (n < max_s) {
                ms.reset();
                int res = ms.match(soffset, anchor ? 1 : 0);
                if (res != -1) {
                    ++n;
                    ms.add_value(lbuf, soffset, res, repl);
                }
                if (res != -1 && res > soffset) {
                    soffset = res;
                } else {
                    if (soffset >= srclen) break;
                    lbuf.append((byte)src.luaByte(soffset++));
                }
                if (!anchor) continue;
                break;
            }
            lbuf.append(src.substring(soffset, srclen));
            return gsub.varargsOf(lbuf.tostring(), (Varargs)gsub.valueOf(n));
        }
    }

    static class GMatchAux
    extends VarArgFunction {
        private final int srclen;
        private final MatchState ms;
        private int soffset;

        public GMatchAux(Varargs args, LuaString src, LuaString pat) {
            this.srclen = src.length();
            this.ms = new MatchState(args, src, pat);
            this.soffset = 0;
        }

        @Override
        public Varargs invoke(Varargs args) {
            while (this.soffset < this.srclen) {
                this.ms.reset();
                int res = this.ms.match(this.soffset, 0);
                if (res >= 0) {
                    int soff = this.soffset;
                    this.soffset = res;
                    return this.ms.push_captures(true, soff, res);
                }
                ++this.soffset;
            }
            return NIL;
        }
    }

    static final class gmatch
    extends VarArgFunction {
        gmatch() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            LuaString src = args.checkstring(1);
            LuaString pat = args.checkstring(2);
            return new GMatchAux(args, src, pat);
        }
    }

    static class FormatDesc {
        private boolean leftAdjust;
        private boolean zeroPad;
        private boolean explicitPlus;
        private boolean space;
        private boolean alternateForm;
        private static final int MAX_FLAGS = 5;
        private int width;
        private int precision;
        public final int conversion;
        public final int length;

        public FormatDesc(Varargs args, LuaString strfrmt, int start) {
            int p = start;
            int n = strfrmt.length();
            int c = 0;
            boolean moreFlags = true;
            block7: while (moreFlags) {
                c = p < n ? strfrmt.luaByte(p++) : 0;
                switch (c) {
                    case 45: {
                        this.leftAdjust = true;
                        continue block7;
                    }
                    case 43: {
                        this.explicitPlus = true;
                        continue block7;
                    }
                    case 32: {
                        this.space = true;
                        continue block7;
                    }
                    case 35: {
                        this.alternateForm = true;
                        continue block7;
                    }
                    case 48: {
                        this.zeroPad = true;
                        continue block7;
                    }
                }
                moreFlags = false;
            }
            if (p - start > 5) {
                LuaValue.error("invalid format (repeated flags)");
            }
            this.width = -1;
            if (Character.isDigit((char)c)) {
                this.width = c - 48;
                int n2 = c = p < n ? strfrmt.luaByte(p++) : 0;
                if (Character.isDigit((char)c)) {
                    this.width = this.width * 10 + (c - 48);
                    c = p < n ? strfrmt.luaByte(p++) : 0;
                }
            }
            this.precision = -1;
            if (c == 46) {
                int n3 = c = p < n ? strfrmt.luaByte(p++) : 0;
                if (Character.isDigit((char)c)) {
                    this.precision = c - 48;
                    int n4 = c = p < n ? strfrmt.luaByte(p++) : 0;
                    if (Character.isDigit((char)c)) {
                        this.precision = this.precision * 10 + (c - 48);
                        int n5 = c = p < n ? strfrmt.luaByte(p++) : 0;
                    }
                }
            }
            if (Character.isDigit((char)c)) {
                LuaValue.error("invalid format (width or precision too long)");
            }
            this.zeroPad &= !this.leftAdjust;
            this.conversion = c;
            this.length = p - start;
        }

        public void format(Buffer buf, byte c) {
            buf.append(c);
        }

        public void format(Buffer buf, long number) {
            int nspaces;
            int minwidth;
            String digits;
            if (number == 0L && this.precision == 0) {
                digits = "";
            } else {
                int radix;
                switch (this.conversion) {
                    case 88: 
                    case 120: {
                        radix = 16;
                        break;
                    }
                    case 111: {
                        radix = 8;
                        break;
                    }
                    default: {
                        radix = 10;
                    }
                }
                digits = Long.toString(number, radix);
                if (this.conversion == 88) {
                    digits = digits.toUpperCase();
                }
            }
            int ndigits = minwidth = digits.length();
            if (number < 0L) {
                --ndigits;
            } else if (this.explicitPlus || this.space) {
                ++minwidth;
            }
            int nzeros = this.precision > ndigits ? this.precision - ndigits : (this.precision == -1 && this.zeroPad && this.width > minwidth ? this.width - minwidth : 0);
            int n = nspaces = this.width > (minwidth += nzeros) ? this.width - minwidth : 0;
            if (!this.leftAdjust) {
                FormatDesc.pad(buf, ' ', nspaces);
            }
            if (number < 0L) {
                if (nzeros > 0) {
                    buf.append((byte)45);
                    digits = digits.substring(1);
                }
            } else if (this.explicitPlus) {
                buf.append((byte)43);
            } else if (this.space) {
                buf.append((byte)32);
            }
            if (nzeros > 0) {
                FormatDesc.pad(buf, '0', nzeros);
            }
            buf.append(digits);
            if (this.leftAdjust) {
                FormatDesc.pad(buf, ' ', nspaces);
            }
        }

        public void format(Buffer buf, double x) {
            buf.append(String.valueOf(x));
        }

        public void format(Buffer buf, LuaString s) {
            int nullindex = s.indexOf((byte)0, 0);
            if (nullindex != -1) {
                s = s.substring(0, nullindex);
            }
            buf.append(s);
        }

        public static final void pad(Buffer buf, char c, int n) {
            byte b = (byte)c;
            while (n-- > 0) {
                buf.append(b);
            }
        }
    }

    static final class format
    extends VarArgFunction {
        format() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            LuaString fmt = args.checkstring(1);
            int n = fmt.length();
            Buffer result = new Buffer(n);
            int arg = 1;
            int i = 0;
            block12: while (i < n) {
                int c = fmt.luaByte(i++);
                switch (c) {
                    case 10: {
                        result.append("\n");
                        continue block12;
                    }
                    default: {
                        result.append((byte)c);
                        continue block12;
                    }
                    case 37: 
                }
                if (i >= n) continue;
                c = fmt.luaByte(i);
                if (c == 37) {
                    ++i;
                    result.append((byte)37);
                    continue;
                }
                ++arg;
                FormatDesc fdsc = new FormatDesc(args, fmt, i);
                i += fdsc.length;
                switch (fdsc.conversion) {
                    case 99: {
                        fdsc.format(result, (byte)args.checkint(arg));
                        break;
                    }
                    case 100: 
                    case 105: {
                        fdsc.format(result, args.checkint(arg));
                        break;
                    }
                    case 88: 
                    case 111: 
                    case 117: 
                    case 120: {
                        fdsc.format(result, args.checklong(arg));
                        break;
                    }
                    case 69: 
                    case 71: 
                    case 101: 
                    case 102: 
                    case 103: {
                        fdsc.format(result, args.checkdouble(arg));
                        break;
                    }
                    case 113: {
                        StringLib.addquoted(result, args.checkstring(arg));
                        break;
                    }
                    case 115: {
                        LuaString s = args.checkstring(arg);
                        if (fdsc.precision == -1 && s.length() >= 100) {
                            result.append(s);
                            break;
                        }
                        fdsc.format(result, s);
                        break;
                    }
                    default: {
                        format.error("invalid option '%" + (char)fdsc.conversion + "' to 'format'");
                    }
                }
            }
            return result.tostring();
        }
    }

    static final class find
    extends VarArgFunction {
        find() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            return StringLib.str_find_aux(args, true);
        }
    }

    static final class dump
    extends OneArgFunction {
        dump() {
        }

        @Override
        public LuaValue call(LuaValue arg) {
            LuaFunction f = arg.checkfunction();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                DumpState.dump(((LuaClosure)f).p, baos, true);
                return LuaString.valueUsing(baos.toByteArray());
            }
            catch (IOException e) {
                return dump.error(e.getMessage());
            }
        }
    }

    static final class char_
    extends VarArgFunction {
        char_() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            int n = args.narg();
            byte[] bytes = new byte[n];
            int i = 0;
            int a = 1;
            while (i < n) {
                int c = args.checkint(a);
                if (c < 0 || c >= 256) {
                    char_.argerror(a, "invalid value");
                }
                bytes[i] = (byte)c;
                ++i;
                ++a;
            }
            return LuaString.valueUsing(bytes);
        }
    }

    static final class byte_
    extends VarArgFunction {
        byte_() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            LuaString s = args.checkstring(1);
            int l = s.m_length;
            int posi = StringLib.posrelat(args.optint(2, 1), l);
            int pose = StringLib.posrelat(args.optint(3, posi), l);
            if (posi <= 0) {
                posi = 1;
            }
            if (pose > l) {
                pose = l;
            }
            if (posi > pose) {
                return NONE;
            }
            int n = pose - posi + 1;
            if (posi + n <= pose) {
                byte_.error("string slice too long");
            }
            LuaValue[] v = new LuaValue[n];
            for (int i = 0; i < n; ++i) {
                v[i] = byte_.valueOf(s.luaByte(posi + i - 1));
            }
            return byte_.varargsOf(v);
        }
    }
}

