/*
 * Decompiled with CFR 0.152.
 */
package org.mod.luaj.vm2.lib.jse;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mod.luaj.vm2.LuaString;
import org.mod.luaj.vm2.LuaValue;
import org.mod.luaj.vm2.lib.jse.CoerceJavaToLua;
import org.mod.luaj.vm2.lib.jse.JavaConstructor;
import org.mod.luaj.vm2.lib.jse.JavaInstance;
import org.mod.luaj.vm2.lib.jse.JavaMethod;

class JavaClass
extends JavaInstance
implements CoerceJavaToLua.Coercion {
    static final Map classes = Collections.synchronizedMap(new HashMap());
    static final LuaValue NEW = JavaClass.valueOf("new");
    Map fields;
    Map methods;
    Map innerclasses;

    static JavaClass forClass(Class c) {
        JavaClass j = (JavaClass)classes.get(c);
        if (j == null) {
            j = new JavaClass(c);
            classes.put(c, j);
        }
        return j;
    }

    JavaClass(Class c) {
        super(c);
        this.jclass = this;
    }

    @Override
    public LuaValue coerce(Object javaValue) {
        return this;
    }

    Field getField(LuaValue key) {
        if (this.fields == null) {
            HashMap<LuaString, Field> m = new HashMap<LuaString, Field>();
            Field[] f = ((Class)this.m_instance).getFields();
            for (int i = 0; i < f.length; ++i) {
                Field fi = f[i];
                if (!Modifier.isPublic(fi.getModifiers())) continue;
                m.put(LuaValue.valueOf(fi.getName()), fi);
                try {
                    if (fi.isAccessible()) continue;
                    fi.setAccessible(true);
                    continue;
                }
                catch (SecurityException s) {
                    // empty catch block
                }
            }
            this.fields = m;
        }
        return (Field)this.fields.get(key);
    }

    LuaValue getMethod(LuaValue key) {
        if (this.methods == null) {
            HashMap<String, ArrayList<JavaMethod>> namedlists = new HashMap<String, ArrayList<JavaMethod>>();
            Method[] m = ((Class)this.m_instance).getMethods();
            for (int i = 0; i < m.length; ++i) {
                Method mi = m[i];
                if (!Modifier.isPublic(mi.getModifiers())) continue;
                String name = mi.getName();
                ArrayList<JavaMethod> list = (ArrayList<JavaMethod>)namedlists.get(name);
                if (list == null) {
                    list = new ArrayList<JavaMethod>();
                    namedlists.put(name, list);
                }
                list.add(JavaMethod.forMethod(mi));
            }
            HashMap<LuaValue, Object> map = new HashMap<LuaValue, Object>();
            Constructor<?>[] c = ((Class)this.m_instance).getConstructors();
            ArrayList<JavaConstructor> list = new ArrayList<JavaConstructor>();
            for (int i = 0; i < c.length; ++i) {
                if (!Modifier.isPublic(c[i].getModifiers())) continue;
                list.add(JavaConstructor.forConstructor(c[i]));
            }
            switch (list.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    map.put(NEW, list.get(0));
                    break;
                }
                default: {
                    map.put(NEW, JavaConstructor.forConstructors(list.toArray(new JavaConstructor[list.size()])));
                }
            }
            for (Map.Entry e : namedlists.entrySet()) {
                String name = (String)e.getKey();
                List methods = (List)e.getValue();
                map.put(LuaValue.valueOf(name), methods.size() == 1 ? methods.get(0) : JavaMethod.forMethods(methods.toArray(new JavaMethod[methods.size()])));
            }
            this.methods = map;
        }
        return (LuaValue)this.methods.get(key);
    }

    Class getInnerClass(LuaValue key) {
        if (this.innerclasses == null) {
            HashMap m = new HashMap();
            Class<?>[] c = ((Class)this.m_instance).getClasses();
            for (int i = 0; i < c.length; ++i) {
                Class<?> ci = c[i];
                String name = ci.getName();
                String stub = name.substring(Math.max(name.lastIndexOf(36), name.lastIndexOf(46)) + 1);
                m.put(LuaValue.valueOf(stub), ci);
            }
            this.innerclasses = m;
        }
        return (Class)this.innerclasses.get(key);
    }

    public LuaValue getConstructor() {
        return this.getMethod(NEW);
    }
}

