/*
 * Decompiled with CFR 0.152.
 */
package org.mod.luaj.vm2.luajc;

import org.mod.luaj.vm2.Lua;
import org.mod.luaj.vm2.luajc.BasicBlock;
import org.mod.luaj.vm2.luajc.ProtoInfo;
import org.mod.luaj.vm2.luajc.VarInfo;

public class UpvalInfo {
    ProtoInfo pi;
    int slot;
    int nvars;
    VarInfo[] var;
    boolean rw;

    public UpvalInfo(ProtoInfo pi) {
        this.pi = pi;
        this.slot = 0;
        this.nvars = 1;
        this.var = new VarInfo[]{VarInfo.PARAM(0)};
        this.rw = false;
    }

    public UpvalInfo(ProtoInfo pi, int pc, int slot) {
        this.pi = pi;
        this.slot = slot;
        this.nvars = 0;
        this.var = null;
        this.includeVarAndPosteriorVars(pi.vars[slot][pc]);
        for (int i = 0; i < this.nvars; ++i) {
            this.var[i].allocupvalue = this.testIsAllocUpvalue(this.var[i]);
        }
        this.rw = this.nvars > 1;
    }

    private boolean includeVarAndPosteriorVars(VarInfo var) {
        if (var == null || var == VarInfo.INVALID) {
            return false;
        }
        if (var.upvalue == this) {
            return true;
        }
        var.upvalue = this;
        this.appendVar(var);
        if (this.isLoopVariable(var)) {
            return false;
        }
        boolean loopDetected = this.includePosteriorVarsCheckLoops(var);
        if (loopDetected) {
            this.includePriorVarsIgnoreLoops(var);
        }
        return loopDetected;
    }

    private boolean isLoopVariable(VarInfo var) {
        if (var.pc >= 0) {
            switch (Lua.GET_OPCODE(this.pi.prototype.code[var.pc])) {
                case 32: 
                case 35: {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean includePosteriorVarsCheckLoops(VarInfo prior) {
        boolean loopDetected = false;
        block0: for (BasicBlock b : this.pi.blocklist) {
            VarInfo v = this.pi.vars[this.slot][b.pc1];
            if (v == prior) {
                int m;
                int n = m = b.next != null ? b.next.length : 0;
                for (int j = 0; j < m; ++j) {
                    BasicBlock b1 = b.next[j];
                    VarInfo v1 = this.pi.vars[this.slot][b1.pc0];
                    if (v1 == prior) continue;
                    loopDetected |= this.includeVarAndPosteriorVars(v1);
                    if (!v1.isPhiVar()) continue;
                    this.includePriorVarsIgnoreLoops(v1);
                }
                continue;
            }
            for (int pc = b.pc1 - 1; pc >= b.pc0; --pc) {
                if (this.pi.vars[this.slot][pc] != prior) continue;
                loopDetected |= this.includeVarAndPosteriorVars(this.pi.vars[this.slot][pc + 1]);
                continue block0;
            }
        }
        return loopDetected;
    }

    private void includePriorVarsIgnoreLoops(VarInfo poster) {
        block0: for (BasicBlock b : this.pi.blocklist) {
            VarInfo v = this.pi.vars[this.slot][b.pc0];
            if (v == poster) {
                int m;
                int n = m = b.prev != null ? b.prev.length : 0;
                for (int j = 0; j < m; ++j) {
                    BasicBlock b0 = b.prev[j];
                    VarInfo v0 = this.pi.vars[this.slot][b0.pc1];
                    if (v0 == poster) continue;
                    this.includeVarAndPosteriorVars(v0);
                }
                continue;
            }
            for (int pc = b.pc0 + 1; pc <= b.pc1; ++pc) {
                if (this.pi.vars[this.slot][pc] != poster) continue;
                this.includeVarAndPosteriorVars(this.pi.vars[this.slot][pc - 1]);
                continue block0;
            }
        }
    }

    private void appendVar(VarInfo v) {
        if (this.nvars == 0) {
            this.var = new VarInfo[1];
        } else if (this.nvars + 1 >= this.var.length) {
            VarInfo[] s = this.var;
            this.var = new VarInfo[this.nvars * 2 + 1];
            System.arraycopy(s, 0, this.var, 0, this.nvars);
        }
        this.var[this.nvars++] = v;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.pi.name);
        for (int i = 0; i < this.nvars; ++i) {
            sb.append(i > 0 ? "," : " ");
            sb.append(String.valueOf(this.var[i]));
        }
        if (this.rw) {
            sb.append("(rw)");
        }
        return sb.toString();
    }

    private boolean testIsAllocUpvalue(VarInfo v) {
        if (v.pc < 0) {
            return true;
        }
        BasicBlock b = this.pi.blocks[v.pc];
        if (v.pc > b.pc0) {
            return this.pi.vars[this.slot][v.pc - 1].upvalue != this;
        }
        if (b.prev == null) {
            v = this.pi.params[this.slot];
            if (v != null && v.upvalue != this) {
                return true;
            }
        } else {
            int n = b.prev.length;
            for (int i = 0; i < n; ++i) {
                v = this.pi.vars[this.slot][b.prev[i].pc1];
                if (v == null || v.upvalue == this) continue;
                return true;
            }
        }
        return false;
    }
}

