/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftSilicon;
import buildcraft.BuildCraftTransport;
import buildcraft.additionalpipes.APConfiguration;
import buildcraft.additionalpipes.ChunkLoadViewDataProxy;
import buildcraft.additionalpipes.CommandAdditionalPipes;
import buildcraft.additionalpipes.MultiPlayerProxy;
import buildcraft.additionalpipes.api.TeleportManagerBase;
import buildcraft.additionalpipes.chunkloader.BlockChunkLoader;
import buildcraft.additionalpipes.chunkloader.ChunkLoadingHandler;
import buildcraft.additionalpipes.chunkloader.TileChunkLoader;
import buildcraft.additionalpipes.gates.GateProvider;
import buildcraft.additionalpipes.gates.TriggerPipeClosed;
import buildcraft.additionalpipes.gui.GuiHandler;
import buildcraft.additionalpipes.item.ItemDogDeaggravator;
import buildcraft.additionalpipes.network.PacketHandler;
import buildcraft.additionalpipes.pipes.PipeItemsAddition;
import buildcraft.additionalpipes.pipes.PipeItemsAdvancedInsertion;
import buildcraft.additionalpipes.pipes.PipeItemsAdvancedWood;
import buildcraft.additionalpipes.pipes.PipeItemsClosed;
import buildcraft.additionalpipes.pipes.PipeItemsDistributor;
import buildcraft.additionalpipes.pipes.PipeItemsGravityFeed;
import buildcraft.additionalpipes.pipes.PipeItemsJeweled;
import buildcraft.additionalpipes.pipes.PipeItemsPriorityInsertion;
import buildcraft.additionalpipes.pipes.PipeItemsTeleport;
import buildcraft.additionalpipes.pipes.PipeLiquidsObsidian;
import buildcraft.additionalpipes.pipes.PipeLiquidsTeleport;
import buildcraft.additionalpipes.pipes.PipeLiquidsWaterPump;
import buildcraft.additionalpipes.pipes.PipeLogisticsTeleport;
import buildcraft.additionalpipes.pipes.PipePowerTeleport;
import buildcraft.additionalpipes.pipes.PipeSwitchFluids;
import buildcraft.additionalpipes.pipes.PipeSwitchItems;
import buildcraft.additionalpipes.pipes.PipeSwitchPower;
import buildcraft.additionalpipes.pipes.TeleportManager;
import buildcraft.additionalpipes.test.TeleportManagerTest;
import buildcraft.additionalpipes.textures.Textures;
import buildcraft.additionalpipes.utils.Log;
import buildcraft.additionalpipes.utils.PipeCreator;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.statements.ITriggerProvider;
import buildcraft.api.statements.StatementManager;
import buildcraft.core.BCCreativeTab;
import buildcraft.core.recipes.AssemblyRecipeManager;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.PipeTransportFluids;
import buildcraft.transport.PipeTransportPower;
import buildcraft.transport.pipes.PipeFluidsGold;
import buildcraft.transport.pipes.PipeFluidsIron;
import buildcraft.transport.pipes.PipePowerGold;
import buildcraft.transport.pipes.PipePowerIron;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.command.ICommand;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="additionalpipes", name="Additional Pipes", dependencies="after:BuildCraft|Transport[7.1.5,);after:BuildCraft|Silicon;after:BuildCraft|Transport;after:BuildCraft|Factory;after:LogisticsPipes", version="4.7.0")
public class AdditionalPipes {
    public static final String MODID = "additionalpipes";
    public static final String NAME = "Additional Pipes";
    public static final String VERSION = "4.7.0";
    @Mod.Instance(value="additionalpipes")
    public static AdditionalPipes instance;
    @SidedProxy(clientSide="buildcraft.additionalpipes.MultiPlayerProxyClient", serverSide="buildcraft.additionalpipes.MultiPlayerProxy")
    public static MultiPlayerProxy proxy;
    public File configFile;
    public boolean logisticsPipesInstalled;
    public ChunkLoadViewDataProxy chunkLoadViewer;
    public BCCreativeTab creativeTab;
    public Item pipeLiquidsRedstone;
    public Item pipeItemsRedStone;
    public Item pipeItemsAdvancedInsertion;
    public Item pipeItemsAddition;
    public Item pipeItemsAdvancedWood;
    public Item pipeItemsGravityFeed;
    public Item pipeItemsDistributor;
    public Item pipeItemsJeweled;
    public Item pipeItemsPriority;
    public Item pipeItemsTeleport;
    public Item pipeLiquidsTeleport;
    public Item pipePowerTeleport;
    public Item pipeLogisticsTeleport;
    public Item pipeItemsClosed;
    public Item pipePowerSwitch;
    public Item pipeItemsSwitch;
    public Item pipeLiquidsSwitch;
    public Item pipeLiquidsWaterPump;
    public Item pipeLiquidsObsidian;
    public Block blockChunkLoader;
    public Item dogDeaggravator;
    public ITriggerInternal triggerPipeClosed;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        PacketHandler.init();
        this.configFile = event.getSuggestedConfigurationFile();
        APConfiguration.loadConfigs(false, this.configFile);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.creativeTab = new BCCreativeTab("apcreativetab");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.logisticsPipesInstalled = Loader.isModLoaded((String)"LogisticsPipes");
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        Log.info("Registering chunk load handler");
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)this, (ForgeChunkManager.LoadingCallback)new ChunkLoadingHandler());
        this.chunkLoadViewer = new ChunkLoadViewDataProxy(APConfiguration.chunkSightRange);
        FMLCommonHandler.instance().bus().register((Object)this.chunkLoadViewer);
        proxy.registerKeyHandler();
        proxy.registerRendering();
        APConfiguration.loadConfigs(true, this.configFile);
        Log.info("Registering pipes");
        this.loadPipes();
        this.creativeTab.setIcon(new ItemStack(this.pipeItemsTeleport));
        this.triggerPipeClosed = new TriggerPipeClosed();
        StatementManager.registerTriggerProvider((ITriggerProvider)new GateProvider());
        if (APConfiguration.allowWRRemove) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(this.pipeItemsTeleport), (Object[])new Object[]{this.pipePowerTeleport});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(this.pipeItemsTeleport), (Object[])new Object[]{this.pipeLiquidsTeleport});
            if (this.logisticsPipesInstalled) {
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(this.pipeItemsTeleport), (Object[])new Object[]{this.pipeLogisticsTeleport});
            }
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(this.pipeItemsSwitch), (Object[])new Object[]{this.pipeLiquidsSwitch});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(this.pipeItemsSwitch), (Object[])new Object[]{this.pipePowerSwitch});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(BuildCraftTransport.pipeItemsCobblestone), (Object[])new Object[]{BuildCraftTransport.pipeFluidsCobblestone});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(BuildCraftTransport.pipeItemsGold), (Object[])new Object[]{BuildCraftTransport.pipeFluidsGold});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(BuildCraftTransport.pipeItemsIron), (Object[])new Object[]{BuildCraftTransport.pipeFluidsIron});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(BuildCraftTransport.pipeItemsStone), (Object[])new Object[]{BuildCraftTransport.pipeFluidsStone});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(BuildCraftTransport.pipeItemsWood), (Object[])new Object[]{BuildCraftTransport.pipeFluidsWood});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(BuildCraftTransport.pipeItemsDiamond), (Object[])new Object[]{BuildCraftTransport.pipeFluidsDiamond});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(BuildCraftTransport.pipeItemsEmerald), (Object[])new Object[]{BuildCraftTransport.pipeFluidsEmerald});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(BuildCraftTransport.pipeItemsGold), (Object[])new Object[]{BuildCraftTransport.pipePowerGold});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(BuildCraftTransport.pipeItemsStone), (Object[])new Object[]{BuildCraftTransport.pipePowerStone});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(BuildCraftTransport.pipeItemsWood), (Object[])new Object[]{BuildCraftTransport.pipePowerWood});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(BuildCraftTransport.pipeItemsCobblestone), (Object[])new Object[]{BuildCraftTransport.pipePowerCobblestone});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(BuildCraftTransport.pipeItemsEmerald), (Object[])new Object[]{BuildCraftTransport.pipePowerEmerald});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(BuildCraftTransport.pipeItemsDiamond), (Object[])new Object[]{BuildCraftTransport.pipePowerDiamond});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(BuildCraftTransport.pipeItemsQuartz), (Object[])new Object[]{BuildCraftTransport.pipePowerQuartz});
        }
        this.blockChunkLoader = new BlockChunkLoader();
        this.blockChunkLoader.func_149663_c("teleportTether");
        GameRegistry.registerBlock((Block)this.blockChunkLoader, ItemBlock.class, (String)"chunkLoader");
        GameRegistry.registerTileEntity(TileChunkLoader.class, (String)"TeleportTether");
        GameRegistry.addRecipe((ItemStack)new ItemStack(this.blockChunkLoader), (Object[])new Object[]{"iii", "iLi", "iii", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('L'), new ItemStack(Items.field_151100_aR, 1, 4)});
        this.dogDeaggravator = new ItemDogDeaggravator();
        GameRegistry.registerItem((Item)this.dogDeaggravator, (String)"dogDeaggravator");
        Log.info("Running Teleport Manager Tests");
        TeleportManagerTest.runAllTests();
        TeleportManagerBase.INSTANCE = TeleportManager.instance;
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (this.logisticsPipesInstalled) {
            Log.info("Commencing morass of reflection to try and integrate with Logistics Pipes");
            boolean success = false;
            try {
                Class<?> SimpleServiceLocator = Class.forName("logisticspipes.proxy.SimpleServiceLocator");
                Class<?> SpecialPipeConnection = Class.forName("logisticspipes.proxy.specialconnection.SpecialPipeConnection");
                Class<?> ISpecialPipedConnection = Class.forName("logisticspipes.interfaces.routing.ISpecialPipedConnection");
                Class<?> APSpecialPipedConnection2 = Class.forName("buildcraft.additionalpipes.pipes.APSpecialPipedConnection");
                Field specialpipeconnectionField = SimpleServiceLocator.getDeclaredField("specialpipeconnection");
                Object specialpipeconnection = specialpipeconnectionField.get(null);
                Method registerHandler = SpecialPipeConnection.getDeclaredMethod("registerHandler", ISpecialPipedConnection);
                Object apSpecialPC = APSpecialPipedConnection2.newInstance();
                registerHandler.invoke(specialpipeconnection, apSpecialPC);
                success = true;
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            Log.info("Integration " + (success ? "succeeded" : "failed"));
        } else {
            Log.info("Logistics Pipes not detected");
        }
    }

    @Mod.EventHandler
    public void onServerStart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandAdditionalPipes());
        TeleportManager.instance.reset();
    }

    private void loadPipes() {
        this.pipeItemsTeleport = PipeCreator.createPipeTooltip(PipeItemsTeleport.class, "tip.teleportPipe");
        GameRegistry.addRecipe((ItemStack)new ItemStack(this.pipeItemsTeleport, 4), (Object[])new Object[]{"dgd", Character.valueOf('d'), BuildCraftCore.diamondGearItem, Character.valueOf('g'), Blocks.field_150359_w});
        AssemblyRecipeManager.INSTANCE.addRecipe("teleportPipe", 10000, new ItemStack(this.pipeItemsTeleport, 8), new Object[]{new ItemStack((Item)BuildCraftSilicon.redstoneChipset, 1, 4), new ItemStack(BuildCraftTransport.pipeItemsDiamond, 8), new ItemStack((Item)BuildCraftSilicon.redstoneChipset, 1, 3)});
        this.pipeLiquidsTeleport = PipeCreator.createPipeTooltip(PipeLiquidsTeleport.class, "tip.teleportPipe");
        if (this.pipeItemsTeleport != null) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(this.pipeLiquidsTeleport), (Object[])new Object[]{BuildCraftTransport.pipeWaterproof, this.pipeItemsTeleport});
        }
        this.pipePowerTeleport = PipeCreator.createPipeTooltip(PipePowerTeleport.class, "tip.teleportPipe");
        if (this.pipeItemsTeleport != null) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(this.pipePowerTeleport), (Object[])new Object[]{Items.field_151137_ax, this.pipeItemsTeleport});
        }
        if (this.logisticsPipesInstalled) {
            this.pipeLogisticsTeleport = PipeCreator.createPipeTooltip(PipeLogisticsTeleport.class, "tip.teleportLogisticsPipe");
            if (this.pipeItemsTeleport != null) {
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(this.pipeLogisticsTeleport), (Object[])new Object[]{this.pipeItemsTeleport, BuildCraftSilicon.redstoneChipset});
            }
        }
        this.pipeItemsJeweled = PipeCreator.createPipeAndRecipe(2, PipeItemsJeweled.class, new Object[]{" D ", "DGD", " D ", Character.valueOf('D'), BuildCraftTransport.pipeItemsDiamond, Character.valueOf('G'), BuildCraftCore.goldGearItem}, false);
        this.pipeItemsDistributor = PipeCreator.createPipeAndRecipe(1, PipeItemsDistributor.class, new Object[]{" r ", "IgI", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('I'), Items.field_151042_j, Character.valueOf('g'), Blocks.field_150359_w}, false);
        this.pipeItemsAdvancedInsertion = PipeCreator.createPipeAndRecipe(8, PipeItemsAdvancedInsertion.class, new Object[]{"IgI", Character.valueOf('I'), BuildCraftCore.ironGearItem, Character.valueOf('g'), Blocks.field_150359_w}, false);
        this.pipeItemsAddition = PipeCreator.createPipeAndRecipe(1, PipeItemsAddition.class, new Object[]{" R ", "RIR", " R ", Character.valueOf('I'), this.pipeItemsAdvancedInsertion, Character.valueOf('R'), Items.field_151137_ax}, false);
        this.pipeItemsPriority = PipeCreator.createPipeAndRecipe(2, PipeItemsPriorityInsertion.class, new Object[]{this.pipeItemsDistributor, this.pipeItemsAdvancedInsertion}, true);
        this.pipeItemsAdvancedWood = PipeCreator.createPipeAndRecipe(8, PipeItemsAdvancedWood.class, new Object[]{"WgW", Character.valueOf('W'), BuildCraftCore.woodenGearItem, Character.valueOf('g'), Blocks.field_150359_w}, false);
        this.pipeItemsGravityFeed = PipeCreator.createPipeAndRecipe(1, PipeItemsGravityFeed.class, new Object[]{"   ", "IgI", " I ", Character.valueOf('S'), Blocks.field_150348_b, Character.valueOf('I'), Items.field_151042_j, Character.valueOf('g'), Blocks.field_150359_w}, false);
        this.pipeItemsClosed = PipeCreator.createPipeAndRecipe(1, PipeItemsClosed.class, new Object[]{BuildCraftTransport.pipeItemsVoid, BuildCraftCore.ironGearItem}, true);
        this.pipeItemsSwitch = PipeCreator.createPipeAndRecipe(8, PipeSwitchItems.class, new Object[]{"GgI", Character.valueOf('g'), Blocks.field_150359_w, Character.valueOf('G'), BuildCraftCore.goldGearItem, Character.valueOf('I'), BuildCraftCore.ironGearItem}, false);
        int switchPowerCapacity = ((Integer)PipeTransportPower.powerCapacities.get(PipePowerGold.class) + (Integer)PipeTransportPower.powerCapacities.get(PipePowerIron.class)) / 2;
        PipeTransportPower.powerCapacities.put(PipeSwitchPower.class, switchPowerCapacity);
        this.pipePowerSwitch = PipeCreator.createPipeAndRecipe(1, PipeSwitchPower.class, new Object[]{this.pipeItemsSwitch, Items.field_151137_ax}, true);
        int switchFluidCapacity = ((Integer)PipeTransportFluids.fluidCapacities.get(PipeFluidsGold.class) + (Integer)PipeTransportFluids.fluidCapacities.get(PipeFluidsIron.class)) / 2;
        PipeTransportFluids.fluidCapacities.put(PipeSwitchFluids.class, switchFluidCapacity);
        this.pipeLiquidsSwitch = PipeCreator.createPipeAndRecipe(1, PipeSwitchFluids.class, new Object[]{this.pipeItemsSwitch, BuildCraftTransport.pipeWaterproof}, true);
        PipeTransportFluids.fluidCapacities.put(PipeLiquidsWaterPump.class, APConfiguration.waterPumpWaterPerTick);
        this.pipeLiquidsWaterPump = PipeCreator.createPipeAndRecipe(1, PipeLiquidsWaterPump.class, new Object[]{" L ", "rPr", " W ", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('P'), BuildCraftCore.ironGearItem, Character.valueOf('L'), BuildCraftTransport.pipeFluidsGold, Character.valueOf('w'), BuildCraftTransport.pipeWaterproof, Character.valueOf('W'), BuildCraftTransport.pipeFluidsWood}, false);
        PipeTransportFluids.fluidCapacities.put(PipeLiquidsObsidian.class, 100);
        this.pipeLiquidsObsidian = PipeCreator.createPipeAndRecipe(1, PipeLiquidsObsidian.class, new Object[]{BuildCraftTransport.pipeItemsObsidian, BuildCraftTransport.pipeWaterproof}, true);
    }

    public static boolean isPipe(Item item) {
        return item != null && BlockGenericPipe.pipes.containsKey(item);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void textureHook(TextureStitchEvent.Pre event) throws IOException {
        Textures.registerIcons((IIconRegister)event.map, event.map.func_130086_a());
    }
}

