/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes;

import buildcraft.additionalpipes.APConfiguration;
import buildcraft.additionalpipes.MultiPlayerProxy;
import buildcraft.additionalpipes.keyboard.KeyInputEventHandler;
import buildcraft.additionalpipes.keyboard.Keybindings;
import buildcraft.additionalpipes.utils.Log;
import buildcraft.transport.ItemPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.TransportProxyClient;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.Item;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.util.ForgeDirection;

@SideOnly(value=Side.CLIENT)
public class MultiPlayerProxyClient
extends MultiPlayerProxy {
    @Override
    public void registerKeyHandler() {
        Log.info("Registering key handler(s)");
        Keybindings.lasers = new KeyBinding("key.lasers", APConfiguration.laserKeyCode, "Additional Pipes");
        ClientRegistry.registerKeyBinding((KeyBinding)Keybindings.lasers);
        FMLCommonHandler.instance().bus().register((Object)new KeyInputEventHandler());
    }

    @Override
    public void registerPipeRendering(Item res) {
        MinecraftForgeClient.registerItemRenderer((Item)res, (IItemRenderer)TransportProxyClient.pipeItemRenderer);
    }

    @Override
    public void createPipeSpecial(ItemPipe item, Class<? extends Pipe<?>> clas) {
        try {
            Pipe<?> dummyPipe = clas.getConstructor(Item.class).newInstance(item);
            if (dummyPipe != null) {
                item.setPipesIcons(dummyPipe.getIconProvider());
                item.setPipeIconIndex(dummyPipe.getIconIndex(ForgeDirection.VALID_DIRECTIONS[0]));
            }
        }
        catch (Exception e) {
            Log.error("MultiPlayerProxyClient.createPipeSpecial() failed with exception!");
            e.printStackTrace();
        }
    }
}

