/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.APConfiguration;
import buildcraft.additionalpipes.AdditionalPipes;
import buildcraft.additionalpipes.pipes.APPipe;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.pipes.events.PipeEventItem;
import java.util.Arrays;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeItemsDistributor
extends APPipe<PipeTransportItems> {
    public int[] distData = new int[]{1, 1, 1, 1, 1, 1};
    public int distSide = 0;
    public int curTick = Integer.MAX_VALUE;

    public PipeItemsDistributor(Item item) {
        super(new PipeTransportItems(), item);
    }

    @Override
    public int getIconIndex(ForgeDirection connection) {
        switch (connection) {
            case DOWN: {
                return 10;
            }
            case UP: {
                return 11;
            }
            case NORTH: {
                return 12;
            }
            case SOUTH: {
                return 13;
            }
            case WEST: {
                return 14;
            }
        }
        return 9;
    }

    public void eventHandler(PipeEventItem.FindDest event) {
        LinkedList<ForgeDirection> result = new LinkedList<ForgeDirection>();
        if (this.curTick >= this.distData[this.distSide]) {
            this.toNextOpenSide();
        }
        result.add(ForgeDirection.VALID_DIRECTIONS[this.distSide]);
        this.curTick += event.item.getItemStack().field_77994_a;
        event.destinations.clear();
        event.destinations.addAll(result);
    }

    private void toNextOpenSide() {
        this.curTick = 0;
        for (int o = 0; o < this.distData.length; ++o) {
            this.distSide = (this.distSide + 1) % this.distData.length;
            if (this.distData[this.distSide] > 0 && this.container.isPipeConnected(ForgeDirection.VALID_DIRECTIONS[this.distSide])) break;
        }
    }

    public boolean blockActivated(EntityPlayer player, ForgeDirection direction) {
        Item equipped;
        if (player.func_70093_af()) {
            return false;
        }
        Item item = equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
        if (equipped != null && APConfiguration.filterRightclicks && AdditionalPipes.isPipe(equipped)) {
            return false;
        }
        player.openGui((Object)AdditionalPipes.instance, 2, this.container.func_145831_w(), this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e);
        return true;
    }

    private void sanityCheck() {
        for (int d : this.distData) {
            if (d <= 0) continue;
            return;
        }
        for (int i = 0; i < this.distData.length; ++i) {
            Arrays.fill(this.distData, 1);
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74768_a("curTick", this.curTick);
        nbt.func_74768_a("distSide", this.distSide);
        for (int i = 0; i < this.distData.length; ++i) {
            nbt.func_74768_a("distData" + i, this.distData[i]);
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.curTick = nbt.func_74762_e("curTick");
        this.distSide = nbt.func_74762_e("distSide");
        for (int i = 0; i < this.distData.length; ++i) {
            this.distData[i] = nbt.func_74762_e("distData" + i);
        }
        this.sanityCheck();
    }
}

