/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.APConfiguration;
import buildcraft.additionalpipes.AdditionalPipes;
import buildcraft.additionalpipes.pipes.APPipe;
import buildcraft.additionalpipes.pipes.SideFilterData;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.core.lib.inventory.InvUtils;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.pipes.events.PipeEventItem;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeItemsJeweled
extends APPipe<PipeTransportItems>
implements IDebuggable {
    public SideFilterData[] filterData = new SideFilterData[6];

    public PipeItemsJeweled(Item item) {
        super(new PipeTransportItems(), item);
        for (int index = 0; index < this.filterData.length; ++index) {
            this.filterData[index] = new SideFilterData();
        }
    }

    @Override
    public int getIconIndex(ForgeDirection connection) {
        switch (connection) {
            case DOWN: {
                return 35;
            }
            case UP: {
                return 36;
            }
            case NORTH: {
                return 37;
            }
            case SOUTH: {
                return 38;
            }
            case WEST: {
                return 39;
            }
        }
        return 34;
    }

    public void eventHandler(PipeEventItem.FindDest event) {
        LinkedList<ForgeDirection> filteredOrientations = new LinkedList<ForgeDirection>();
        LinkedList<ForgeDirection> defaultOrientations = new LinkedList<ForgeDirection>();
        ItemStack stack = event.item.getItemStack();
        for (ForgeDirection dir : event.destinations) {
            SideFilterData data = this.filterData[dir.ordinal()];
            if (data.matchesStack(stack)) {
                filteredOrientations.add(dir);
                continue;
            }
            if (!data.acceptsUnsortedItems()) continue;
            defaultOrientations.add(dir);
        }
        event.destinations.clear();
        if (!filteredOrientations.isEmpty()) {
            event.destinations.addAll(filteredOrientations);
        } else {
            event.destinations.addAll(defaultOrientations);
        }
    }

    public boolean blockActivated(EntityPlayer player, ForgeDirection direction) {
        Item equipped;
        if (player.func_70093_af()) {
            return false;
        }
        Item item = equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
        if (equipped != null && APConfiguration.filterRightclicks && AdditionalPipes.isPipe(equipped)) {
            return false;
        }
        player.openGui((Object)AdditionalPipes.instance, 6, this.container.func_145831_w(), this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e);
        return true;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        NBTTagList filterList = new NBTTagList();
        for (int index = 0; index < this.filterData.length; ++index) {
            NBTTagCompound filterTag = new NBTTagCompound();
            this.filterData[index].writeToNBT(filterTag);
            filterList.func_74742_a((NBTBase)filterTag);
        }
        nbt.func_74782_a("filterList", (NBTBase)filterList);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        NBTTagList filterList = nbt.func_150295_c("filterList", 10);
        for (int index = 0; index < this.filterData.length; ++index) {
            NBTTagCompound filterTag = filterList.func_150305_b(index);
            this.filterData[index].readFromNBT(filterTag);
        }
    }

    public void dropContents() {
        super.dropContents();
        for (SideFilterData sideFilter : this.filterData) {
            InvUtils.dropItems((World)this.getWorld(), (IInventory)sideFilter, (int)this.container.field_145851_c, (int)this.container.field_145848_d, (int)this.container.field_145849_e);
        }
    }

    public void getDebugInfo(List<String> info, ForgeDirection side, ItemStack debugger, EntityPlayer player) {
        SideFilterData clickedSide = this.filterData[side.ordinal()];
        info.add("Accepts unsorted items: " + clickedSide.acceptsUnsortedItems());
        info.add("Matches NBT: " + clickedSide.matchNBT());
        info.add("Matches metadata: " + clickedSide.matchMetadata());
    }
}

