/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.pipes.APPipe;
import buildcraft.additionalpipes.utils.Log;
import buildcraft.api.core.Position;
import buildcraft.core.lib.RFBattery;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.transport.PipeTransportFluids;
import buildcraft.transport.TransportProxy;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.pipes.events.PipeEvent;
import buildcraft.transport.pipes.events.PipeEventItem;
import cofh.api.energy.IEnergyHandler;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class PipeLiquidsObsidian
extends APPipe<PipeTransportFluids>
implements IEnergyHandler {
    private static final int ICON = 31;
    AxisAlignedBB searchBox;
    private RFBattery battery = new RFBattery(2560, 640, 0);
    private int[] entitiesDropped;
    private int entitiesDroppedIndex = 0;
    private FluidStack fluidInItem = null;
    private ItemStack currentItem = null;

    public PipeLiquidsObsidian(Item item) {
        super(new PipeTransportFluids(), item);
        ((PipeTransportFluids)this.transport).initFromPipe(((Object)((Object)this)).getClass());
        this.entitiesDropped = new int[32];
        Arrays.fill(this.entitiesDropped, -1);
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        return 31;
    }

    public void onEntityCollidedWithBlock(Entity entity) {
        EntityItem entityItem;
        super.onEntityCollidedWithBlock(entity);
        if (entity.field_70128_L) {
            return;
        }
        if (entity instanceof EntityItem && this.canSuck(entityItem = (EntityItem)entity, 0)) {
            this.pullItemIntoPipe(entityItem, 0);
        }
    }

    private AxisAlignedBB getSuckingBox(ForgeDirection orientation, int distance) {
        if (orientation == ForgeDirection.UNKNOWN) {
            return null;
        }
        Position p1 = new Position((double)this.container.field_145851_c, (double)this.container.field_145848_d, (double)this.container.field_145849_e, orientation);
        Position p2 = new Position((double)this.container.field_145851_c, (double)this.container.field_145848_d, (double)this.container.field_145849_e, orientation);
        switch (orientation) {
            case EAST: {
                p1.x += (double)distance;
                p2.x += (double)(1 + distance);
                break;
            }
            case WEST: {
                p1.x -= (double)(distance - 1);
                p2.x -= (double)distance;
                break;
            }
            case UP: 
            case DOWN: {
                p1.x += (double)(distance + 1);
                p2.x -= (double)distance;
                p1.z += (double)(distance + 1);
                p2.z -= (double)distance;
                break;
            }
            case SOUTH: {
                p1.z += (double)distance;
                p2.z += (double)(distance + 1);
                break;
            }
            default: {
                p1.z -= (double)(distance - 1);
                p2.z -= (double)distance;
            }
        }
        switch (orientation) {
            case EAST: 
            case WEST: {
                p1.y += (double)(distance + 1);
                p2.y -= (double)distance;
                p1.z += (double)(distance + 1);
                p2.z -= (double)distance;
                break;
            }
            case UP: {
                p1.y += (double)(distance + 1);
                p2.y += (double)distance;
                break;
            }
            case DOWN: {
                p1.y -= (double)(distance - 1);
                p2.y -= (double)distance;
                break;
            }
            default: {
                p1.y += (double)(distance + 1);
                p2.y -= (double)distance;
                p1.x += (double)(distance + 1);
                p2.x -= (double)distance;
            }
        }
        Position min = p1.min(p2);
        Position max = p1.max(p2);
        return AxisAlignedBB.func_72330_a((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
    }

    public void updateEntity() {
        super.updateEntity();
        if (this.fluidInItem != null) {
            this.fluidInItem.amount -= ((PipeTransportFluids)this.transport).fill(ForgeDirection.UNKNOWN, this.fluidInItem, true);
            if (this.fluidInItem.amount <= 0) {
                TravelingItem travelingItem = TravelingItem.make((double)this.container.x(), (double)this.container.y(), (double)this.container.z(), (ItemStack)this.currentItem);
                travelingItem.setContainer((TileEntity)this.container);
                this.dropItem(travelingItem);
                this.fluidInItem = null;
                this.currentItem = null;
            }
        } else {
            if (this.battery.getEnergyStored() > 0) {
                for (int j = 1; j < 5; ++j) {
                    if (!this.suckItem(j)) continue;
                    return;
                }
            }
            this.battery.useEnergy(0, 5, false);
        }
    }

    private boolean suckItem(int distance) {
        AxisAlignedBB box = this.getSuckingBox(this.getOpenOrientation(), distance);
        if (box == null) {
            return false;
        }
        List discoveredEntities = this.container.func_145831_w().func_72872_a(EntityItem.class, box);
        for (EntityItem entity : discoveredEntities) {
            if (!this.canSuck(entity, distance)) continue;
            this.pullItemIntoPipe(entity, distance);
            return true;
        }
        return false;
    }

    public void pullItemIntoPipe(EntityItem entity, int distance) {
        if (this.container.func_145831_w().field_72995_K) {
            return;
        }
        this.container.func_145831_w().func_72956_a((Entity)entity, "random.pop", 0.2f, ((this.container.func_145831_w().field_73012_v.nextFloat() - this.container.func_145831_w().field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        ItemStack stack = null;
        double speed = 0.01f;
        ItemStack contained = entity.func_92059_d();
        if (contained == null) {
            return;
        }
        TransportProxy.proxy.obsidianPipePickup(this.container.func_145831_w(), entity, (TileEntity)this.container);
        int energyUsed = Math.min(10 * contained.field_77994_a * distance, this.battery.getEnergyStored());
        if (distance == 0 || energyUsed / distance / 10 == contained.field_77994_a) {
            stack = contained;
            CoreProxy.proxy.removeEntity((Entity)entity);
        } else {
            stack = contained.func_77979_a(energyUsed / distance / 10);
        }
        speed = Math.sqrt(entity.field_70159_w * entity.field_70159_w + entity.field_70181_x * entity.field_70181_x + entity.field_70179_y * entity.field_70179_y);
        speed = speed / 2.0 - 0.05;
        if (speed < 0.01) {
            speed = 0.01;
        }
        if (stack == null) {
            return;
        }
        this.storeAndDrainItem(contained);
    }

    private void storeAndDrainItem(ItemStack stack) {
        FluidStack drainedLiquid;
        if (FluidContainerRegistry.isFilledContainer((ItemStack)stack)) {
            drainedLiquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
            this.currentItem = FluidContainerRegistry.drainFluidContainer((ItemStack)stack);
        } else {
            IFluidContainerItem fluidContainerItem = (IFluidContainerItem)stack.func_77973_b();
            drainedLiquid = fluidContainerItem.drain(stack, fluidContainerItem.getCapacity(stack), true);
            this.currentItem = stack;
        }
        Log.debug("Storing " + drainedLiquid.amount + "MB of fluid in buffer.");
        if (this.fluidInItem != null && this.fluidInItem.isFluidEqual(drainedLiquid)) {
            this.fluidInItem.amount += drainedLiquid.amount;
        } else {
            this.fluidInItem = drainedLiquid;
        }
    }

    private void dropItem(TravelingItem item) {
        if (this.container.func_145831_w().field_72995_K) {
            return;
        }
        PipeEventItem.DropItem event = new PipeEventItem.DropItem(this.container.pipe, item, item.toEntityItem());
        this.container.pipe.eventBus.handleEvent(PipeEventItem.DropItem.class, (PipeEvent)event);
        if (event.entity == null) {
            return;
        }
        EntityItem entity = event.entity;
        ForgeDirection direction = item.input;
        entity.func_70107_b(entity.field_70165_t + (double)direction.offsetX * 0.5, entity.field_70163_u + (double)direction.offsetY * 0.5, entity.field_70161_v + (double)direction.offsetZ * 0.5);
        entity.field_70159_w = (double)((float)direction.offsetX * item.getSpeed() * 5.0f) + this.getWorld().field_73012_v.nextGaussian() * 0.1;
        entity.field_70181_x = (double)((float)direction.offsetY * item.getSpeed() * 5.0f) + this.getWorld().field_73012_v.nextGaussian() * 0.1;
        entity.field_70179_y = (double)((float)direction.offsetZ * item.getSpeed() * 5.0f) + this.getWorld().field_73012_v.nextGaussian() * 0.1;
        this.container.func_145831_w().func_72838_d((Entity)entity);
    }

    public void eventHandler(PipeEventItem.DropItem event) {
        this.entitiesDroppedIndex = this.entitiesDroppedIndex + 1 >= this.entitiesDropped.length ? 0 : ++this.entitiesDroppedIndex;
        this.entitiesDropped[this.entitiesDroppedIndex] = event.entity.func_145782_y();
    }

    public boolean canSuck(EntityItem item, int distance) {
        if (item.func_92059_d().field_77994_a <= 0) {
            return false;
        }
        if (this.battery.getEnergyStored() < distance * 10) {
            return false;
        }
        Item fluidItem = item.func_92059_d().func_77973_b();
        Integer fluidID = null;
        if (fluidItem instanceof IFluidContainerItem) {
            FluidStack containedFluid = ((IFluidContainerItem)fluidItem).getFluid(item.func_92059_d());
            if (containedFluid != null) {
                fluidID = containedFluid.getFluidID();
            }
        } else if (FluidContainerRegistry.isFilledContainer((ItemStack)item.func_92059_d())) {
            fluidID = FluidContainerRegistry.getFluidForFilledItem((ItemStack)item.func_92059_d()).getFluidID();
        }
        if (fluidID == null || ((PipeTransportFluids)this.transport).fluidType != null && fluidID != ((PipeTransportFluids)this.transport).fluidType.amount) {
            return false;
        }
        for (int element : this.entitiesDropped) {
            if (item.func_145782_y() != element) continue;
            return false;
        }
        return true;
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.battery.receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.battery.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.battery.getMaxEnergyStored();
    }

    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        if (this.fluidInItem != null) {
            NBTTagCompound fluidInItemTag = new NBTTagCompound();
            this.fluidInItem.writeToNBT(fluidInItemTag);
            nbt.func_74782_a("fluidInItemTag", (NBTBase)fluidInItemTag);
            NBTTagCompound currentItemTag = new NBTTagCompound();
            this.currentItem.func_77955_b(currentItemTag);
            nbt.func_74782_a("currentItemTag", (NBTBase)currentItemTag);
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        if (nbt.func_74764_b("fluidInItemTag")) {
            this.fluidInItem = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("fluidInItemTag"));
            this.currentItem = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("currentItemTag"));
        }
    }
}

