/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.api.PipeType;
import buildcraft.additionalpipes.pipes.PipeTeleport;
import buildcraft.additionalpipes.pipes.PipeTransportItemsLogistics;
import buildcraft.additionalpipes.pipes.TeleportManager;
import buildcraft.additionalpipes.utils.Log;
import buildcraft.api.core.Position;
import buildcraft.api.tools.IToolWrench;
import buildcraft.transport.pipes.events.PipeEventItem;
import buildcraft.transport.utils.TransportUtils;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeLogisticsTeleport
extends PipeTeleport<PipeTransportItemsLogistics> {
    private static final int ICON = 40;

    public PipeLogisticsTeleport(Item items) {
        super(new PipeTransportItemsLogistics(), items, PipeType.ITEMS);
    }

    public void eventHandler(PipeEventItem.Entered event) {
        if (this.getWorld().field_72995_K) {
            return;
        }
        PipeLogisticsTeleport otherPipe = this.getConnectedPipe();
        if (otherPipe == null || !this.canSend()) {
            return;
        }
        Position insertPoint = otherPipe.getPosition();
        insertPoint.x += 0.5;
        insertPoint.y += (double)TransportUtils.getPipeFloorOf((ItemStack)event.item.getItemStack());
        insertPoint.z += 0.5;
        insertPoint.moveForwards(0.5);
        event.item.setPosition(insertPoint.x, insertPoint.y, insertPoint.z);
        ForgeDirection newOrientation = otherPipe.getOpenOrientation().getOpposite();
        ((PipeTransportItemsLogistics)otherPipe.transport).injectItem(event.item, newOrientation);
        Log.debug(event.item + " from " + this.getPosition() + " to " + otherPipe.getPosition() + " " + newOrientation);
        event.cancelled = true;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        return 40;
    }

    public PipeLogisticsTeleport getConnectedPipe() {
        ArrayList<PipeLogisticsTeleport> connectedPipes = TeleportManager.instance.getConnectedPipes(this, true, true);
        if (connectedPipes.size() == 0) {
            return null;
        }
        if (connectedPipes.size() > 1) {
            Log.unexpected("This Logistics Teleport Pipe has more than one other pipe on its channel.  Somewhere, somebody messed up!");
            return null;
        }
        return (PipeLogisticsTeleport)connectedPipes.get(0);
    }

    @Override
    public boolean blockActivated(EntityPlayer entityplayer, ForgeDirection direction) {
        Item equipped;
        Item item = equipped = entityplayer.func_71045_bC() != null ? entityplayer.func_71045_bC().func_77973_b() : null;
        if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(entityplayer, this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e)) {
            ((PipeTransportItemsLogistics)this.transport).switchSource();
            ((IToolWrench)equipped).wrenchUsed(entityplayer, this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e);
            return true;
        }
        return super.blockActivated(entityplayer, direction);
    }
}

