/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.pipes.PipeLogisticsTeleport;
import buildcraft.additionalpipes.pipes.PipeTransportItemsLogistics;
import buildcraft.core.lib.TileBuffer;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.TravelingItem;
import java.util.List;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.buildcraft.LPRoutedBCTravelingItem;
import logisticspipes.routing.pathfinder.IPipeInformationProvider;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.tuples.LPPosition;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeTeleportInformationProvider
implements IPipeInformationProvider {
    public PipeLogisticsTeleport pipe;

    public PipeTeleportInformationProvider(PipeLogisticsTeleport pipe) {
        this.pipe = pipe;
    }

    public boolean isCorrect() {
        return BlockGenericPipe.isValid((Pipe)this.pipe);
    }

    public int getX() {
        return this.pipe.container.x();
    }

    public int getY() {
        return this.pipe.container.y();
    }

    public int getZ() {
        return this.pipe.container.z();
    }

    public boolean isRouterInitialized() {
        return false;
    }

    public boolean isRoutingPipe() {
        return false;
    }

    public CoreRoutedPipe getRoutingPipe() {
        return null;
    }

    public TileEntity getTile(ForgeDirection direction) {
        return this.pipe.container.getTile(direction);
    }

    public boolean isFirewallPipe() {
        return false;
    }

    public IFilter getFirewallFilter() {
        return null;
    }

    public boolean divideNetwork() {
        return false;
    }

    public boolean powerOnly() {
        return false;
    }

    public boolean isOnewayPipe() {
        return this.pipe.canReceive() ^ this.pipe.canSend();
    }

    public boolean isOutputOpen(ForgeDirection direction) {
        if (direction == this.pipe.getOpenOrientation()) {
            return true;
        }
        return direction == ForgeDirection.UNKNOWN && this.pipe.getConnectedPipe() != null;
    }

    public boolean canConnect(TileEntity to, ForgeDirection direction, boolean flag) {
        return ((PipeTransportItemsLogistics)this.pipe.transport).canPipeConnect(to, direction);
    }

    public double getDistance() {
        return 1.0;
    }

    public boolean isItemPipe() {
        return true;
    }

    public boolean isFluidPipe() {
        return false;
    }

    public boolean isPowerPipe() {
        return true;
    }

    public double getDistanceTo(int destinationint, ForgeDirection ignore, ItemIdentifier ident, boolean isActive, double traveled, double max, List<LPPosition> visited) {
        if (traveled >= max) {
            return 2.147483647E9;
        }
        PipeLogisticsTeleport connectedPipe = this.pipe.getConnectedPipe();
        if (connectedPipe != null) {
            LPPosition start = new LPPosition((TileEntity)this.pipe.container);
            LPPosition end = new LPPosition((TileEntity)connectedPipe.container);
            return start.distanceTo(end);
        }
        return 2.147483647E9;
    }

    public boolean acceptItem(LPTravelingItem item, TileEntity from) {
        if (BlockGenericPipe.isValid((Pipe)this.pipe) || this.pipe.canSend()) {
            LPRoutedBCTravelingItem bcItem = null;
            if (!(item instanceof LPTravelingItem.LPTravelingItemServer)) {
                return true;
            }
            LPRoutedBCTravelingItem lpBCItem = new LPRoutedBCTravelingItem();
            lpBCItem.setRoutingInformation(((LPTravelingItem.LPTravelingItemServer)item).getInfo());
            lpBCItem.saveToExtraNBTData();
            bcItem = lpBCItem;
            LPPosition p = new LPPosition((double)((float)this.getX() + 0.5f), (double)((float)this.getY() + 0.25f), (double)((float)this.getZ() + 0.5f));
            if (item.output.getOpposite() == ForgeDirection.DOWN) {
                p.moveForward(item.output.getOpposite(), (double)0.24f);
            } else if (item.output.getOpposite() == ForgeDirection.UP) {
                p.moveForward(item.output.getOpposite(), (double)0.74f);
            } else {
                p.moveForward(item.output.getOpposite(), (double)0.49f);
            }
            bcItem.setPosition(p.getXD(), p.getYD(), p.getZD());
            bcItem.setSpeed(item.getSpeed());
            if (item.getItemIdentifierStack() != null) {
                bcItem.setItemStack(item.getItemIdentifierStack().makeNormalStack());
            }
            ((PipeTransportItemsLogistics)this.pipe.transport).injectItem((TravelingItem)bcItem, item.output);
            return true;
        }
        return false;
    }

    public void refreshTileCacheOnSide(ForgeDirection side) {
        TileBuffer[] cache = this.pipe.container.getTileCache();
        if (cache != null) {
            cache[side.ordinal()].refresh();
        }
    }

    public World getWorld() {
        return this.pipe.getWorld();
    }

    public TileEntity getTile() {
        return this.pipe.container;
    }
}

