/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.remaininmotion.carriage;

import me.planetguy.remaininmotion.carriage.TileEntityCarriage;
import me.planetguy.remaininmotion.core.RiMConfiguration;
import me.planetguy.remaininmotion.motion.CarriageMotionException;
import me.planetguy.remaininmotion.motion.CarriagePackage;
import me.planetguy.remaininmotion.util.position.BlockRecord;
import me.planetguy.remaininmotion.util.position.BlockRecordSet;
import me.planetguy.remaininmotion.util.transformations.Directions;

public class TileEntitySupportCarriage
extends TileEntityCarriage {
    public TileEntitySupportCarriage() {
        for (Directions Direction : Directions.values()) {
            if (Direction == Directions.PosY) continue;
            this.SideClosed[Direction.ordinal()] = true;
        }
    }

    @Override
    public void ToggleSide(int Side2, boolean Sneaking) {
        if (Sneaking) {
            Side2 = Directions.values()[Side2].opposite().ordinal();
        }
        for (Directions Direction : Directions.values()) {
            this.SideClosed[Direction.ordinal()] = Direction.ordinal() != Side2;
        }
        this.Propagate();
    }

    public void FailBecauseOverburdened() throws CarriageMotionException {
        throw new CarriageMotionException("support carriage exceeds size limit of " + RiMConfiguration.Carriage.MaxSupportBurden + " blocks carried");
    }

    @Override
    public void fillPackage(CarriagePackage Package2) throws CarriageMotionException {
        BlockRecord TargetRecord;
        Directions SupportDirection = this.getHeadingDirection();
        if (SupportDirection == null) {
            return;
        }
        BlockRecordSet ValidColumns = new BlockRecordSet();
        int ValidColumnCheckFactorX = SupportDirection.deltaX == 0 ? 1 : 0;
        int ValidColumnCheckFactorY = SupportDirection.deltaY == 0 ? 1 : 0;
        int ValidColumnCheckFactorZ = SupportDirection.deltaZ == 0 ? 1 : 0;
        BlockRecordSet BlocksChecked = new BlockRecordSet();
        BlockRecordSet CarriagesToCheck = new BlockRecordSet();
        BlockRecordSet BlocksToCheck = new BlockRecordSet();
        BlocksChecked.add(Package2.AnchorRecord);
        Package2.AddBlock(Package2.AnchorRecord);
        CarriagesToCheck.add(Package2.AnchorRecord);
        int BlocksCarried = 0;
        boolean terminatedByReversal = false;
        while (CarriagesToCheck.size() > 0) {
            BlockRecord checkingRecord = (BlockRecord)CarriagesToCheck.pollFirst();
            if (((TileEntitySupportCarriage)checkingRecord.entity).getHeadingDirection() != SupportDirection) {
                throw new CarriageMotionException("support carriage must have all open sides in the same direction");
            }
            ValidColumns.add(new BlockRecord(checkingRecord.X * ValidColumnCheckFactorX, checkingRecord.Y * ValidColumnCheckFactorY, checkingRecord.Z * ValidColumnCheckFactorZ));
            if (Package2.MotionDirection == SupportDirection.opposite()) {
                Package2.AddPotentialObstruction(checkingRecord.NextInDirection(Package2.MotionDirection));
            }
            for (Directions TargetDirection : Directions.values()) {
                if (TargetDirection == SupportDirection.opposite() || !BlocksChecked.add(TargetRecord = checkingRecord.NextInDirection(TargetDirection)) || this.field_145850_b.func_147437_c(TargetRecord.X, TargetRecord.Y, TargetRecord.Z)) continue;
                TargetRecord.Identify(this.field_145850_b);
                if (TargetDirection == SupportDirection && !terminatedByReversal) {
                    Package2.AddBlock(TargetRecord);
                    BlocksToCheck.add(TargetRecord);
                    if (++BlocksCarried > RiMConfiguration.Carriage.MaxSupportBurden) {
                        this.FailBecauseOverburdened();
                    }
                    if (TargetRecord.entity == null || !(TargetRecord.entity instanceof TileEntitySupportCarriage) || !((TileEntityCarriage)TargetRecord.entity).treatSideAsClosed(SupportDirection.oppositeOrdinal)) continue;
                    terminatedByReversal = true;
                    continue;
                }
                if (Package2.MatchesCarriageType(TargetRecord)) {
                    if (!Package2.AddBlock(TargetRecord)) continue;
                    CarriagesToCheck.add(TargetRecord);
                    continue;
                }
                if (TargetDirection != Package2.MotionDirection) continue;
                Package2.AddPotentialObstruction(TargetRecord);
            }
        }
        terminatedByReversal = false;
        while (BlocksToCheck.size() > 0) {
            BlockRecord BlockRecord2 = (BlockRecord)BlocksToCheck.pollFirst();
            for (Directions TargetDirection : Directions.values()) {
                TargetRecord = BlockRecord2.NextInDirection(TargetDirection);
                BlockRecord TargetRecordCheck = new BlockRecord(TargetRecord.X * ValidColumnCheckFactorX, TargetRecord.Y * ValidColumnCheckFactorY, TargetRecord.Z * ValidColumnCheckFactorZ);
                if (!ValidColumns.contains(TargetRecordCheck)) {
                    if (TargetDirection != Package2.MotionDirection) continue;
                    Package2.AddPotentialObstruction(TargetRecord);
                    continue;
                }
                if (!BlocksChecked.add(TargetRecord)) continue;
                TargetRecord.Identify(this.field_145850_b);
                if (SupportDirection == TargetDirection && terminatedByReversal) continue;
                if (TargetRecord.entity != null && TargetRecord.entity instanceof TileEntitySupportCarriage && !((TileEntityCarriage)TargetRecord.entity).treatSideAsClosed(SupportDirection.oppositeOrdinal)) {
                    terminatedByReversal = true;
                }
                if (!Package2.AddBlock(TargetRecord)) continue;
                BlocksToCheck.add(TargetRecord);
                if (++BlocksCarried <= RiMConfiguration.Carriage.MaxSupportBurden) continue;
                this.FailBecauseOverburdened();
            }
        }
    }

    public Directions getHeadingDirection() {
        Directions heading = null;
        for (Directions Direction : Directions.values()) {
            if (this.SideClosed[Direction.ordinal()]) continue;
            heading = Direction;
            break;
        }
        return heading;
    }
}

