/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.remaininmotion.carriage;

import me.planetguy.lib.util.Debug;
import me.planetguy.remaininmotion.base.BlockRiM;
import me.planetguy.remaininmotion.carriage.BlockCarriage;
import me.planetguy.remaininmotion.carriage.ItemCarriage;
import me.planetguy.remaininmotion.carriage.TileEntityCarriage;
import me.planetguy.remaininmotion.core.RIMBlocks;
import me.planetguy.remaininmotion.core.RiMConfiguration;
import me.planetguy.remaininmotion.motion.CarriageMotionException;
import me.planetguy.remaininmotion.motion.CarriagePackage;
import me.planetguy.remaininmotion.util.WorldUtil;
import me.planetguy.remaininmotion.util.position.BlockRecord;
import me.planetguy.remaininmotion.util.position.BlockRecordList;
import me.planetguy.remaininmotion.util.position.BlockRecordSet;
import me.planetguy.remaininmotion.util.transformations.Directions;
import me.planetguy.remaininmotion.util.transformations.Matrices;
import me.planetguy.remaininmotion.util.transformations.Matrix;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityTemplateCarriage
extends TileEntityCarriage {
    public BlockRecordList Pattern;
    public boolean RenderPattern;

    protected void emitParentDrops(BlockRiM block, int meta) {
        super.EmitDrops(block, meta);
    }

    @Override
    public void EmitDrops(BlockRiM Block2, int Meta) {
        ItemStack item;
        int PatternSize;
        super.EmitDrops(Block2, Meta);
        if (this.Pattern == null) {
            return;
        }
        for (PatternSize = this.Pattern.size(); PatternSize > 64; PatternSize -= 64) {
            item = ItemCarriage.Stack(Meta);
            item.field_77994_a = 64;
            this.EmitDrop(Block2, item);
        }
        item = ItemCarriage.Stack(Meta);
        item.field_77994_a = PatternSize;
        this.EmitDrop(Block2, item);
    }

    @Override
    public void ToggleSide(int Side2, boolean Sneaking) {
        if (this.Pattern == null) {
            this.AbsorbPattern();
            if (this.Pattern == null) {
                return;
            }
        } else if (Sneaking) {
            this.ReabsorbPattern();
        } else {
            this.RenderPattern = !this.RenderPattern;
        }
        this.Propagate();
    }

    public boolean isBlockValidMarkerForPattern(BlockRecord Record) {
        boolean IsUnpatternedTemplateCarriage = false;
        Record.Identify(this.field_145850_b);
        if (Record.block == RIMBlocks.Carriage && Record.Meta == BlockCarriage.Types.Template.ordinal() && ((TileEntityTemplateCarriage)Record.entity).Pattern == null) {
            IsUnpatternedTemplateCarriage = true;
        }
        Record.entity = null;
        return IsUnpatternedTemplateCarriage;
    }

    public void AbsorbPattern() {
        BlockRecordSet Pattern = new BlockRecordSet();
        BlockRecordSet BlocksChecked = new BlockRecordSet();
        BlocksChecked.add(new BlockRecord(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        BlockRecordSet BlocksToCheck = new BlockRecordSet();
        BlocksToCheck.add(new BlockRecord(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        while (BlocksToCheck.size() > 0 && BlocksChecked.size() < RiMConfiguration.Carriage.MaxTemplateBurden) {
            BlockRecord Record = (BlockRecord)BlocksToCheck.pollFirst();
            Directions[] directionsArray = Directions.values();
            int n = directionsArray.length;
            for (int i = 0; i < n; ++i) {
                Directions Direction = directionsArray[i];
                BlockRecord NextRecord = Record.NextInDirection(Direction);
                if (!BlocksChecked.add(NextRecord) || !this.isBlockValidMarkerForPattern(NextRecord)) continue;
                Pattern.add(NextRecord);
                BlocksToCheck.add(NextRecord);
            }
        }
        if (Pattern.size() == 0) {
            return;
        }
        for (BlockRecord PatternBlock : Pattern) {
            this.erase(PatternBlock);
            PatternBlock.X -= this.field_145851_c;
            PatternBlock.Y -= this.field_145848_d;
            PatternBlock.Z -= this.field_145849_e;
        }
        for (Directions Direction : Directions.values()) {
            this.SideClosed[Direction.ordinal()] = true;
        }
        this.Pattern = new BlockRecordList();
        this.Pattern.addAll(Pattern);
    }

    protected void erase(BlockRecord record) {
        WorldUtil.ClearBlock(this.field_145850_b, record.X, record.Y, record.Z);
    }

    public void ReabsorbPattern() {
        BlockRecordSet Pattern = new BlockRecordSet();
        for (BlockRecord Position : this.Pattern) {
            Position.X += this.field_145851_c;
            Position.Y += this.field_145848_d;
            Position.Z += this.field_145849_e;
            Pattern.add(Position);
        }
        BlockRecordSet NewPositions = new BlockRecordSet();
        BlockRecordSet DeadPositions = new BlockRecordSet();
        for (BlockRecord Position : Pattern) {
            for (Directions Direction : Directions.values()) {
                BlockRecord Record = Position.NextInDirection(Direction);
                if (Pattern.contains(Record) || NewPositions.contains(Record) || !this.isBlockValidMarkerForPattern(Record)) continue;
                NewPositions.add(Record);
            }
            if (!this.isBlockValidMarkerForPattern(Position)) continue;
            DeadPositions.add(Position);
        }
        if (RiMConfiguration.Debug.verbose) {
            Debug.dbg((Object)NewPositions);
        }
        for (BlockRecord Position : DeadPositions) {
            WorldUtil.ClearBlock(this.field_145850_b, Position.X, Position.Y, Position.Z);
            Pattern.remove(Position);
        }
        for (BlockRecord Position : NewPositions) {
            WorldUtil.ClearBlock(this.field_145850_b, Position.X, Position.Y, Position.Z);
            Pattern.add(Position);
        }
        for (BlockRecord Position : Pattern) {
            Position.X -= this.field_145851_c;
            Position.Y -= this.field_145848_d;
            Position.Z -= this.field_145849_e;
        }
        this.Pattern.clear();
        this.Pattern.addAll(Pattern);
        if (RiMConfiguration.Debug.verbose) {
            Debug.dbg((Object)Pattern);
            Debug.dbg((Object)this.Pattern);
        }
    }

    @Override
    public void ReadCommonRecord(NBTTagCompound TagCompound) {
        super.ReadCommonRecord(TagCompound);
        if (TagCompound.func_74764_b("Pattern")) {
            if (RiMConfiguration.Debug.verbose) {
                Debug.dbg((Object)"Found PatternRecord");
            }
            NBTTagList PatternRecord = TagCompound.func_150295_c("Pattern", 10);
            this.Pattern = new BlockRecordList();
            int PatternSize = PatternRecord.func_74745_c();
            if (RiMConfiguration.Debug.verbose) {
                Debug.dbg((Object)("PatternRecord size=" + PatternSize));
            }
            for (int Index = 0; Index < PatternSize; ++Index) {
                NBTTagCompound PatternBlockRecord = PatternRecord.func_150305_b(Index);
                this.Pattern.add(new BlockRecord(PatternBlockRecord.func_74765_d("X"), PatternBlockRecord.func_74765_d("Y"), PatternBlockRecord.func_74765_d("Z")));
            }
        } else {
            this.Pattern = null;
        }
        this.RenderPattern = TagCompound.func_74767_n("RenderPattern");
    }

    private void writePattern(NBTTagCompound TagCompound) {
        if (this.Pattern != null) {
            NBTTagList PatternRecord = new NBTTagList();
            for (BlockRecord PatternBlock : this.Pattern) {
                NBTTagCompound PatternBlockRecord = new NBTTagCompound();
                PatternBlockRecord.func_74777_a("X", (short)PatternBlock.X);
                PatternBlockRecord.func_74777_a("Y", (short)PatternBlock.Y);
                PatternBlockRecord.func_74777_a("Z", (short)PatternBlock.Z);
                PatternRecord.func_74742_a((NBTBase)PatternBlockRecord);
            }
            TagCompound.func_74782_a("Pattern", (NBTBase)PatternRecord);
        }
    }

    @Override
    public void WriteServerRecord(NBTTagCompound TagCompound) {
        super.WriteCommonRecord(TagCompound);
        this.writePattern(TagCompound);
    }

    @Override
    public void WriteClientRecord(NBTTagCompound TagCompound) {
        super.WriteClientRecord(TagCompound);
        if (this.RenderPattern) {
            TagCompound.func_74757_a("RenderPattern", this.RenderPattern);
            this.writePattern(TagCompound);
        }
    }

    @Override
    public void fillPackage(CarriagePackage cPackage) throws CarriageMotionException {
        if (this.Pattern == null) {
            this.updatePattern();
        }
        cPackage.AddBlock(cPackage.AnchorRecord);
        if (cPackage.MotionDirection != null) {
            cPackage.AddPotentialObstruction(cPackage.AnchorRecord.NextInDirection(cPackage.MotionDirection));
        }
        for (BlockRecord PatternBlock : this.Pattern) {
            BlockRecord Record = new BlockRecord(PatternBlock.X + this.field_145851_c, PatternBlock.Y + this.field_145848_d, PatternBlock.Z + this.field_145849_e);
            if (this.field_145850_b.func_147437_c(Record.X, Record.Y, Record.Z)) continue;
            Record.Identify(this.field_145850_b);
            cPackage.AddBlock(Record);
            if (cPackage.MotionDirection == null) continue;
            cPackage.AddPotentialObstruction(Record.NextInDirection(cPackage.MotionDirection));
        }
    }

    public void updatePattern() throws CarriageMotionException {
        throw new CarriageMotionException("template carriage has not yet been patterned");
    }

    public String toString() {
        return "Template carriage " + this.Pattern;
    }

    @Override
    public void rotateSpecial(ForgeDirection axis) {
        for (BlockRecord toRotateRecord : this.Pattern) {
            this.rotateOrthogonal(Directions.values()[axis.ordinal()], toRotateRecord);
        }
        this.Propagate();
    }

    public void rotateOrthogonal(Directions clockwiseFace, BlockRecord pos) {
        Matrix coordsMatrixNew = new Matrix(new double[][]{{pos.X}, {pos.Y}, {pos.Z}});
        Matrix rotation = Matrices.ccwRotMatrices[clockwiseFace.ordinal()];
        Matrix newCoords = rotation.crossProduct(coordsMatrixNew);
        pos.X = (int)newCoords.matrix[0][0];
        pos.Y = (int)newCoords.matrix[1][0];
        pos.Z = (int)newCoords.matrix[2][0];
    }
}

