/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.remaininmotion.core;

import java.io.File;
import me.planetguy.lib.util.BlacklistDynamic;
import me.planetguy.remaininmotion.core.Config;
import me.planetguy.remaininmotion.motion.BlacklistManager;
import me.planetguy.remaininmotion.motion.CarriagePackage;

public class RiMConfiguration
extends Config {
    public RiMConfiguration(File File2) {
        super(File2);
    }

    public void Process() {
        this.Category = "Carriage";
        BlacklistManager.blacklistSoft = new BlacklistDynamic(this.Configuration, this.Configuration.get(this.Category, "blacklistSoft", ""), "RemIMBlacklistSoft");
        BlacklistManager.blacklistHard = new BlacklistDynamic(this.Configuration, this.Configuration.get(this.Category, "blacklistHard", ""), "RemIMBlacklistHard");
        BlacklistManager.blacklistRotation = new BlacklistDynamic(this.Configuration, this.Configuration.get(this.Category, "rotationBlacklist", ""), "RemIMBlacklistRotation");
        CarriagePackage.MaxBlockCount = this.BoundedInteger("CarriageMaxSize", "Maximum size of any carriage (0 = no limit)", 0, CarriagePackage.MaxBlockCount, Integer.MAX_VALUE);
        Carriage.MaxPlatformBurden = this.BoundedInteger("PlatformCarriageMaxSize", "Maximum blocks carried by platform carriage", 1, Carriage.MaxPlatformBurden, Integer.MAX_VALUE);
        Carriage.MaxSupportBurden = this.BoundedInteger("SupportCarriageMaxSize", "Maximum blocks carried by a support carriage", 1, Carriage.MaxSupportBurden, Integer.MAX_VALUE);
        Carriage.MaxTemplateBurden = this.BoundedInteger("TemplateCarriageMaxSize", "Maximum blocks carried by a template carriage", 1, Carriage.MaxTemplateBurden, Integer.MAX_VALUE);
        Carriage.MaxMemoryBurden = this.BoundedInteger("MemoryCarriageMaxSize", "Maximum blocks carried by a memory carriage", 1, Carriage.MaxMemoryBurden, Integer.MAX_VALUE);
        Carriage.BlacklistBedrock = this.Boolean("BlacklistBedrock", "Carriages refuse to move bedrock (DANGEROUS IF FALSE)", Carriage.BlacklistBedrock);
        Carriage.BlacklistByPiston = this.Boolean("RespectPistonBlacklist", "Carriages refuse to move blocks that pistons cannot move", Carriage.BlacklistByPiston);
        this.Category = "Carriage Drive";
        CarriageDrive.ContinuousCooldown = this.BoundedInteger("ContinuousModeCooldown", "Cooldown (in ticks) between motions in continuous mode", 0, CarriageDrive.ContinuousCooldown, Integer.MAX_VALUE);
        this.Category = "Carriage motion";
        CarriageMotion.CapturePlayerEntities = this.Boolean("MovePlayers", "Should grab players during motion", CarriageMotion.CapturePlayerEntities);
        CarriageMotion.CaptureOtherLivingEntities = this.Boolean("MoveNonPlayerLiving", "Should grab non-player living entities during motion", CarriageMotion.CaptureOtherLivingEntities);
        CarriageMotion.CaptureItemEntities = this.Boolean("MoveItemEnities", "Should grab floating items during motion", CarriageMotion.CaptureItemEntities);
        CarriageMotion.CaptureOtherEntities = this.Boolean("MoveAllOtherEntities", "Should grab all other miscellaneous entities during motion", CarriageMotion.CaptureOtherEntities);
        CarriageMotion.TeleportEntities = this.Boolean("TeleportEntities", "Should translocate grabbed entities", CarriageMotion.TeleportEntities);
        CarriagePackage.ObstructedByLiquids = this.Boolean("LiquidsBlockMovement", "Carriage motion/teleportation is obstructed by liquids", CarriagePackage.ObstructedByLiquids);
        CarriagePackage.ObstructedByFragileBlocks = this.Boolean("SoftTilesBlockMovement", "Carriage motion is obstructed by fragile blocks like tall grass", CarriagePackage.ObstructedByFragileBlocks);
        CarriageMotion.RenderInFinalPositionDuringLag = this.Boolean("StopAnimationDuringLag", "Animation of motion should stop during severe lag", CarriageMotion.RenderInFinalPositionDuringLag);
        CarriageMotion.MotionDuration = this.BoundedInteger("MotionDurationInTicks", "Duration of motion in ticks", 1, CarriageMotion.MotionDuration, Integer.MAX_VALUE);
        CarriageMotion.TeleportationDuration = this.BoundedInteger("TeleportDurationInTicks", "Duration of translocation in ticks", 1, CarriageMotion.TeleportationDuration, Integer.MAX_VALUE);
        CarriageMotion.SoundIndex = this.BoundedInteger("Sound File Index", "Which Sounds to use. 0 is Default, 1-3 are sounds DA3DSOUL made, 10 is silence", 0, CarriageMotion.SoundIndex, 10);
        switch (CarriageMotion.SoundIndex) {
            case 0: {
                CarriageMotion.SoundFile = "hum";
                break;
            }
            case 10: {
                CarriageMotion.SoundFile = "mute";
                break;
            }
            default: {
                CarriageMotion.SoundFile = "engine_" + CarriageMotion.SoundIndex;
            }
        }
        CarriageMotion.volume = this.Configuration.getFloat("Sound Volume", this.Category, CarriageMotion.volume, 0.0f, 9001.0f, "");
        this.Category = "Cosmetics";
        Cosmetic.ShowHelpInTooltips = this.Boolean("ExtendedTooltips", "Show descriptions of purposes/uses of blocks/items in tooltips", Cosmetic.ShowHelpInTooltips);
        Cosmetic.renderFallback = this.Boolean("FailsafeRendering", "Use the fallback renderer (try this if Minecraft closes instantly when moving carriages)", Cosmetic.renderFallback);
        Cosmetic.maxTags = this.Integer("PacketMaxSize", "Limit on size of carriage to transmit, or -1 for no limit. Decrease if clients get errors like: Unexpected end of ZLIB input stream", Cosmetic.maxTags);
        this.Category = "Dirty Hacks";
        DirtyHacks.UpdateBuildcraftPipes = this.Boolean("ForceBCPipeUpdate", "Attempt to hyper-reinitialize Buildcraft pipes after motion", DirtyHacks.UpdateBuildcraftPipes);
        DirtyHacks.allowRotation = this.Boolean("EnableRotationCarriage", "Allow rotator carriage", DirtyHacks.allowRotation);
        DirtyHacks.experimentalColor = this.Boolean("EnableExperimentalColor", "Things like grass that have colorizers do 'interesting' things when used as camouflage. Who likes funny color glitches?", DirtyHacks.experimentalColor);
        this.Category = "Debugging";
        Debug.LogMotionExceptions = this.Boolean("LogExceptions", "Write carriage-motion errors to client/server log", Debug.LogMotionExceptions);
        Debug.MuteMotionExceptions = this.Boolean("MuteAllMotionErrors", "Mute carriage-motion errors completely", Debug.MuteMotionExceptions);
        Debug.verbose = this.Boolean("VerboseLogging", "Log everything (will fill up your console/logs)", Debug.verbose);
        this.Category = "Hardmode";
        HardMode.HardmodeActive = this.Boolean("EnableHardmode", "Use RF to power carriages in addition to redstone", HardMode.HardmodeActive);
        HardMode.PowerConsumptionFactor = this.Double("EnergyUseScalar", "Power consumption factor", HardMode.PowerConsumptionFactor);
        HardMode.powerCapacity = this.Integer("MaxEnergyStored", "Power capacity of carriages", HardMode.powerCapacity);
        HardMode.distanceAffectsEnergy = this.Boolean("distanceAffectsEnergy", "The distance a translocator moves affects the amount of energy required (very expensive)", HardMode.distanceAffectsEnergy);
        HardMode.peakDistance = this.Integer("peakDistance", "Distance in blocks where peak multiplier is met", HardMode.peakDistance);
        HardMode.maxDistanceMultiplier = this.Double("maxDistanceMultiplier", "Peak distance energy multiplier", HardMode.maxDistanceMultiplier);
        HardMode.otherDimensionMultiplier = this.Double("otherDimensionMultiplier", "Additional multiplier for teleporting to another dimension (it stacks with distance)", HardMode.otherDimensionMultiplier);
        this.Configuration.save();
    }

    public static enum TextureSets {
        JAKJ("256x textures", 256.0, 102.0, 99.0, 159.0, 155.0),
        cubemelon("default 16x textures by cubemelon", 16.0, 7.0, 7.0, 9.0, 9.0),
        JustHev("16x textures (with support for colourblindness) by JustHev", 16.0, 7.0, 5.0, 9.0, 7.0),
        uberifix_wood("16x wood-style textures by uberifix", 16.0, 7.0, 4.0, 9.0, 6.0),
        uberifix_metal("16x metal-style textures (with support for colourblindness) by uberifix", 16.0, 7.0, 4.0, 9.0, 6.0),
        Lethosos("16x Dynasty-style textures by Lethosos", 16.0, 7.0, 8.0, 9.0, 10.0);

        public String Description;
        public double LabelMinH;
        public double LabelMinV;
        public double LabelMaxH;
        public double LabelMaxV;
        public static int TextureSet;

        private TextureSets(String Description, double Resolution, double LabelMinH, double LabelMinV, double LabelMaxH, double LabelMaxV) {
            this.Description = Description;
            this.LabelMinH = LabelMinH / Resolution;
            this.LabelMinV = LabelMinV / Resolution;
            this.LabelMaxH = LabelMaxH / Resolution;
            this.LabelMaxV = LabelMaxV / Resolution;
        }

        static {
            TextureSet = 1;
        }
    }

    public static abstract class HardMode {
        public static boolean HardmodeActive = false;
        public static double PowerConsumptionFactor = 10.0;
        public static int powerCapacity = 10000;
        public static boolean distanceAffectsEnergy = true;
        public static double otherDimensionMultiplier = 4.0;
        public static int peakDistance = 4000;
        public static double maxDistanceMultiplier = 15.0;
    }

    public static abstract class Debug {
        public static boolean LogMotionExceptions = false;
        public static boolean MuteMotionExceptions = true;
        public static boolean verbose = false;
    }

    public static abstract class DirtyHacks {
        public static boolean UpdateBuildcraftPipes = true;
        public static boolean allowRotation = true;
        public static boolean experimentalColor = true;
    }

    public static abstract class Cosmetic {
        public static boolean ShowHelpInTooltips = true;
        public static boolean renderFallback = false;
        public static int maxTags = -1;
    }

    public static abstract class CarriageMotion {
        public static boolean CapturePlayerEntities = true;
        public static boolean CaptureOtherLivingEntities = true;
        public static boolean CaptureItemEntities = true;
        public static boolean CaptureOtherEntities = true;
        public static boolean TeleportEntities = true;
        public static boolean RenderInFinalPositionDuringLag = false;
        public static int MotionDuration = 20;
        public static int TeleportationDuration = 160;
        public static int SoundIndex = 0;
        public static String SoundFile = "hum";
        public static float volume = 1.2f;
    }

    public static abstract class CarriageDrive {
        public static int ContinuousCooldown = 5;
    }

    public static abstract class Carriage {
        public static int MaxPlatformBurden = 5000;
        public static int MaxSupportBurden = 5000;
        public static int MaxTemplateBurden = 5000;
        public static int MaxMemoryBurden = 5000;
        public static boolean BlacklistBedrock = true;
        public static boolean BlacklistByPiston = false;
    }
}

