/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.remaininmotion.core.interop.mod;

import codechicken.lib.world.WorldExtension;
import codechicken.lib.world.WorldExtensionManager;
import codechicken.multipart.MultipartHelper;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TickScheduler;
import codechicken.multipart.TileMultipart;
import codechicken.multipart.handler.MultipartSaveLoad;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashMap;
import me.planetguy.lib.util.transformations.Rotator;
import me.planetguy.remaininmotion.api.event.BlockSelectForMoveEvent;
import me.planetguy.remaininmotion.api.event.BlocksReplacedEvent;
import me.planetguy.remaininmotion.api.event.IBlockPos;
import me.planetguy.remaininmotion.api.event.MotionFinalizeEvent;
import me.planetguy.remaininmotion.api.event.RotatingTEPreUnpackEvent;
import me.planetguy.remaininmotion.api.event.TEPostPlaceEvent;
import me.planetguy.remaininmotion.api.event.TEPrePlaceEvent;
import me.planetguy.remaininmotion.util.position.BlockRecord;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import scala.collection.Iterable;
import scala.collection.JavaConversions;

public class ForgeMultipart {
    private static HashMap<World, TickScheduler.WorldTickScheduler> knownSchedulers = new HashMap();

    @SubscribeEvent
    public void onFMPMoved(BlockSelectForMoveEvent e) {
        if (this.isMultipart(e.location.entity())) {
            ForgeMultipart.saveMultipartTick(e.location.entity(), e.location.entityTag());
        }
    }

    @SubscribeEvent
    public void onFMPFinalized(MotionFinalizeEvent e) {
        if (this.isMultipart(e.location.entity())) {
            this.loadMultipartTick(e.location);
        }
    }

    @SubscribeEvent
    public void replaceTE(TEPrePlaceEvent e) {
        BlockRecord record = (BlockRecord)e.location;
        World worldObj = record.World;
        if (record.entityRecord.func_74779_i("id").equals("savedMultipart")) {
            try {
                record.entity = MultipartHelper.createTileFromNBT((World)worldObj, (NBTTagCompound)record.entityRecord);
            }
            catch (Throwable Throwable2) {
                Throwable2.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void onPlaced(TEPostPlaceEvent e) {
        BlockRecord record = (BlockRecord)e.location;
        World worldObj = record.World;
        if (record.entityRecord.func_74779_i("id").equals("savedMultipart")) {
            try {
                ((TileMultipart)record.entity).onChunkLoad();
                MultipartHelper.sendDescPacket((World)worldObj, (TileEntity)record.entity);
            }
            catch (Throwable Throwable2) {
                Throwable2.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void onUnpackStart(BlocksReplacedEvent e) {
        MultipartSaveLoad.loadingWorld_$eq((World)e.unpackingEntity.func_145831_w());
    }

    @SubscribeEvent
    public void onFMPBlockRotated(RotatingTEPreUnpackEvent e) {
        try {
            IBlockPos pos = e.location;
            NBTTagCompound tag = e.location.entityTag();
            if (tag != null && tag.func_74779_i("id").equals("savedMultipart")) {
                for (int i = 0; i < tag.func_150295_c("parts", 10).func_74745_c(); ++i) {
                    NBTTagCompound part = tag.func_150295_c("parts", 10).func_150305_b(i);
                    if (!part.func_74764_b("shape")) continue;
                    byte shape = part.func_74771_c("shape");
                    shape = (byte)(shape & 0xF0 | Rotator.newSide((int)(shape & 0xF), (ForgeDirection)e.axis));
                    part.func_74774_a("shape", shape);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void saveMultipartTick(TileEntity te, NBTTagCompound record) {
        TickScheduler.WorldTickScheduler sched = ForgeMultipart.getTickScheduler(te.func_145831_w());
        for (TickScheduler.ChunkTickScheduler cts : JavaConversions.asJavaCollection((Iterable)sched.tickChunks())) {
            for (TickScheduler.PartTickEntry entry : JavaConversions.asJavaCollection((Iterable)cts.tickList())) {
                if (entry.part().tile() != te) continue;
                record.func_74768_a("RemIMFMPTickD", (int)(entry.time() - sched.schedTime()));
                record.func_74757_a("RemIMFMPTickR", entry.random());
                record.func_74778_a("RemIMFMPTickT", entry.part().getType());
            }
        }
    }

    private static TickScheduler.WorldTickScheduler getTickScheduler(World w) {
        if (knownSchedulers.containsKey(w)) {
            return knownSchedulers.get(w);
        }
        int extensionsCounted = 0;
        try {
            WorldExtension we;
            while (!((we = WorldExtensionManager.getWorldExtension((World)w, (int)extensionsCounted)) instanceof TickScheduler.WorldTickScheduler)) {
            }
            knownSchedulers.put(w, (TickScheduler.WorldTickScheduler)we);
            return (TickScheduler.WorldTickScheduler)we;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void loadMultipartTick(IBlockPos pos) {
        TileEntity te = pos.entity();
        NBTTagCompound record = pos.entityTag();
        TickScheduler.WorldTickScheduler sched = ForgeMultipart.getTickScheduler(te.func_145831_w());
        long ticks = record.func_74762_e("RemIMFMPTickD");
        boolean random = record.func_74767_n("RemIMFMPTickR");
        String type = record.func_74779_i("RemIMFMPTickT");
        for (TMultiPart part : JavaConversions.asJavaCollection((Iterable)((TileMultipart)te).partList())) {
            if (!part.getType().equals(type)) continue;
            sched.scheduleTick(part, (int)ticks, random);
        }
    }

    public boolean isMultipart(TileEntity part) {
        return part instanceof TileMultipart;
    }
}

