/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.remaininmotion.drive;

import java.util.List;
import me.planetguy.lib.util.SidedIcons;
import me.planetguy.remaininmotion.base.BlockCamouflageable;
import me.planetguy.remaininmotion.base.BlockRiM;
import me.planetguy.remaininmotion.base.TileEntityRiM;
import me.planetguy.remaininmotion.core.ModRiM;
import me.planetguy.remaininmotion.core.RIMBlocks;
import me.planetguy.remaininmotion.drive.ItemCarriageDrive;
import me.planetguy.remaininmotion.drive.TileEntityCarriageAdapter;
import me.planetguy.remaininmotion.drive.TileEntityCarriageController;
import me.planetguy.remaininmotion.drive.TileEntityCarriageDirected;
import me.planetguy.remaininmotion.drive.TileEntityCarriageDrive;
import me.planetguy.remaininmotion.drive.TileEntityCarriageEngine;
import me.planetguy.remaininmotion.drive.TileEntityCarriageMotor;
import me.planetguy.remaininmotion.drive.TileEntityCarriageRotator;
import me.planetguy.remaininmotion.drive.TileEntityCarriageTransduplicator;
import me.planetguy.remaininmotion.drive.TileEntityCarriageTranslocator;
import me.planetguy.remaininmotion.util.Registry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCarriageDrive
extends BlockCamouflageable {
    public static IIcon InactiveIcon;
    public static IIcon DyeIconSet;
    public static IIcon PublicIcon;
    public static IIcon PrivateToSelfIcon;
    public static IIcon PrivateToOtherIcon;

    public BlockCarriageDrive() {
        super(Blocks.field_150339_S, ItemCarriageDrive.class, TileEntityCarriageEngine.class, TileEntityCarriageMotor.class, TileEntityCarriageController.class, TileEntityCarriageTranslocator.class, TileEntityCarriageTransduplicator.class, TileEntityCarriageAdapter.class, TileEntityCarriageRotator.class, TileEntityCarriageDirected.class);
        this.setHarvestLevel(BlockRiM.HarvestToolTypes.Pickaxe, 0);
    }

    @Override
    public void AddShowcaseStacks(List Showcase) {
        for (Types Type2 : Types.values()) {
            if (Type2 == Types.Controller && ModRiM.CarriageControllerEntity == null) continue;
            Showcase.add(ItemCarriageDrive.Stack(Type2.ordinal(), 0));
        }
    }

    public void func_149651_a(IIconRegister IconRegister) {
        for (Types Type2 : Types.values()) {
            if (Type2 == Types.Controller) {
                if (ModRiM.CarriageControllerEntity == null) {
                    continue;
                }
            } else {
                Type2.ContinuousIcon = Registry.RegisterIcon(IconRegister, "Carriage" + Type2.name() + "_Continuous");
                Type2.ContinuousActiveIcon = Registry.RegisterIcon(IconRegister, "Carriage" + Type2.name() + "_Continuous_Active");
            }
            Type2.NormalIcon = Registry.RegisterIcon(IconRegister, "Carriage" + Type2.name());
            Type2.NormalActiveIcon = Registry.RegisterIcon(IconRegister, "Carriage" + Type2.name() + "_Active");
        }
        InactiveIcon = Registry.RegisterIcon(IconRegister, "CarriageDriveInactive");
        DyeIconSet = Registry.RegisterIcon(IconRegister, "CarriageTranslocator_LabelDyes");
        PublicIcon = Registry.RegisterIcon(IconRegister, "CarriageTranslocator_LabelPublic");
        PrivateToSelfIcon = Registry.RegisterIcon(IconRegister, "CarriageTranslocator_LabelPrivateToSelf");
        PrivateToOtherIcon = Registry.RegisterIcon(IconRegister, "CarriageTranslocator_LabelPrivateToOther");
        TileEntityCarriageDirected.helper = new SidedIcons(Registry.RegisterIcon(IconRegister, "DirectedFront"), Registry.RegisterIcon(IconRegister, "DirectedSide"), Registry.RegisterIcon(IconRegister, "DirectedSide1"), Registry.RegisterIcon(IconRegister, "DirectedSide2"), Types.Adapter.NormalIcon);
        TileEntityCarriageRotator.onRegisterIcons(IconRegister);
    }

    public IIcon func_149691_a(int Side2, int Meta) {
        try {
            switch (Types.values()[Meta]) {
                case Rotator: {
                    return TileEntityCarriageRotator.icons[0][Side2];
                }
                case Predirected: {
                    return TileEntityCarriageDirected.helper.getIcon(ForgeDirection.NORTH, Side2);
                }
            }
            return Types.values()[Meta].NormalIcon;
        }
        catch (Throwable Throwable2) {
            return RIMBlocks.Spectre.func_149691_a(0, 0);
        }
    }

    public IIcon func_149673_e(IBlockAccess World2, int X, int Y, int Z, int Side2) {
        try {
            TileEntityCarriageDrive Drive = (TileEntityCarriageDrive)World2.func_147438_o(X, Y, Z);
            int meta = World2.func_72805_g(X, Y, Z);
            IIcon icon = Drive.getIcon(Side2, meta);
            if (icon == null) {
                icon = InactiveIcon;
            }
            return icon;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean func_149727_a(World World2, int X, int Y, int Z, EntityPlayer Player, int Side2, float HitX, float HitY, float HitZ) {
        TileEntity te = World2.func_147438_o(X, Y, Z);
        if (te instanceof TileEntityCarriageDrive && Player != null) {
            return ((TileEntityCarriageDrive)te).HandleToolUsage(Side2, Player.func_70093_af(), Player);
        }
        return false;
    }

    public void func_149695_a(World World2, int X, int Y, int Z, Block Id) {
        try {
            ((TileEntityCarriageDrive)World2.func_147438_o(X, Y, Z)).HandleNeighbourBlockChange();
        }
        catch (Throwable Throwable2) {
            Throwable2.printStackTrace();
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntityRiM tile = (TileEntityRiM)world.func_147438_o(x, y, z);
        if (tile != null) {
            ItemStack stack;
            int label = 0;
            if (tile instanceof TileEntityCarriageTranslocator) {
                label = ((TileEntityCarriageTranslocator)tile).Label;
            }
            if ((stack = ItemCarriageDrive.Stack(world.func_72805_g(x, y, z), 0, false, label)) != null) {
                return stack;
            }
        }
        return super.getPickBlock(target, world, x, y, z);
    }

    public static enum Tiers {
        wood(1.0, 1.0);

        public double MaxBurdenFactor;
        public double EnergyConsumptionFactor;

        private Tiers(double burden, double power) {
            this.EnergyConsumptionFactor = power;
            this.MaxBurdenFactor = burden;
        }
    }

    public static enum Types {
        Engine(1.0),
        Motor(1.01),
        Controller(1.1),
        Translocator(4.0),
        Transduplicator(0.0),
        Adapter(1.0),
        Rotator(1.0),
        Predirected(1.01);

        public IIcon NormalIcon;
        public IIcon ContinuousIcon;
        public IIcon NormalActiveIcon;
        public IIcon ContinuousActiveIcon;
        public double MaxBurden = 1000.0;
        public double EnergyConsumption;

        private Types(double energy) {
            this.EnergyConsumption = energy;
        }
    }
}

