/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.remaininmotion.drive;

import cofh.api.energy.IEnergyHandler;
import me.planetguy.lib.util.Debug;
import me.planetguy.lib.util.SneakyWorldUtil;
import me.planetguy.remaininmotion.api.Moveable;
import me.planetguy.remaininmotion.base.BlockRiM;
import me.planetguy.remaininmotion.base.TileEntityCamouflageable;
import me.planetguy.remaininmotion.core.ModRiM;
import me.planetguy.remaininmotion.core.RIMBlocks;
import me.planetguy.remaininmotion.core.RiMConfiguration;
import me.planetguy.remaininmotion.core.RiMItems;
import me.planetguy.remaininmotion.core.interop.EventPool;
import me.planetguy.remaininmotion.drive.BlockCarriageDrive;
import me.planetguy.remaininmotion.drive.ItemCarriageDrive;
import me.planetguy.remaininmotion.drive.gui.Buttons;
import me.planetguy.remaininmotion.motion.CarriageMatchers;
import me.planetguy.remaininmotion.motion.CarriageMotionException;
import me.planetguy.remaininmotion.motion.CarriageObstructionException;
import me.planetguy.remaininmotion.motion.CarriagePackage;
import me.planetguy.remaininmotion.network.PacketRenderData;
import me.planetguy.remaininmotion.spectre.BlockSpectre;
import me.planetguy.remaininmotion.spectre.TileEntityMotiveSpectre;
import me.planetguy.remaininmotion.spectre.TileEntitySupportiveSpectre;
import me.planetguy.remaininmotion.util.WorldUtil;
import me.planetguy.remaininmotion.util.position.BlockPosition;
import me.planetguy.remaininmotion.util.position.BlockRecord;
import me.planetguy.remaininmotion.util.position.BlockRecordSet;
import me.planetguy.remaininmotion.util.transformations.ArrayRotator;
import me.planetguy.remaininmotion.util.transformations.Directions;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;

public abstract class TileEntityCarriageDrive
extends TileEntityCamouflageable
implements IEnergyHandler {
    public boolean Continuous;
    public boolean[] SideClosed = new boolean[Directions.values().length];
    public boolean Signalled;
    public int CooldownRemaining;
    public boolean Active;
    public int Tier;
    public int energyStored = 0;
    public EntityPlayer lastUsingPlayer;
    public Directions CarriageDirection;
    protected Directions SignalDirection;
    protected double extraEnergy = 1.0;
    private int ticksExisted = 0;
    public boolean isCreative = false;
    public boolean requiresScrewdriverToOpen = false;
    public int personalDurationInTicks = RiMConfiguration.CarriageMotion.MotionDuration;
    public boolean zeroContinuousCooldown = false;
    public boolean Stale = true;
    public boolean isAnchored = false;

    @Override
    public void WriteCommonRecord(NBTTagCompound tag) {
        super.WriteCommonRecord(tag);
        tag.func_74757_a("Continuous", this.Continuous);
        for (Directions Direction : Directions.values()) {
            tag.func_74757_a("SideClosed" + Direction.ordinal(), this.SideClosed[Direction.ordinal()]);
        }
        tag.func_74757_a("Active", this.Active);
        tag.func_74768_a("Tier", this.Tier);
        tag.func_74768_a("energyStored", this.energyStored);
        tag.func_74757_a("screwdriver", this.requiresScrewdriverToOpen);
        tag.func_74757_a("anchored", this.isAnchored);
        tag.func_74768_a("PersonalDuration", this.personalDurationInTicks);
        tag.func_74757_a("ForceZeroCooldown", this.zeroContinuousCooldown);
    }

    @Override
    public void WriteServerRecord(NBTTagCompound tag) {
        super.WriteServerRecord(tag);
        tag.func_74757_a("Signalled", this.Signalled);
        tag.func_74768_a("CooldownRemaining", this.CooldownRemaining);
        if (this.lastUsingPlayer != null) {
            tag.func_74778_a("player", this.lastUsingPlayer.func_70005_c_());
        }
        tag.func_74757_a("creative", this.isCreative);
    }

    @Override
    public void ReadCommonRecord(NBTTagCompound tag) {
        super.ReadCommonRecord(tag);
        this.Continuous = tag.func_74767_n("Continuous");
        for (Directions Direction : Directions.values()) {
            this.SideClosed[Direction.ordinal()] = tag.func_74767_n("SideClosed" + Direction.ordinal());
        }
        this.Active = tag.func_74767_n("Active");
        this.Tier = tag.func_74762_e("Tier");
        this.energyStored = tag.func_74762_e("energyStored");
        this.requiresScrewdriverToOpen = tag.func_74767_n("screwdriver");
        this.isAnchored = tag.func_74767_n("anchored");
        this.personalDurationInTicks = tag.func_74762_e("PersonalDuration");
        this.zeroContinuousCooldown = tag.func_74767_n("ForceZeroCooldown");
    }

    @Override
    public void ReadServerRecord(NBTTagCompound tag) {
        super.ReadServerRecord(tag);
        this.Signalled = tag.func_74767_n("Signalled");
        this.CooldownRemaining = tag.func_74762_e("CooldownRemaining");
        try {
            if (tag.func_74764_b("player")) {
                this.lastUsingPlayer = this.field_145850_b.func_72924_a(tag.func_74779_i("player"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isCreative = tag.func_74767_n("creative");
    }

    @Override
    public void EmitDrops(BlockRiM Block2, int Meta) {
        this.EmitDrop(Block2, ItemCarriageDrive.Stack(Meta, this.Tier));
    }

    @Override
    public void Setup(EntityPlayer Player, ItemStack Item2) {
        super.Setup(Player, Item2);
        this.lastUsingPlayer = Player;
        this.Tier = ItemCarriageDrive.GetTier(Item2);
        this.isCreative = Player != null ? Player.field_71075_bZ.field_75098_d : false;
    }

    public boolean HandleToolUsage(int Side2, boolean Sneaking, EntityPlayer player) {
        if (!this.requiresScrewdriverToOpen || player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == RiMItems.ToolItemSet) {
            player.openGui((Object)ModRiM.instance, 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return false;
    }

    public void ToggleActivity() {
        if (this.Active && this.Continuous && !this.zeroContinuousCooldown) {
            this.CooldownRemaining = RiMConfiguration.CarriageDrive.ContinuousCooldown;
        } else if (this.Active) {
            this.Signalled = true;
        }
        this.Active = !this.Active;
        this.Propagate();
    }

    @Override
    public void Initialize() {
        this.Stale = true;
    }

    public void HandleNeighbourBlockChange() {
        this.Stale = false;
        this.CarriageDirection = null;
        boolean CarriageDirectionValid = true;
        this.setSignalDirection(null);
        boolean SignalDirectionValid = true;
        for (Directions Direction : Directions.values()) {
            int X = this.field_145851_c + Direction.deltaX;
            int Y = this.field_145848_d + Direction.deltaY;
            int Z = this.field_145849_e + Direction.deltaZ;
            if (this.field_145850_b.func_147437_c(X, Y, Z) || this.isSideClosed(Direction.ordinal())) continue;
            Block Id = this.field_145850_b.func_147439_a(X, Y, Z);
            TileEntity te = this.field_145850_b.func_147438_o(X, Y, Z);
            Moveable m = CarriageMatchers.getMover(Id, this.field_145850_b.func_72805_g(X, Y, Z), te);
            if (m != null) {
                if (this.CarriageDirection != null) {
                    CarriageDirectionValid = false;
                } else {
                    this.CarriageDirection = Direction;
                }
            }
            if (Id.func_149709_b((IBlockAccess)this.field_145850_b, X, Y, Z, Direction.ordinal()) <= 0) continue;
            if (this.getSignalDirection() != null) {
                SignalDirectionValid = false;
                continue;
            }
            this.setSignalDirection(Direction);
        }
        if (!CarriageDirectionValid) {
            this.CarriageDirection = null;
        }
        if (!SignalDirectionValid) {
            this.setSignalDirection(null);
        }
    }

    public void func_145845_h() {
        block19: {
            this.field_145850_b.field_72984_F.func_76320_a("RiMCarriageDrive");
            if (this.field_145850_b.field_72995_K) {
                this.field_145850_b.field_72984_F.func_76319_b();
                return;
            }
            if (this.Active) {
                if (this.ticksExisted > 0 && this.ticksExisted < this.personalDurationInTicks && this.ticksExisted % 20 == 0 && this.Anchored()) {
                    ModRiM.plHelper.playSound(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, RiMConfiguration.CarriageMotion.SoundFile, RiMConfiguration.CarriageMotion.volume, 1.0f);
                }
                ++this.ticksExisted;
                if (this.ticksExisted >= this.personalDurationInTicks) {
                    this.ticksExisted = 0;
                }
            } else if (this.ticksExisted != 0) {
                this.ticksExisted = 0;
            }
            if (this.Stale) {
                this.HandleNeighbourBlockChange();
            }
            if (this.CooldownRemaining > 0) {
                --this.CooldownRemaining;
                this.MarkServerRecordDirty();
                this.field_145850_b.field_72984_F.func_76319_b();
                return;
            }
            if (this.Active) {
                this.field_145850_b.field_72984_F.func_76319_b();
                return;
            }
            if (this.SignalDirection == null) {
                if (this.Signalled) {
                    this.Signalled = false;
                    this.MarkServerRecordDirty();
                }
                this.field_145850_b.field_72984_F.func_76319_b();
                return;
            }
            if (this.CarriageDirection == null) {
                this.field_145850_b.field_72984_F.func_76319_b();
                return;
            }
            if (this.Signalled) {
                if (!this.Continuous) {
                    this.field_145850_b.field_72984_F.func_76319_b();
                    return;
                }
            } else {
                this.Signalled = true;
                this.MarkServerRecordDirty();
            }
            this.field_145850_b.field_72984_F.func_76320_a("InitiateMotion");
            try {
                this.InitiateMotion(this.PreparePackage(this.getSignalDirection().opposite()));
                ModRiM.plHelper.playSound(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, RiMConfiguration.CarriageMotion.SoundFile, RiMConfiguration.CarriageMotion.volume, 1.0f);
            }
            catch (CarriageMotionException Exception2) {
                String Message = "Drive at (" + this.field_145851_c + "," + this.field_145848_d + "," + this.field_145849_e + ") in dimension " + this.field_145850_b.field_73011_w.field_76574_g + " failed to move carriage: " + Exception2.getMessage();
                if (Exception2 instanceof CarriageObstructionException) {
                    CarriageObstructionException ObstructionException = (CarriageObstructionException)Exception2;
                    Message = Message + " - (" + ObstructionException.X + "," + ObstructionException.Y + "," + ObstructionException.Z + ")";
                }
                if (RiMConfiguration.Debug.LogMotionExceptions) {
                    Debug.dbg((Object)Message);
                }
                if (this.lastUsingPlayer == null) break block19;
                this.lastUsingPlayer.func_146105_b((IChatComponent)new ChatComponentText(Message));
            }
        }
        this.field_145850_b.field_72984_F.func_76319_b();
        this.field_145850_b.field_72984_F.func_76319_b();
    }

    public CarriagePackage PreparePackage(Directions dir) throws CarriageMotionException {
        return this.prepareDefaultPackage(dir);
    }

    public static int targetBlockFromOffsetReplaceable(TileEntity translocator, BlockRecord record) {
        return TileEntityCarriageDrive.isBlockReplaceable(translocator.func_145831_w(), new BlockRecord(record.X + translocator.field_145851_c, record.Y + translocator.field_145848_d, record.Z + translocator.field_145849_e));
    }

    public static int isBlockReplaceable(World w, BlockRecord record) {
        if (w.func_147437_c(record.X, record.Y, record.Z)) {
            return 0;
        }
        Block block = w.func_147439_a(record.X, record.Y, record.Z);
        if (block != null) {
            if (!CarriagePackage.ObstructedByLiquids && FluidRegistry.lookupFluidForBlock((Block)block) != null) {
                return 0;
            }
            if (CarriagePackage.ObstructedByLiquids && FluidRegistry.lookupFluidForBlock((Block)block) != null) {
                return 2;
            }
            if (!CarriagePackage.ObstructedByFragileBlocks && block.func_149688_o().func_76222_j()) {
                return 0;
            }
            if (CarriagePackage.ObstructedByFragileBlocks && block.func_149688_o().func_76222_j()) {
                return 1;
            }
            return 3;
        }
        return 0;
    }

    public CarriagePackage prepareDefaultPackage(Directions MotionDirection) throws CarriageMotionException {
        Moveable mv = CarriageMatchers.getMover(this.field_145850_b.func_147439_a(this.field_145851_c + this.CarriageDirection.deltaX, this.field_145848_d + this.CarriageDirection.deltaY, this.field_145849_e + this.CarriageDirection.deltaZ), this.field_145850_b.func_72805_g(this.field_145851_c + this.CarriageDirection.deltaX, this.field_145848_d + this.CarriageDirection.deltaY, this.field_145849_e + this.CarriageDirection.deltaZ), this.field_145850_b.func_147438_o(this.field_145851_c + this.CarriageDirection.deltaX, this.field_145848_d + this.CarriageDirection.deltaY, this.field_145849_e + this.CarriageDirection.deltaZ));
        CarriagePackage _package = this.GeneratePackage(this.field_145850_b.func_147438_o(this.field_145851_c + this.CarriageDirection.deltaX, this.field_145848_d + this.CarriageDirection.deltaY, this.field_145849_e + this.CarriageDirection.deltaZ), this.CarriageDirection, MotionDirection);
        return _package;
    }

    public void removeUsedEnergy(CarriagePackage _package) throws CarriageMotionException {
        if (RiMConfiguration.HardMode.HardmodeActive && !this.isCreative) {
            int Type2 = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            double EnergyRequired = _package.getMass() * BlockCarriageDrive.Types.values()[Type2].EnergyConsumption * this.extraEnergy;
            int powerConsumed = (int)Math.ceil(EnergyRequired * RiMConfiguration.HardMode.PowerConsumptionFactor);
            if (powerConsumed > this.energyStored) {
                throw new CarriageMotionException("(HARDMODE) not enough power to move carriage (have " + this.energyStored + ", need " + powerConsumed);
            }
            this.energyStored -= powerConsumed;
        }
    }

    public BlockPosition GeneratePositionObject() {
        return new BlockPosition(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
    }

    public void InitiateMotion(CarriagePackage Package2) {
        this.ToggleActivity();
        Package2.RenderCacheKey = this.GeneratePositionObject();
        this.field_145850_b.field_72984_F.func_76320_a("SendRenderPacket");
        PacketRenderData.send(Package2);
        this.field_145850_b.field_72984_F.func_76318_c("PreMovementModInteraction");
        this.doPreMovementModInteraction(Package2);
        this.field_145850_b.field_72984_F.func_76318_c("Placeholders");
        this.EstablishPlaceholders(Package2);
        this.field_145850_b.field_72984_F.func_76318_c("UpdateBlocks");
        this.RefreshWorld(Package2);
        this.field_145850_b.field_72984_F.func_76318_c("MotiveSpecter");
        this.EstablishSpectre(Package2);
        this.field_145850_b.field_72984_F.func_76319_b();
    }

    public void doPreMovementModInteraction(CarriagePackage carriagePackage) {
        for (BlockRecord record : carriagePackage.Body) {
            EventPool.postBlockPreMoveEvent(record, carriagePackage.MotionDirection != null ? record.NextInDirection(carriagePackage.MotionDirection) : record, carriagePackage.Body);
        }
    }

    public void EstablishPlaceholders(CarriagePackage Package2) {
        BlockRecordSet temp = new BlockRecordSet();
        byte[] lightValues = new byte[Package2.Body.size()];
        byte[] lightOpacities = new byte[Package2.Body.size()];
        int i = 0;
        if (Package2.MotionDirection != null) {
            for (BlockRecord Record : Package2.Body) {
                try {
                    lightValues[i] = (byte)Record.block.getLightValue((IBlockAccess)this.field_145850_b, Record.X, Record.Y, Record.Z);
                    lightOpacities[i] = (byte)Record.block.getLightOpacity((IBlockAccess)this.field_145850_b, Record.X, Record.Y, Record.Z);
                }
                catch (Exception e) {
                    lightValues[i] = (byte)Record.block.func_149750_m();
                    lightOpacities[i] = (byte)Record.block.func_149717_k();
                }
                BlockRecord temp2 = Record.NextInDirection(Package2.MotionDirection);
                temp2.block = Record.block;
                temp.add(temp2);
                ++i;
            }
        } else {
            temp = Package2.Body;
        }
        i = 0;
        for (BlockRecord Record : temp) {
            if (Package2.MotionDirection != null) {
                if (Package2.MotionDirection.deltaY == 0) {
                    Block block = Record.block;
                    if (block.func_149662_c()) {
                        SneakyWorldUtil.setBlock((World)this.field_145850_b, (int)Record.X, (int)Record.Y, (int)Record.Z, (Block)RIMBlocks.Spectre, (int)BlockSpectre.Types.Supportive.ordinal());
                    } else if (block instanceof BlockRailBase) {
                        SneakyWorldUtil.setBlock((World)this.field_145850_b, (int)Record.X, (int)Record.Y, (int)Record.Z, (Block)RIMBlocks.RailSpectre, (int)this.field_145850_b.func_72805_g(Record.X, Record.Y, Record.Z));
                    } else if (block.func_149668_a(this.field_145850_b, Record.X - Package2.MotionDirection.deltaX, Record.Y, Record.Z - Package2.MotionDirection.deltaZ) == null) {
                        SneakyWorldUtil.setBlock((World)this.field_145850_b, (int)Record.X, (int)Record.Y, (int)Record.Z, (Block)RIMBlocks.Spectre, (int)BlockSpectre.Types.SupportiveNoCollide.ordinal());
                    } else {
                        SneakyWorldUtil.setBlock((World)this.field_145850_b, (int)Record.X, (int)Record.Y, (int)Record.Z, (Block)RIMBlocks.Spectre, (int)BlockSpectre.Types.Supportive.ordinal());
                    }
                } else if (!Package2.Body.contains(Record)) {
                    SneakyWorldUtil.setBlock((World)this.field_145850_b, (int)Record.X, (int)Record.Y, (int)Record.Z, (Block)RIMBlocks.Spectre, (int)BlockSpectre.Types.SupportiveNoCollide.ordinal());
                } else {
                    SneakyWorldUtil.setBlock((World)this.field_145850_b, (int)Record.X, (int)Record.Y, (int)Record.Z, (Block)RIMBlocks.Spectre, (int)BlockSpectre.Types.Supportive.ordinal());
                }
                if (Package2.MotionDirection.ordinal() != ForgeDirection.UNKNOWN.ordinal()) {
                    WorldUtil.unsafeAddSpectre(this.field_145850_b, Record.X, Record.Y, Record.Z, new TileEntitySupportiveSpectre());
                    TileEntitySupportiveSpectre tile = (TileEntitySupportiveSpectre)this.field_145850_b.func_147438_o(Record.X, Record.Y, Record.Z);
                    tile.setLight(lightValues[i], lightOpacities[i]);
                }
            }
            ++i;
        }
        for (BlockRecord Record : Package2.Body) {
            if (temp.contains(Record) || Package2.MotionDirection == null) continue;
            if (Package2.MotionDirection.deltaY == 0) {
                if (Record.block.func_149668_a(this.field_145850_b, Record.X, Record.Y, Record.Z) == null) {
                    SneakyWorldUtil.setBlock((World)this.field_145850_b, (int)Record.X, (int)Record.Y, (int)Record.Z, (Block)RIMBlocks.Spectre, (int)BlockSpectre.Types.SupportiveNoCollide.ordinal());
                } else {
                    SneakyWorldUtil.setBlock((World)this.field_145850_b, (int)Record.X, (int)Record.Y, (int)Record.Z, (Block)RIMBlocks.Spectre, (int)BlockSpectre.Types.Supportive.ordinal());
                }
            } else {
                SneakyWorldUtil.setBlock((World)this.field_145850_b, (int)Record.X, (int)Record.Y, (int)Record.Z, (Block)RIMBlocks.Spectre, (int)BlockSpectre.Types.SupportiveNoCollide.ordinal());
            }
            if (Package2.MotionDirection.ordinal() != ForgeDirection.UNKNOWN.ordinal()) {
                ((TileEntitySupportiveSpectre)this.field_145850_b.func_147438_o(Record.X, Record.Y, Record.Z)).setLight((byte)0, (byte)0);
            }
            Package2.spectersToDestroy.add(new BlockRecord(Record));
        }
    }

    public void RefreshWorld(CarriagePackage Package2) {
        for (BlockRecord Record : Package2.Body) {
            SneakyWorldUtil.refreshBlock((World)this.field_145850_b, (int)Record.X, (int)Record.Y, (int)Record.Z, (Block)Record.block, (Block)Blocks.field_150350_a);
        }
    }

    public void EstablishSpectre(CarriagePackage Package2) {
        int CarriageX = Package2.AnchorRecord.X + Package2.MotionDirection.deltaX;
        int CarriageY = Package2.AnchorRecord.Y + Package2.MotionDirection.deltaY;
        int CarriageZ = Package2.AnchorRecord.Z + Package2.MotionDirection.deltaZ;
        WorldUtil.SetBlock(this.field_145850_b, CarriageX, CarriageY, CarriageZ, (Block)RIMBlocks.Spectre, BlockSpectre.Types.Motive.ordinal());
        TileEntityMotiveSpectre specter = (TileEntityMotiveSpectre)this.field_145850_b.func_147438_o(CarriageX, CarriageY, CarriageZ);
        specter.Absorb(Package2);
        specter.personalDurationInTicks = this.personalDurationInTicks;
        specter.personalVelocity = 1.0 / (double)specter.personalDurationInTicks;
    }

    public abstract CarriagePackage GeneratePackage(TileEntity var1, Directions var2, Directions var3) throws CarriageMotionException;

    public abstract boolean Anchored();

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        int toRecieve = Math.min(RiMConfiguration.HardMode.powerCapacity - this.energyStored, maxReceive);
        if (!simulate) {
            this.energyStored += toRecieve;
        }
        return toRecieve;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        if (this.isCreative) {
            return false;
        }
        return RiMConfiguration.HardMode.HardmodeActive;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.energyStored;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return RiMConfiguration.HardMode.powerCapacity;
    }

    public IIcon getIcon(int Side2, int meta) {
        try {
            if (this.SideClosed[Side2]) {
                if (this.getDecoration() != null) {
                    return this.getDecoration().func_149691_a(Side2, this.DecorationMeta);
                }
                return BlockCarriageDrive.InactiveIcon;
            }
            BlockCarriageDrive.Types Type2 = BlockCarriageDrive.Types.values()[meta];
            if (this.Continuous) {
                return this.Active ? Type2.ContinuousActiveIcon : Type2.ContinuousIcon;
            }
            return this.Active ? Type2.NormalActiveIcon : Type2.NormalIcon;
        }
        catch (Throwable Throwable2) {
            return Blocks.field_150339_S.func_149691_a(0, 0);
        }
    }

    public boolean isSideClosed(int side) {
        return this.SideClosed[side];
    }

    public void setSideClosed(int side, boolean closed) {
        this.SideClosed[side] = closed;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    @Override
    public void rotateSpecial(ForgeDirection axis) {
        ArrayRotator.rotate(this.SideClosed, axis);
        this.Propagate();
    }

    public Directions getSignalDirection() {
        return this.SignalDirection;
    }

    public void setSignalDirection(Directions signalDirection) {
        this.SignalDirection = signalDirection;
    }

    public void setConfiguration(long flags, EntityPlayerMP changer) {
        this.SideClosed[0] = ((flags >>= 3) & (long)(1 << Buttons.DOWN.ordinal())) != 0L;
        this.SideClosed[1] = (flags & (long)(1 << Buttons.UP.ordinal())) != 0L;
        this.SideClosed[2] = (flags & (long)(1 << Buttons.NORTH.ordinal())) != 0L;
        this.SideClosed[3] = (flags & (long)(1 << Buttons.SOUTH.ordinal())) != 0L;
        this.SideClosed[4] = (flags & (long)(1 << Buttons.WEST.ordinal())) != 0L;
        this.SideClosed[5] = (flags & (long)(1 << Buttons.EAST.ordinal())) != 0L;
        this.requiresScrewdriverToOpen = (flags & (long)(1 << Buttons.SCREWDRIVER_MODE.ordinal())) != 0L;
        this.Continuous = (flags & (long)(1 << Buttons.CONTINUOUS_MODE.ordinal())) != 0L;
        this.zeroContinuousCooldown = (flags & (long)(1 << Buttons.ZERO_COOLDOWN.ordinal())) != 0L;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }
}

