/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.remaininmotion.drive;

import me.planetguy.lib.util.Lang;
import me.planetguy.lib.util.SneakyWorldUtil;
import me.planetguy.remaininmotion.api.ISpecialMoveBehavior;
import me.planetguy.remaininmotion.core.RIMBlocks;
import me.planetguy.remaininmotion.core.RiMConfiguration;
import me.planetguy.remaininmotion.drive.TileEntityCarriageDirected;
import me.planetguy.remaininmotion.motion.CarriageMotionException;
import me.planetguy.remaininmotion.motion.CarriagePackage;
import me.planetguy.remaininmotion.spectre.BlockSpectre;
import me.planetguy.remaininmotion.spectre.RemIMRotator;
import me.planetguy.remaininmotion.spectre.TileEntityRotativeSpectre;
import me.planetguy.remaininmotion.util.MultiTypeCarriageUtil;
import me.planetguy.remaininmotion.util.Registry;
import me.planetguy.remaininmotion.util.WorldUtil;
import me.planetguy.remaininmotion.util.position.BlockRecord;
import me.planetguy.remaininmotion.util.position.BlockRecordSet;
import me.planetguy.remaininmotion.util.transformations.Directions;
import me.planetguy.remaininmotion.util.transformations.Rotator;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.IconFlipped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCarriageRotator
extends TileEntityCarriageDirected
implements ISpecialMoveBehavior {
    static IIcon[][] icons;
    public boolean alreadyMoving;

    @Override
    public CarriagePackage GeneratePackage(TileEntity carriage, Directions CarriageDirection, Directions MotionDirection) throws CarriageMotionException {
        if (!RiMConfiguration.DirtyHacks.allowRotation) {
            throw new CarriageMotionException(Lang.translate((String)"JAKJ_RedstoneInMotion.noRotatorCarriage"));
        }
        CarriagePackage Package2 = new CarriagePackage(this, carriage, Directions.Null);
        Package2.axis = this.pointedDir.ordinal();
        Package2.blacklistByRotation = true;
        MultiTypeCarriageUtil.fillPackage(Package2, carriage);
        BlockRecordSet dests = new BlockRecordSet();
        BlockRecordSet temp = Package2.Body;
        block0: for (BlockRecord record : Package2.Body) {
            if (record.X == this.field_145851_c || record.Y == this.field_145848_d || record.Z == this.field_145849_e) continue;
            BlockRecord dest = RemIMRotator.simulateRotateOrthogonal(new BlockRecord(this), this.pointedDir, record);
            if (dest.Y > 255 || dest.Y < 0) {
                throw new CarriageMotionException("Cannot rotate block at " + new BlockRecord(this) + " to " + dest + ": out of bounds");
            }
            for (BlockRecord record2 : temp) {
                if (record2.X != dest.X || record2.Y != dest.Y || record2.X != dest.X) continue;
                continue block0;
            }
            if (TileEntityCarriageRotator.isBlockReplaceable(this.func_145831_w(), dest) == 0) continue;
            throw new CarriageMotionException("motion obstructed at " + dest.X + ", " + dest.Y + ", " + dest.Z);
        }
        Package2.Finalize();
        return Package2;
    }

    @Override
    public void EstablishPlaceholders(CarriagePackage pkg) {
        for (BlockRecord Record : pkg.Body) {
            SneakyWorldUtil.setBlock((World)this.field_145850_b, (int)Record.X, (int)Record.Y, (int)Record.Z, (Block)RIMBlocks.air, (int)0);
        }
    }

    @Override
    public void EstablishSpectre(CarriagePackage Package2) {
        int CarriageX = Package2.AnchorRecord.X;
        int CarriageY = Package2.AnchorRecord.Y;
        int CarriageZ = Package2.AnchorRecord.Z;
        WorldUtil.SetBlock(this.field_145850_b, CarriageX, CarriageY, CarriageZ, (Block)RIMBlocks.Spectre, BlockSpectre.Types.Rotative.ordinal());
        TileEntityRotativeSpectre theEntity = (TileEntityRotativeSpectre)this.field_145850_b.func_147438_o(CarriageX, CarriageY, CarriageZ);
        theEntity.setAxis(this.pointedDir.ordinal());
        theEntity.Absorb(Package2);
        this.field_145850_b.func_147471_g(CarriageX, CarriageY, CarriageZ);
        this.field_145850_b.func_147451_t(CarriageX, CarriageY, CarriageZ);
    }

    @Override
    public IIcon getIcon(int side, int meta) {
        try {
            if (this.drawSideClosed(side)) {
                return super.getIcon(side, meta);
            }
            return icons[this.pointedDir.ordinal()][side];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return Blocks.field_150408_cc.func_149691_a(0, 0);
        }
    }

    public static void onRegisterIcons(IIconRegister iconRegister) {
        IIcon pivotCCW = Registry.RegisterIcon(iconRegister, "RotatorArrowCCW");
        IconFlipped pivotCW = new IconFlipped(pivotCCW, true, false);
        IIcon arrow = Registry.RegisterIcon(iconRegister, "RotatorArrowUp");
        icons = new IIcon[][]{{pivotCCW, pivotCCW, arrow, arrow, arrow, arrow}, {pivotCW, pivotCW, arrow, arrow, arrow, arrow}, {arrow, arrow, pivotCW, pivotCCW, arrow, arrow}, {arrow, arrow, pivotCCW, pivotCW, arrow, arrow}, {arrow, arrow, arrow, arrow, pivotCW, pivotCCW}, {arrow, arrow, arrow, arrow, pivotCCW, pivotCW}};
    }

    public void setAxis(int axis) {
        this.pointedDir = Directions.validDirections()[axis];
    }

    public boolean drawSideClosed(int side) {
        return super.isSideClosed(side);
    }

    @Override
    public void func_145845_h() {
        if (this.CarriageDirection == null || this.CarriageDirection != this.pointedDir && this.CarriageDirection.oppositeOrdinal != this.pointedDir.ordinal()) {
            this.CarriageDirection = null;
        }
        super.func_145845_h();
    }

    @Override
    public void rotateSpecial(ForgeDirection axis) {
        super.rotateSpecial(axis);
        this.pointedDir = Directions.values()[Rotator.newSide(this.pointedDir.ordinal(), axis)];
    }

    @Override
    public void onAdded(CarriagePackage pkg, NBTTagCompound tag) throws CarriageMotionException {
        this.HandleNeighbourBlockChange();
        BlockRecord record = new BlockRecord(this);
        if (!this.alreadyMoving) {
            this.alreadyMoving = true;
            pkg.AddBlock(record);
            if (this.CarriageDirection != null && this.CarriageDirection != Directions.Null) {
                BlockRecord oldAnchor = pkg.AnchorRecord;
                pkg.AnchorRecord = new BlockRecord(this.field_145851_c + this.CarriageDirection.deltaX, this.field_145848_d + this.CarriageDirection.deltaY, this.field_145849_e + this.CarriageDirection.deltaZ);
                pkg.AnchorRecord.Identify(this.field_145850_b);
                MultiTypeCarriageUtil.fillPackage(pkg, this.field_145850_b.func_147438_o(this.field_145851_c + this.CarriageDirection.deltaX, this.field_145848_d + this.CarriageDirection.deltaY, this.field_145849_e + this.CarriageDirection.deltaZ));
                pkg.AnchorRecord = oldAnchor;
            }
        }
    }
}

