/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.remaininmotion.drive;

import java.util.HashMap;
import java.util.LinkedList;
import me.planetguy.lib.util.SneakyWorldUtil;
import me.planetguy.remaininmotion.base.BlockRiM;
import me.planetguy.remaininmotion.core.ModRiM;
import me.planetguy.remaininmotion.core.RIMBlocks;
import me.planetguy.remaininmotion.core.RiMConfiguration;
import me.planetguy.remaininmotion.core.RiMItems;
import me.planetguy.remaininmotion.drive.ItemCarriageDrive;
import me.planetguy.remaininmotion.drive.TileEntityCarriageDrive;
import me.planetguy.remaininmotion.drive.gui.Buttons;
import me.planetguy.remaininmotion.motion.CarriageMotionException;
import me.planetguy.remaininmotion.motion.CarriagePackage;
import me.planetguy.remaininmotion.spectre.BlockSpectre;
import me.planetguy.remaininmotion.spectre.TileEntitySupportiveSpectre;
import me.planetguy.remaininmotion.spectre.TileEntityTeleportativeSpectre;
import me.planetguy.remaininmotion.util.MultiTypeCarriageUtil;
import me.planetguy.remaininmotion.util.WorldUtil;
import me.planetguy.remaininmotion.util.position.BlockPosition;
import me.planetguy.remaininmotion.util.position.BlockRecord;
import me.planetguy.remaininmotion.util.transformations.Directions;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityCarriageTranslocator
extends TileEntityCarriageDrive {
    public String Player = "";
    public int Label;
    public static HashMap<String, HashMap<Integer, LinkedList<BlockPosition>>> ActiveTranslocatorSets = new HashMap();

    public HashMap<String, HashMap<Integer, LinkedList<BlockPosition>>> getRegistry() {
        return ActiveTranslocatorSets;
    }

    protected void registerLabel() {
        LinkedList<BlockPosition> ActiveTranslocators;
        HashMap<String, HashMap<Integer, LinkedList<BlockPosition>>> ActiveTranslocatorSets = this.getRegistry();
        HashMap<Integer, LinkedList<BlockPosition>> ActiveTranslocatorSet = ActiveTranslocatorSets.get(this.Player);
        if (ActiveTranslocatorSet == null) {
            ActiveTranslocatorSet = new HashMap();
            ActiveTranslocatorSets.put(this.Player, ActiveTranslocatorSet);
        }
        if ((ActiveTranslocators = ActiveTranslocatorSet.get(this.Label)) == null) {
            ActiveTranslocators = new LinkedList();
            ActiveTranslocatorSet.put(this.Label, ActiveTranslocators);
        }
        ActiveTranslocators.add(this.GeneratePositionObject());
    }

    public void unregisterLabel() {
        HashMap<String, HashMap<Integer, LinkedList<BlockPosition>>> ActiveTranslocatorSets = this.getRegistry();
        try {
            ActiveTranslocatorSets.get(this.Player).get(this.Label).remove(this.GeneratePositionObject());
        }
        catch (Throwable Throwable2) {
            Throwable2.printStackTrace();
        }
    }

    @Override
    public void Setup(EntityPlayer Player, ItemStack Item2) {
        super.Setup(Player, Item2);
        this.Player = ItemCarriageDrive.GetPrivateFlag(Item2) ? Player.getDisplayName() : "";
        this.Label = ItemCarriageDrive.GetLabel(Item2);
        if (!this.field_145850_b.field_72995_K) {
            this.registerLabel();
            this.unregisterLabel();
            this.registerLabel();
        }
    }

    @Override
    public void EmitDrops(BlockRiM Block2, int Meta) {
        this.EmitDrop(Block2, ItemCarriageDrive.Stack(Meta, this.Tier, !this.Player.equals(""), this.Label));
    }

    @Override
    public void Initialize() {
        super.Initialize();
        if (!this.field_145850_b.field_72995_K && this.Player != null) {
            this.registerLabel();
        }
    }

    @Override
    public void Finalize() {
        if (!this.field_145850_b.field_72995_K) {
            this.unregisterLabel();
        }
    }

    @Override
    public void ReadCommonRecord(NBTTagCompound TagCompound) {
        super.ReadCommonRecord(TagCompound);
        this.Player = TagCompound.func_74779_i("Player");
        this.Label = TagCompound.func_74762_e("Label");
    }

    @Override
    public void WriteCommonRecord(NBTTagCompound TagCompound) {
        super.WriteCommonRecord(TagCompound);
        TagCompound.func_74778_a("Player", this.Player);
        TagCompound.func_74768_a("Label", this.Label);
    }

    @Override
    public boolean Anchored() {
        return true;
    }

    @Override
    public CarriagePackage PreparePackage(Directions MotionDirection) throws CarriageMotionException {
        LinkedList<BlockPosition> activeTranslocators;
        CarriagePackage Package2 = super.PreparePackage(null);
        TileEntityCarriageTranslocator target = null;
        try {
            activeTranslocators = this.getRegistry().get(this.Player).get(this.Label);
        }
        catch (Throwable Throwable2) {
            Throwable2.printStackTrace();
            throw new CarriageMotionException("translocator array is corrupt");
        }
        for (int index = 0; index < activeTranslocators.size(); ++index) {
            BlockPosition position = activeTranslocators.get(index);
            try {
                TileEntityCarriageTranslocator translocator = (TileEntityCarriageTranslocator)WorldUtil.GetWorld(position.Dimension).func_147438_o(position.X, position.Y, position.Z);
                if (translocator == this) continue;
                boolean targetValid = true;
                for (BlockRecord record : Package2.NewPositions) {
                    if (TileEntityCarriageTranslocator.targetBlockFromOffsetReplaceable(translocator, record) == 0) continue;
                    targetValid = false;
                    break;
                }
                if (!targetValid) continue;
                target = translocator;
                break;
            }
            catch (Throwable Throwable3) {
                Throwable3.printStackTrace();
            }
        }
        if (target == null) {
            throw new CarriageMotionException("no other matching translocators available with space to receive carriage assembly");
        }
        Package2.Translocator = target;
        if (RiMConfiguration.HardMode.distanceAffectsEnergy) {
            double distance = Math.sqrt((target.field_145851_c - this.field_145851_c) * (target.field_145851_c - this.field_145851_c) + (target.field_145848_d - this.field_145848_d) * (target.field_145848_d - this.field_145848_d) + (target.field_145849_e - this.field_145849_e) * (target.field_145849_e - this.field_145849_e));
            distance = Math.min(distance, (double)RiMConfiguration.HardMode.peakDistance) / (double)RiMConfiguration.HardMode.peakDistance * RiMConfiguration.HardMode.maxDistanceMultiplier;
            if (target.field_145850_b.func_72912_H().func_76076_i() != this.field_145850_b.func_72912_H().func_76076_i()) {
                distance *= RiMConfiguration.HardMode.otherDimensionMultiplier;
            }
            this.extraEnergy = Math.max(distance, 1.0);
        }
        Package2.Finalize();
        return Package2;
    }

    @Override
    public CarriagePackage GeneratePackage(TileEntity carriage, Directions CarriageDirection, Directions MotionDirection) throws CarriageMotionException {
        CarriagePackage Package2 = new CarriagePackage(this, carriage, null);
        MultiTypeCarriageUtil.fillPackage(Package2, carriage);
        if (Package2.Body.contains(Package2.driveRecord)) {
            throw new CarriageMotionException("carriage is attempting to grab translocator");
        }
        return Package2;
    }

    @Override
    public void InitiateMotion(CarriagePackage Package2) {
        Package2.Translocator.ToggleActivity();
        super.InitiateMotion(Package2);
    }

    @Override
    public void EstablishPlaceholders(CarriagePackage pack) {
        byte[] lightValues = new byte[pack.Body.size()];
        byte[] lightOpacities = new byte[pack.Body.size()];
        int i = 0;
        for (BlockRecord Record : pack.NewPositions) {
            try {
                lightValues[i] = (byte)Record.block.getLightValue((IBlockAccess)this.field_145850_b, this.field_145851_c + Record.X, this.field_145848_d + Record.Y, this.field_145849_e + Record.Z);
                lightOpacities[i] = (byte)Record.block.getLightOpacity((IBlockAccess)this.field_145850_b, this.field_145851_c + Record.X, this.field_145848_d + Record.Y, this.field_145849_e + Record.Z);
            }
            catch (Exception e) {
                lightValues[i] = (byte)Record.block.func_149750_m();
                lightOpacities[i] = (byte)Record.block.func_149717_k();
            }
            ++i;
        }
        i = 0;
        for (BlockRecord Record : pack.NewPositions) {
            Block block = Record.block;
            if (block.func_149662_c()) {
                SneakyWorldUtil.setBlock((World)this.field_145850_b, (int)(this.field_145851_c + Record.X), (int)(this.field_145848_d + Record.Y), (int)(this.field_145849_e + Record.Z), (Block)RIMBlocks.Spectre, (int)BlockSpectre.Types.Supportive.ordinal());
                SneakyWorldUtil.setBlock((World)pack.Translocator.func_145831_w(), (int)(pack.Translocator.field_145851_c + Record.X), (int)(pack.Translocator.field_145848_d + Record.Y), (int)(pack.Translocator.field_145849_e + Record.Z), (Block)RIMBlocks.Spectre, (int)BlockSpectre.Types.Supportive.ordinal());
            } else if (block instanceof BlockRailBase) {
                SneakyWorldUtil.setBlock((World)this.field_145850_b, (int)(this.field_145851_c + Record.X), (int)(this.field_145848_d + Record.Y), (int)(this.field_145849_e + Record.Z), (Block)RIMBlocks.RailSpectre, (int)this.field_145850_b.func_72805_g(this.field_145851_c + Record.X, this.field_145848_d + Record.Y, this.field_145849_e + Record.Z));
                SneakyWorldUtil.setBlock((World)pack.Translocator.func_145831_w(), (int)(pack.Translocator.field_145851_c + Record.X), (int)(pack.Translocator.field_145848_d + Record.Y), (int)(pack.Translocator.field_145849_e + Record.Z), (Block)RIMBlocks.RailSpectre, (int)pack.Translocator.func_145831_w().func_72805_g(pack.Translocator.field_145851_c + Record.X, pack.Translocator.field_145848_d + Record.Y, pack.Translocator.field_145849_e + Record.Z));
            } else if (block.func_149668_a(this.field_145850_b, this.field_145851_c + Record.X, this.field_145848_d + Record.Y, this.field_145849_e + Record.Z) == null) {
                SneakyWorldUtil.setBlock((World)this.field_145850_b, (int)(this.field_145851_c + Record.X), (int)(this.field_145848_d + Record.Y), (int)(this.field_145849_e + Record.Z), (Block)RIMBlocks.Spectre, (int)BlockSpectre.Types.SupportiveNoCollide.ordinal());
                SneakyWorldUtil.setBlock((World)pack.Translocator.func_145831_w(), (int)(pack.Translocator.field_145851_c + Record.X), (int)(pack.Translocator.field_145848_d + Record.Y), (int)(pack.Translocator.field_145849_e + Record.Z), (Block)RIMBlocks.Spectre, (int)BlockSpectre.Types.SupportiveNoCollide.ordinal());
            } else {
                SneakyWorldUtil.setBlock((World)this.field_145850_b, (int)(this.field_145851_c + Record.X), (int)(this.field_145848_d + Record.Y), (int)(this.field_145849_e + Record.Z), (Block)RIMBlocks.Spectre, (int)BlockSpectre.Types.Supportive.ordinal());
                SneakyWorldUtil.setBlock((World)pack.Translocator.func_145831_w(), (int)(pack.Translocator.field_145851_c + Record.X), (int)(pack.Translocator.field_145848_d + Record.Y), (int)(pack.Translocator.field_145849_e + Record.Z), (Block)RIMBlocks.Spectre, (int)BlockSpectre.Types.Supportive.ordinal());
            }
            pack.spectersToDestroy.add(new BlockRecord(this.field_145851_c + Record.X, this.field_145848_d + Record.Y, this.field_145849_e + Record.Z));
            this.field_145850_b.func_147455_a(this.field_145851_c + Record.X, this.field_145848_d + Record.Y, this.field_145849_e + Record.Z, (TileEntity)new TileEntitySupportiveSpectre());
            TileEntitySupportiveSpectre tile = (TileEntitySupportiveSpectre)this.field_145850_b.func_147438_o(this.field_145851_c + Record.X, this.field_145848_d + Record.Y, this.field_145849_e + Record.Z);
            tile.setLight(lightValues[i], lightOpacities[i]);
            pack.Translocator.func_145831_w().func_147455_a(pack.Translocator.field_145851_c + Record.X, pack.Translocator.field_145848_d + Record.Y, pack.Translocator.field_145849_e + Record.Z, (TileEntity)new TileEntitySupportiveSpectre());
            tile = (TileEntitySupportiveSpectre)pack.Translocator.func_145831_w().func_147438_o(pack.Translocator.field_145851_c + Record.X, pack.Translocator.field_145848_d + Record.Y, pack.Translocator.field_145849_e + Record.Z);
            tile.setLight(lightValues[i], lightOpacities[i]);
            ++i;
        }
    }

    @Override
    public void EstablishSpectre(CarriagePackage Package2) {
        WorldUtil.SetBlock(this.field_145850_b, Package2.AnchorRecord.X, Package2.AnchorRecord.Y, Package2.AnchorRecord.Z, (Block)RIMBlocks.Spectre, BlockSpectre.Types.Teleportative.ordinal());
        ((TileEntityTeleportativeSpectre)this.field_145850_b.func_147438_o(Package2.AnchorRecord.X, Package2.AnchorRecord.Y, Package2.AnchorRecord.Z)).AbsorbSource(Package2);
        int NewX = Package2.AnchorRecord.X - this.field_145851_c + Package2.Translocator.field_145851_c;
        int NewY = Package2.AnchorRecord.Y - this.field_145848_d + Package2.Translocator.field_145848_d;
        int NewZ = Package2.AnchorRecord.Z - this.field_145849_e + Package2.Translocator.field_145849_e;
        WorldUtil.SetBlock(Package2.Translocator.field_145850_b, NewX, NewY, NewZ, (Block)RIMBlocks.Spectre, BlockSpectre.Types.Teleportative.ordinal());
        ((TileEntityTeleportativeSpectre)Package2.Translocator.field_145850_b.func_147438_o(NewX, NewY, NewZ)).AbsorbSink(Package2);
    }

    @Override
    public void setConfiguration(long flags, EntityPlayerMP changer) {
        this.unregisterLabel();
        super.setConfiguration(flags, changer);
        this.Label = (int)((flags >>= 3) & 0xFFFFL);
        this.Player = (flags & (long)(1 << Buttons.PRIVATE.ordinal())) != 0L ? changer.getDisplayName() : "";
        this.registerLabel();
    }

    @Override
    public boolean HandleToolUsage(int Side2, boolean Sneaking, EntityPlayer player) {
        if (this.Active) {
            return false;
        }
        if (!this.requiresScrewdriverToOpen || player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == RiMItems.ToolItemSet) {
            player.openGui((Object)ModRiM.instance, 1, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return false;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.unregisterLabel();
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        this.registerLabel();
    }
}

