/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.remaininmotion.network;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;

public abstract class NBTPacket {
    public NBTTagCompound body;
    public byte type;

    @Deprecated
    public NBTPacket() {
    }

    public NBTPacket(int type, NBTTagCompound body) {
        this.type = (byte)type;
        this.body = body;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            int tagLength = buf.readInt();
            buf.discardReadBytes();
            this.type = buf.readByte();
            buf.discardReadBytes();
            byte[] bytes = buf.array();
            byte[] fixedBytes = new byte[bytes.length - 6];
            for (int i = 1; i < fixedBytes.length + 1; ++i) {
                fixedBytes[i - 1] = bytes[i];
            }
            this.body = CompressedStreamTools.func_152457_a((byte[])fixedBytes, (NBTSizeTracker)this.createTracker());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected abstract NBTSizeTracker createTracker();

    public void toBytes(ByteBuf buf) {
        try {
            byte[] tagBytes = CompressedStreamTools.func_74798_a((NBTTagCompound)this.body);
            buf.writeInt(tagBytes.length);
            buf.writeByte((int)this.type);
            buf.writeBytes(tagBytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

