/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.remaininmotion.plugins.fmp;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.CommonMicroblock;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.minecraft.McBlockPart;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Iterator;
import me.planetguy.lib.util.Debug;
import me.planetguy.remaininmotion.api.ConnectabilityState;
import me.planetguy.remaininmotion.api.ICloseable;
import me.planetguy.remaininmotion.base.ToolItemSet;
import me.planetguy.remaininmotion.core.RIMBlocks;
import me.planetguy.remaininmotion.core.RiMConfiguration;
import me.planetguy.remaininmotion.plugins.fmp.FMPCarriagePlugin;
import me.planetguy.remaininmotion.plugins.fmp.FMPRenderer;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;

@Optional.Interface(iface="JNormalOcclusion", modid="ForgeMultipart")
public class PartCarriageFMP
extends McBlockPart
implements JNormalOcclusion,
ICloseable {
    private boolean[] sidesClosed = new boolean[6];
    public static PartCarriageFMP instance;
    @SideOnly(value=Side.CLIENT)
    FMPRenderer renderer;
    static final double l = 0.1875;
    static final double e = 0.01;
    public static final Cuboid6[] cubeOutsideEdges;

    public PartCarriageFMP() {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.renderer = new FMPRenderer();
        }
    }

    @Optional.Method(modid="ForgeMultipart")
    public Iterable<Cuboid6> getOcclusionBoxes() {
        return new Iterable(){

            public Iterator iterator() {
                return new Iterator(){

                    @Override
                    public boolean hasNext() {
                        return false;
                    }

                    public Object next() {
                        return null;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    @Optional.Method(modid="ForgeMultipart")
    public Iterable<Cuboid6> getCollisionBoxes() {
        return new Iterable(){

            public Iterator iterator() {
                return new Iterator(){
                    boolean done = false;

                    @Override
                    public boolean hasNext() {
                        return !this.done;
                    }

                    public Object next() {
                        this.done = true;
                        return Cuboid6.full;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    @Optional.Method(modid="ForgeMultipart")
    public String getType() {
        return "FMPCarriage";
    }

    @Optional.Method(modid="ForgeMultipart")
    public Cuboid6 getBounds() {
        return Cuboid6.full;
    }

    @Optional.Method(modid="ForgeMultipart")
    public Block getBlock() {
        return RIMBlocks.Carriage;
    }

    @Optional.Method(modid="ForgeMultipart")
    @SideOnly(value=Side.CLIENT)
    public boolean renderStatic(Vector3 pos, int pass) {
        this.renderer.renderCovers(this.world(), pos, pass, this);
        return pass == 0;
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition hit, ItemStack held) {
        if (ToolItemSet.IsScrewdriverOrEquivalent(held)) {
            this.sidesClosed[hit.field_72310_e] = !this.sidesClosed[hit.field_72310_e];
            this.tile().func_70296_d();
            this.tile().markRender();
            return true;
        }
        return false;
    }

    @Override
    public ConnectabilityState isSideClosed(int side) {
        return this.treatSideAsClosed(side) ? ConnectabilityState.CLOSED : ConnectabilityState.OPEN;
    }

    public boolean treatSideAsClosed(int side) {
        return this.sidesClosed[side] || this.isSideCovered(side);
    }

    public boolean drawSideClosedJAKJ(int side) {
        return this.sidesClosed[side];
    }

    private boolean isSideCovered(int side) {
        if (RiMConfiguration.Debug.verbose) {
            Debug.dbg((Object)side);
        }
        for (TMultiPart part : this.tile().jPartList()) {
            if (RiMConfiguration.Debug.verbose) {
                Debug.dbg(part.getClass());
            }
            if (part instanceof CommonMicroblock) {
                CommonMicroblock mb;
                if (RiMConfiguration.Debug.verbose) {
                    Debug.dbg(part.getClass());
                }
                if ((mb = (CommonMicroblock)part).getSlot() != side) continue;
                int size = mb.getSize();
                return size == 1;
            }
            if (part instanceof PartCarriageFMP) continue;
        }
        return false;
    }

    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeByte((int)((byte)this.toInt()));
    }

    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.fromInt(packet.readByte());
    }

    public void save(NBTTagCompound tag) {
        super.save(tag);
        tag.func_74774_a("sideFlags", (byte)this.toInt());
    }

    public void load(NBTTagCompound tag) {
        super.load(tag);
        this.fromInt(tag.func_74771_c("sideFlags"));
    }

    public int toInt() {
        int i = 0;
        int pos = 1;
        for (int index = 0; index < this.sidesClosed.length; ++index) {
            if (this.sidesClosed[index]) {
                i |= pos;
            }
            pos <<= 1;
        }
        return i;
    }

    public void fromInt(int i) {
        this.sidesClosed = new boolean[6];
        int pos = 1;
        for (int index = 0; index < this.sidesClosed.length; ++index) {
            this.sidesClosed[index] = (i & pos) != 0;
            pos <<= 1;
        }
    }

    public ItemStack pickItem(MovingObjectPosition hit) {
        return new ItemStack(FMPCarriagePlugin.hollowCarriage);
    }

    static {
        cubeOutsideEdges = new Cuboid6[]{new Cuboid6(-0.01, -0.01, -0.01, 1.01, 0.1875, 0.1875), new Cuboid6(-0.01, -0.01, -0.01, 0.1875, 0.8225, 0.1875), new Cuboid6(-0.01, -0.01, -0.01, 0.1875, 0.1875, 1.01), new Cuboid6(1.01, 1.01, -0.01, -0.01, 0.8225, 0.1875), new Cuboid6(1.01, 1.01, -0.01, 0.8225, 0.1875, 0.1875), new Cuboid6(1.01, 1.01, -0.01, 0.8225, 0.8225, 0.8225), new Cuboid6(1.01, -0.01, 1.01, 0.8225, 0.1875, 0.1875), new Cuboid6(1.01, -0.01, 1.01, 0.8225, 0.8225, 0.8225), new Cuboid6(1.01, -0.01, 1.01, 0.1875, 0.1875, 0.8225), new Cuboid6(-0.01, 1.01, 1.01, 1.01, 0.8225, 0.8225), new Cuboid6(-0.01, 1.01, 1.01, 0.1875, 0.1875, 0.8225), new Cuboid6(-0.01, 1.01, 1.01, 0.1875, 0.8225, 0.1875)};
    }
}

