/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.remaininmotion.render;

import me.planetguy.remaininmotion.base.ItemBlockRiM;
import me.planetguy.remaininmotion.core.RIMBlocks;
import me.planetguy.remaininmotion.core.RiMConfiguration;
import me.planetguy.remaininmotion.drive.BlockCarriageDrive;
import me.planetguy.remaininmotion.drive.ItemCarriageDrive;
import me.planetguy.remaininmotion.drive.TileEntityCarriageTranslocator;
import me.planetguy.remaininmotion.render.BlockRenderer;
import me.planetguy.remaininmotion.util.Vanilla;
import me.planetguy.remaininmotion.util.transformations.Directions;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;

public class CarriageDriveRenderer
extends BlockRenderer {
    public CarriageDriveRenderer() {
        RIMBlocks.CarriageDrive.RenderId = this.Initialize((Block)RIMBlocks.CarriageDrive);
    }

    public void UseFullLabel() {
        RiMConfiguration.TextureSets TextureSet = RiMConfiguration.TextureSets.values()[RiMConfiguration.TextureSets.TextureSet];
        this.SetSideSpan(TextureSet.LabelMinH, TextureSet.LabelMinV, TextureSet.LabelMaxH, TextureSet.LabelMaxV);
    }

    public void UsePartialLabel(double MinH, double MinV, double MaxH, double MaxV) {
        this.UseFullLabel();
        this.SubsectSideSpan(MinH, MinV, MaxH, MaxV);
    }

    public void UseFullIcon(IIcon Icon) {
        this.SetTextureSpan(Icon);
    }

    public void UsePartialIcon(IIcon Icon, double MinU, double MinV, double MaxU, double MaxV) {
        this.UseFullIcon(Icon);
        this.SubsectTextureSpan(MinU, MinV, MaxU, MaxV);
    }

    @Override
    public void Render(TileEntity TileEntity2) {
        if (TileEntity2 instanceof TileEntityCarriageTranslocator) {
            TileEntityCarriageTranslocator Translocator = (TileEntityCarriageTranslocator)TileEntity2;
            if (Translocator.Player == null) {
                return;
            }
            this.UseFullLabel();
            if (Translocator.Player.equals("")) {
                this.UseFullIcon(BlockCarriageDrive.PublicIcon);
            } else if (Translocator.Player.equals(Minecraft.func_71410_x().field_71439_g.getDisplayName())) {
                this.UseFullIcon(BlockCarriageDrive.PrivateToSelfIcon);
            } else {
                this.UseFullIcon(BlockCarriageDrive.PrivateToOtherIcon);
            }
            this.RenderOverlay(0.001, Translocator.SideClosed, false);
            for (Vanilla.DyeTypes DyeType : Vanilla.DyeTypes.values()) {
                if (!ItemCarriageDrive.LabelHasDye(Translocator.Label, DyeType)) continue;
                double GridH = (double)(DyeType.ordinal() % 4) / 4.0;
                double GridV = (double)(DyeType.ordinal() / 4) / 4.0;
                this.UsePartialLabel(GridH, GridV, GridH + 0.25, GridV + 0.25);
                this.UsePartialIcon(BlockCarriageDrive.DyeIconSet, GridH, GridV, GridH + 0.25, GridV + 0.25);
                this.RenderOverlay(0.002, Translocator.SideClosed, false);
            }
        }
    }

    @Override
    public IIcon GetIcon(ItemStack Item2, Directions Side2) {
        IIcon ico = RIMBlocks.CarriageDrive.func_149691_a(Side2.ordinal(), ItemBlockRiM.GetBlockType(Item2));
        if (ico == null) {
            return Blocks.field_150348_b.func_149691_a(0, 0);
        }
        return ico;
    }
}

