/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.remaininmotion.spectre;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.planetguy.lib.util.Debug;
import me.planetguy.lib.util.SneakyWorldUtil;
import me.planetguy.remaininmotion.base.BlockCamouflageable;
import me.planetguy.remaininmotion.base.TileEntityRiM;
import me.planetguy.remaininmotion.core.ModRiM;
import me.planetguy.remaininmotion.core.RIMBlocks;
import me.planetguy.remaininmotion.core.RiMConfiguration;
import me.planetguy.remaininmotion.core.interop.EventPool;
import me.planetguy.remaininmotion.drive.BlockCarriageDrive;
import me.planetguy.remaininmotion.drive.TileEntityCarriageDrive;
import me.planetguy.remaininmotion.motion.CarriagePackage;
import me.planetguy.remaininmotion.render.CarriageRenderCache;
import me.planetguy.remaininmotion.util.position.BlockPosition;
import me.planetguy.remaininmotion.util.position.BlockRecord;
import me.planetguy.remaininmotion.util.position.BlockRecordSet;
import me.planetguy.remaininmotion.util.transformations.Directions;
import me.planetguy.remaininmotion.util.transformations.Matrix;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEntityMotiveSpectre
extends TileEntityRiM {
    public static Block MultipartContainerBlockId;
    public Directions motionDirection = Directions.Null;
    public BlockPosition renderCacheKey;
    public NBTTagList pendingBlockUpdates;
    public BlockRecord driveRecord;
    public boolean driveIsAnchored;
    public BlockRecordSet body;
    public BlockRecordSet spectersToDestroy;
    public int ticksExisted = 0;
    public ArrayList<CapturedEntity> CapturedEntities = new ArrayList();
    private boolean initialized;
    public int personalDurationInTicks = RiMConfiguration.CarriageMotion.MotionDuration;
    public double personalVelocity = 1.0 / (double)this.personalDurationInTicks;

    public void ShiftBlockPosition(BlockRecord Record) {
        Record.Shift(this.motionDirection);
    }

    public void ScheduleShiftedBlockUpdate(NBTTagCompound PendingBlockUpdateRecord) {
        this.field_145850_b.func_147446_b(PendingBlockUpdateRecord.func_74762_e("X") + this.motionDirection.deltaX, PendingBlockUpdateRecord.func_74762_e("Y") + this.motionDirection.deltaY, PendingBlockUpdateRecord.func_74762_e("Z") + this.motionDirection.deltaZ, Block.func_149729_e((int)PendingBlockUpdateRecord.func_74762_e("Id")), PendingBlockUpdateRecord.func_74762_e("Delay"), PendingBlockUpdateRecord.func_74762_e("Priority"));
    }

    public void func_145845_h() {
        this.field_145850_b.field_72984_F.func_76320_a("RiMMotiveSpecter");
        ++this.ticksExisted;
        for (CapturedEntity Entity2 : this.CapturedEntities) {
            this.field_145850_b.field_72984_F.func_76320_a("EntityMovement");
            Entity2.Update();
            this.field_145850_b.field_72984_F.func_76319_b();
        }
        if (this.field_145850_b.field_72995_K) {
            this.field_145850_b.field_72984_F.func_76319_b();
            return;
        }
        if (this.ticksExisted > 0 && this.ticksExisted < this.personalDurationInTicks && this.ticksExisted % 20 == 0 && this.bodyHasCarriageDrive()) {
            ModRiM.plHelper.playSound(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, RiMConfiguration.CarriageMotion.SoundFile, RiMConfiguration.CarriageMotion.volume, 1.0f);
        }
        if (this.ticksExisted < this.personalDurationInTicks) {
            this.field_145850_b.field_72984_F.func_76319_b();
            return;
        }
        this.field_145850_b.field_72984_F.func_76320_a("Release");
        this.Release();
        this.field_145850_b.field_72984_F.func_76319_b();
        this.field_145850_b.field_72984_F.func_76319_b();
    }

    private boolean bodyHasCarriageDrive() {
        if (this.body == null || this.body.isEmpty()) {
            return false;
        }
        for (BlockRecord temp : this.body) {
            if (temp.block instanceof BlockCarriageDrive) {
                return true;
            }
            if (temp.entity == null || !(temp.entity instanceof TileEntityCarriageDrive)) continue;
            return true;
        }
        return false;
    }

    public void Release() {
        if (this.body != null && !this.body.isEmpty()) {
            for (BlockRecord record : this.body) {
                this.ShiftBlockPosition(record);
            }
            this.doRelease();
            this.body = new BlockRecordSet();
            if (!this.spectersToDestroy.isEmpty()) {
                this.spectersToDestroy = new BlockRecordSet();
            }
        }
    }

    public void doRelease() {
        if (!this.spectersToDestroy.isEmpty()) {
            for (BlockRecord Record : this.spectersToDestroy) {
                SneakyWorldUtil.setBlock((World)this.field_145850_b, (int)Record.X, (int)Record.Y, (int)Record.Z, (Block)Blocks.field_150350_a, (int)0);
            }
        }
        for (BlockRecord record : this.body) {
            record.World = this.field_145850_b;
            SneakyWorldUtil.setBlock((World)this.field_145850_b, (int)record.X, (int)record.Y, (int)record.Z, (Block)record.block, (int)record.Meta);
        }
        EventPool.postBlocksReplacedEvent(this);
        for (BlockRecord record : this.body) {
            int[] offset = this.getOffset();
            if (record.entityRecord == null) continue;
            this.constructTE(record);
        }
        try {
            Iterator Drive = (TileEntityCarriageDrive)this.field_145850_b.func_147438_o(this.driveRecord.X, this.driveRecord.Y, this.driveRecord.Z);
            if (!this.driveIsAnchored) {
                ((TileEntityCarriageDrive)((Object)Drive)).Active = true;
            }
            ((TileEntityCarriageDrive)((Object)Drive)).ToggleActivity();
        }
        catch (Throwable Drive) {
            // empty catch block
        }
        SneakyWorldUtil.refreshBlock((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (Block)RIMBlocks.Spectre, (Block)Blocks.field_150350_a);
        for (BlockRecord Record : this.body) {
            this.onMotionFinalized(Record);
            SneakyWorldUtil.refreshBlock((World)this.field_145850_b, (int)Record.X, (int)Record.Y, (int)Record.Z, (Block)Blocks.field_150350_a, (Block)Record.block);
        }
        if (!this.spectersToDestroy.isEmpty()) {
            for (BlockRecord Record : this.spectersToDestroy) {
                SneakyWorldUtil.refreshBlock((World)this.field_145850_b, (int)Record.X, (int)Record.Y, (int)Record.Z, (Block)Blocks.field_150350_a, (Block)Blocks.field_150350_a);
            }
        }
        int PendingBlockUpdateCount = this.pendingBlockUpdates.func_74745_c();
        for (int Index = 0; Index < PendingBlockUpdateCount; ++Index) {
            this.ScheduleShiftedBlockUpdate(this.pendingBlockUpdates.func_150305_b(Index));
        }
        for (BlockRecord record : this.body) {
            EventPool.postMotionFinalizeEvent(record);
        }
        this.cleanupSpecter();
    }

    public void cleanupSpecter() {
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) == RIMBlocks.Spectre) {
            this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, Blocks.field_150350_a);
        }
    }

    public int[] getOffset() {
        return new int[]{this.motionDirection.deltaX, this.motionDirection.deltaY, this.motionDirection.deltaZ};
    }

    public int[] getOffset(BlockRecord record) {
        return this.getOffset();
    }

    public void announceTEConstruction(BlockRecord record) {
        EventPool.postTEPreUnpackEvent(this, record);
    }

    public void constructTE(BlockRecord record) {
        record.entityRecord.func_74768_a("x", record.X);
        record.entityRecord.func_74768_a("y", record.Y);
        record.entityRecord.func_74768_a("z", record.Z);
        this.announceTEConstruction(record);
        try {
            record.entity = TileEntity.func_145827_c((NBTTagCompound)record.entityRecord);
        }
        catch (Exception exception) {
            // empty catch block
        }
        EventPool.postTEPrePlaceEvent(this, record);
        if (record.entity != null) {
            SneakyWorldUtil.setTileEntity((World)this.field_145850_b, (int)record.X, (int)record.Y, (int)record.Z, (TileEntity)record.entity);
        }
        EventPool.postTEPostPlaceEvent(this, record);
    }

    public void onMotionFinalized(BlockRecord Record) {
    }

    @Override
    public void Finalize() {
        if (this.field_145850_b.field_72995_K) {
            CarriageRenderCache.Release(this.renderCacheKey);
        }
    }

    @Override
    public void WriteCommonRecord(NBTTagCompound TagCompound) {
        TagCompound.func_74768_a("motion", this.motionDirection.ordinal());
        if (this.renderCacheKey != null) {
            TagCompound.func_74768_a("RenderCacheKeyX", this.renderCacheKey.X);
            TagCompound.func_74768_a("RenderCacheKeyY", this.renderCacheKey.Y);
            TagCompound.func_74768_a("RenderCacheKeyZ", this.renderCacheKey.Z);
            TagCompound.func_74768_a("RenderCacheKeyD", this.renderCacheKey.Dimension);
        }
        if (this.driveRecord != null) {
            NBTTagCompound tag = new NBTTagCompound();
            this.driveRecord.writeToNBT(tag);
            TagCompound.func_74782_a("driveRecord", (NBTBase)tag);
        }
        TagCompound.func_74768_a("PersonalDuration", this.personalDurationInTicks);
    }

    @Override
    public void ReadCommonRecord(NBTTagCompound TagCompound) {
        this.motionDirection = Directions.values()[TagCompound.func_74762_e("motion")];
        this.renderCacheKey = new BlockPosition(TagCompound.func_74762_e("RenderCacheKeyX"), TagCompound.func_74762_e("RenderCacheKeyY"), TagCompound.func_74762_e("RenderCacheKeyZ"), TagCompound.func_74762_e("RenderCacheKeyD"));
        if (TagCompound.func_74764_b("driveRecord")) {
            NBTTagCompound drt = TagCompound.func_74775_l("driveRecord");
            this.driveRecord = new BlockRecord(drt.func_74762_e("DriveX"), drt.func_74762_e("DriveY"), drt.func_74762_e("DriveZ"));
        }
        if (TagCompound.func_74764_b("driveRecord")) {
            this.driveRecord = BlockRecord.createFromNBT(TagCompound.func_74775_l("driveRecord"));
        }
        this.personalDurationInTicks = TagCompound.func_74762_e("PersonalDuration");
        this.personalVelocity = 1.0 / (double)this.personalDurationInTicks;
    }

    @Override
    public void WriteServerRecord(NBTTagCompound TagCompound) {
        NBTTagCompound BodyBlockRecord;
        TagCompound.func_74757_a("driveIsAnchored", this.driveIsAnchored);
        TagCompound.func_74768_a("ticksExisted", this.ticksExisted);
        TagCompound.func_74782_a("pendingBlockUpdates", (NBTBase)this.pendingBlockUpdates);
        NBTTagList BodyRecord = new NBTTagList();
        if (this.body != null && !this.body.isEmpty()) {
            for (BlockRecord Record : this.body) {
                BodyBlockRecord = new NBTTagCompound();
                Record.writeToNBT(BodyBlockRecord);
                BodyRecord.func_74742_a((NBTBase)BodyBlockRecord);
            }
        }
        TagCompound.func_74782_a("Body", (NBTBase)BodyRecord);
        BodyRecord = new NBTTagList();
        if (this.spectersToDestroy != null && !this.spectersToDestroy.isEmpty()) {
            for (BlockRecord Record : this.spectersToDestroy) {
                BodyBlockRecord = new NBTTagCompound();
                Record.writeToNBT(BodyBlockRecord);
                BodyRecord.func_74742_a((NBTBase)BodyBlockRecord);
            }
            TagCompound.func_74782_a("spectersToDestroy", (NBTBase)BodyRecord);
        }
    }

    @Override
    public void ReadServerRecord(NBTTagCompound TagCompound) {
        BlockRecord Record;
        NBTTagCompound BodyBlockRecord;
        int Index;
        this.driveIsAnchored = TagCompound.func_74767_n("driveIsAnchored");
        this.ticksExisted = TagCompound.func_74762_e("ticksExisted");
        this.pendingBlockUpdates = TagCompound.func_150295_c("pendingBlockUpdates", 10);
        this.body = new BlockRecordSet();
        NBTTagList BodyRecord = TagCompound.func_150295_c("Body", 10);
        int BodyBlockCount = BodyRecord.func_74745_c();
        for (Index = 0; Index < BodyBlockCount; ++Index) {
            BodyBlockRecord = BodyRecord.func_150305_b(Index);
            Record = BlockRecord.createFromNBT(BodyBlockRecord);
            this.body.add(Record);
        }
        this.spectersToDestroy = new BlockRecordSet();
        if (TagCompound.func_74764_b("spectersToDestroy")) {
            BodyRecord = TagCompound.func_150295_c("spectersToDestroy", 10);
            BodyBlockCount = BodyRecord.func_74745_c();
            for (Index = 0; Index < BodyBlockCount; ++Index) {
                BodyBlockRecord = BodyRecord.func_150305_b(Index);
                Record = BlockRecord.createFromNBT(BodyBlockRecord);
                this.spectersToDestroy.add(Record);
            }
        }
    }

    @Override
    public void WriteClientRecord(NBTTagCompound TagCompound) {
        NBTTagList CapturedEntityRecords = new NBTTagList();
        int i = 0;
        for (CapturedEntity Entity2 : this.CapturedEntities) {
            if (i++ == RiMConfiguration.Cosmetic.maxTags) break;
            NBTTagCompound CapturedEntityRecord = new NBTTagCompound();
            CapturedEntityRecord.func_74768_a("Id", Entity2.entity.func_145782_y());
            CapturedEntityRecord.func_74780_a("InitialX", Entity2.InitialX);
            CapturedEntityRecord.func_74780_a("InitialY", Entity2.InitialY);
            CapturedEntityRecord.func_74780_a("InitialZ", Entity2.InitialZ);
            CapturedEntityRecord.func_74780_a("netMotionX", Entity2.netMotionX);
            CapturedEntityRecord.func_74780_a("netMotionY", Entity2.netMotionY);
            CapturedEntityRecord.func_74780_a("netMotionZ", Entity2.netMotionZ);
            CapturedEntityRecords.func_74742_a((NBTBase)CapturedEntityRecord);
        }
        if (RiMConfiguration.Debug.verbose) {
            Debug.dbg((Object)("Captured " + i + " tile entities."));
        }
        TagCompound.func_74782_a("CapturedEntities", (NBTBase)CapturedEntityRecords);
    }

    @Override
    public void ReadClientRecord(NBTTagCompound TagCompound) {
        NBTTagList CapturedEntityRecords = TagCompound.func_150295_c("CapturedEntities", 10);
        this.CapturedEntities.clear();
        int CapturedEntityCount = CapturedEntityRecords.func_74745_c();
        for (int Index = 0; Index < CapturedEntityCount; ++Index) {
            NBTTagCompound EntityRecord = CapturedEntityRecords.func_150305_b(Index);
            Entity Entity2 = this.field_145850_b.func_73045_a(EntityRecord.func_74762_e("Id"));
            if (Entity2 == null) continue;
            this.CapturedEntities.add(new CapturedEntity(Entity2, EntityRecord.func_74769_h("InitialX"), EntityRecord.func_74769_h("InitialY"), EntityRecord.func_74769_h("InitialZ"), EntityRecord.func_74769_h("netMotionX"), EntityRecord.func_74769_h("netMotionY"), EntityRecord.func_74769_h("netMotionZ")));
        }
    }

    public void fixLagError(CapturedEntity capture, Entity entity) {
        double motionX = 0.0;
        double motionZ = 0.0;
        motionX = this.fixDouble(motionX, this.motionDirection.deltaX, capture.netMotionX, true);
        motionZ = this.fixDouble(motionZ, this.motionDirection.deltaZ, capture.netMotionZ, true);
        if (this.motionDirection.deltaY != 0) {
            entity.field_70122_E = capture.WasOnGround;
            entity.field_70160_al = capture.WasAirBorne;
            capture.SetPosition(motionX, 0.0, motionZ);
            capture.SetYPosition((double)this.motionDirection.deltaY + 0.025);
        } else if (motionX != 0.0 || motionZ != 0.0) {
            double[] motion = this.handleEntityCollision(entity, motionX, motionZ);
            capture.netMotionX += motion[0];
            capture.netMotionZ += motion[1];
        }
    }

    public void doPerSpectreEntityUpdate(CapturedEntity capture, Entity entity) {
        entity.field_70143_R = 0.0f;
        if ((double)this.motionDirection.deltaX != capture.netMotionX || (double)this.motionDirection.deltaZ != capture.netMotionZ || (double)this.motionDirection.deltaY != capture.netMotionY) {
            double motionX = this.personalVelocity * (double)this.motionDirection.deltaX;
            double motionY = this.personalVelocity * (double)this.motionDirection.deltaY;
            double motionZ = this.personalVelocity * (double)this.motionDirection.deltaZ;
            motionX = this.fixDouble(motionX, this.motionDirection.deltaX, capture.netMotionX + motionX, false);
            motionZ = this.fixDouble(motionZ, this.motionDirection.deltaZ, capture.netMotionZ + motionZ, false);
            if (this.motionDirection.deltaY != 0) {
                entity.field_70122_E = capture.WasOnGround;
                entity.field_70160_al = capture.WasAirBorne;
                capture.netMotionY += motionY;
                capture.SetPosition(motionX, 0.0, motionZ);
                capture.SetYPosition(capture.netMotionY);
            } else {
                double[] motion = this.handleEntityCollision(entity, motionX, motionZ);
                motionX = motion[0];
                motionZ = motion[1];
                capture.netMotionX += motionX;
                capture.netMotionZ += motionZ;
            }
        }
        if (this.ticksExisted >= this.personalDurationInTicks) {
            this.fixLagError(capture, entity);
            capture.stop();
            return;
        }
    }

    private double[] handleEntityCollision(Entity entity, double motionX, double motionZ) {
        int j;
        double X = motionX;
        double Z = motionZ;
        List list = this.field_145850_b.func_72945_a(entity, entity.field_70121_D.func_72321_a(X, 0.0, Z));
        for (j = 0; j < list.size(); ++j) {
            X = ((AxisAlignedBB)list.get(j)).func_72316_a(entity.field_70121_D, X);
        }
        entity.field_70121_D.func_72317_d(X, 0.0, 0.0);
        for (j = 0; j < list.size(); ++j) {
            Z = ((AxisAlignedBB)list.get(j)).func_72322_c(entity.field_70121_D, motionZ);
        }
        entity.field_70121_D.func_72317_d(0.0, 0.0, motionZ);
        entity.field_70165_t = (entity.field_70121_D.field_72340_a + entity.field_70121_D.field_72336_d) / 2.0;
        entity.field_70161_v = (entity.field_70121_D.field_72339_c + entity.field_70121_D.field_72334_f) / 2.0;
        entity.field_70123_F = motionX != X || motionZ != Z;
        entity.field_70132_H = entity.field_70123_F || entity.field_70124_G;
        motionX = X;
        motionZ = Z;
        return new double[]{motionX, motionZ};
    }

    private double fixDouble(double progress, double goal, double net, boolean forceBothWays) {
        double out = progress;
        if (net == goal) {
            return 0.0;
        }
        if (forceBothWays && net < goal) {
            out = goal - net;
        }
        if (Math.abs(net) > Math.abs(goal)) {
            out = goal - net;
        }
        return out;
    }

    public boolean ShouldCaptureEntity(Entity Entity2) {
        if (Entity2 instanceof EntityPlayer) {
            return RiMConfiguration.CarriageMotion.CapturePlayerEntities;
        }
        if (Entity2 instanceof EntityLiving) {
            return RiMConfiguration.CarriageMotion.CaptureOtherLivingEntities;
        }
        if (Entity2 instanceof EntityItem) {
            return RiMConfiguration.CarriageMotion.CaptureItemEntities;
        }
        return RiMConfiguration.CarriageMotion.CaptureOtherEntities;
    }

    public void ProcessCapturedEntity(Entity Entity2) {
        this.CapturedEntities.add(new CapturedEntity(Entity2));
    }

    public void CaptureEntities(int MinX, int MinY, int MinZ, int MaxX, int MaxY, int MaxZ) {
        AxisAlignedBB EntityCaptureBox = AxisAlignedBB.func_72330_a((double)(MinX - 5), (double)(MinY - 5), (double)(MinZ - 5), (double)(MaxX + 5), (double)(MaxY + 5), (double)(MaxZ + 5));
        List EntitiesFound = this.field_145850_b.func_72872_a(Entity.class, EntityCaptureBox);
        for (Object EntityObject : EntitiesFound) {
            Entity entity = (Entity)EntityObject;
            BlockRecord PositionCheck = new BlockRecord((int)Math.floor(entity.field_70165_t), (int)Math.floor(entity.field_70163_u), (int)Math.floor(entity.field_70161_v));
            if (!this.body.contains(PositionCheck)) {
                --PositionCheck.Y;
                if (!this.body.contains(PositionCheck)) {
                    --PositionCheck.Y;
                    if (!this.body.contains(PositionCheck)) {
                        entity = null;
                    }
                }
            }
            if (entity == null || !this.ShouldCaptureEntity(entity)) continue;
            try {
                this.ProcessCapturedEntity(entity);
            }
            catch (Throwable Throwable2) {
                Throwable2.printStackTrace();
            }
        }
    }

    public void Absorb(CarriagePackage Package) {
        this.motionDirection = Package.MotionDirection;
        this.body = Package.Body;
        this.spectersToDestroy = Package.spectersToDestroy;
        this.renderCacheKey = Package.RenderCacheKey;
        this.pendingBlockUpdates = Package.PendingBlockUpdates;
        this.driveRecord = new BlockRecord(Package.driveRecord);
        if (!Package.DriveIsAnchored) {
            this.driveRecord.Shift(Package.MotionDirection);
        }
        if (Package.MotionDirection != null) {
            this.CaptureEntities(Package.MinX, Package.MinY, Package.MinZ, Package.MaxX, Package.MaxY, Package.MaxZ);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public boolean shouldRenderInPass(int Pass) {
        return true;
    }

    public boolean canUpdate() {
        return true;
    }

    public int getLightValue() {
        Block b2;
        Block b = null;
        NBTTagCompound nbt = null;
        if (this.body == null) {
            return RIMBlocks.Spectre.func_149750_m();
        }
        for (BlockRecord temp : this.body) {
            if (temp.X != this.field_145851_c || temp.Y != this.field_145848_d || temp.Z != this.field_145849_e) continue;
            b = temp.block;
            nbt = temp.entityRecord;
        }
        if (b instanceof BlockCamouflageable && nbt != null && (b2 = Block.func_149729_e((int)nbt.func_74762_e("DecorationId"))) != null) {
            return b2.func_149750_m();
        }
        if (b != null) {
            return b.func_149750_m();
        }
        return RIMBlocks.Spectre.func_149750_m();
    }

    public int getLightOpacity() {
        Block b2;
        Block b = null;
        NBTTagCompound nbt = null;
        if (this.body == null) {
            return RIMBlocks.Spectre.func_149717_k();
        }
        for (BlockRecord temp : this.body) {
            if (temp.X != this.field_145851_c || temp.Y != this.field_145848_d || temp.Z != this.field_145849_e) continue;
            b = temp.block;
            nbt = temp.entityRecord;
            break;
        }
        if (b instanceof BlockCamouflageable && nbt != null && (b2 = Block.func_149729_e((int)nbt.func_74762_e("DecorationId"))) != null) {
            return b2.func_149717_k();
        }
        if (b != null) {
            return b.func_149717_k();
        }
        return RIMBlocks.Spectre.func_149717_k();
    }

    public class CapturedEntity {
        public Entity entity;
        public double InitialX;
        public double InitialY;
        public double InitialZ;
        public Matrix startingPosition;
        public double netMotionX = 0.0;
        public double netMotionY = 0.0;
        public double netMotionZ = 0.0;
        boolean WasOnGround;
        boolean WasAirBorne;

        public CapturedEntity(Entity entity) {
            this(entity, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.0, 0.0, 0.0);
        }

        public CapturedEntity(Entity entity, double InitialX, double InitialY, double InitialZ, double netMotionX, double netMotionY, double netMotionZ) {
            this.entity = entity;
            this.InitialX = InitialX;
            this.InitialY = InitialY;
            this.InitialZ = InitialZ;
            this.netMotionX = netMotionX;
            this.netMotionY = netMotionY;
            this.netMotionZ = netMotionZ;
            this.WasOnGround = entity.field_70122_E;
            this.WasAirBorne = entity.field_70160_al;
            this.Update();
        }

        public void SetPosition(double OffsetX, double OffsetY, double OffsetZ) {
            this.entity.func_70107_b(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v);
        }

        public void SetYPosition(double OffsetY) {
            this.entity.func_70107_b(this.entity.field_70165_t, this.InitialY + (double)this.entity.field_70129_M + OffsetY, this.entity.field_70161_v);
        }

        public void Update() {
            TileEntityMotiveSpectre.this.doPerSpectreEntityUpdate(this, this.entity);
        }

        public void stop() {
            this.entity.field_70142_S = this.entity.field_70169_q = this.entity.field_70165_t;
            this.entity.field_70137_T = this.entity.field_70167_r = this.entity.field_70163_u;
            this.entity.field_70136_U = this.entity.field_70166_s = this.entity.field_70161_v;
            this.entity.field_70179_y = 0.0;
            this.entity.field_70181_x = 0.0;
            this.entity.field_70159_w = 0.0;
        }
    }
}

