/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.remaininmotion.util;

import me.planetguy.remaininmotion.api.ConnectabilityState;
import me.planetguy.remaininmotion.api.ICloseable;
import me.planetguy.remaininmotion.api.Moveable;
import me.planetguy.remaininmotion.core.Closeables;
import me.planetguy.remaininmotion.motion.CarriageMatchers;
import me.planetguy.remaininmotion.motion.CarriageMotionException;
import me.planetguy.remaininmotion.motion.CarriagePackage;
import me.planetguy.remaininmotion.util.position.BlockRecord;
import me.planetguy.remaininmotion.util.position.BlockRecordSet;
import me.planetguy.remaininmotion.util.transformations.Directions;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class MultiTypeCarriageUtil {
    public static void fillPackage(CarriagePackage package1, TileEntity carriage) throws CarriageMotionException {
        Moveable m = CarriageMatchers.getMover(package1.AnchorRecord.block, package1.AnchorRecord.Meta, package1.AnchorRecord.entity);
        m.fillPackage(package1);
    }

    public static void fillFramePackage(CarriagePackage Package2, World worldObj) throws CarriageMotionException {
        int seen = 0;
        BlockRecordSet CarriagesToCheck = new BlockRecordSet();
        BlockRecordSet BlocksChecked = new BlockRecordSet();
        BlocksChecked.add(Package2.driveRecord);
        BlocksChecked.add(Package2.AnchorRecord);
        Package2.AddBlock(Package2.AnchorRecord);
        CarriagesToCheck.add(Package2.AnchorRecord);
        while (CarriagesToCheck.size() > 0) {
            ++seen;
            BlockRecord CarriageRecord = (BlockRecord)CarriagesToCheck.pollFirst();
            for (Directions TargetDirection : Directions.validDirections()) {
                BlockRecord TargetRecord = CarriageRecord.NextInDirection(TargetDirection);
                ICloseable closeable = Closeables.getCloseable(CarriageRecord.entity);
                if (closeable != null) {
                    int direction = TargetDirection.ordinal();
                    ConnectabilityState state = closeable.isSideClosed(direction);
                    if (direction >= 0 && direction < 6 && state == ConnectabilityState.CLOSED) {
                        if (TargetDirection != Package2.MotionDirection) continue;
                        Package2.AddPotentialObstruction(TargetRecord);
                        continue;
                    }
                }
                if (!BlocksChecked.add(TargetRecord) || worldObj.func_147437_c(TargetRecord.X, TargetRecord.Y, TargetRecord.Z)) continue;
                TargetRecord.Identify(worldObj);
                Package2.AddBlock(TargetRecord);
                if (Package2.MatchesCarriageType(TargetRecord)) {
                    CarriagesToCheck.add(TargetRecord);
                    continue;
                }
                if (Package2.MotionDirection == null) continue;
                Package2.AddPotentialObstruction(TargetRecord.NextInDirection(Package2.MotionDirection));
            }
        }
    }
}

