/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.remaininmotion.util.transformations;

import me.planetguy.remaininmotion.util.transformations.Matrix;

public class Matrices {
    public static final Matrix[] ccwRotMatrices = new Matrix[]{new Matrix(new double[][]{{0.0, 0.0, 1.0}, {0.0, 1.0, 0.0}, {-1.0, 0.0, 0.0}}), new Matrix(new double[][]{{0.0, 0.0, -1.0}, {0.0, 1.0, 0.0}, {1.0, 0.0, 0.0}}), new Matrix(new double[][]{{0.0, -1.0, 0.0}, {1.0, 0.0, 0.0}, {0.0, 0.0, 1.0}}), new Matrix(new double[][]{{0.0, 1.0, 0.0}, {-1.0, 0.0, 0.0}, {0.0, 0.0, 1.0}}), new Matrix(new double[][]{{1.0, 0.0, 0.0}, {0.0, 0.0, -1.0}, {0.0, 1.0, 0.0}}), new Matrix(new double[][]{{1.0, 0.0, 0.0}, {0.0, 0.0, 1.0}, {0.0, -1.0, 0.0}})};

    public static double sin(double fractionOfCircle) {
        return Math.sin(fractionOfCircle * 2.0 * Math.PI);
    }

    public static double cos(double fractionOfCircle) {
        return Math.cos(fractionOfCircle * 2.0 * Math.PI);
    }

    public static Matrix fromAxisAndAngle(int axis, double a) {
        switch (axis) {
            case 5: {
                a = -a;
            }
            case 4: {
                return new Matrix(new double[][]{{1.0, 0.0, 0.0}, {0.0, Matrices.cos(a), -Matrices.sin(a)}, {0.0, Matrices.sin(a), Matrices.cos(a)}});
            }
            case 3: {
                a = -a;
            }
            case 2: {
                return new Matrix(new double[][]{{Matrices.cos(a), -Matrices.sin(a), 0.0}, {Matrices.sin(a), Matrices.cos(a), 0.0}, {0.0, 0.0, 1.0}});
            }
            case 1: {
                a = -a;
            }
            case 0: {
                return new Matrix(new double[][]{{Matrices.cos(a), 0.0, Matrices.sin(a)}, {0.0, 1.0, 0.0}, {-Matrices.sin(a), 0.0, Matrices.cos(a)}});
            }
        }
        return null;
    }
}

