/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.imagine;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkCheckHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.Map;
import pw.prok.imagine.ImagineProxy;
import pw.prok.imagine.asm.ImagineASMClassTransformer;
import pw.prok.imagine.asm.Transformer;
import pw.prok.imagine.fan.FanRegistry;
import pw.prok.imagine.inject.Creator;
import pw.prok.imagine.inject.Injector;
import pw.prok.imagine.inject.RegisterInjector;

public class ImagineModContainer
extends DummyModContainer {
    public static final String MODID = "kimagine";
    public static ImagineModContainer INSTANCE;
    @SidedProxy(serverSide="pw.prok.imagine.ImaginePoxy", clientSide="pw.prok.imagine.client.ImagineClientProxy")
    private ImagineProxy proxy;
    private ModMetadata mMetadata = this.getMetadata();

    public static ImagineProxy proxy() {
        return ImagineModContainer.INSTANCE.proxy;
    }

    public ImagineModContainer() {
        super(ImagineModContainer.createContainerMetadata());
        INSTANCE = this;
    }

    private static ModMetadata createContainerMetadata() {
        ModMetadata metadata = new ModMetadata();
        metadata.modId = MODID;
        metadata.name = "KImagine";
        metadata.version = "0.1";
        return metadata;
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    public static void registerChildMod(ModContainer modContainer) {
        ModMetadata metadata = modContainer.getMetadata();
        metadata.parent = MODID;
        metadata.parentMod = INSTANCE;
        ImagineModContainer.INSTANCE.mMetadata.childMods.add(modContainer);
    }

    @Subscribe
    public void constructMod(FMLConstructionEvent event) {
        try {
            for (ASMDataTable.ASMData data : event.getASMHarvestedData().getAll(RegisterInjector.class.getName())) {
                Injector.registerInjector(event.getModClassLoader().loadClass(data.getClassName()));
            }
            for (ASMDataTable.ASMData data : event.getASMHarvestedData().getAll(Transformer.RegisterTransformer.class.getName())) {
                ImagineASMClassTransformer.addTransformer((Transformer)Creator.creator(data.getClassName()).build());
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    @NetworkCheckHandler
    public boolean checkModLists(Map<String, String> modList, Side side) {
        return true;
    }

    @Subscribe
    public void onPreInit(FMLPreInitializationEvent event) {
        FanRegistry.finishLoading();
    }
}

