/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.imagine.asm;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import pw.prok.imagine.ImagineLoadingPlugin;
import pw.prok.imagine.api.Pair;
import pw.prok.imagine.api.Triple;
import pw.prok.imagine.asm.Action;
import pw.prok.imagine.asm.Filter;
import pw.prok.imagine.asm.ImagineMethod;
import pw.prok.imagine.asm.ImagineRemapper;
import pw.prok.imagine.asm.MethodFilter;

public class ImagineASM {
    private static final Filter CONSTRUCTO_FILTER = new Filter(){

        @Override
        public boolean matching(ImagineMethod method) {
            return "<init>".equals(method.getName());
        }
    };
    protected byte[] mClass;
    protected boolean mDev = ImagineLoadingPlugin.DEV;
    protected ClassNode mClassNode;
    protected String mName;
    protected String mDevName;

    public static ImagineASM create() {
        return new ImagineASM();
    }

    public ImagineASM loadClass(byte[] bytes) {
        return this.loadClass(null, null, bytes);
    }

    public ImagineASM loadClass(String name, String devName, byte[] bytes) {
        this.mClass = bytes;
        this.mClassNode = null;
        this.mName = name;
        this.mDevName = devName;
        if (this.mName == null) {
            this.reset();
            this.mName = this.mClassNode.name;
            this.mClassNode = null;
        }
        if (this.mDevName == null) {
            this.mDevName = ImagineRemapper.clazzDev(this.mName);
        }
        return this;
    }

    public String getName() {
        return this.mName;
    }

    public String getDevName() {
        return this.mDevName;
    }

    public boolean is(String name) {
        return ImagineASM.toName(this.mDevName).equals(ImagineASM.toName(ImagineRemapper.clazzDev(name)));
    }

    public boolean isDev() {
        return this.mDev;
    }

    protected void readClass() {
        if (this.mClassNode != null) {
            return;
        }
        this.reset();
    }

    public ImagineASM reset() {
        if (this.mClass == null) {
            this.mClassNode = null;
            return this;
        }
        this.mClassNode = new ClassNode(327680);
        ClassReader reader = new ClassReader(this.mClass);
        reader.accept((ClassVisitor)this.mClassNode, 8);
        return this;
    }

    public ImagineASM clear() {
        this.mClass = null;
        this.mClassNode = null;
        this.mName = null;
        this.mDevName = null;
        return null;
    }

    public byte[] build() {
        if (this.mClassNode == null) {
            return this.mClass;
        }
        ClassWriter writer = new ClassWriter(1);
        this.mClassNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public ImagineASM renameClass(String name) {
        this.readClass();
        this.mClassNode.name = ImagineASM.toDesc(name);
        return this;
    }

    public ImagineASM renameClass(String obfName, String devName) {
        return this.renameClass(this.mDev ? devName : obfName);
    }

    public ImagineASM renameMappedClass(String name) {
        return this.renameClass(this.clazz(name));
    }

    public ImagineMethod method(String name, String desc) {
        this.readClass();
        name = this.clazz(name);
        desc = this.desc(desc);
        for (MethodNode method : this.mClassNode.methods) {
            if (!name.equals(method.name) || desc != null && !desc.equals(method.desc)) continue;
            return new ImagineMethod(this, method);
        }
        return null;
    }

    public ImagineMethod addMethod(int flags, String name, String desc) {
        this.readClass();
        MethodNode node = new MethodNode(327680, flags, name, desc, null, null);
        this.mClassNode.methods.add(node);
        return new ImagineMethod(this, node);
    }

    public static String toDesc(String name) {
        return name == null ? null : name.replace('.', '/');
    }

    public static String toName(String desc) {
        return desc == null ? null : desc.replace('/', '.');
    }

    public String clazz(String name) {
        name = ImagineASM.toDesc(name);
        return ImagineRemapper.clazz(name, this.mDev);
    }

    public String desc(String desc) {
        return ImagineRemapper.desc(desc, this.mDev);
    }

    public Pair<String, String> field(String owner, String name) {
        return ImagineRemapper.field(owner, name, this.mDev);
    }

    public Triple<String, String, String> method(String owner, String method, String desc) {
        return ImagineRemapper.method(owner, method, desc, this.mDev);
    }

    public String getActualName() {
        if (this.mClassNode != null) {
            return ImagineASM.toName(this.mClassNode.name);
        }
        return this.mName;
    }

    public ImagineMethod constructor(String desc) {
        return this.method("<init>", desc);
    }

    public Iterable<ImagineMethod> constructors() {
        return this.filter(CONSTRUCTO_FILTER);
    }

    public ImagineASM constructors(Action<ImagineMethod> action) {
        return this.action(this.constructors(), action);
    }

    public Iterable<ImagineMethod> filter(Filter filter) {
        return new MethodFilter(this, filter);
    }

    public ImagineASM action(Iterable<ImagineMethod> methods, Action<ImagineMethod> action) {
        for (ImagineMethod method : methods) {
            action.action(method);
        }
        return this;
    }

    public ImagineASM action(Filter filter, Action<ImagineMethod> action) {
        return this.action(this.filter(filter), action);
    }

    public static List<AbstractInsnNode> asList(InsnList instructions) {
        ArrayList<AbstractInsnNode> list = new ArrayList<AbstractInsnNode>(instructions.size());
        ListIterator iterator = instructions.iterator();
        while (iterator.hasNext()) {
            list.add((AbstractInsnNode)iterator.next());
        }
        return list;
    }

    public ClassNode getClassNode() {
        this.readClass();
        return this.mClassNode;
    }
}

