/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.imagine.asm;

import java.util.LinkedList;
import java.util.List;
import org.objectweb.asm.Type;
import pw.prok.imagine.util.Array;

public class ImagineDesc {
    private final SubDesc mReturnType;
    private final List<SubDesc> mParameterTypes;

    public ImagineDesc(SubDesc returnType, SubDesc ... parameterTypes) {
        assert (returnType != null);
        assert (parameterTypes != null);
        this.mReturnType = returnType;
        this.mParameterTypes = Array.asList(parameterTypes);
    }

    public SubDesc returnType() {
        return this.mReturnType;
    }

    public List<SubDesc> parameters() {
        return this.mParameterTypes;
    }

    public SubDesc parameter(int i) {
        return this.mParameterTypes.get(i);
    }

    public ImagineDesc insert(SubDesc sub, int pos) {
        this.mParameterTypes.add(pos, sub);
        return this;
    }

    public ImagineDesc insert(Type type, int level, int pos) {
        return this.insert(SubDesc.create(type, level), pos);
    }

    public ImagineDesc first(SubDesc sub) {
        return this.insert(sub, 0);
    }

    public ImagineDesc first(Type type, int level) {
        return this.first(SubDesc.create(type, level));
    }

    public ImagineDesc last(SubDesc sub) {
        this.mParameterTypes.add(sub);
        return this;
    }

    public ImagineDesc last(Type type, int level) {
        return this.last(SubDesc.create(type, level));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (SubDesc sub : this.mParameterTypes) {
            builder.append(sub.toString());
        }
        builder.append(')');
        builder.append(this.mReturnType.toString());
        return builder.toString();
    }

    public int returnOpcode() {
        return this.mReturnType.opcodeReturn();
    }

    public static ImagineDesc parse(String desc) {
        boolean returnTypeFlag = false;
        SubDesc returnType = null;
        LinkedList<SubDesc> parameterTypes = new LinkedList<SubDesc>();
        int level = 0;
        for (int i = 0; i < desc.length(); ++i) {
            String name;
            char c = desc.charAt(i);
            if (c == '(') continue;
            if (c == ')') {
                returnTypeFlag = true;
                continue;
            }
            if (c == '[') {
                ++level;
                continue;
            }
            if (c == 'L') {
                int end = desc.indexOf(59, i + 1);
                name = desc.substring(i, end + 1);
                i = end;
            } else {
                name = new String(new char[]{c});
            }
            Type type = Type.getType((String)name);
            if (returnTypeFlag) {
                returnType = new SubDesc(type, level);
            } else {
                parameterTypes.add(new SubDesc(type, level));
            }
            level = 0;
        }
        return new ImagineDesc(returnType, (SubDesc[])Array.asArray(parameterTypes));
    }

    public static class SubDesc {
        public final Type type;
        public final int level;

        public static SubDesc create(Type type, int level) {
            assert (level >= 0);
            assert (type != null);
            return new SubDesc(type, level);
        }

        private SubDesc(Type type, int level) {
            this.type = type;
            this.level = level;
        }

        public int opcodeLoad() {
            return this.type.getOpcode(21);
        }

        public int opcodeReturn() {
            return this.type.getOpcode(172);
        }

        public String toString() {
            return this.type.getDescriptor();
        }
    }
}

