/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.imagine.asm;

import LZMA.LzmaInputStream;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import pw.prok.imagine.api.Pair;
import pw.prok.imagine.api.Triple;

public class ImagineRemapper {
    private static final BiMap<String, String> sRawClass = HashBiMap.create();
    private static final BiMap<String, String> sRawField = HashBiMap.create();
    private static final BiMap<String, String> sRawMethod = HashBiMap.create();
    private static final Map<String, String> sSrgMethods = new HashMap<String, String>();
    private static final Map<String, String> sSrgFields = new HashMap<String, String>();
    private static final BiMap<String, String> sDevMethods = HashBiMap.create();
    private static boolean sDevMethodsDirty = true;
    private static final BiMap<String, String> sDevFields = HashBiMap.create();
    private static boolean sDevFieldsDirty = true;

    public static String descDev(String desc) {
        return ImagineRemapper.desc(desc, true);
    }

    public static String descObf(String desc) {
        return ImagineRemapper.desc(desc, false);
    }

    public static String desc(String desc, boolean dev) {
        StringBuilder newDesc = new StringBuilder();
        for (int i = 0; i < desc.length(); ++i) {
            char c = desc.charAt(i);
            if (c == 'L') {
                int end = desc.indexOf(59, i + 1);
                newDesc.append('L');
                newDesc.append(ImagineRemapper.clazz(desc.substring(i + 1, end), dev));
                newDesc.append(';');
                i = end;
                continue;
            }
            newDesc.append(c);
        }
        return newDesc.toString();
    }

    public static String clazzDev(String name) {
        return ImagineRemapper.clazz(name, true);
    }

    public static String clazzObf(String name) {
        return ImagineRemapper.clazz(name, false);
    }

    public static String clazz(String name, boolean dev) {
        String clazz = (String)(dev ? sRawClass : sRawClass.inverse()).get((Object)name);
        return clazz != null ? clazz : name;
    }

    public static String methodSrgToDev(String srg) {
        String dev = sSrgMethods.get(srg);
        return dev != null ? dev : srg;
    }

    public static Triple<String, String, String> methodDev(String owner, String name, String desc) {
        return ImagineRemapper.method(owner, name, desc, true);
    }

    public static Triple<String, String, String> methodObf(String owner, String name, String desc) {
        return ImagineRemapper.method(owner, name, desc, false);
    }

    public static Triple<String, String, String> method(String owner, String name, String desc, boolean dev) {
        String method;
        owner = ImagineRemapper.clazz(owner, dev);
        desc = ImagineRemapper.desc(desc, dev);
        BiMap<String, String> methods = ImagineRemapper.obtainDevMap(MappingType.Method);
        if (dev) {
            name = ImagineRemapper.methodSrgToDev(name);
            method = (String)methods.inverse().get((Object)(owner + name + desc));
        } else {
            method = (String)methods.get((Object)(owner + name + desc));
        }
        if (method != null) {
            return Triple.create(ImagineRemapper.cutMethodClass(method), ImagineRemapper.cutMethod(method), ImagineRemapper.cutMethodDesc(method));
        }
        return Triple.create(owner, name, desc);
    }

    public static String cutMethod(String fullDesc) {
        int c = fullDesc.indexOf(40);
        if (c > 0) {
            int n = fullDesc.lastIndexOf(47, c);
            return fullDesc.substring(n < 0 ? 0 : n, c);
        }
        return fullDesc;
    }

    public static String cutMethodClass(String fullDesc) {
        int n;
        int c = fullDesc.indexOf(40);
        if (c > 0 && (n = fullDesc.lastIndexOf(47, c)) > 0) {
            return fullDesc.substring(0, n);
        }
        return fullDesc;
    }

    public static String cutDesc(String fullDesc) {
        int c = fullDesc.indexOf(40);
        if (c > 0) {
            return fullDesc.substring(c);
        }
        return fullDesc;
    }

    public static String cutMethodDesc(String fullDesc) {
        int n;
        int c = fullDesc.indexOf(40);
        if (c > 0 && (n = fullDesc.lastIndexOf(47, c)) > 0) {
            return fullDesc.substring(n + 1);
        }
        return fullDesc;
    }

    public static String cutField(String fullDesc) {
        int c = fullDesc.indexOf(47);
        if (c > 0) {
            return fullDesc.substring(c + 1);
        }
        return fullDesc;
    }

    public static String cutFieldClass(String fullDesc) {
        int c = fullDesc.indexOf(47);
        if (c > 0) {
            return fullDesc.substring(0, c);
        }
        return fullDesc;
    }

    public static String fieldSrgToDev(String srg) {
        String dev = sSrgFields.get(srg);
        return dev != null ? dev : srg;
    }

    public static Pair<String, String> fieldDev(String owner, String name) {
        return ImagineRemapper.field(owner, name, true);
    }

    public static Pair<String, String> fieldObf(String owner, String name) {
        return ImagineRemapper.field(owner, name, false);
    }

    public static Pair<String, String> field(String owner, String name, boolean dev) {
        owner = ImagineRemapper.clazz(owner, dev);
        name = ImagineRemapper.fieldSrgToDev(name);
        BiMap fields = ImagineRemapper.obtainDevMap(MappingType.Field);
        if (!dev) {
            fields = fields.inverse();
        }
        String field = (String)fields.get((Object)((dev ? ImagineRemapper.clazzObf(owner) : owner) + name));
        return field != null ? Pair.create(ImagineRemapper.cutFieldClass(field), ImagineRemapper.cutField(field)) : Pair.create(owner, name);
    }

    public static void mergeDeobfuscationData(InputStream is, MappingType type) throws Exception {
        String line;
        Map<String, String> srgData = null;
        switch (type) {
            case Method: {
                srgData = sSrgMethods;
                sDevMethodsDirty = true;
                break;
            }
            case Field: {
                srgData = sSrgFields;
                sDevFieldsDirty = true;
            }
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        if (type == MappingType.Srg) {
            ImagineRemapper.mergeSrgData(reader);
            return;
        }
        boolean firstLine = true;
        while ((line = reader.readLine()) != null) {
            int c2;
            if (firstLine) {
                firstLine = false;
                continue;
            }
            int c1 = line.indexOf(44);
            if (c1 < 0 || (c2 = line.indexOf(44, c1 + 1)) < 0) continue;
            String srgName = line.substring(0, c1);
            String devName = line.substring(c1 + 1, c2);
            srgData.put(srgName, devName);
        }
        reader.close();
        is.close();
    }

    private static void mergeSrgData(BufferedReader reader) throws Exception {
        String line;
        sDevMethodsDirty = true;
        sDevFieldsDirty = true;
        while ((line = reader.readLine()) != null) {
            String[] parts = line.split("\\d+");
            switch (parts[0]) {
                case "CL:": {
                    sRawClass.put((Object)parts[1], (Object)parts[2]);
                    break;
                }
                case "MD:": {
                    sRawMethod.put((Object)(parts[1] + parts[2]), (Object)(parts[3] + parts[4]));
                    break;
                }
                case "FD:": {
                    sRawField.put((Object)(parts[1] + parts[2]), (Object)(parts[3] + parts[4]));
                }
            }
        }
    }

    public static void setupDeobfuscationData(String srg, String methodData, String fieldData) {
        try {
            ImagineRemapper.mergeDeobfuscationData((InputStream)new LzmaInputStream(ImagineRemapper.class.getResourceAsStream(srg)), MappingType.Srg);
            ImagineRemapper.mergeDeobfuscationData((InputStream)new LzmaInputStream(ImagineRemapper.class.getResourceAsStream(methodData)), MappingType.Method);
            ImagineRemapper.mergeDeobfuscationData((InputStream)new LzmaInputStream(ImagineRemapper.class.getResourceAsStream(fieldData)), MappingType.Field);
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't load deobfuscation data", e);
        }
    }

    private static BiMap<String, String> obtainDevMap(MappingType type) {
        switch (type) {
            case Method: {
                if (sDevMethodsDirty) {
                    sDevMethods.clear();
                    for (Map.Entry clazz : sRawMethod.entrySet()) {
                        String srgMethodClass = ImagineRemapper.cutMethodClass((String)clazz.getValue());
                        String srgMethod = ImagineRemapper.cutMethod((String)clazz.getValue());
                        String srgMethodDesc = ImagineRemapper.cutMethodDesc((String)clazz.getValue());
                        sDevMethods.put(clazz.getKey(), (Object)(srgMethodClass + ImagineRemapper.methodSrgToDev(srgMethod) + srgMethodDesc));
                    }
                    sDevMethodsDirty = false;
                }
                return sDevMethods;
            }
            case Field: {
                if (sDevFieldsDirty) {
                    sDevFields.clear();
                    for (Map.Entry clazz : sRawField.entrySet()) {
                        String srgClass = ImagineRemapper.cutFieldClass((String)clazz.getValue());
                        String srgField = ImagineRemapper.cutField((String)clazz.getValue());
                        sDevFields.put(clazz.getKey(), (Object)(srgClass + ImagineRemapper.fieldSrgToDev(srgField)));
                    }
                    sDevFieldsDirty = false;
                }
                return sDevFields;
            }
        }
        throw new IllegalStateException("Wrong mapping");
    }

    public static enum MappingType {
        Srg,
        Method,
        Field;

    }
}

