/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.imagine.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import pw.prok.imagine.collections.Indirect;
import pw.prok.imagine.util.Array;

public abstract class AbstractIndirectList<T>
implements List<T>,
Indirect {
    private T[] mObjects;
    private int mActualEnd;
    private int mInitialSize;
    private int mLastAvailable;

    public AbstractIndirectList() {
        this(100);
    }

    public AbstractIndirectList(int initialSize) {
        this.mInitialSize = initialSize;
        this.clear();
    }

    @Override
    public int size() {
        return this.mActualEnd;
    }

    @Override
    public boolean isEmpty() {
        return this.mActualEnd == 0;
    }

    @Override
    public boolean contains(Object o) {
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return this.listIterator();
    }

    @Override
    public Object[] toArray() {
        return this.mObjects;
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        if (a.length < this.mActualEnd) {
            a = Array.newArray(a.getClass().getComponentType(), this.mActualEnd);
        }
        System.arraycopy(this.mObjects, 0, a, 0, this.mActualEnd);
        return a;
    }

    @Override
    public boolean add(T t) {
        if (t == null) {
            return false;
        }
        for (int i = this.mLastAvailable; i < this.mActualEnd; ++i) {
            if (this.mObjects[i] != null) continue;
            this.mLastAvailable = i;
            this.set(this.mLastAvailable, t);
            this.checkEnd(i + 1);
            return true;
        }
        int index = this.mActualEnd;
        if (index < this.mObjects.length) {
            this.mLastAvailable = index;
            this.set(this.mLastAvailable, t);
            this.checkEnd(index + 1);
            return true;
        }
        for (int i = 0; i < this.mLastAvailable && i < this.mActualEnd; ++i) {
            if (this.mObjects[i] != null) continue;
            this.set(i, t);
            this.checkEnd(i + 1);
            return true;
        }
        this.grow(t);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        int index = this.indexOf(o);
        return index >= 0 && this.remove(index) == o;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        if (c == null || c.size() == 0) {
            return false;
        }
        this.grow(this.mObjects.length + c.size());
        boolean changed = false;
        for (T o : c) {
            changed |= this.add(o);
        }
        return changed;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c == null || c.size() == 0) {
            return false;
        }
        boolean changed = false;
        for (Object o : c) {
            changed |= this.remove(o);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.mObjects = new Object[this.mInitialSize];
        this.mActualEnd = 0;
        this.mLastAvailable = 0;
    }

    @Override
    public T get(int index) {
        return null;
    }

    @Override
    public T set(int index, T element) {
        T old = this.mObjects[index];
        this.mObjects[index] = element;
        return old;
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int index) {
        return this.set(index, (T)null);
    }

    @Override
    public int indexOf(Object o) {
        for (int i = 0; i < this.mActualEnd; ++i) {
            if (this.mObjects[i] != o) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        for (int i = this.mActualEnd - 1; i >= 0; --i) {
            if (this.mObjects[i] != o) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<T> listIterator(final int index) {
        return new ListIterator<T>(){
            int mIndex;
            {
                this.mIndex = index;
            }

            @Override
            public boolean hasNext() {
                return this.mIndex + 1 < AbstractIndirectList.this.mActualEnd;
            }

            @Override
            public T next() {
                return AbstractIndirectList.this.mObjects[++this.mIndex];
            }

            @Override
            public boolean hasPrevious() {
                return this.mIndex - 1 >= 0;
            }

            @Override
            public T previous() {
                return AbstractIndirectList.this.mObjects[--this.mIndex];
            }

            @Override
            public int nextIndex() {
                return this.mIndex + 1;
            }

            @Override
            public int previousIndex() {
                return this.mIndex - 1;
            }

            @Override
            public void remove() {
                AbstractIndirectList.this.remove(this.mIndex);
            }

            @Override
            public void set(T t) {
                AbstractIndirectList.this.set(this.mIndex, t);
            }

            @Override
            public void add(T t) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        ArrayList<T> subList = new ArrayList<T>(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            T t = this.mObjects[i];
            if (t == null) continue;
            subList.add(t);
        }
        return subList;
    }

    @Override
    public void compat(boolean trim) {
        int last = -1;
        int count = 0;
        for (int i = 0; i < this.mActualEnd; ++i) {
            T item = this.mObjects[i];
            if (item == null) {
                if (last != -1) continue;
                last = i;
                continue;
            }
            ++count;
            if (last == -1) continue;
            this.mObjects[last++] = this.mObjects[i];
            this.mObjects[i] = null;
        }
        this.mActualEnd = count;
        if (trim) {
            this.trim();
        }
    }

    @Override
    public void trim() {
        if (this.mActualEnd <= 0) {
            return;
        }
        Object[] newObjects = new Object[this.mActualEnd];
        System.arraycopy(this.mObjects, 0, newObjects, 0, this.mActualEnd);
        this.mObjects = newObjects;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append('[');
        for (int i = 0; i < this.mObjects.length; ++i) {
            if (i != 0) {
                builder.append(',');
            }
            builder.append(this.mObjects[i]);
        }
        builder.append(']');
        return builder.toString();
    }

    private void grow(T element) {
        int currentLength = this.mObjects.length;
        int newSize = Math.max(currentLength * 3 / 2, 10);
        Object[] newData = new Object[newSize];
        System.arraycopy(this.mObjects, 0, newData, 0, currentLength);
        newData[currentLength] = element;
        this.mObjects = newData;
        this.checkEnd(currentLength + 1);
    }

    private void grow(int newSize) {
        int currentLength = this.mObjects.length;
        Object[] newData = new Object[newSize];
        System.arraycopy(this.mObjects, 0, newData, 0, currentLength);
        this.mObjects = newData;
        this.mLastAvailable = currentLength;
    }

    private void checkEnd(int i) {
        if (i > this.mActualEnd) {
            this.mActualEnd = i;
        }
    }
}

