/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.imagine.fan;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.util.HashMap;
import java.util.Map;
import pw.prok.imagine.api.Pair;
import pw.prok.imagine.fan.Fan;
import pw.prok.imagine.fan.FanModContainer;

public class FanRegistry {
    private static final Map<Fan, Pair<FanModContainer, Object>> sFansMap = new HashMap<Fan, Pair<FanModContainer, Object>>();
    private static final Map<String, Fan> sIdMap = new HashMap<String, Fan>();

    public static void registerFan(Fan fan, FanModContainer container, Object object) {
        String id = fan.id();
        sFansMap.put(fan, Pair.create(container, object));
        sIdMap.put(id, fan);
    }

    public static Fan getFanInfo(String id) {
        return sIdMap.get(id);
    }

    public static <T> T getFan(String id) {
        return (T)sFansMap.get(FanRegistry.getFanInfo(id));
    }

    public static boolean isFanLoaded(String id) {
        return sIdMap.containsKey(id);
    }

    public static void finishLoading() {
        for (Map.Entry<Fan, Pair<FanModContainer, Object>> entry : sFansMap.entrySet()) {
            Fan fan = entry.getKey();
            ModContainer container = entry.getValue().first();
            String submod = fan.submod();
            if (submod == null || "".equals(submod)) continue;
            Fan parentFan = FanRegistry.getFanInfo(submod);
            ModContainer parent = null;
            if (parentFan != null) {
                parent = sFansMap.get(parentFan).first();
            } else {
                for (ModContainer c : Loader.instance().getActiveModList()) {
                    if (!submod.equals(c.getModId())) continue;
                    parent = c;
                    break;
                }
            }
            if (parent == null) {
                throw new IllegalStateException("Cannot find submod " + submod);
            }
            parent.getMetadata().childMods.add(container);
            container.getMetadata().parentMod = parent;
            container.getMetadata().parent = parent.getModId();
        }
    }
}

