/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.imagine.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import pw.prok.imagine.inject.AbstractInjector;
import pw.prok.imagine.inject.IConstructorBuilder;
import pw.prok.imagine.inject.Injector;
import pw.prok.imagine.util.Array;

public abstract class AnnotationFieldInjector<A extends Annotation, T>
extends AbstractInjector<AnnotationFieldState<A, T>> {
    private final Class<A> mAnnotationClass;
    private final Class<T> mObjectClass;

    public AnnotationFieldInjector(Class<A> annotationClass, Class<T> objectClass) {
        this.mAnnotationClass = annotationClass;
        this.mObjectClass = objectClass;
    }

    @Override
    public AnnotationFieldState<A, T> parseClass(Class<?> clazz) {
        LinkedList<A> annotations = new LinkedList<A>();
        LinkedList<Field> fields = new LinkedList<Field>();
        LinkedList classes = new LinkedList();
        for (Field field : clazz.getDeclaredFields()) {
            A annotation;
            if (Modifier.isStatic(field.getModifiers()) || (annotation = field.getAnnotation(this.mAnnotationClass)) == null) continue;
            Class<?> type = field.getType();
            if (this.mObjectClass != null && !this.mObjectClass.isAssignableFrom(type)) continue;
            field.setAccessible(true);
            annotations.add(annotation);
            fields.add(field);
            classes.add(type);
        }
        if (annotations.size() == 0) {
            return null;
        }
        return new AnnotationFieldState(annotations, fields, classes);
    }

    @Override
    public boolean inject(AnnotationFieldState<A, T> state, Object o, Object ... args) {
        for (int i = 0; i < state.length; ++i) {
            try {
                state.mFields[i].set(o, this.inject(((Annotation[])state.mAnnotations)[i], state.mTypes[i], o, args));
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to inject annotation " + ((Annotation[])state.mAnnotations)[i], e);
            }
        }
        return true;
    }

    @Override
    public <Z> IConstructorBuilder<Z, ?> create(Class<Z> clazz) {
        return super.create(clazz).atLeast(this.mObjectClass);
    }

    public abstract <V extends T> V inject(A var1, Class<V> var2, Object var3, Object ... var4) throws Exception;

    public static class AnnotationFieldState<A, T>
    extends Injector.InjectorState {
        final A[] mAnnotations;
        final Class<? extends T>[] mTypes;
        final Field[] mFields;
        final int length;

        public AnnotationFieldState(List<A> annotations, List<Field> fields, List<Class<? extends T>> types) {
            this.mAnnotations = Array.asArray(annotations);
            this.mFields = Array.asArray(fields);
            this.mTypes = Array.asArray(types);
            if (this.mAnnotations.length != this.mFields.length || this.mAnnotations.length != this.mTypes.length) {
                throw new RuntimeException("Annotation/field/types desync!");
            }
            this.length = this.mAnnotations.length;
        }
    }
}

