/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.imagine.inject;

import java.lang.reflect.Constructor;
import java.util.Stack;
import pw.prok.imagine.inject.IConstructorBuilder;

public class Creator<D>
implements IConstructorBuilder<D, ConstructorBuilder<D>> {
    private static final IFilter INT_FILTER = new DynamicClassFilter(Integer.TYPE);
    private final Class<D> mClass;

    public static <D> Creator<D> creator(Class<D> clazz) {
        return new Creator<D>(clazz);
    }

    public static <D> Creator<D> creator(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return Creator.creator(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public Creator(Class<D> clazz) {
        assert (clazz != null);
        this.mClass = clazz;
    }

    public ConstructorBuilder<D> builder() {
        return new ConstructorBuilder<D>(this.mClass);
    }

    @Override
    public ConstructorBuilder<D> atLeast(Class<?> clazz) {
        return this.builder().atLeast((Class)clazz);
    }

    @Override
    public <T, V extends T> ConstructorBuilder<D> arg(Class<T> clazz, V value) {
        return this.builder().arg((Class)clazz, (Object)value);
    }

    @Override
    public <T, V extends T> ConstructorBuilder<D> arg(int pos, Class<T> clazz, V value) {
        return this.builder().arg(pos, (Class)clazz, (Object)value);
    }

    @Override
    public <V> ConstructorBuilder<D> arg(V value) {
        return this.builder().arg((Object)value);
    }

    @Override
    public <V> ConstructorBuilder<D> arg(int pos, V value) {
        return this.builder().arg(pos, (Object)value);
    }

    @Override
    public ConstructorBuilder<D> arg(int value) {
        return this.builder().arg(value);
    }

    @Override
    public ConstructorBuilder<D> arg(int pos, int value) {
        return this.builder().arg(pos, value);
    }

    @Override
    public D build() {
        return this.builder().build();
    }

    @Override
    public <V> ConstructorBuilder<D> args(V ... args) {
        return this.builder().args((Object[])args);
    }

    private static class DynamicClassFilter
    implements IFilter {
        private final Class<?> mClass;

        public DynamicClassFilter(Class<?> clazz) {
            this.mClass = clazz;
        }

        @Override
        public boolean match(Class<?> argType) {
            return argType.isAssignableFrom(this.mClass);
        }
    }

    private static class FixedClassFilter<T>
    implements IFilter {
        private final Class<T> mClass;

        public FixedClassFilter(Class<T> clazz) {
            this.mClass = clazz;
        }

        @Override
        public boolean match(Class<?> argType) {
            return argType == this.mClass;
        }
    }

    private static interface IFilter {
        public boolean match(Class<?> var1);
    }

    public static class ConstructorBuilder<D>
    implements IConstructorBuilder<D, ConstructorBuilder<D>> {
        private final Class<D> mClass;
        private final Stack<IFilter> mFilters;
        private final Stack<Object> mArgStack;
        private Constructor<D> mConstructor;
        private boolean mConstructorFound = false;
        private Object[] mConstructorArgs;
        private Class<?> mAtLeast;

        public ConstructorBuilder(Class<D> clazz) {
            this.mClass = clazz;
            this.mFilters = new Stack();
            this.mArgStack = new Stack();
        }

        public boolean valid() {
            return this.constructor() != null;
        }

        public Constructor<D> constructor() {
            if (!this.mConstructorFound) {
                int argSize;
                Class<Object> clazz = this.mClass;
                if (this.mAtLeast != null && clazz.isAssignableFrom(this.mAtLeast)) {
                    clazz = this.mAtLeast;
                }
                if ((argSize = this.mArgStack.size()) == 0) {
                    try {
                        this.mConstructor = clazz.getDeclaredConstructor(new Class[0]);
                        this.mConstructorFound = true;
                        return this.mConstructor;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Default constructor not found", e);
                    }
                }
                for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                    Class<?>[] types = constructor.getParameterTypes();
                    if (types.length != argSize) continue;
                    boolean constructorMatching = true;
                    for (int i = types.length - 1; i >= 0; --i) {
                        IFilter filter = (IFilter)this.mFilters.get(i);
                        if (filter.match(types[i])) continue;
                        constructorMatching = false;
                        break;
                    }
                    if (!constructorMatching) continue;
                    this.mConstructor = constructor;
                }
                this.mConstructorFound = true;
            }
            return this.mConstructor;
        }

        @Override
        public D build() {
            Constructor<D> constructor = this.constructor();
            if (constructor == null) {
                return null;
            }
            if (this.mConstructorArgs == null) {
                this.mConstructorArgs = this.mArgStack.toArray();
            }
            try {
                return constructor.newInstance(this.mConstructorArgs);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to instantiate", e);
            }
        }

        @Override
        public <V> ConstructorBuilder<D> args(V ... args) {
            if (args == null || args.length == 0) {
                return this;
            }
            for (V arg : args) {
                this.arg((Object)arg);
            }
            return this;
        }

        private ConstructorBuilder<D> iArg(int pos, Object value, IFilter filter) {
            this.mArgStack.setElementAt(value, pos);
            this.mFilters.setElementAt(filter, pos);
            this.mConstructor = null;
            this.mConstructorFound = false;
            this.mConstructorArgs = null;
            return this;
        }

        private ConstructorBuilder<D> iArg(Object value, IFilter filter) {
            this.mArgStack.push(value);
            this.mFilters.push(filter);
            this.mConstructor = null;
            this.mConstructorFound = false;
            this.mConstructorArgs = null;
            return this;
        }

        @Override
        public ConstructorBuilder<D> atLeast(Class<?> clazz) {
            this.mAtLeast = clazz;
            return this;
        }

        @Override
        public <T, V extends T> ConstructorBuilder<D> arg(Class<T> clazz, V value) {
            return this.iArg(value, new FixedClassFilter<T>(clazz));
        }

        @Override
        public <T, V extends T> ConstructorBuilder<D> arg(int pos, Class<T> clazz, V value) {
            return this.iArg(pos, value, new FixedClassFilter<T>(clazz));
        }

        @Override
        public <V> ConstructorBuilder<D> arg(V value) {
            return this.iArg(value, new DynamicClassFilter(value.getClass()));
        }

        @Override
        public <V> ConstructorBuilder<D> arg(int pos, V value) {
            return this.iArg(pos, value, new DynamicClassFilter(value.getClass()));
        }

        @Override
        public ConstructorBuilder<D> arg(int value) {
            return this.iArg(value, INT_FILTER);
        }

        @Override
        public ConstructorBuilder<D> arg(int pos, int value) {
            return this.iArg(pos, value, INT_FILTER);
        }
    }
}

