/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.imagine.network;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.util.AttributeKey;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.util.List;
import pw.prok.imagine.network.ImagineNetwork;
import pw.prok.imagine.network.ImaginePacket;
import pw.prok.imagine.network.ImaginePacketRegistry;
import pw.prok.imagine.writer.WritableBuf;

@ChannelHandler.Sharable
public class ImaginePacketCodec
extends MessageToMessageCodec<FMLProxyPacket, ImaginePacket> {
    public static final AttributeKey<ThreadLocal<WeakReference<FMLProxyPacket>>> PACKET_TRACKER = new AttributeKey("imagine:inboundpacket");
    public static final AttributeKey<ImaginePacketRegistry> PACKET_REGISTRY = new AttributeKey("imagine:packet_registry");
    private static final Charset UTF_8 = Charset.forName("utf-8");
    private final ImagineNetwork mNetwork;

    public ImaginePacketCodec(ImagineNetwork network) {
        this.mNetwork = network;
    }

    protected void encode(ChannelHandlerContext ctx, ImaginePacket packet, List<Object> out) throws Exception {
        FMLProxyPacket old;
        WritableBuf buffer = new WritableBuf(Unpooled.buffer());
        ImaginePacketRegistry packetRegistry = (ImaginePacketRegistry)ctx.attr(PACKET_REGISTRY).get();
        Class<?> packetClass = packet.getClass();
        int packetClassId = packetRegistry.id(packetClass);
        if (packetRegistry.missing(packetClass)) {
            packetRegistry.register(packetClassId, packetClass);
            buffer.writeBoolean(true);
            buffer.writeInt(packetClassId);
            byte[] classNameBytes = packetClass.getName().getBytes(UTF_8);
            int classNameLength = classNameBytes.length;
            buffer.writeInt(classNameLength);
            buffer.writeBytes(classNameBytes, 0, classNameLength);
        } else {
            buffer.writeBoolean(false);
            buffer.writeInt(packetClassId);
        }
        packet.writePacket(ctx, buffer);
        FMLProxyPacket proxy = new FMLProxyPacket((ByteBuf)buffer, (String)ctx.channel().attr(NetworkRegistry.FML_CHANNEL).get());
        WeakReference ref = (WeakReference)((ThreadLocal)ctx.attr(PACKET_TRACKER).get()).get();
        FMLProxyPacket fMLProxyPacket = old = ref == null ? null : (FMLProxyPacket)ref.get();
        if (old != null) {
            proxy.setDispatcher(old.getDispatcher());
        }
        out.add(proxy);
    }

    protected void decode(ChannelHandlerContext ctx, FMLProxyPacket msg, List<Object> out) throws Exception {
        Class<ImaginePacket> packetClass;
        ((ThreadLocal)ctx.attr(PACKET_TRACKER).get()).set(new WeakReference<FMLProxyPacket>(msg));
        ImaginePacketRegistry packetRegistry = (ImaginePacketRegistry)ctx.attr(PACKET_REGISTRY).get();
        ByteBuf payload = msg.payload();
        boolean newPacketClass = payload.readBoolean();
        int packetClassId = payload.readInt();
        if (newPacketClass) {
            int classNameLength = payload.readInt();
            if (classNameLength <= 0) {
                throw new IllegalArgumentException("Too short class name: " + classNameLength);
            }
            if (classNameLength > 1024) {
                throw new IllegalArgumentException("Too long class name: " + classNameLength);
            }
            byte[] classNameBytes = new byte[classNameLength];
            payload.readBytes(classNameBytes, 0, classNameLength);
            String className = new String(classNameBytes, 0, classNameLength, UTF_8);
            packetClass = Class.forName(className);
            if (!ImaginePacket.class.isAssignableFrom(packetClass)) {
                throw new IllegalArgumentException("Provided class isn't imagine packet: " + packetClass);
            }
            packetRegistry.register(packetClassId, packetClass);
        } else {
            packetClass = packetRegistry.get(packetClassId);
        }
        if (packetClass == null) {
            throw new NullPointerException("Undefined message in channel " + msg.channel());
        }
        ImaginePacket packet = packetClass.newInstance();
        packet.readPacket(ctx, new WritableBuf(payload.slice()));
        out.add(packet);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        ctx.attr(PACKET_TRACKER).set(new ThreadLocal());
        ctx.attr(PACKET_REGISTRY).set((Object)new ImaginePacketRegistry());
    }
}

