/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util;

import cofh.core.CoFHProps;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketSocial;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.config.Configuration;

public class SocialRegistry {
    public static Configuration friendConf;
    public static List<String> clientPlayerFriends;

    public static void initialize() {
        friendConf = new Configuration(new File(CoFHProps.configDir, "/cofh/core/friends.cfg"));
        friendConf.load();
    }

    public static synchronized boolean addFriend(GameProfile gameProfile, String string) {
        if (gameProfile == null || string == null) {
            return false;
        }
        friendConf.get(gameProfile.getId().toString(), string.toLowerCase(), 1);
        friendConf.save();
        return true;
    }

    public static synchronized boolean removeFriend(GameProfile gameProfile, String string) {
        if (gameProfile == null || string == null) {
            return false;
        }
        String string2 = gameProfile.getId().toString();
        string = string.toLowerCase();
        if (friendConf.hasCategory(string2) && friendConf.getCategory(string2).containsKey(string)) {
            friendConf.getCategory(string2).remove((Object)string);
            friendConf.save();
            return true;
        }
        return false;
    }

    public static boolean playerHasAccess(String string, GameProfile gameProfile) {
        if (gameProfile == null || string == null) {
            return false;
        }
        if (string.equals(gameProfile.getName())) {
            return true;
        }
        String string2 = gameProfile.getId().toString();
        return friendConf.hasCategory(string2) && friendConf.getCategory(string2).containsKey(string.toLowerCase());
    }

    public static synchronized void sendFriendsToPlayer(EntityPlayerMP entityPlayerMP) {
        PacketSocial packetSocial = new PacketSocial();
        packetSocial.addByte(PacketSocial.PacketTypes.FRIEND_LIST.ordinal());
        String string = entityPlayerMP.func_146103_bH().getId().toString();
        packetSocial.addInt(friendConf.getCategory(string).keySet().size());
        for (String string2 : friendConf.getCategory(string).keySet()) {
            packetSocial.addString(string2);
        }
        PacketHandler.sendTo((PacketBase)packetSocial, entityPlayerMP);
    }

    static {
        clientPlayerFriends = new LinkedList<String>();
    }
}

