/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics;

import buildcraft.BuildCraftCore;
import buildcraft.api.boards.RedstoneBoardNBT;
import buildcraft.api.boards.RedstoneBoardRegistry;
import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.IZone;
import buildcraft.api.events.RobotEvent;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.DockingStation;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.IRobotOverlayItem;
import buildcraft.api.robots.RobotManager;
import buildcraft.api.statements.StatementSlot;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.core.DefaultProps;
import buildcraft.core.ItemWrench;
import buildcraft.core.LaserData;
import buildcraft.core.lib.RFBattery;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.ICommandReceiver;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.lib.utils.NetworkUtils;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.robotics.EntityRobotEnergyParticle;
import buildcraft.robotics.ItemRobot;
import buildcraft.robotics.RobotRegistry;
import buildcraft.robotics.ai.AIRobotMain;
import buildcraft.robotics.ai.AIRobotShutdown;
import buildcraft.robotics.ai.AIRobotSleep;
import buildcraft.robotics.statements.ActionRobotWorkInArea;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemSkull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class EntityRobot
extends EntityRobotBase
implements IEntityAdditionalSpawnData,
IInventory,
IFluidHandler,
ICommandReceiver,
IDebuggable {
    public static final ResourceLocation ROBOT_BASE = new ResourceLocation(DefaultProps.TEXTURE_PATH_ROBOTS + "/robot_base.png");
    public static final int MAX_WEARABLES = 8;
    private static Set<Integer> blacklistedItemsForUpdate = Sets.newHashSet();
    public LaserData laser = new LaserData();
    public DockingStation linkedDockingStation;
    public BlockIndex linkedDockingStationIndex;
    public ForgeDirection linkedDockingStationSide;
    public BlockIndex currentDockingStationIndex;
    public ForgeDirection currentDockingStationSide;
    public boolean isDocked = false;
    public RedstoneBoardRobot board;
    public AIRobotMain mainAI;
    public ItemStack itemInUse;
    public float itemAngle1 = 0.0f;
    public float itemAngle2 = 0.0f;
    public boolean itemActive = false;
    public float itemActiveStage = 0.0f;
    public long lastUpdateTime = 0L;
    private DockingStation currentDockingStation;
    private List<ItemStack> wearables = new ArrayList<ItemStack>();
    private boolean needsUpdate = false;
    private ItemStack[] inv = new ItemStack[4];
    private FluidStack tank;
    private int maxFluid = 4000;
    private ResourceLocation texture;
    private WeakHashMap<Entity, Long> unreachableEntities = new WeakHashMap();
    private NBTTagList stackRequestNBT;
    private RFBattery battery = new RFBattery(100000, 100000, 100);
    private boolean firstUpdateDone = false;
    private boolean isActiveClient = false;
    private long robotId = Long.MAX_VALUE;
    private int energySpendPerCycle = 0;
    private int ticksCharging = 0;
    private float energyFX = 0.0f;
    private int steamDx = 0;
    private int steamDy = -1;
    private int steamDz = 0;

    public EntityRobot(World world, RedstoneBoardRobotNBT boardNBT) {
        this(world);
        this.board = boardNBT.create(this);
        this.field_70180_af.func_75692_b(16, (Object)this.board.getNBTHandler().getID());
        if (!world.field_72995_K) {
            this.mainAI = new AIRobotMain(this);
            this.mainAI.start();
        }
    }

    public EntityRobot(World world) {
        super(world);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70158_ak = true;
        this.laser.isVisible = false;
        this.field_70144_Y = 1.0f;
        this.field_70130_N = 0.25f;
        this.field_70131_O = 0.25f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.setNullBoundingBox();
        this.field_70156_m = false;
        this.field_70145_X = true;
        this.field_70178_ae = true;
        this.func_110163_bv();
        this.field_70180_af.func_75682_a(12, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(13, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(14, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(15, (Object)0);
        this.field_70180_af.func_75682_a(16, (Object)"");
        this.field_70180_af.func_75682_a(17, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(18, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(19, (Object)0);
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)0);
    }

    protected void updateDataClient() {
        this.laser.tail.x = this.field_70180_af.func_111145_d(12);
        this.laser.tail.y = this.field_70180_af.func_111145_d(13);
        this.laser.tail.z = this.field_70180_af.func_111145_d(14);
        this.laser.isVisible = this.field_70180_af.func_75683_a(15) == 1;
        RedstoneBoardNBT<?> boardNBT = RedstoneBoardRegistry.instance.getRedstoneBoard(this.field_70180_af.func_75681_e(16));
        if (boardNBT != null) {
            this.texture = ((RedstoneBoardRobotNBT)boardNBT).getRobotTexture();
        }
        this.itemAngle1 = this.field_70180_af.func_111145_d(17);
        this.itemAngle2 = this.field_70180_af.func_111145_d(18);
        this.energySpendPerCycle = this.field_70180_af.func_75679_c(19);
        this.isActiveClient = this.field_70180_af.func_75683_a(20) == 1;
        this.battery.setEnergy(this.field_70180_af.func_75679_c(21));
    }

    protected void updateDataServer() {
        this.field_70180_af.func_75692_b(12, (Object)Float.valueOf((float)this.laser.tail.x));
        this.field_70180_af.func_75692_b(13, (Object)Float.valueOf((float)this.laser.tail.y));
        this.field_70180_af.func_75692_b(14, (Object)Float.valueOf((float)this.laser.tail.z));
        this.field_70180_af.func_75692_b(15, (Object)((byte)(this.laser.isVisible ? 1 : 0)));
        this.field_70180_af.func_75692_b(17, (Object)Float.valueOf(this.itemAngle1));
        this.field_70180_af.func_75692_b(18, (Object)Float.valueOf(this.itemAngle2));
    }

    public boolean isActive() {
        if (this.field_70170_p.field_72995_K) {
            return this.isActiveClient;
        }
        return this.mainAI.getActiveAI() instanceof AIRobotSleep || this.mainAI.getActiveAI() instanceof AIRobotShutdown;
    }

    protected void init() {
        if (this.field_70170_p.field_72995_K) {
            BuildCraftCore.instance.sendToServer(new PacketCommand(this, "requestInitialization", null));
        }
    }

    public void setLaserDestination(float x, float y, float z) {
        if ((double)x != this.laser.tail.x || (double)y != this.laser.tail.y || (double)z != this.laser.tail.z) {
            this.laser.tail.x = x;
            this.laser.tail.y = y;
            this.laser.tail.z = z;
            this.needsUpdate = true;
        }
    }

    public void showLaser() {
        if (!this.laser.isVisible) {
            this.laser.isVisible = true;
            this.needsUpdate = true;
        }
    }

    public void hideLaser() {
        if (this.laser.isVisible) {
            this.laser.isVisible = false;
            this.needsUpdate = true;
        }
    }

    protected void firstUpdate() {
        if (this.stackRequestNBT != null) {
            // empty if block
        }
        if (!this.field_70170_p.field_72995_K) {
            this.getRegistry().registerRobot(this);
        }
    }

    public String func_70005_c_() {
        return StatCollector.func_74838_a((String)"item.robot.name");
    }

    public void func_70030_z() {
        this.field_70170_p.field_72984_F.func_76320_a("bcEntityRobot");
        if (!this.firstUpdateDone) {
            this.firstUpdate();
            this.firstUpdateDone = true;
        }
        if (this.ticksCharging > 0) {
            --this.ticksCharging;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(20, (Object)((byte)(this.isActive() && this.ticksCharging == 0 ? 1 : 0)));
            this.field_70180_af.func_75692_b(21, (Object)this.getEnergy());
            if (this.needsUpdate) {
                this.updateDataServer();
                this.needsUpdate = false;
            }
        }
        if (this.field_70170_p.field_72995_K) {
            this.updateDataClient();
            this.updateRotationYaw(60.0f);
            this.updateEnergyFX();
        }
        if (this.currentDockingStation != null) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.field_70165_t = (float)this.currentDockingStation.x() + 0.5f + (float)this.currentDockingStation.side().offsetX * 0.5f;
            this.field_70163_u = (float)this.currentDockingStation.y() + 0.5f + (float)this.currentDockingStation.side().offsetY * 0.5f;
            this.field_70161_v = (float)this.currentDockingStation.z() + 0.5f + (float)this.currentDockingStation.side().offsetZ * 0.5f;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.linkedDockingStation == null) {
                if (this.linkedDockingStationIndex != null) {
                    this.linkedDockingStation = this.getRegistry().getStation(this.linkedDockingStationIndex.x, this.linkedDockingStationIndex.y, this.linkedDockingStationIndex.z, this.linkedDockingStationSide);
                }
                if (this.linkedDockingStation == null) {
                    this.shutdown("no docking station");
                } else if (this.linkedDockingStation.robotTaking() != this) {
                    if (this.linkedDockingStation.robotIdTaking() == this.robotId) {
                        BCLog.logger.warn("A robot entity was not properly unloaded");
                        this.linkedDockingStation.invalidateRobotTakingEntity();
                    }
                    if (this.linkedDockingStation.robotTaking() != this) {
                        this.shutdown("wrong docking station");
                    }
                }
            }
            if (this.currentDockingStationIndex != null && this.currentDockingStation == null) {
                this.currentDockingStation = this.getRegistry().getStation(this.currentDockingStationIndex.x, this.currentDockingStationIndex.y, this.currentDockingStationIndex.z, this.currentDockingStationSide);
            }
            if (this.field_70163_u < -128.0) {
                this.field_70128_L = true;
                BCLog.logger.info("Destroying robot " + this.toString() + " - Fallen into Void");
                this.getRegistry().killRobot(this);
            }
            if (this.linkedDockingStation == null || this.linkedDockingStation.isInitialized()) {
                this.field_70170_p.field_72984_F.func_76320_a("bcRobotAI");
                this.mainAI.cycle();
                this.field_70170_p.field_72984_F.func_76319_b();
                if (this.energySpendPerCycle != this.mainAI.getActiveAI().getEnergyCost()) {
                    this.energySpendPerCycle = this.mainAI.getActiveAI().getEnergyCost();
                    this.field_70180_af.func_75692_b(19, (Object)this.energySpendPerCycle);
                }
            }
        }
        for (int i = 0; i < this.inv.length; ++i) {
            this.updateItem(this.inv[i], i, false);
        }
        this.updateItem(this.itemInUse, 0, true);
        super.func_70030_z();
        this.field_70170_p.field_72984_F.func_76319_b();
    }

    protected void func_70626_be() {
    }

    public boolean func_70072_I() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private void updateEnergyFX() {
        this.energyFX += (float)this.energySpendPerCycle;
        if (this.energyFX >= (float)(100 << 2 * Minecraft.func_71410_x().field_71474_y.field_74362_aa)) {
            this.energyFX = 0.0f;
            this.spawnEnergyFX();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnEnergyFX() {
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new EntityRobotEnergyParticle(this.field_70170_p, this.field_70165_t + (double)this.steamDx * 0.25, this.field_70163_u + (double)this.steamDy * 0.25, this.field_70161_v + (double)this.steamDz * 0.25, (double)this.steamDx * 0.05, (double)this.steamDy * 0.05, (double)this.steamDz * 0.05, (float)this.energySpendPerCycle * 0.075f < 1.0f ? 1.0f : (float)this.energySpendPerCycle * 0.075f));
    }

    public AxisAlignedBB func_70046_E() {
        return AxisAlignedBB.func_72330_a((double)(this.field_70165_t - 0.25), (double)(this.field_70163_u - 0.25), (double)(this.field_70161_v - 0.25), (double)(this.field_70165_t + 0.25), (double)(this.field_70163_u + 0.25), (double)(this.field_70161_v + 0.25));
    }

    public void setNullBoundingBox() {
        this.field_70130_N = 0.0f;
        this.field_70131_O = 0.0f;
        this.field_70121_D.field_72340_a = this.field_70165_t;
        this.field_70121_D.field_72338_b = this.field_70163_u;
        this.field_70121_D.field_72339_c = this.field_70161_v;
        this.field_70121_D.field_72336_d = this.field_70165_t;
        this.field_70121_D.field_72337_e = this.field_70163_u;
        this.field_70121_D.field_72334_f = this.field_70161_v;
    }

    private void shutdown(String reason) {
        if (!(this.mainAI.getDelegateAI() instanceof AIRobotShutdown)) {
            BCLog.logger.info("Shutting down robot " + this.toString() + " - " + reason);
            this.mainAI.startDelegateAI(new AIRobotShutdown(this));
        }
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeByte(this.wearables.size());
        for (ItemStack s : this.wearables) {
            NetworkUtils.writeStack(data, s);
        }
    }

    public void readSpawnData(ByteBuf data) {
        for (int amount = data.readUnsignedByte(); amount > 0; --amount) {
            this.wearables.add(NetworkUtils.readStack(data));
        }
        this.init();
    }

    public ItemStack func_70694_bm() {
        return this.itemInUse;
    }

    public void func_70062_b(int i, ItemStack itemstack) {
    }

    public ItemStack[] func_70035_c() {
        return new ItemStack[0];
    }

    protected void func_70069_a(float par1) {
    }

    protected void func_70064_a(double par1, boolean par3) {
    }

    public void func_70612_e(float par1, float par2) {
        this.func_70107_b(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
    }

    public boolean func_70617_f_() {
        return false;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.linkedDockingStationIndex != null) {
            NBTTagCompound linkedStationNBT = new NBTTagCompound();
            NBTTagCompound linkedStationIndexNBT = new NBTTagCompound();
            this.linkedDockingStationIndex.writeTo(linkedStationIndexNBT);
            linkedStationNBT.func_74782_a("index", (NBTBase)linkedStationIndexNBT);
            linkedStationNBT.func_74774_a("side", (byte)this.linkedDockingStationSide.ordinal());
            nbt.func_74782_a("linkedStation", (NBTBase)linkedStationNBT);
        }
        if (this.currentDockingStationIndex != null) {
            NBTTagCompound currentStationNBT = new NBTTagCompound();
            NBTTagCompound currentStationIndexNBT = new NBTTagCompound();
            this.currentDockingStationIndex.writeTo(currentStationIndexNBT);
            currentStationNBT.func_74782_a("index", (NBTBase)currentStationIndexNBT);
            currentStationNBT.func_74774_a("side", (byte)this.currentDockingStationSide.ordinal());
            nbt.func_74782_a("currentStation", (NBTBase)currentStationNBT);
        }
        NBTTagCompound nbtLaser = new NBTTagCompound();
        this.laser.writeToNBT(nbtLaser);
        nbt.func_74782_a("laser", (NBTBase)nbtLaser);
        NBTTagCompound batteryNBT = new NBTTagCompound();
        this.battery.writeToNBT(batteryNBT);
        nbt.func_74782_a("battery", (NBTBase)batteryNBT);
        if (this.itemInUse != null) {
            NBTTagCompound itemNBT = new NBTTagCompound();
            this.itemInUse.func_77955_b(itemNBT);
            nbt.func_74782_a("itemInUse", (NBTBase)itemNBT);
            nbt.func_74757_a("itemActive", this.itemActive);
        }
        for (int i = 0; i < this.inv.length; ++i) {
            NBTTagCompound stackNbt = new NBTTagCompound();
            if (this.inv[i] == null) continue;
            nbt.func_74782_a("inv[" + i + "]", (NBTBase)this.inv[i].func_77955_b(stackNbt));
        }
        if (this.wearables.size() > 0) {
            NBTTagList wearableList = new NBTTagList();
            for (ItemStack wearable : this.wearables) {
                NBTTagCompound item = new NBTTagCompound();
                wearable.func_77955_b(item);
                wearableList.func_74742_a((NBTBase)item);
            }
            nbt.func_74782_a("wearables", (NBTBase)wearableList);
        }
        NBTTagCompound ai = new NBTTagCompound();
        this.mainAI.writeToNBT(ai);
        nbt.func_74782_a("mainAI", (NBTBase)ai);
        if (this.mainAI.getDelegateAI() != this.board) {
            NBTTagCompound boardNBT = new NBTTagCompound();
            this.board.writeToNBT(boardNBT);
            nbt.func_74782_a("board", (NBTBase)boardNBT);
        }
        nbt.func_74772_a("robotId", this.robotId);
        if (this.tank != null) {
            NBTTagCompound tankNBT = new NBTTagCompound();
            this.tank.writeToNBT(tankNBT);
            nbt.func_74782_a("tank", (NBTBase)tankNBT);
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("linkedStation")) {
            NBTTagCompound linkedStationNBT = nbt.func_74775_l("linkedStation");
            this.linkedDockingStationIndex = new BlockIndex(linkedStationNBT.func_74775_l("index"));
            this.linkedDockingStationSide = ForgeDirection.values()[linkedStationNBT.func_74771_c("side")];
        }
        if (nbt.func_74764_b("currentStation")) {
            NBTTagCompound currentStationNBT = nbt.func_74775_l("currentStation");
            this.currentDockingStationIndex = new BlockIndex(currentStationNBT.func_74775_l("index"));
            this.currentDockingStationSide = ForgeDirection.values()[currentStationNBT.func_74771_c("side")];
        }
        this.laser.readFromNBT(nbt.func_74775_l("laser"));
        this.battery.readFromNBT(nbt.func_74775_l("battery"));
        this.wearables.clear();
        if (nbt.func_74764_b("wearables")) {
            NBTTagList list = nbt.func_150295_c("wearables", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)list.func_150305_b(i));
                if (stack == null) continue;
                this.wearables.add(stack);
            }
        }
        if (nbt.func_74764_b("itemInUse")) {
            this.itemInUse = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("itemInUse"));
            this.itemActive = nbt.func_74767_n("itemActive");
        }
        for (int i = 0; i < this.inv.length; ++i) {
            this.inv[i] = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("inv[" + i + "]"));
        }
        NBTTagCompound ai = nbt.func_74775_l("mainAI");
        this.mainAI = (AIRobotMain)AIRobot.loadAI(ai, this);
        this.board = nbt.func_74764_b("board") ? (RedstoneBoardRobot)AIRobot.loadAI(nbt.func_74775_l("board"), this) : (RedstoneBoardRobot)this.mainAI.getDelegateAI();
        if (this.board == null) {
            this.board = RedstoneBoardRegistry.instance.getEmptyRobotBoard().create(this);
        }
        this.field_70180_af.func_75692_b(16, (Object)this.board.getNBTHandler().getID());
        this.stackRequestNBT = nbt.func_150295_c("stackRequests", 10);
        if (nbt.func_74764_b("robotId")) {
            this.robotId = nbt.func_74763_f("robotId");
        }
        this.tank = nbt.func_74764_b("tank") ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("tank")) : null;
        this.func_110163_bv();
    }

    @Override
    public void dock(DockingStation station) {
        this.currentDockingStation = station;
        this.setSteamDirection(this.currentDockingStation.side.offsetX, this.currentDockingStation.side.offsetY, this.currentDockingStation.side.offsetZ);
        this.currentDockingStationIndex = this.currentDockingStation.index();
        this.currentDockingStationSide = this.currentDockingStation.side();
    }

    @Override
    public void undock() {
        if (this.currentDockingStation != null) {
            this.currentDockingStation.release(this);
            this.currentDockingStation = null;
            this.setSteamDirection(0, -1, 0);
            this.currentDockingStationIndex = null;
            this.currentDockingStationSide = null;
        }
    }

    @Override
    public DockingStation getDockingStation() {
        return this.currentDockingStation;
    }

    @Override
    public void setMainStation(DockingStation station) {
        if (this.linkedDockingStation != null && this.linkedDockingStation != station) {
            this.linkedDockingStation.unsafeRelease(this);
        }
        this.linkedDockingStation = station;
        if (station != null) {
            this.linkedDockingStationIndex = this.linkedDockingStation.index();
            this.linkedDockingStationSide = this.linkedDockingStation.side();
        } else {
            this.linkedDockingStationIndex = null;
            this.linkedDockingStationSide = ForgeDirection.UNKNOWN;
        }
    }

    public ItemStack func_71124_b(int var1) {
        return null;
    }

    public int func_70302_i_() {
        return this.inv.length;
    }

    public ItemStack func_70301_a(int var1) {
        return this.inv[var1];
    }

    public ItemStack func_70298_a(int var1, int var2) {
        ItemStack result = this.inv[var1].func_77979_a(var2);
        if (this.inv[var1].field_77994_a == 0) {
            this.inv[var1] = null;
        }
        this.updateClientSlot(var1);
        return result;
    }

    public ItemStack func_70304_b(int var1) {
        ItemStack stack = this.inv[var1];
        this.inv[var1] = null;
        return stack;
    }

    public void func_70299_a(int var1, ItemStack var2) {
        this.inv[var1] = var2;
        this.updateClientSlot(var1);
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public void updateClientSlot(final int slot) {
        BuildCraftCore.instance.sendToEntity(new PacketCommand(this, "clientSetInventory", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                data.writeShort(slot);
                NetworkUtils.writeStack(data, EntityRobot.this.inv[slot]);
            }
        }), (Entity)this);
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return this.inv[var1] == null || this.inv[var1].func_77969_a(var2) && this.inv[var1].func_77985_e() && this.inv[var1].field_77994_a + var2.field_77994_a <= this.inv[var1].func_77973_b().getItemStackLimit(this.inv[var1]);
    }

    @Override
    public boolean isMoving() {
        return this.field_70159_w != 0.0 || this.field_70181_x != 0.0 || this.field_70179_y != 0.0;
    }

    @Override
    public void setItemInUse(ItemStack stack) {
        this.itemInUse = stack;
        BuildCraftCore.instance.sendToEntity(new PacketCommand(this, "clientSetItemInUse", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                NetworkUtils.writeStack(data, EntityRobot.this.itemInUse);
            }
        }), (Entity)this);
    }

    private void setSteamDirection(final int x, final int y, final int z) {
        if (!this.field_70170_p.field_72995_K) {
            BuildCraftCore.instance.sendToEntity(new PacketCommand(this, "setSteamDirection", new CommandWriter(){

                @Override
                public void write(ByteBuf data) {
                    data.writeInt(x);
                    data.writeShort(y);
                    data.writeInt(z);
                }
            }), (Entity)this);
        } else {
            Vec3 v = Vec3.func_72443_a((double)x, (double)y, (double)z);
            v = v.func_72432_b();
            this.steamDx = (int)v.field_72450_a;
            this.steamDy = (int)v.field_72448_b;
            this.steamDz = (int)v.field_72449_c;
        }
    }

    @Override
    public void receiveCommand(String command, Side side, Object sender, ByteBuf stream) {
        if (side.isClient()) {
            if ("clientSetItemInUse".equals(command)) {
                this.itemInUse = NetworkUtils.readStack(stream);
            } else if ("clientSetInventory".equals(command)) {
                int slot = stream.readUnsignedShort();
                this.inv[slot] = NetworkUtils.readStack(stream);
            } else if ("initialize".equals(command)) {
                this.itemInUse = NetworkUtils.readStack(stream);
                this.itemActive = stream.readBoolean();
            } else if ("setItemActive".equals(command)) {
                this.itemActive = stream.readBoolean();
                this.itemActiveStage = 0.0f;
                this.lastUpdateTime = new Date().getTime();
                if (!this.itemActive) {
                    this.setSteamDirection(0, -1, 0);
                }
            } else if ("setSteamDirection".equals(command)) {
                this.setSteamDirection(stream.readInt(), stream.readShort(), stream.readInt());
            } else if ("syncWearables".equals(command)) {
                this.wearables.clear();
                for (int amount = stream.readUnsignedByte(); amount > 0; --amount) {
                    this.wearables.add(NetworkUtils.readStack(stream));
                }
            }
        } else if (side.isServer()) {
            EntityPlayer p = (EntityPlayer)sender;
            if ("requestInitialization".equals(command)) {
                BuildCraftCore.instance.sendToPlayer(p, new PacketCommand(this, "initialize", new CommandWriter(){

                    @Override
                    public void write(ByteBuf data) {
                        NetworkUtils.writeStack(data, EntityRobot.this.itemInUse);
                        data.writeBoolean(EntityRobot.this.itemActive);
                    }
                }));
                int i = 0;
                while (i < this.inv.length) {
                    final int j = i++;
                    BuildCraftCore.instance.sendToPlayer(p, new PacketCommand(this, "clientSetInventory", new CommandWriter(){

                        @Override
                        public void write(ByteBuf data) {
                            data.writeShort(j);
                            NetworkUtils.writeStack(data, EntityRobot.this.inv[j]);
                        }
                    }));
                }
                if (this.currentDockingStation != null) {
                    this.setSteamDirection(this.currentDockingStation.side.offsetX, this.currentDockingStation.side.offsetY, this.currentDockingStation.side.offsetZ);
                } else {
                    this.setSteamDirection(0, -1, 0);
                }
            }
        }
    }

    public void func_70606_j(float par1) {
    }

    public boolean func_70097_a(DamageSource source, float f) {
        Entity src = source.func_76364_f();
        if (src != null && !(src instanceof EntityFallingBlock) && !(src instanceof IMob) && this.currentDockingStation == null) {
            if (ForgeHooks.onLivingAttack((EntityLivingBase)this, (DamageSource)source, (float)f)) {
                return false;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.field_70738_aO = 10;
                this.field_70737_aN = 10;
                int mul = 2600;
                for (ItemStack s : this.wearables) {
                    if (s.func_77973_b() instanceof ItemArmor) {
                        mul = mul * 2 / (2 + ((ItemArmor)s.func_77973_b()).field_77879_b);
                        continue;
                    }
                    mul = (int)((double)mul * 0.7);
                }
                int energy = Math.round(f * (float)mul);
                if (this.battery.getEnergyStored() - energy > 0) {
                    this.battery.setEnergy(this.battery.getEnergyStored() - energy);
                    return true;
                }
                this.onRobotHit(true);
            }
            return true;
        }
        return false;
    }

    @Override
    public float getAimYaw() {
        return this.itemAngle1;
    }

    @Override
    public float getAimPitch() {
        return this.itemAngle2;
    }

    @Override
    public void aimItemAt(float yaw, float pitch) {
        this.itemAngle1 = yaw;
        this.itemAngle2 = pitch;
        this.updateDataServer();
    }

    @Override
    public void aimItemAt(int x, int y, int z) {
        int deltaX = x - (int)Math.floor(this.field_70165_t);
        int deltaY = y - (int)Math.floor(this.field_70163_u);
        int deltaZ = z - (int)Math.floor(this.field_70161_v);
        if (deltaX != 0 || deltaZ != 0) {
            this.itemAngle1 = (float)(Math.atan2(deltaZ, deltaX) * 180.0 / Math.PI) + 180.0f;
        }
        double d3 = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaZ * deltaZ));
        this.itemAngle2 = (float)(-(Math.atan2(deltaY, d3) * 180.0 / Math.PI));
        this.setSteamDirection(deltaX, deltaY, deltaZ);
        this.updateDataServer();
    }

    private void updateRotationYaw(float maxStep) {
        float step = MathHelper.func_76142_g((float)(this.itemAngle1 - this.field_70177_z));
        if (step > maxStep) {
            step = maxStep;
        }
        if (step < -maxStep) {
            step = -maxStep;
        }
        this.field_70177_z += step;
    }

    protected float func_110146_f(float targetYaw, float dist) {
        if (this.field_70170_p.field_72995_K) {
            float f2 = MathHelper.func_76142_g((float)(this.field_70177_z - this.field_70761_aq));
            this.field_70761_aq += f2 * 0.5f;
            float f3 = MathHelper.func_76142_g((float)(this.field_70177_z - this.field_70761_aq));
            boolean flag = f3 < -90.0f || f3 >= 90.0f;
            this.field_70761_aq = this.field_70177_z - f3;
            if (f3 * f3 > 2500.0f) {
                this.field_70761_aq += f3 * 0.2f;
            }
            float newDist = dist;
            if (flag) {
                newDist *= -1.0f;
            }
            return newDist;
        }
        return 0.0f;
    }

    @Override
    public void setItemActive(final boolean isActive) {
        if (isActive != this.itemActive) {
            this.itemActive = isActive;
            BuildCraftCore.instance.sendToEntity(new PacketCommand(this, "setItemActive", new CommandWriter(){

                @Override
                public void write(ByteBuf data) {
                    data.writeBoolean(isActive);
                }
            }), (Entity)this);
        }
    }

    @Override
    public RedstoneBoardRobot getBoard() {
        return this.board;
    }

    @Override
    public DockingStation getLinkedStation() {
        return this.linkedDockingStation;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double par1) {
        return true;
    }

    @Override
    public int getEnergy() {
        return this.battery.getEnergyStored();
    }

    @Override
    public RFBattery getBattery() {
        return this.battery;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public AIRobot getOverridingAI() {
        return this.mainAI.getOverridingAI();
    }

    public void overrideAI(AIRobot ai) {
        this.mainAI.setOverridingAI(ai);
    }

    public void attackTargetEntityWithCurrentItem(Entity par1Entity) {
        if (MinecraftForge.EVENT_BUS.post((Event)new AttackEntityEvent((EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v).get(), par1Entity))) {
            return;
        }
        if (par1Entity.func_70075_an() && !par1Entity.func_85031_j((Entity)this)) {
            float attackDamage = 2.0f;
            int knockback = 0;
            if (par1Entity instanceof EntityLivingBase) {
                attackDamage += EnchantmentHelper.func_77512_a((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)par1Entity));
                knockback += EnchantmentHelper.func_77507_b((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)par1Entity));
            }
            if (attackDamage > 0.0f) {
                int fireAspect = EnchantmentHelper.func_90036_a((EntityLivingBase)this);
                if (par1Entity instanceof EntityLivingBase && fireAspect > 0 && !par1Entity.func_70027_ad()) {
                    par1Entity.func_70015_d(fireAspect * 4);
                }
                if (par1Entity.func_70097_a((DamageSource)new EntityDamageSource("robot", (Entity)this), attackDamage)) {
                    this.func_130011_c(par1Entity);
                    if (knockback > 0) {
                        par1Entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f));
                        this.field_70159_w *= 0.6;
                        this.field_70179_y *= 0.6;
                        this.func_70031_b(false);
                    }
                    if (par1Entity instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)par1Entity), (Entity)this);
                    }
                    EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)par1Entity);
                    ItemStack itemstack = this.itemInUse;
                    if (itemstack != null && par1Entity instanceof EntityLivingBase) {
                        itemstack.func_77973_b().func_77644_a(itemstack, (EntityLivingBase)par1Entity, (EntityLivingBase)this);
                    }
                }
            }
        }
    }

    @Override
    public IZone getZoneToWork() {
        return this.getZone(ActionRobotWorkInArea.AreaType.WORK);
    }

    @Override
    public IZone getZoneToLoadUnload() {
        IZone zone = this.getZone(ActionRobotWorkInArea.AreaType.LOAD_UNLOAD);
        if (zone == null) {
            zone = this.getZoneToWork();
        }
        return zone;
    }

    private IZone getZone(ActionRobotWorkInArea.AreaType areaType) {
        if (this.linkedDockingStation != null) {
            for (StatementSlot s : this.linkedDockingStation.getActiveActions()) {
                IZone zone;
                if (!(s.statement instanceof ActionRobotWorkInArea) || ((ActionRobotWorkInArea)s.statement).getAreaType() != areaType || (zone = ActionRobotWorkInArea.getArea(s)) == null) continue;
                return zone;
            }
        }
        return null;
    }

    @Override
    public boolean containsItems() {
        for (ItemStack element : this.inv) {
            if (element == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasFreeSlot() {
        for (ItemStack element : this.inv) {
            if (element != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void unreachableEntityDetected(Entity entity) {
        this.unreachableEntities.put(entity, this.field_70170_p.func_82737_E() + 1200L);
    }

    @Override
    public boolean isKnownUnreachable(Entity entity) {
        if (this.unreachableEntities.containsKey(entity)) {
            if (this.unreachableEntities.get(entity) >= this.field_70170_p.func_82737_E()) {
                return true;
            }
            this.unreachableEntities.remove(entity);
            return false;
        }
        return false;
    }

    protected void onRobotHit(boolean attacked) {
        if (!this.field_70170_p.field_72995_K) {
            if (attacked) {
                this.convertToItems();
            } else if (this.wearables.size() > 0) {
                this.func_70099_a(this.wearables.remove(this.wearables.size() - 1), 0.0f);
                this.syncWearablesToClient();
            } else if (this.itemInUse != null) {
                this.func_70099_a(this.itemInUse, 0.0f);
                this.itemInUse = null;
            } else {
                this.convertToItems();
            }
        }
    }

    protected boolean func_70085_c(EntityPlayer player) {
        ItemStack stack = player.func_71045_bC();
        if (stack == null || stack.func_77973_b() == null) {
            return false;
        }
        RobotEvent.Interact robotInteractEvent = new RobotEvent.Interact(this, player, stack);
        MinecraftForge.EVENT_BUS.post((Event)robotInteractEvent);
        if (robotInteractEvent.isCanceled()) {
            return false;
        }
        if (player.func_70093_af() && stack.func_77973_b() == BuildCraftCore.wrenchItem) {
            RobotEvent.Dismantle robotDismantleEvent = new RobotEvent.Dismantle(this, player);
            MinecraftForge.EVENT_BUS.post((Event)robotDismantleEvent);
            if (robotDismantleEvent.isCanceled()) {
                return false;
            }
            this.onRobotHit(false);
            if (this.field_70170_p.field_72995_K) {
                ((ItemWrench)stack.func_77973_b()).wrenchUsed(player, 0, 0, 0);
            }
            return true;
        }
        if (this.wearables.size() < 8 && stack.func_77973_b().isValidArmor(stack, 0, (Entity)this)) {
            if (!this.field_70170_p.field_72995_K) {
                this.wearables.add(stack.func_77979_a(1));
                this.syncWearablesToClient();
            } else {
                player.func_71038_i();
            }
            return true;
        }
        if (this.wearables.size() < 8 && stack.func_77973_b() instanceof IRobotOverlayItem && ((IRobotOverlayItem)stack.func_77973_b()).isValidRobotOverlay(stack)) {
            if (!this.field_70170_p.field_72995_K) {
                this.wearables.add(stack.func_77979_a(1));
                this.syncWearablesToClient();
            } else {
                player.func_71038_i();
            }
            return true;
        }
        if (this.wearables.size() < 8 && stack.func_77973_b() instanceof ItemSkull) {
            if (!this.field_70170_p.field_72995_K) {
                ItemStack skullStack = stack.func_77979_a(1);
                this.initSkullItem(skullStack);
                this.wearables.add(skullStack);
                this.syncWearablesToClient();
            } else {
                player.func_71038_i();
            }
            return true;
        }
        return super.func_70085_c(player);
    }

    private void initSkullItem(ItemStack skullStack) {
        if (skullStack.func_77942_o()) {
            Property property;
            NBTTagCompound nbttagcompound = skullStack.func_77978_p();
            GameProfile gameProfile = null;
            if (nbttagcompound.func_150297_b("SkullOwner", 10)) {
                gameProfile = NBTUtil.func_152459_a((NBTTagCompound)nbttagcompound.func_74775_l("SkullOwner"));
            } else if (nbttagcompound.func_150297_b("SkullOwner", 8) && !StringUtils.func_151246_b((String)nbttagcompound.func_74779_i("SkullOwner"))) {
                gameProfile = new GameProfile(null, nbttagcompound.func_74779_i("SkullOwner"));
            }
            if (!(gameProfile == null || StringUtils.func_151246_b((String)gameProfile.getName()) || gameProfile.isComplete() && gameProfile.getProperties().containsKey((Object)"textures") || (gameProfile = MinecraftServer.func_71276_C().func_152358_ax().func_152655_a(gameProfile.getName())) == null || (property = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get((Object)"textures"), null)) != null)) {
                gameProfile = MinecraftServer.func_71276_C().func_147130_as().fillProfileProperties(gameProfile, true);
            }
            if (gameProfile != null && gameProfile.isComplete() && gameProfile.getProperties().containsKey((Object)"textures")) {
                NBTTagCompound profileNBT = new NBTTagCompound();
                NBTUtil.func_152460_a((NBTTagCompound)profileNBT, (GameProfile)gameProfile);
                nbttagcompound.func_74782_a("SkullOwner", (NBTBase)profileNBT);
            } else {
                nbttagcompound.func_82580_o("SkullOwner");
            }
        }
    }

    private void syncWearablesToClient() {
        BuildCraftCore.instance.sendToEntity(new PacketCommand(this, "syncWearables", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                data.writeByte(EntityRobot.this.wearables.size());
                for (ItemStack s : EntityRobot.this.wearables) {
                    NetworkUtils.writeStack(data, s);
                }
            }
        }), (Entity)this);
    }

    private List<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(ItemRobot.createRobotStack(this.board.getNBTHandler(), this.battery.getEnergyStored()));
        if (this.itemInUse != null) {
            drops.add(this.itemInUse);
        }
        for (ItemStack element : this.inv) {
            if (element == null) continue;
            drops.add(element);
        }
        drops.addAll(this.wearables);
        return drops;
    }

    private void convertToItems() {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            if (this.mainAI != null) {
                this.mainAI.abort();
            }
            List<ItemStack> drops = this.getDrops();
            for (ItemStack stack : drops) {
                this.func_70099_a(stack, 0.0f);
            }
            this.field_70128_L = true;
        }
        this.getRegistry().killRobot(this);
    }

    public void func_70106_y() {
        if (this.field_70170_p.field_72995_K) {
            super.func_70106_y();
        }
    }

    @Override
    public void onChunkUnload() {
        this.getRegistry().unloadRobot(this);
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity par1Entity) {
    }

    public void func_70108_f(Entity par1Entity) {
    }

    public void setUniqueRobotId(long iRobotId) {
        this.robotId = iRobotId;
    }

    @Override
    public long getRobotId() {
        return this.robotId;
    }

    @Override
    public RobotRegistry getRegistry() {
        return (RobotRegistry)RobotManager.registryProvider.getRegistry(this.field_70170_p);
    }

    @Override
    public void releaseResources() {
        this.getRegistry().releaseResources(this);
    }

    @Override
    public ItemStack receiveItem(TileEntity tile, ItemStack stack) {
        if (this.currentDockingStation != null && this.currentDockingStation.index().nextTo(new BlockIndex(tile)) && this.mainAI != null) {
            return this.mainAI.getActiveAI().receiveItem(stack);
        }
        return stack;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int result;
        if (this.tank != null && !this.tank.isFluidEqual(resource)) {
            return 0;
        }
        if (this.tank == null) {
            this.tank = new FluidStack(resource.getFluid(), 0);
        }
        if (this.tank.amount + resource.amount <= this.maxFluid) {
            result = resource.amount;
            if (doFill) {
                this.tank.amount += resource.amount;
            }
        } else {
            result = this.maxFluid - this.tank.amount;
            if (doFill) {
                this.tank.amount = this.maxFluid;
            }
        }
        if (this.tank != null && this.tank.amount == 0) {
            this.tank = null;
        }
        return result;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.tank != null && this.tank.isFluidEqual(resource)) {
            return this.drain(from, resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack result;
        if (this.tank == null) {
            result = null;
        } else if (this.tank.amount <= maxDrain) {
            result = this.tank.copy();
            if (doDrain) {
                this.tank = null;
            }
        } else {
            result = this.tank.copy();
            result.amount = maxDrain;
            if (doDrain) {
                this.tank.amount -= maxDrain;
            }
        }
        if (this.tank != null && this.tank.amount == 0) {
            this.tank = null;
        }
        return result;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tank == null || this.tank.amount == 0 || this.tank.amount < this.maxFluid && this.tank.getFluid().getID() == fluid.getID();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tank != null && this.tank.amount != 0 && this.tank.getFluid().getID() == fluid.getID();
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo(this.tank, this.maxFluid)};
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_70620_b(ItemStack stack, int renderPass) {
        IIcon iicon = super.func_70620_b(stack, renderPass);
        if (iicon == null) {
            iicon = stack.func_77973_b().getIcon(stack, renderPass, null, this.itemInUse, 0);
        }
        return iicon;
    }

    @Override
    public void getDebugInfo(List<String> info, ForgeDirection side, ItemStack debugger, EntityPlayer player) {
        info.add("Robot " + this.board.getNBTHandler().getID() + " (" + this.getBattery().getEnergyStored() + "/" + this.getBattery().getMaxEnergyStored() + " RF)");
        info.add(String.format("Position: %.2f, %.2f, %.2f", this.field_70165_t, this.field_70163_u, this.field_70161_v));
        info.add("AI tree:");
        for (AIRobot aiRobot = this.mainAI; aiRobot != null; aiRobot = aiRobot.getDelegateAI()) {
            info.add("- " + RobotManager.getAIRobotName(aiRobot.getClass()) + " (" + ((AIRobot)aiRobot).getEnergyCost() + " RF/t)");
            if (!(aiRobot instanceof IDebuggable)) continue;
            ((IDebuggable)((Object)aiRobot)).getDebugInfo(info, side, debugger, player);
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyReceived = this.getBattery().receiveEnergy(maxReceive, simulate);
        if (!simulate && energyReceived > 5 && this.ticksCharging <= 25) {
            this.ticksCharging += 5;
        }
        return energyReceived;
    }

    public List<ItemStack> getWearables() {
        return this.wearables;
    }

    private void updateItem(ItemStack stack, int i, boolean held) {
        int id;
        if (stack != null && stack.func_77973_b() != null && !blacklistedItemsForUpdate.contains(id = Item.func_150891_b((Item)stack.func_77973_b()))) {
            try {
                stack.func_77973_b().func_77663_a(stack, this.field_70170_p, (Entity)this, i, held);
            }
            catch (Exception e) {
                e.printStackTrace();
                blacklistedItemsForUpdate.add(id);
            }
        }
    }
}

