/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.transport.pipes.events.PipeEventItem;
import buildcraft.transport.pipes.events.PipeEventPriority;
import buildcraft.transport.pluggable.LensPluggable;
import java.util.LinkedList;
import net.minecraftforge.common.util.ForgeDirection;

public class LensFilterHandler {
    @PipeEventPriority(priority=-100)
    public void eventHandler(PipeEventItem.FindDest event) {
        IPipeTile container = event.pipe.getTile();
        LinkedList<ForgeDirection> correctColored = new LinkedList<ForgeDirection>();
        LinkedList<ForgeDirection> notColored = new LinkedList<ForgeDirection>();
        boolean encounteredColor = false;
        int myColor = event.item.color == null ? -1 : event.item.color.ordinal();
        for (ForgeDirection dir : event.destinations) {
            IPipeTile otherContainer;
            IPipe otherPipe;
            boolean hasFilter = false;
            boolean hasLens = false;
            int sideColor = -1;
            int sideLensColor = -1;
            PipePluggable pluggable = container.getPipePluggable(dir);
            if (pluggable != null && pluggable instanceof LensPluggable) {
                if (((LensPluggable)pluggable).isFilter) {
                    hasFilter = true;
                    sideColor = ((LensPluggable)pluggable).color;
                } else {
                    hasLens = true;
                    sideLensColor = ((LensPluggable)pluggable).color;
                }
            }
            if ((otherPipe = container.getNeighborPipe(dir)) != null && otherPipe.getTile() != null && (pluggable = (otherContainer = otherPipe.getTile()).getPipePluggable(dir.getOpposite())) != null && pluggable instanceof LensPluggable && ((LensPluggable)pluggable).isFilter) {
                int otherColor = ((LensPluggable)pluggable).color;
                if (hasFilter && otherColor != sideColor) continue;
                if (hasLens) {
                    if (sideLensColor != otherColor) continue;
                    hasFilter = false;
                    sideColor = -1;
                } else {
                    hasFilter = true;
                    sideColor = otherColor;
                }
            }
            if (hasFilter) {
                if (myColor != sideColor) continue;
                encounteredColor = true;
                correctColored.add(dir);
                continue;
            }
            notColored.add(dir);
        }
        event.destinations.clear();
        event.destinations.addAll(encounteredColor ? correctColored : notColored);
    }
}

