/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.blocks.powertile;

import cofh.api.energy.IEnergyHandler;
import ic2.api.energy.tile.IEnergySink;
import java.util.List;
import logisticspipes.api.ILogisticsPowerProvider;
import logisticspipes.asm.ModDependentInterface;
import logisticspipes.asm.ModDependentMethod;
import logisticspipes.blocks.LogisticsSolidTileEntity;
import logisticspipes.config.Configs;
import logisticspipes.gui.hud.HUDPowerLevel;
import logisticspipes.interfaces.IBlockWatchingHandler;
import logisticspipes.interfaces.IGuiOpenControler;
import logisticspipes.interfaces.IGuiTileEntity;
import logisticspipes.interfaces.IHeadUpDisplayBlockRendererProvider;
import logisticspipes.interfaces.IHeadUpDisplayRenderer;
import logisticspipes.interfaces.IPowerLevelDisplay;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractguis.CoordinatesGuiProvider;
import logisticspipes.network.guis.block.PowerJunctionGui;
import logisticspipes.network.packets.block.PowerJunctionLevel;
import logisticspipes.network.packets.hud.HUDStartBlockWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopBlockWatchingPacket;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.computers.interfaces.CCCommand;
import logisticspipes.proxy.computers.interfaces.CCType;
import logisticspipes.renderer.LogisticsHUDRenderer;
import logisticspipes.utils.PlayerCollectionList;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@ModDependentInterface(modId={"IC2", "CoFHAPI|energy", "BuildCraft|Transport"}, interfacePath={"ic2.api.energy.tile.IEnergySink", "cofh.api.energy.IEnergyHandler", "buildcraft.api.power.IPowerReceptor"})
@CCType(name="LogisticsPowerJunction")
public class LogisticsPowerJunctionTileEntity
extends LogisticsSolidTileEntity
implements IGuiTileEntity,
ILogisticsPowerProvider,
IPowerLevelDisplay,
IGuiOpenControler,
IHeadUpDisplayBlockRendererProvider,
IBlockWatchingHandler,
IEnergySink,
IEnergyHandler {
    public Object OPENPERIPHERAL_IGNORE;
    public boolean needMorePowerTriggerCheck = true;
    public static final int IC2Multiplier = 2;
    public static final int RFDivisor = 2;
    public static final int MAX_STORAGE = 2000000;
    private int internalStorage = 0;
    private int lastUpdateStorage = 0;
    private double internalBuffer = 0.0;
    private int internalRFbuffer = 0;
    private boolean addedToEnergyNet = false;
    private boolean init = false;
    private PlayerCollectionList guiListener = new PlayerCollectionList();
    private PlayerCollectionList watcherList = new PlayerCollectionList();
    private IHeadUpDisplayRenderer HUD = new HUDPowerLevel(this);

    @Override
    public boolean useEnergy(int amount, List<Object> providersToIgnore) {
        if (providersToIgnore != null && providersToIgnore.contains(this)) {
            return false;
        }
        if (this.canUseEnergy(amount, null)) {
            this.internalStorage -= (int)((double)amount * Configs.POWER_USAGE_MULTIPLIER + 0.5);
            if (this.internalStorage < 1000000) {
                this.needMorePowerTriggerCheck = true;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canUseEnergy(int amount, List<Object> providersToIgnore) {
        if (providersToIgnore != null && providersToIgnore.contains(this)) {
            return false;
        }
        return this.internalStorage >= (int)((double)amount * Configs.POWER_USAGE_MULTIPLIER + 0.5);
    }

    @Override
    public boolean useEnergy(int amount) {
        return this.useEnergy(amount, null);
    }

    public int freeSpace() {
        return 2000000 - this.internalStorage;
    }

    public void updateClients() {
        MainProxy.sendToPlayerList(PacketHandler.getPacket(PowerJunctionLevel.class).setInteger(this.internalStorage).setPosX(this.field_145851_c).setPosY(this.field_145848_d).setPosZ(this.field_145849_e), this.guiListener);
        MainProxy.sendToPlayerList(PacketHandler.getPacket(PowerJunctionLevel.class).setInteger(this.internalStorage).setPosX(this.field_145851_c).setPosY(this.field_145848_d).setPosZ(this.field_145849_e), this.watcherList);
        this.lastUpdateStorage = this.internalStorage;
    }

    @Override
    public boolean canUseEnergy(int amount) {
        return this.canUseEnergy(amount, null);
    }

    public void addEnergy(float amount) {
        if (MainProxy.isClient(this.getWorld())) {
            return;
        }
        this.internalStorage = (int)((float)this.internalStorage + amount);
        if (this.internalStorage > 2000000) {
            this.internalStorage = 2000000;
        }
        if (this.internalStorage == 2000000) {
            this.needMorePowerTriggerCheck = false;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound par1nbtTagCompound) {
        super.func_145839_a(par1nbtTagCompound);
        this.internalStorage = par1nbtTagCompound.func_74762_e("powerLevel");
        if (par1nbtTagCompound.func_74764_b("needMorePowerTriggerCheck")) {
            this.needMorePowerTriggerCheck = par1nbtTagCompound.func_74767_n("needMorePowerTriggerCheck");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound par1nbtTagCompound) {
        super.func_145841_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74768_a("powerLevel", this.internalStorage);
        par1nbtTagCompound.func_74757_a("needMorePowerTriggerCheck", this.needMorePowerTriggerCheck);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (MainProxy.isServer(this.getWorld()) && this.internalStorage != this.lastUpdateStorage) {
            this.updateClients();
        }
        if (!this.init) {
            if (MainProxy.isClient(this.getWorld())) {
                LogisticsHUDRenderer.instance().add(this);
            }
            if (!this.addedToEnergyNet) {
                SimpleServiceLocator.IC2Proxy.registerToEneryNet(this);
                this.addedToEnergyNet = true;
            }
            this.init = true;
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (MainProxy.isClient(this.getWorld())) {
            LogisticsHUDRenderer.instance().remove(this);
        }
        if (this.addedToEnergyNet) {
            SimpleServiceLocator.IC2Proxy.unregisterToEneryNet(this);
            this.addedToEnergyNet = false;
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (MainProxy.isClient(this.getWorld())) {
            this.init = false;
        }
        if (!this.addedToEnergyNet) {
            this.init = false;
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (MainProxy.isClient(this.getWorld())) {
            LogisticsHUDRenderer.instance().remove(this);
        }
        if (this.addedToEnergyNet) {
            SimpleServiceLocator.IC2Proxy.unregisterToEneryNet(this);
            this.addedToEnergyNet = false;
        }
    }

    @Override
    @CCCommand(description="Returns the currently stored power")
    public int getPowerLevel() {
        return this.internalStorage;
    }

    @Override
    public int getDisplayPowerLevel() {
        return this.getPowerLevel();
    }

    @Override
    public String getBrand() {
        return "LP";
    }

    @Override
    @CCCommand(description="Returns the max. storable power")
    public int getMaxStorage() {
        return 2000000;
    }

    @Override
    public int getChargeState() {
        return this.internalStorage * 100 / 2000000;
    }

    @Override
    public void guiOpenedByPlayer(EntityPlayer player) {
        this.guiListener.add(player);
        this.updateClients();
    }

    @Override
    public void guiClosedByPlayer(EntityPlayer player) {
        this.guiListener.remove(player);
    }

    public void handlePowerPacket(int integer) {
        if (MainProxy.isClient(this.getWorld())) {
            this.internalStorage = integer;
        }
    }

    @Override
    public IHeadUpDisplayRenderer getRenderer() {
        return this.HUD;
    }

    @Override
    public int getX() {
        return this.field_145851_c;
    }

    @Override
    public int getY() {
        return this.field_145848_d;
    }

    @Override
    public int getZ() {
        return this.field_145849_e;
    }

    @Override
    public World getWorld() {
        return this.func_145831_w();
    }

    @Override
    public void startWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartBlockWatchingPacket.class).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    @Override
    public void stopWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopBlockWatchingPacket.class).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    @Override
    public void playerStartWatching(EntityPlayer player) {
        this.watcherList.add(player);
        this.updateClients();
    }

    @Override
    public void playerStopWatching(EntityPlayer player) {
        this.watcherList.remove(player);
    }

    @Override
    public boolean isHUDExistent() {
        return this.getWorld().func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this;
    }

    public void func_145828_a(CrashReportCategory par1CrashReportCategory) {
        super.func_145828_a(par1CrashReportCategory);
        par1CrashReportCategory.func_71507_a("LP-Version", (Object)"0.9.3.70:false");
    }

    @ModDependentMethod(modId="IC2")
    public boolean acceptsEnergyFrom(TileEntity tile, ForgeDirection dir) {
        return true;
    }

    private void transferFromIC2Buffer() {
        if (this.freeSpace() > 0 && this.internalBuffer >= 1.0) {
            int addAmount = Math.min((int)Math.floor(this.internalBuffer), this.freeSpace());
            this.addEnergy(addAmount);
            this.internalBuffer -= (double)addAmount;
        }
    }

    @ModDependentMethod(modId="IC2")
    public double getDemandedEnergy() {
        if (!this.addedToEnergyNet) {
            return 0.0;
        }
        this.transferFromIC2Buffer();
        return (this.freeSpace() + 2 - 1) / 2;
    }

    @ModDependentMethod(modId="IC2")
    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        this.internalBuffer += amount * 2.0;
        this.transferFromIC2Buffer();
        return 0.0;
    }

    @ModDependentMethod(modId="IC2")
    public int getSinkTier() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isHUDInvalid() {
        return this.func_145837_r();
    }

    @ModDependentMethod(modId="CoFHAPI|energy")
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.freeSpace() < 1) {
            return 0;
        }
        int RFspace = this.freeSpace() * 2 - this.internalRFbuffer;
        int RFtotake = Math.min(maxReceive, RFspace);
        if (!simulate) {
            this.addEnergy(RFtotake / 2);
            this.internalRFbuffer += RFtotake % 2;
            if (this.internalRFbuffer >= 2) {
                this.addEnergy(1.0f);
                this.internalRFbuffer -= 2;
            }
        }
        return RFtotake;
    }

    @ModDependentMethod(modId="CoFHAPI|energy")
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @ModDependentMethod(modId="CoFHAPI|energy")
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @ModDependentMethod(modId="CoFHAPI|energy")
    public int getEnergyStored(ForgeDirection from) {
        return this.internalStorage * 2 + this.internalRFbuffer;
    }

    @ModDependentMethod(modId="CoFHAPI|energy")
    public int getMaxEnergyStored(ForgeDirection from) {
        return 4000000;
    }

    @Override
    public CoordinatesGuiProvider getGuiProvider() {
        return NewGuiHandler.getGui(PowerJunctionGui.class);
    }
}

