/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.blocks.powertile;

import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import logisticspipes.blocks.LogisticsSolidTileEntity;
import logisticspipes.gui.hud.HUDPowerLevel;
import logisticspipes.interfaces.IBlockWatchingHandler;
import logisticspipes.interfaces.IGuiOpenControler;
import logisticspipes.interfaces.IGuiTileEntity;
import logisticspipes.interfaces.IHeadUpDisplayBlockRendererProvider;
import logisticspipes.interfaces.IHeadUpDisplayRenderer;
import logisticspipes.interfaces.IPowerLevelDisplay;
import logisticspipes.interfaces.ISubSystemPowerProvider;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractguis.CoordinatesGuiProvider;
import logisticspipes.network.guis.block.PowerProviderGui;
import logisticspipes.network.packets.block.PowerProviderLevel;
import logisticspipes.network.packets.hud.HUDStartBlockWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopBlockWatchingPacket;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.computers.interfaces.CCCommand;
import logisticspipes.proxy.computers.interfaces.CCType;
import logisticspipes.renderer.LogisticsHUDRenderer;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.routing.ServerRouter;
import logisticspipes.utils.AdjacentTile;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.WorldUtil;
import logisticspipes.utils.tuples.Triplet;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@CCType(name="LogisticsPowerProvider")
public abstract class LogisticsPowerProviderTileEntity
extends LogisticsSolidTileEntity
implements IGuiTileEntity,
ISubSystemPowerProvider,
IPowerLevelDisplay,
IGuiOpenControler,
IHeadUpDisplayBlockRendererProvider,
IBlockWatchingHandler {
    public static final int BC_COLOR = 65535;
    public static final int RF_COLOR = 0xFF0000;
    public static final int IC2_COLOR = 0xFFFF00;
    public boolean needMorePowerTriggerCheck = true;
    protected Map<Integer, Float> orders = new HashMap<Integer, Float>();
    protected BitSet reOrdered = new BitSet(ServerRouter.getBiggestSimpleID());
    protected boolean pauseRequesting = false;
    protected float internalStorage = 0.0f;
    private float lastUpdateStorage = 0.0f;
    protected int maxMode = 1;
    private PlayerCollectionList guiListener = new PlayerCollectionList();
    private PlayerCollectionList watcherList = new PlayerCollectionList();
    private IHeadUpDisplayRenderer HUD = new HUDPowerLevel(this);
    private boolean init = false;

    protected LogisticsPowerProviderTileEntity() {
    }

    @Override
    public void func_145845_h() {
        float fullfullratio;
        super.func_145845_h();
        this.pauseRequesting = false;
        if (!this.init) {
            if (MainProxy.isClient(this.getWorld())) {
                LogisticsHUDRenderer.instance().add(this);
            }
            this.init = true;
        }
        float globalRequest = 0.0f;
        for (Map.Entry<Integer, Float> order : this.orders.entrySet()) {
            globalRequest += order.getValue().floatValue();
        }
        if (globalRequest > 0.0f && (fullfullratio = Math.min(1.0f, Math.min(this.internalStorage, this.getMaxProvidePerTick()) / globalRequest)) > 0.0f) {
            block1: for (Map.Entry<Integer, Float> order : this.orders.entrySet()) {
                IRouter destinationRouter;
                float toSend = order.getValue().floatValue() * fullfullratio;
                if (toSend > this.internalStorage) {
                    toSend = this.internalStorage;
                }
                if ((destinationRouter = SimpleServiceLocator.routerManager.getRouter(order.getKey())) == null || destinationRouter.getPipe() == null) continue;
                WorldUtil util = new WorldUtil(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
                for (AdjacentTile adjacent : util.getAdjacentTileEntities(false)) {
                    IRouter sourceRouter;
                    if (!(adjacent.tile instanceof LogisticsTileGenericPipe) || !(((LogisticsTileGenericPipe)adjacent.tile).pipe instanceof CoreRoutedPipe) || ((CoreRoutedPipe)((LogisticsTileGenericPipe)adjacent.tile).pipe).stillNeedReplace() || (sourceRouter = ((CoreRoutedPipe)((LogisticsTileGenericPipe)adjacent.tile).pipe).getRouter()) == null) continue;
                    block3: for (ExitRoute exit : sourceRouter.getDistanceTo(destinationRouter)) {
                        if (!exit.containsFlag(PipeRoutingConnectionType.canPowerSubSystemFrom)) continue;
                        for (IFilter filter : exit.filters) {
                            if (!filter.blockPower()) continue;
                            continue block3;
                        }
                        CoreRoutedPipe pipe = sourceRouter.getPipe();
                        if (pipe != null && pipe.isInitialized()) {
                            pipe.container.addLaser(adjacent.orientation.getOpposite(), 1.0f, this.getLaserColor(), true, true);
                        }
                        this.sendPowerLaserPackets(sourceRouter, destinationRouter, exit.exitOrientation, exit.exitOrientation != adjacent.orientation);
                        this.internalStorage -= toSend;
                        this.handlePower(destinationRouter.getPipe(), toSend);
                        continue block1;
                    }
                }
            }
        }
        this.orders.clear();
        if (MainProxy.isServer(this.field_145850_b) && this.internalStorage != this.lastUpdateStorage) {
            this.updateClients();
            this.lastUpdateStorage = this.internalStorage;
        }
    }

    protected abstract void handlePower(CoreRoutedPipe var1, float var2);

    private void sendPowerLaserPackets(IRouter sourceRouter, IRouter destinationRouter, ForgeDirection exitOrientation, boolean addBall) {
        if (sourceRouter == destinationRouter) {
            return;
        }
        LinkedList<Triplet<IRouter, ForgeDirection, Boolean>> todo = new LinkedList<Triplet<IRouter, ForgeDirection, Boolean>>();
        todo.add(new Triplet<IRouter, ForgeDirection, Boolean>(sourceRouter, exitOrientation, addBall));
        while (!todo.isEmpty()) {
            Triplet part = (Triplet)todo.pollFirst();
            List<ExitRoute> exits = ((IRouter)part.getValue1()).getRoutersOnSide((ForgeDirection)part.getValue2());
            for (ExitRoute exit : exits) {
                IRouter nextRouter;
                if (!exit.containsFlag(PipeRoutingConnectionType.canPowerSubSystemFrom)) continue;
                int distance = ((IRouter)part.getValue1()).getDistanceToNextPowerPipe(exit.exitOrientation);
                CoreRoutedPipe pipe = ((IRouter)part.getValue1()).getPipe();
                if (pipe != null && pipe.isInitialized()) {
                    pipe.container.addLaser(exit.exitOrientation, distance, this.getLaserColor(), false, (Boolean)part.getValue3());
                }
                if ((nextRouter = exit.destination) == destinationRouter) {
                    return;
                }
                block2: for (ExitRoute newExit : nextRouter.getDistanceTo(destinationRouter)) {
                    if (!newExit.containsFlag(PipeRoutingConnectionType.canPowerSubSystemFrom)) continue;
                    for (IFilter filter : newExit.filters) {
                        if (!filter.blockPower()) continue;
                        continue block2;
                    }
                    todo.addLast(new Triplet<IRouter, ForgeDirection, Boolean>(nextRouter, newExit.exitOrientation, newExit.exitOrientation != exit.exitOrientation));
                }
            }
        }
    }

    protected abstract float getMaxProvidePerTick();

    @CCCommand(description="Returns the color for the power provided by this power provider")
    protected abstract int getLaserColor();

    @Override
    @CCCommand(description="Returns the max. amount of storable power")
    public abstract int getMaxStorage();

    @Override
    @CCCommand(description="Returns the power type stored in this power provider")
    public abstract String getBrand();

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (MainProxy.isClient(this.getWorld())) {
            LogisticsHUDRenderer.instance().remove(this);
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (MainProxy.isClient(this.getWorld())) {
            this.init = false;
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (MainProxy.isClient(this.getWorld())) {
            LogisticsHUDRenderer.instance().remove(this);
        }
    }

    @Override
    public void requestPower(int destination, float amount) {
        if (this.pauseRequesting) {
            return;
        }
        if (this.getBrand().equals("EU")) {
            System.out.print("");
        }
        if (this.orders.containsKey(destination)) {
            if (this.reOrdered.get(destination)) {
                this.pauseRequesting = true;
                this.reOrdered.clear();
            } else {
                this.reOrdered.set(destination);
            }
        } else {
            this.reOrdered.clear();
        }
        this.orders.put(destination, Float.valueOf(amount));
    }

    @Override
    @CCCommand(description="Returns the current power level for this power provider")
    public float getPowerLevel() {
        return this.lastUpdateStorage;
    }

    @Override
    public boolean usePaused() {
        return this.pauseRequesting;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.internalStorage = nbt.func_74760_g("internalStorage");
        this.maxMode = nbt.func_74762_e("maxMode");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74776_a("internalStorage", this.internalStorage);
        nbt.func_74768_a("maxMode", this.maxMode);
    }

    @Override
    public IHeadUpDisplayRenderer getRenderer() {
        return this.HUD;
    }

    @Override
    public int getX() {
        return this.field_145851_c;
    }

    @Override
    public int getY() {
        return this.field_145848_d;
    }

    @Override
    public int getZ() {
        return this.field_145849_e;
    }

    @Override
    public World getWorld() {
        return this.func_145831_w();
    }

    @Override
    public void startWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartBlockWatchingPacket.class).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    @Override
    public void stopWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopBlockWatchingPacket.class).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    @Override
    public void playerStartWatching(EntityPlayer player) {
        this.watcherList.add(player);
        this.updateClients();
    }

    @Override
    public void playerStopWatching(EntityPlayer player) {
        this.watcherList.remove(player);
    }

    @Override
    public boolean isHUDExistent() {
        return this.getWorld().func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this;
    }

    @Override
    public void guiOpenedByPlayer(EntityPlayer player) {
        this.guiListener.add(player);
        this.updateClients();
    }

    @Override
    public void guiClosedByPlayer(EntityPlayer player) {
        this.guiListener.remove(player);
    }

    public void updateClients() {
        MainProxy.sendToPlayerList(PacketHandler.getPacket(PowerProviderLevel.class).setFloat(this.internalStorage).setTilePos(this), this.guiListener);
        MainProxy.sendToPlayerList(PacketHandler.getPacket(PowerProviderLevel.class).setFloat(this.internalStorage).setTilePos(this), this.watcherList);
    }

    public void func_145828_a(CrashReportCategory par1CrashReportCategory) {
        super.func_145828_a(par1CrashReportCategory);
        par1CrashReportCategory.func_71507_a("LP-Version", (Object)"0.9.3.70:false");
    }

    public void handlePowerPacket(float float1) {
        if (MainProxy.isClient(this.getWorld())) {
            this.internalStorage = float1;
        }
    }

    @Override
    public int getChargeState() {
        return (int)Math.min(100.0f, this.internalStorage * 100.0f / (float)this.getMaxStorage());
    }

    @Override
    public int getDisplayPowerLevel() {
        return Math.round(this.internalStorage);
    }

    @Override
    public boolean isHUDInvalid() {
        return this.func_145837_r();
    }

    @Override
    public CoordinatesGuiProvider getGuiProvider() {
        return NewGuiHandler.getGui(PowerProviderGui.class);
    }
}

