/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.ISlotCheck;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.pipe.InvSysConContentRequest;
import logisticspipes.network.packets.pipe.InvSysConResistance;
import logisticspipes.pipes.PipeItemsInvSysConnector;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.Color;
import logisticspipes.utils.gui.DummyContainer;
import logisticspipes.utils.gui.GuiGraphics;
import logisticspipes.utils.gui.LogisticsBaseGuiScreen;
import logisticspipes.utils.gui.SmallGuiButton;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.item.ItemStackRenderer;
import logisticspipes.utils.string.StringUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiInvSysConnector
extends LogisticsBaseGuiScreen {
    private static final String PREFIX = "gui.invsyscon.";
    private int page = 0;
    private final List<ItemIdentifierStack> _allItems = new ArrayList<ItemIdentifierStack>();
    private final PipeItemsInvSysConnector pipe;
    private int localresistance;

    public GuiInvSysConnector(EntityPlayer player, PipeItemsInvSysConnector pipe) {
        super(180, 200, 0, 0);
        DummyContainer dummy = new DummyContainer((IInventory)player.field_71071_by, pipe.inv);
        dummy.addRestrictedSlot(0, (IInventory)pipe.inv, 98, 17, new ISlotCheck(){

            @Override
            public boolean isStackAllowed(ItemStack itemStack) {
                if (itemStack == null) {
                    return false;
                }
                if (itemStack.func_77973_b() != LogisticsPipes.LogisticsItemCard) {
                    return false;
                }
                return itemStack.func_77960_j() == 0;
            }
        });
        dummy.addNormalSlotsForPlayerInventory(10, 115);
        this.field_147002_h = dummy;
        this.pipe = pipe;
        this.localresistance = pipe.resistance;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146292_n.add(new SmallGuiButton(0, this.field_147003_i + 120, this.field_147009_r + 47, 10, 10, "<"));
        this.field_146292_n.add(new SmallGuiButton(1, this.field_147003_i + 160, this.field_147009_r + 47, 10, 10, ">"));
        this.field_146292_n.add(new SmallGuiButton(2, this.field_147003_i + 68, this.field_147009_r + 47, 46, 10, StringUtils.translate("gui.invsyscon.Refresh")));
        this.field_146292_n.add(new SmallGuiButton(3, this.field_147003_i + 80, this.field_147009_r + 35, 10, 10, "<"));
        this.field_146292_n.add(new SmallGuiButton(4, this.field_147003_i + 120, this.field_147009_r + 35, 10, 10, ">"));
        this.field_146292_n.add(new SmallGuiButton(5, this.field_147003_i + 140, this.field_147009_r + 35, 30, 10, StringUtils.translate("gui.invsyscon.Save")));
        this.refreshPacket();
    }

    @Override
    protected void func_146976_a(float var1, int var2, int var3) {
        GuiGraphics.drawGuiBackGround(this.field_146297_k, this.field_147003_i, this.field_147009_r, this.right, this.bottom, this.field_73735_i, true);
        GuiGraphics.drawPlayerInventoryBackground(this.field_146297_k, this.field_147003_i + 10, this.field_147009_r + 115);
        this.field_146297_k.field_71466_p.func_78276_b(StringUtils.translate("gui.invsyscon.InventorySystemConnector"), this.field_147003_i + 5, this.field_147009_r + 6, 0x404040);
        this.drawRect(this.field_147003_i + 9, this.field_147009_r + 58, this.field_147003_i + 170, this.field_147009_r + 112, Color.GREY);
        this.field_146297_k.field_71466_p.func_78276_b(StringUtils.translate("gui.invsyscon.ConnectionCard") + ":", this.field_147003_i + 10, this.field_147009_r + 21, 0x404040);
        GuiGraphics.drawSlotBackground(this.field_146297_k, this.field_147003_i + 97, this.field_147009_r + 16);
        this.field_146297_k.field_71466_p.func_78276_b(StringUtils.translate("gui.invsyscon.Waitingfor") + ":", this.field_147003_i + 10, this.field_147009_r + 48, 0x404040);
        this.field_146297_k.field_71466_p.func_78276_b(this.page + 1 + "/" + this.maxPage(), this.field_147003_i + 136, this.field_147009_r + 49, 0x404040);
        this.field_146297_k.field_71466_p.func_78276_b(StringUtils.translate("gui.invsyscon.Resistance") + ":", this.field_147003_i + 10, this.field_147009_r + 35, 0x404040);
        this.field_146297_k.field_71466_p.func_78276_b(Integer.toString(this.localresistance), this.field_147003_i + 105 - this.field_146297_k.field_71466_p.func_78256_a(Integer.toString(this.localresistance)) / 2, this.field_147009_r + 37, 0x404040);
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        ItemStackRenderer.renderItemIdentifierStackListIntoGui(this._allItems, null, this.page, 9, 59, 9, 27, 18, 18, 100.0f, ItemStackRenderer.DisplayAmount.ALWAYS);
        int ppi = 0;
        int column = 0;
        int row = 0;
        for (ItemIdentifierStack itemStack : this._allItems) {
            if (++ppi <= 27 * this.page || ppi > 27 * (this.page + 1)) continue;
            ItemStack st = itemStack.unsafeMakeNormalStack();
            int x = 9 + 18 * column + this.field_147003_i;
            int y = 59 + 18 * row + this.field_147009_r;
            GL11.glDisable((int)2896);
            int mouseX = Mouse.getX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int mouseY = this.field_146295_m - Mouse.getY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            if (x < mouseX && mouseX < x + 18 && y < mouseY && mouseY < y + 18) {
                GuiGraphics.displayItemToolTip(new Object[]{mouseX, mouseY, st, true}, this.field_73735_i, this.field_147003_i, this.field_147009_r, false, false);
            }
            if (++column < 9) continue;
            ++row;
            column = 0;
        }
    }

    private void refreshPacket() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(InvSysConContentRequest.class).setPosX(this.pipe.getX()).setPosY(this.pipe.getY()).setPosZ(this.pipe.getZ()));
    }

    private void pageDown() {
        this.page = this.page <= 0 ? this.maxPage() - 1 : --this.page;
    }

    private void pageUp() {
        this.page = this.page >= this.maxPage() - 1 ? 0 : ++this.page;
    }

    private int maxPage() {
        int i = (int)(Math.floor((float)this._allItems.size() / 27.0f) + (double)((float)this._allItems.size() % 27.0f != 0.0f ? 1 : 0));
        if (i <= 0) {
            i = 1;
        }
        return i;
    }

    protected void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (button.field_146127_k == 0) {
            this.pageDown();
        } else if (button.field_146127_k == 1) {
            this.pageUp();
        } else if (button.field_146127_k == 2) {
            this.refreshPacket();
        } else if (button.field_146127_k == 3) {
            for (int i = 0; i < (Keyboard.isKeyDown((int)29) ? 10 : 1); ++i) {
                if (this.localresistance <= 0) continue;
                --this.localresistance;
            }
        } else if (button.field_146127_k == 4) {
            for (int i = 0; i < (Keyboard.isKeyDown((int)29) ? 10 : 1); ++i) {
                ++this.localresistance;
            }
        } else if (button.field_146127_k == 5) {
            this.pipe.resistance = this.localresistance;
            MainProxy.sendPacketToServer(PacketHandler.getPacket(InvSysConResistance.class).setInteger(this.pipe.resistance).setPosX(this.pipe.getX()).setPosY(this.pipe.getY()).setPosZ(this.pipe.getZ()));
        }
    }

    public void handleContentAnswer(Collection<ItemIdentifierStack> allItems) {
        this._allItems.clear();
        this._allItems.addAll(allItems);
    }

    public void handleResistanceAnswer(int resistance) {
        this.localresistance = resistance;
    }
}

