/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui;

import logisticspipes.LogisticsPipes;
import logisticspipes.config.PlayerConfig;
import logisticspipes.interfaces.IGuiOpenControler;
import logisticspipes.utils.gui.DummyContainer;
import logisticspipes.utils.gui.GuiCheckBox;
import logisticspipes.utils.gui.LogisticsBaseTabGuiScreen;
import logisticspipes.utils.gui.SearchBar;
import logisticspipes.utils.string.StringUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class GuiLogisticsSettings
extends LogisticsBaseTabGuiScreen {
    private final String PREFIX = "gui.settings.";

    public GuiLogisticsSettings(EntityPlayer player) {
        super(180, 220);
        DummyContainer dummy = new DummyContainer(player, null, new IGuiOpenControler[0]);
        dummy.addNormalSlotsForPlayerInventory(10, 135);
        this.addTab(new PipeRenderSettings());
        this.field_147002_h = dummy;
    }

    private class PipeRenderSettings
    extends LogisticsBaseTabGuiScreen.TabSubGui {
        private SearchBar renderDistance;
        private SearchBar contentRenderDistance;
        private GuiCheckBox useNewRendererButton;
        private GuiCheckBox useFallbackRendererButton;

        private PipeRenderSettings() {
        }

        @Override
        public void initTab() {
            PlayerConfig config = LogisticsPipes.getClientPlayerConfig();
            if (this.renderDistance == null) {
                this.renderDistance = new SearchBar(GuiLogisticsSettings.this.field_146289_q, GuiLogisticsSettings.this.getBaseScreen(), 15, 75, 30, 15, false, true, true);
                this.renderDistance.searchinput1 = config.getRenderPipeDistance() + "";
            }
            this.renderDistance.reposition(15, 80, 30, 15);
            if (this.contentRenderDistance == null) {
                this.contentRenderDistance = new SearchBar(GuiLogisticsSettings.this.field_146289_q, GuiLogisticsSettings.this.getBaseScreen(), 15, 105, 30, 15, false, true, true);
                this.contentRenderDistance.searchinput1 = config.getRenderPipeContentDistance() + "";
            }
            this.contentRenderDistance.reposition(15, 110, 30, 15);
            this.useNewRendererButton = (GuiCheckBox)this.addButton(new GuiCheckBox(0, GuiLogisticsSettings.this.field_147003_i + 15, GuiLogisticsSettings.this.field_147009_r + 30, 16, 16, config.isUseNewRenderer()));
            this.useFallbackRendererButton = (GuiCheckBox)this.addButton(new GuiCheckBox(0, GuiLogisticsSettings.this.field_147003_i + 15, GuiLogisticsSettings.this.field_147009_r + 50, 16, 16, config.isUseFallbackRenderer()));
        }

        @Override
        public void renderIcon(int x, int y) {
            GL11.glEnable((int)32826);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            RenderHelper.func_74520_c();
            ItemStack stack = new ItemStack(LogisticsPipes.LogisticsBasicPipe, 1);
            field_146296_j.func_82406_b(GuiLogisticsSettings.this.field_146289_q, GuiLogisticsSettings.this.getMC().field_71446_o, stack, x, y);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            field_146296_j.field_77023_b = 0.0f;
        }

        @Override
        public void renderBackgroundContent() {
        }

        @Override
        public void buttonClicked(GuiButton button) {
            if (button == this.useNewRendererButton) {
                this.useNewRendererButton.change();
            }
            if (button == this.useFallbackRendererButton) {
                this.useFallbackRendererButton.change();
            }
        }

        @Override
        public void renderForgroundContent() {
            this.renderDistance.renderSearchBar();
            this.contentRenderDistance.renderSearchBar();
            GuiLogisticsSettings.this.field_146289_q.func_78276_b(StringUtils.translate("gui.settings.pipenewrenderer"), 38, 34, 0x404040);
            GuiLogisticsSettings.this.field_146289_q.func_78276_b(StringUtils.translate("gui.settings.pipefallbackrenderer"), 38, 54, 0x404040);
            GuiLogisticsSettings.this.field_146289_q.func_78276_b(StringUtils.translate("gui.settings.piperenderdistance"), 10, 70, 0x404040);
            GuiLogisticsSettings.this.field_146289_q.func_78276_b(StringUtils.translate("gui.settings.pipecontentrenderdistance"), 10, 100, 0x404040);
        }

        @Override
        public boolean handleClick(int x, int y, int type) {
            boolean val1 = this.renderDistance.handleClick(x - GuiLogisticsSettings.this.field_147003_i, y - GuiLogisticsSettings.this.field_147009_r, type);
            boolean val2 = this.contentRenderDistance.handleClick(x - GuiLogisticsSettings.this.field_147003_i, y - GuiLogisticsSettings.this.field_147009_r, type);
            return val1 || val2;
        }

        @Override
        public boolean handleKey(int code, char c) {
            return this.renderDistance.handleKey(c, code) || this.contentRenderDistance.handleKey(c, code);
        }

        @Override
        public void guiClose() {
            PlayerConfig config = LogisticsPipes.getClientPlayerConfig();
            try {
                config.setRenderPipeDistance(Integer.valueOf(this.renderDistance.getContent()));
                config.setRenderPipeContentDistance(Integer.valueOf(this.contentRenderDistance.getContent()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            config.setUseNewRenderer(this.useNewRendererButton.getState());
            config.setUseFallbackRenderer(this.useFallbackRendererButton.getState());
            config.sendUpdate();
        }
    }
}

