/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.network.IWriteListObject;
import logisticspipes.request.resources.IResource;
import logisticspipes.request.resources.ResourceNetwork;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LinkedLogisticsOrderList;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.LPPosition;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class LPDataOutputStream
extends DataOutputStream {
    private final ByteArrayOutputStream byteStream;

    public LPDataOutputStream() {
        super(new ByteArrayOutputStream());
        this.byteStream = (ByteArrayOutputStream)this.out;
    }

    public LPDataOutputStream(ByteBuf outBytes) throws IOException {
        super((OutputStream)new ByteBufOutputStream(outBytes));
        this.byteStream = null;
    }

    public void writeForgeDirection(ForgeDirection dir) throws IOException {
        if (dir == null) {
            this.out.write(10);
        } else {
            this.out.write(dir.ordinal());
        }
    }

    public void writeExitRoute(ExitRoute route) throws IOException {
        this.writeIRouter(route.destination);
        this.writeIRouter(route.root);
        this.writeForgeDirection(route.exitOrientation);
        this.writeForgeDirection(route.insertOrientation);
        this.writeEnumSet(route.connectionDetails, PipeRoutingConnectionType.class);
        this.writeDouble(route.distanceToDestination);
        this.writeDouble(route.destinationDistanceToRoot);
        this.writeInt(route.blockDistance);
        this.writeList(route.filters, new IWriteListObject<IFilter>(){

            @Override
            public void writeObject(LPDataOutputStream data, IFilter filter) throws IOException {
                data.writeLPPosition(filter.getLPPosition());
            }
        });
        this.writeUTF(route.toString());
        this.writeBoolean(route.debug.isNewlyAddedCanidate);
        this.writeBoolean(route.debug.isTraced);
        this.writeInt(route.debug.index);
    }

    public void writeIRouter(IRouter router) throws IOException {
        if (router == null) {
            this.out.write(0);
        } else {
            this.out.write(1);
            this.writeLPPosition(router.getLPPosition());
        }
    }

    public void writeLPPosition(LPPosition pos) throws IOException {
        this.writeDouble(pos.getXD());
        this.writeDouble(pos.getYD());
        this.writeDouble(pos.getZD());
    }

    public <T extends Enum<T>> void writeEnumSet(EnumSet<T> types, Class<T> clazz) throws IOException {
        Enum[] parts = (Enum[])clazz.getEnumConstants();
        byte[] set = new byte[parts.length / 8 + (parts.length % 8 == 0 ? 0 : 1)];
        this.out.write(set.length);
        for (Enum part : parts) {
            if (!types.contains(part)) continue;
            byte i = (byte)(1 << part.ordinal() % 8);
            int n = part.ordinal() / 8;
            set[n] = (byte)(set[n] | i);
        }
        this.out.write(set);
    }

    public void writeBitSet(BitSet bits) throws IOException {
        byte[] bytes = new byte[(bits.length() + 7) / 8];
        for (int i = 0; i < bits.length(); ++i) {
            if (!bits.get(i)) continue;
            int n = bytes.length - i / 8 - 1;
            bytes[n] = (byte)(bytes[n] | 1 << i % 8);
        }
        this.writeByte(bytes.length);
        this.write(bytes);
    }

    public void writeNBTTagCompound(NBTTagCompound tag) throws IOException {
        if (tag == null) {
            this.writeShort(-1);
        } else {
            byte[] var3 = CompressedStreamTools.func_74798_a((NBTTagCompound)tag);
            this.writeShort((short)var3.length);
            this.write(var3);
        }
    }

    public void writeBooleanArray(boolean[] array) throws IOException {
        this.writeInt(array.length);
        BitSet set = new BitSet();
        for (int i = 0; i < array.length; ++i) {
            set.set(i, array[i]);
        }
        this.writeBitSet(set);
    }

    public void writeIntegerArray(int[] array) throws IOException {
        this.writeInt(array.length);
        for (int element : array) {
            this.writeInt(element);
        }
    }

    public byte[] toByteArray() {
        return this.byteStream.toByteArray();
    }

    public void writeItemIdentifier(ItemIdentifier item) throws IOException {
        if (item == null) {
            this.writeBoolean(false);
            return;
        }
        this.writeBoolean(true);
        this.writeInt(Item.func_150891_b((Item)item.item));
        this.writeInt(item.itemDamage);
        this.writeNBTTagCompound(item.tag);
    }

    public void writeItemIdentifierStack(ItemIdentifierStack stack) throws IOException {
        this.writeItemIdentifier(stack.getItem());
        this.writeInt(stack.getStackSize());
    }

    public <T> void writeList(List<T> list, IWriteListObject<T> handler) throws IOException {
        this.writeInt(list.size());
        for (int i = 0; i < list.size(); ++i) {
            handler.writeObject(this, list.get(i));
        }
    }

    public <T> void writeCollection(Collection<T> collection, IWriteListObject<T> handler) throws IOException {
        this.writeList(new ArrayList<T>(collection), handler);
    }

    public void writeOrderInfo(IOrderInfoProvider order) throws IOException {
        this.writeItemIdentifierStack(order.getAsDisplayItem());
        this.writeInt(order.getRouterId());
        this.writeBoolean(order.isFinished());
        this.writeBoolean(order.isInProgress());
        this.writeEnum(order.getType());
        this.writeList(order.getProgresses(), new IWriteListObject<Float>(){

            @Override
            public void writeObject(LPDataOutputStream data, Float object) throws IOException {
                data.writeFloat(object.floatValue());
            }
        });
        this.writeByte(order.getMachineProgress());
        this.writeLPPosition(order.getTargetPosition());
        this.writeItemIdentifier(order.getTargetType());
    }

    public <T extends Enum<T>> void writeEnum(T object) throws IOException {
        this.writeInt(object.ordinal());
    }

    public void writeLinkedLogisticsOrderList(LinkedLogisticsOrderList orders) throws IOException {
        this.writeList(orders, new IWriteListObject<IOrderInfoProvider>(){

            @Override
            public void writeObject(LPDataOutputStream data, IOrderInfoProvider order) throws IOException {
                data.writeOrderInfo(order);
            }
        });
        this.writeList(orders.getSubOrders(), new IWriteListObject<LinkedLogisticsOrderList>(){

            @Override
            public void writeObject(LPDataOutputStream data, LinkedLogisticsOrderList order) throws IOException {
                data.writeLinkedLogisticsOrderList(order);
            }
        });
    }

    public void writeByteArray(byte[] array) throws IOException {
        this.writeInt(array.length);
        for (byte element : array) {
            this.writeByte(element);
        }
    }

    public void writeByteBuf(ByteBuf buf) throws IOException {
        byte[] bytes;
        buf = buf.copy();
        buf.setIndex(0, 0);
        int length = buf.readableBytes();
        if (buf.hasArray()) {
            bytes = buf.array();
        } else {
            bytes = new byte[length];
            buf.getBytes(buf.readerIndex(), bytes);
        }
        this.writeByteArray(bytes);
    }

    public void writeLongArray(long[] array) throws IOException {
        this.writeInt(array.length);
        for (long element : array) {
            this.writeLong(element);
        }
    }

    public void writeIResource(IResource stack) throws IOException {
        ResourceNetwork.writeResource(this, stack);
    }
}

