/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import logisticspipes.LogisticsPipes;
import logisticspipes.gui.hud.HUDInvSysConnector;
import logisticspipes.interfaces.IHeadUpDisplayRenderer;
import logisticspipes.interfaces.IHeadUpDisplayRendererProvider;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.IOrderManagerContentReceiver;
import logisticspipes.interfaces.routing.IDirectRoutingConnection;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.hud.HUDStartWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopWatchingPacket;
import logisticspipes.network.packets.orderer.OrdererManagerContent;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.ItemRoutingInformation;
import logisticspipes.textures.Textures;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.transport.TransportInvConnection;
import logisticspipes.utils.AdjacentTile;
import logisticspipes.utils.InventoryHelper;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.SidedInventoryMinecraftAdapter;
import logisticspipes.utils.WorldUtil;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.transactor.ITransactor;
import logisticspipes.utils.tuples.LPPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeItemsInvSysConnector
extends CoreRoutedPipe
implements IDirectRoutingConnection,
IHeadUpDisplayRendererProvider,
IOrderManagerContentReceiver {
    private boolean init = false;
    private HashMap<ItemIdentifier, List<ItemRoutingInformation>> itemsOnRoute = new HashMap();
    public ItemIdentifierInventory inv = new ItemIdentifierInventory(1, "Freq. card", 1);
    public int resistance;
    public Set<ItemIdentifierStack> oldList = new TreeSet<ItemIdentifierStack>();
    public final LinkedList<ItemIdentifierStack> displayList = new LinkedList();
    public final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    private HUDInvSysConnector HUD = new HUDInvSysConnector(this);
    private UUID idbuffer = UUID.randomUUID();

    public PipeItemsInvSysConnector(Item item) {
        super(new TransportInvConnection(), item);
    }

    @Override
    public void enabledUpdateEntity() {
        CoreRoutedPipe CRP;
        super.enabledUpdateEntity();
        if (!this.init && this.hasConnectionUUID()) {
            if (!SimpleServiceLocator.connectionManager.addDirectConnection(this.getConnectionUUID(), this.getRouter())) {
                this.dropFreqCard();
            }
            if ((CRP = SimpleServiceLocator.connectionManager.getConnectedPipe(this.getRouter())) != null) {
                CRP.refreshRender(true);
            }
            this.getRouter().update(true, this);
            this.refreshRender(true);
            this.init = true;
            this.idbuffer = this.getConnectionUUID();
        }
        if (this.init && !this.hasConnectionUUID()) {
            this.init = false;
            CRP = SimpleServiceLocator.connectionManager.getConnectedPipe(this.getRouter());
            SimpleServiceLocator.connectionManager.removeDirectConnection(this.getRouter());
            if (CRP != null) {
                CRP.refreshRender(true);
            }
        }
        if (this.init && this.idbuffer != null && !this.idbuffer.equals(this.getConnectionUUID())) {
            this.init = false;
            CRP = SimpleServiceLocator.connectionManager.getConnectedPipe(this.getRouter());
            SimpleServiceLocator.connectionManager.removeDirectConnection(this.getRouter());
            if (CRP != null) {
                CRP.refreshRender(true);
            }
        }
        if (this.itemsOnRoute.size() > 0) {
            this.checkConnectedInvs();
        }
    }

    private void checkConnectedInvs() {
        if (!this.itemsOnRoute.isEmpty()) {
            WorldUtil wUtil = new WorldUtil(this.getWorld(), this.getX(), this.getY(), this.getZ());
            for (AdjacentTile tile : wUtil.getAdjacentTileEntities(true)) {
                IInventoryUtil access;
                if (!(tile.tile instanceof IInventory)) continue;
                IInventory inv = InventoryHelper.getInventory((IInventory)tile.tile);
                if (inv instanceof ISidedInventory) {
                    inv = new SidedInventoryMinecraftAdapter((ISidedInventory)inv, tile.orientation.getOpposite(), false);
                }
                if (!this.checkOneConnectedInv(access = SimpleServiceLocator.inventoryUtilFactory.getInventoryUtil(inv, tile.orientation.getOpposite()), tile.orientation)) continue;
                this.updateContentListener();
                break;
            }
        }
    }

    private boolean checkOneConnectedInv(IInventoryUtil inv, ForgeDirection dir) {
        boolean contentchanged = false;
        if (!this.itemsOnRoute.isEmpty()) {
            ArrayList<ItemIdentifier> items = new ArrayList<ItemIdentifier>(this.itemsOnRoute.keySet());
            items.retainAll(inv.getItems());
            Map<ItemIdentifier, Integer> amounts = null;
            if (!items.isEmpty()) {
                amounts = inv.getItemsAndCount();
            }
            block0: for (ItemIdentifier ident : items) {
                if (!amounts.containsKey(ident)) continue;
                int itemAmount = amounts.get(ident);
                List<ItemRoutingInformation> needs = this.itemsOnRoute.get(ident);
                Iterator<ItemRoutingInformation> iterator = needs.iterator();
                while (iterator.hasNext()) {
                    ItemRoutingInformation need = iterator.next();
                    if (need.getItem().getStackSize() > itemAmount) continue;
                    if (!this.useEnergy(6)) {
                        return contentchanged;
                    }
                    ItemStack toSend = inv.getMultipleItems(ident, need.getItem().getStackSize());
                    if (toSend == null) {
                        return contentchanged;
                    }
                    if (toSend.field_77994_a != need.getItem().getStackSize()) {
                        if (inv instanceof ITransactor) {
                            ((ITransactor)((Object)inv)).add(toSend, dir.getOpposite(), true);
                        } else {
                            this.container.func_145831_w().func_72838_d((Entity)ItemIdentifierStack.getFromStack(toSend).makeEntityItem(this.getWorld(), this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e));
                        }
                        new UnsupportedOperationException("The extracted amount didn't match the requested one. (" + inv + ")").printStackTrace();
                        return contentchanged;
                    }
                    this.sendStack(need, dir);
                    iterator.remove();
                    contentchanged = true;
                    if (needs.isEmpty()) {
                        this.itemsOnRoute.remove(ident);
                    }
                    if ((amounts = inv.getItemsAndCount()).containsKey(ident)) {
                        itemAmount = amounts.get(ident);
                        continue;
                    }
                    itemAmount = 0;
                    continue block0;
                }
            }
        }
        return contentchanged;
    }

    public void sendStack(ItemRoutingInformation info, ForgeDirection dir) {
        LPTravelingItem.LPTravelingItemServer itemToSend = SimpleServiceLocator.routedItemHelper.createNewTravelItem(info);
        super.queueRoutedItem(itemToSend, dir);
        this.spawnParticle(Particles.OrangeParticle, 4);
    }

    private UUID getConnectionUUID() {
        if (this.inv != null && this.inv.func_70301_a(0) != null && this.inv.func_70301_a(0).func_77942_o() && this.inv.func_70301_a(0).func_77978_p().func_74764_b("UUID")) {
            return UUID.fromString(this.inv.func_70301_a(0).func_77978_p().func_74779_i("UUID"));
        }
        return null;
    }

    private boolean hasConnectionUUID() {
        return this.inv != null && this.inv.func_70301_a(0) != null && this.inv.func_70301_a(0).func_77942_o() && this.inv.func_70301_a(0).func_77978_p().func_74764_b("UUID");
    }

    private void dropFreqCard() {
        if (this.inv.func_70301_a(0) == null) {
            return;
        }
        EntityItem item = new EntityItem(this.getWorld(), (double)this.getX(), (double)this.getY(), (double)this.getZ(), this.inv.func_70301_a(0));
        this.getWorld().func_72838_d((Entity)item);
        this.inv.clearInventorySlotContents(0);
    }

    public Set<ItemIdentifierStack> getExpectedItems() {
        TreeSet<ItemIdentifierStack> list = new TreeSet<ItemIdentifierStack>();
        for (Map.Entry<ItemIdentifier, List<ItemRoutingInformation>> entry : this.itemsOnRoute.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            ItemIdentifierStack currentStack = new ItemIdentifierStack(entry.getKey(), 0);
            for (ItemRoutingInformation e : entry.getValue()) {
                currentStack.setStackSize(currentStack.getStackSize() + e.getItem().getStackSize());
            }
            list.add(currentStack);
        }
        return list;
    }

    @Override
    public void onWrenchClicked(EntityPlayer entityplayer) {
        entityplayer.openGui((Object)LogisticsPipes.instance, 16, this.getWorld(), this.getX(), this.getY(), this.getZ());
    }

    @Override
    public void onAllowedRemoval() {
        if (!this.stillNeedReplace) {
            CoreRoutedPipe CRP = SimpleServiceLocator.connectionManager.getConnectedPipe(this.getRouter());
            SimpleServiceLocator.connectionManager.removeDirectConnection(this.getRouter());
            if (CRP != null) {
                CRP.refreshRender(true);
            }
        }
        this.dropFreqCard();
    }

    @Override
    public void invalidate() {
        if (!this.stillNeedReplace) {
            CoreRoutedPipe CRP = SimpleServiceLocator.connectionManager.getConnectedPipe(this.getRouter());
            SimpleServiceLocator.connectionManager.removeDirectConnection(this.getRouter());
            if (CRP != null) {
                CRP.refreshRender(true);
            }
        }
        this.init = false;
        super.invalidate();
    }

    @Override
    public void onChunkUnload() {
        if (!this.stillNeedReplace) {
            CoreRoutedPipe CRP = SimpleServiceLocator.connectionManager.getConnectedPipe(this.getRouter());
            SimpleServiceLocator.connectionManager.removeDirectConnection(this.getRouter());
            if (CRP != null) {
                CRP.refreshRender(true);
            }
        }
        this.init = false;
        super.onChunkUnload();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.inv.writeToNBT(nbttagcompound, "");
        nbttagcompound.func_74768_a("resistance", this.resistance);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.inv.readFromNBT(nbttagcompound, "");
        this.resistance = nbttagcompound.func_74762_e("resistance");
    }

    private boolean hasRemoteConnection() {
        return this.hasConnectionUUID() && this.getWorld() != null && SimpleServiceLocator.connectionManager.hasDirectConnection(this.getRouter());
    }

    private boolean inventoryConnected() {
        for (int i = 0; i < 6; ++i) {
            LPPosition p = new LPPosition(this.getX(), this.getY(), this.getZ());
            p.moveForward(ForgeDirection.values()[i]);
            TileEntity tile = p.getTileEntity(this.getWorld());
            if (!(tile instanceof IInventory)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        if (!this.stillNeedReplace && this.hasRemoteConnection()) {
            if (this.inventoryConnected()) {
                return Textures.LOGISTICSPIPE_INVSYSCON_CON_TEXTURE;
            }
            return Textures.LOGISTICSPIPE_INVSYSCON_MIS_TEXTURE;
        }
        return Textures.LOGISTICSPIPE_INVSYSCON_DIS_TEXTURE;
    }

    @Override
    public LogisticsModule getLogisticsModule() {
        return null;
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Fast;
    }

    @Override
    public int getConnectionResistance() {
        return this.resistance;
    }

    @Override
    public void addItem(ItemRoutingInformation info) {
        if (info.getItem() != null && info.getItem().getStackSize() > 0 && info.destinationint >= 0) {
            ItemIdentifier insertedType = info.getItem().getItem();
            List<ItemRoutingInformation> entry = this.itemsOnRoute.get(insertedType);
            if (entry == null) {
                entry = new LinkedList<ItemRoutingInformation>();
                this.itemsOnRoute.put(insertedType, entry);
            }
            entry.add(info);
            this.updateContentListener();
        }
    }

    public boolean isConnectedInv(TileEntity tile) {
        for (int i = 0; i < 6; ++i) {
            LPPosition p = new LPPosition(this.getX(), this.getY(), this.getZ());
            p.moveForward(ForgeDirection.values()[i]);
            TileEntity lTile = p.getTileEntity(this.getWorld());
            if (!(lTile instanceof IInventory)) continue;
            return lTile == tile;
        }
        return false;
    }

    public void handleItemEnterInv(ItemRoutingInformation info, TileEntity tile) {
        CoreRoutedPipe CRP;
        if (info.getItem().getStackSize() == 0) {
            return;
        }
        if (this.isConnectedInv(tile) && this.hasRemoteConnection() && (CRP = SimpleServiceLocator.connectionManager.getConnectedPipe(this.getRouter())) instanceof IDirectRoutingConnection) {
            IDirectRoutingConnection pipe = (IDirectRoutingConnection)((Object)CRP);
            pipe.addItem(info);
            this.spawnParticle(Particles.OrangeParticle, 4);
        }
    }

    @Override
    public void startWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartWatchingPacket.class).setInteger(1).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    @Override
    public void stopWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopWatchingPacket.class).setInteger(1).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    @Override
    public IHeadUpDisplayRenderer getRenderer() {
        return this.HUD;
    }

    private void updateContentListener() {
        Set<ItemIdentifierStack> newList;
        if (!this.localModeWatchers.isEmpty() && !(newList = this.getExpectedItems()).equals(this.oldList)) {
            this.oldList = newList;
            MainProxy.sendToPlayerList(PacketHandler.getPacket(OrdererManagerContent.class).setIdentSet(newList).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), this.localModeWatchers);
        }
    }

    @Override
    public void playerStartWatching(EntityPlayer player, int mode) {
        if (mode == 1) {
            this.localModeWatchers.add(player);
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(OrdererManagerContent.class).setIdentSet(this.getExpectedItems()).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), player);
        } else {
            super.playerStartWatching(player, mode);
        }
    }

    @Override
    public void playerStopWatching(EntityPlayer player, int mode) {
        super.playerStopWatching(player, mode);
        this.localModeWatchers.remove(player);
    }

    @Override
    public void setOrderManagerContent(Collection<ItemIdentifierStack> list) {
        this.displayList.clear();
        this.displayList.addAll(list);
    }
}

