/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import logisticspipes.LogisticsPipes;
import logisticspipes.gui.hud.HUDProvider;
import logisticspipes.interfaces.IChangeListener;
import logisticspipes.interfaces.IChestContentReceiver;
import logisticspipes.interfaces.IHeadUpDisplayRenderer;
import logisticspipes.interfaces.IHeadUpDisplayRendererProvider;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.IOrderManagerContentReceiver;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.interfaces.routing.IProvideItems;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.logistics.LogisticsManager;
import logisticspipes.logisticspipes.ExtractionMode;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.modules.ModuleProvider;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.hud.ChestContent;
import logisticspipes.network.packets.hud.HUDStartWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopWatchingPacket;
import logisticspipes.network.packets.modules.ProviderPipeInclude;
import logisticspipes.network.packets.modules.ProviderPipeMode;
import logisticspipes.network.packets.orderer.OrdererManagerContent;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.request.RequestTree;
import logisticspipes.request.RequestTreeNode;
import logisticspipes.request.resources.DictResource;
import logisticspipes.request.resources.ItemResource;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.LogisticsPromise;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LogisticsItemOrder;
import logisticspipes.routing.order.LogisticsItemOrderManager;
import logisticspipes.routing.order.LogisticsOrder;
import logisticspipes.textures.Textures;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.utils.AdjacentTile;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.SidedInventoryMinecraftAdapter;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.WorldUtil;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class PipeItemsProviderLogistics
extends CoreRoutedPipe
implements IProvideItems,
IHeadUpDisplayRendererProvider,
IChestContentReceiver,
IChangeListener,
IOrderManagerContentReceiver {
    public final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    private final Map<ItemIdentifier, Integer> displayMap = new TreeMap<ItemIdentifier, Integer>();
    public final ArrayList<ItemIdentifierStack> displayList = new ArrayList();
    private final ArrayList<ItemIdentifierStack> oldList = new ArrayList();
    public final LinkedList<ItemIdentifierStack> oldManagerList = new LinkedList();
    public final LinkedList<ItemIdentifierStack> itemListOrderer = new LinkedList();
    private final HUDProvider HUD = new HUDProvider(this);
    protected LogisticsItemOrderManager _orderManager = new LogisticsItemOrderManager(this, this);
    private boolean doContentUpdate = true;
    protected ModuleProvider myModule;
    private ItemIdentifierInventory providingInventory = new ItemIdentifierInventory(9, "", 1);
    private boolean _filterIsExclude;
    private ExtractionMode _extractionMode = ExtractionMode.Normal;

    public PipeItemsProviderLogistics(Item item) {
        super(item);
    }

    public PipeItemsProviderLogistics(Item item, LogisticsItemOrderManager logisticsOrderManager) {
        this(item);
        this._orderManager = logisticsOrderManager;
        this.myModule = new ModuleProvider();
        this.myModule.registerHandler(this, this);
    }

    @Override
    public void onAllowedRemoval() {
        while (this._orderManager.hasOrders(IOrderInfoProvider.ResourceType.PROVIDER)) {
            this._orderManager.sendFailed();
        }
    }

    public int getTotalItemCount(ItemIdentifier item) {
        if (!this.isEnabled()) {
            return 0;
        }
        if (this.hasFilter() && (this.isExcludeFilter() && this.itemIsFiltered(item) || !this.isExcludeFilter() && !this.itemIsFiltered(item))) {
            return 0;
        }
        int count = 0;
        WorldUtil wUtil = new WorldUtil(this.getWorld(), this.getX(), this.getY(), this.getZ());
        for (AdjacentTile tile : wUtil.getAdjacentTileEntities(true)) {
            if (!(tile.tile instanceof IInventory) || SimpleServiceLocator.pipeInformationManager.isItemPipe(tile.tile)) continue;
            IInventoryUtil inv = this.getAdaptedInventoryUtil(tile);
            count += inv.itemCount(item);
        }
        return count;
    }

    protected int neededEnergy() {
        return 1;
    }

    protected int itemsToExtract() {
        return 8;
    }

    protected int stacksToExtract() {
        return 1;
    }

    private int sendStack(ItemIdentifierStack stack, int maxCount, int destination, IAdditionalTargetInformation info) {
        ItemIdentifier item = stack.getItem();
        WorldUtil wUtil = new WorldUtil(this.getWorld(), this.getX(), this.getY(), this.getZ());
        for (AdjacentTile tile : wUtil.getAdjacentTileEntities(true)) {
            IInventoryUtil inv;
            int available;
            if (!(tile.tile instanceof IInventory) || SimpleServiceLocator.pipeInformationManager.isItemPipe(tile.tile) || (available = (inv = this.getAdaptedInventoryUtil(tile)).itemCount(item)) == 0) continue;
            int wanted = Math.min(available, stack.getStackSize());
            wanted = Math.min(wanted, maxCount);
            wanted = Math.min(wanted, item.getMaxStackSize());
            IRouter dRtr = SimpleServiceLocator.routerManager.getRouterUnsafe(destination, false);
            if (dRtr == null) {
                this._orderManager.sendFailed();
                return 0;
            }
            SinkReply reply = LogisticsManager.canSink(dRtr, null, true, stack.getItem(), null, true, false);
            boolean defersend = false;
            if (reply != null && reply.maxNumberOfItems < wanted) {
                wanted = reply.maxNumberOfItems;
                if (wanted <= 0) {
                    this._orderManager.deferSend();
                    return 0;
                }
                defersend = true;
            }
            if (!this.canUseEnergy(wanted * this.neededEnergy())) {
                return -1;
            }
            ItemStack removed = inv.getMultipleItems(item, wanted);
            if (removed == null || removed.field_77994_a == 0) continue;
            int sent = removed.field_77994_a;
            this.useEnergy(sent * this.neededEnergy());
            LPTravelingItem.LPTravelingItemServer routedItem = SimpleServiceLocator.routedItemHelper.createNewTravelItem(removed);
            routedItem.setDestination(destination);
            routedItem.setTransportMode(IRoutedItem.TransportMode.Active);
            routedItem.setAdditionalTargetInformation(info);
            super.queueRoutedItem(routedItem, tile.orientation);
            this._orderManager.sendSuccessfull(sent, defersend, routedItem);
            return sent;
        }
        this._orderManager.sendFailed();
        return 0;
    }

    private IInventoryUtil getAdaptedInventoryUtil(AdjacentTile tile) {
        IInventory base = (IInventory)tile.tile;
        if (base instanceof ISidedInventory) {
            base = new SidedInventoryMinecraftAdapter((ISidedInventory)base, tile.orientation.getOpposite(), true);
        }
        ExtractionMode mode = this.getExtractionMode();
        switch (mode) {
            case LeaveFirst: {
                return SimpleServiceLocator.inventoryUtilFactory.getHidingInventoryUtil(base, tile.orientation.getOpposite(), false, false, 1, 0);
            }
            case LeaveLast: {
                return SimpleServiceLocator.inventoryUtilFactory.getHidingInventoryUtil(base, tile.orientation.getOpposite(), false, false, 0, 1);
            }
            case LeaveFirstAndLast: {
                return SimpleServiceLocator.inventoryUtilFactory.getHidingInventoryUtil(base, tile.orientation.getOpposite(), false, false, 1, 1);
            }
            case Leave1PerStack: {
                return SimpleServiceLocator.inventoryUtilFactory.getHidingInventoryUtil(base, tile.orientation.getOpposite(), true, false, 0, 0);
            }
            case Leave1PerType: {
                return SimpleServiceLocator.inventoryUtilFactory.getHidingInventoryUtil(base, tile.orientation.getOpposite(), false, true, 0, 0);
            }
        }
        return SimpleServiceLocator.inventoryUtilFactory.getHidingInventoryUtil(base, tile.orientation.getOpposite(), false, false, 0, 0);
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_PROVIDER_TEXTURE;
    }

    private int getAvailableItemCount(ItemIdentifier item) {
        if (!this.isEnabled()) {
            return 0;
        }
        return this.getTotalItemCount(item) - this._orderManager.totalItemsCountInOrders(item);
    }

    @Override
    public void enabledUpdateEntity() {
        int sent;
        super.enabledUpdateEntity();
        if (this.isNthTick(6)) {
            this.updateInv(null);
        }
        if (this.doContentUpdate) {
            this.checkContentUpdate(null);
        }
        if (!this._orderManager.hasOrders(IOrderInfoProvider.ResourceType.PROVIDER) || this.getWorld().func_82737_E() % 6L != 0L) {
            return;
        }
        int itemsleft = this.itemsToExtract();
        LogisticsItemOrder firstOrder = null;
        LogisticsItemOrder order = null;
        for (int stacksleft = this.stacksToExtract(); itemsleft > 0 && stacksleft > 0 && this._orderManager.hasOrders(IOrderInfoProvider.ResourceType.PROVIDER) && (firstOrder == null || firstOrder != order); --stacksleft, itemsleft -= sent) {
            if (firstOrder == null) {
                firstOrder = order;
            }
            if ((sent = this.sendStack((order = this._orderManager.peekAtTopRequest(IOrderInfoProvider.ResourceType.PROVIDER)).getItemStack(), itemsleft, order.getRouter().getSimpleID(), order.getInformation())) < 0) break;
            this.spawnParticle(Particles.VioletParticle, 3);
        }
    }

    @Override
    public void canProvide(RequestTreeNode tree, RequestTree root, List<IFilter> filters) {
        if (!this.isEnabled()) {
            return;
        }
        if (tree.getRequestType() instanceof ItemResource) {
            ItemIdentifier item = ((ItemResource)tree.getRequestType()).getItem();
            for (IFilter filter : filters) {
                if (filter.isBlocked() != filter.isFilteredItem(item.getUndamaged()) && !filter.blockProvider()) continue;
                return;
            }
            int canProvide = this.getAvailableItemCount(item);
            if ((canProvide -= root.getAllPromissesFor(this, item)) < 1) {
                return;
            }
            LogisticsPromise promise = new LogisticsPromise(item, Math.min(canProvide, tree.getMissingAmount()), this, IOrderInfoProvider.ResourceType.PROVIDER);
            tree.addPromise(promise);
        } else if (tree.getRequestType() instanceof DictResource) {
            DictResource dict = (DictResource)tree.getRequestType();
            HashMap<ItemIdentifier, Integer> available = new HashMap<ItemIdentifier, Integer>();
            this.getAllItems(available, filters);
            for (Map.Entry<ItemIdentifier, Integer> item : available.entrySet()) {
                if (!dict.matches(item.getKey())) continue;
                int canProvide = this.getAvailableItemCount(item.getKey());
                if ((canProvide -= root.getAllPromissesFor(this, item.getKey())) < 1) continue;
                LogisticsPromise promise = new LogisticsPromise(item.getKey(), Math.min(canProvide, tree.getMissingAmount()), this, IOrderInfoProvider.ResourceType.PROVIDER);
                tree.addPromise(promise);
                if (tree.getMissingAmount() > 0) continue;
                break;
            }
        }
    }

    @Override
    public LogisticsOrder fullFill(LogisticsPromise promise, IRequestItems destination, IAdditionalTargetInformation info) {
        this.spawnParticle(Particles.WhiteParticle, 2);
        return this._orderManager.addOrder(new ItemIdentifierStack(promise.item, promise.numberOfItems), destination, IOrderInfoProvider.ResourceType.PROVIDER, info);
    }

    @Override
    public void getAllItems(Map<ItemIdentifier, Integer> items, List<IFilter> filters) {
        if (!this.isEnabled()) {
            return;
        }
        HashMap<ItemIdentifier, Integer> addedItems = new HashMap<ItemIdentifier, Integer>();
        WorldUtil wUtil = new WorldUtil(this.getWorld(), this.getX(), this.getY(), this.getZ());
        for (AdjacentTile adjacentTile : wUtil.getAdjacentTileEntities(true)) {
            if (!(adjacentTile.tile instanceof IInventory) || SimpleServiceLocator.pipeInformationManager.isItemPipe(adjacentTile.tile)) continue;
            IInventoryUtil inv = this.getAdaptedInventoryUtil(adjacentTile);
            Map<ItemIdentifier, Integer> currentInv = inv.getItemsAndCount();
            block1: for (Map.Entry<ItemIdentifier, Integer> currItem : currentInv.entrySet()) {
                if (items.containsKey(currItem.getKey()) || this.hasFilter() && (this.isExcludeFilter() && this.itemIsFiltered(currItem.getKey()) || !this.isExcludeFilter() && !this.itemIsFiltered(currItem.getKey()))) continue;
                for (IFilter filter : filters) {
                    if (filter.isBlocked() != filter.isFilteredItem(currItem.getKey().getUndamaged()) && !filter.blockProvider()) continue;
                    continue block1;
                }
                Integer addedAmount = (Integer)addedItems.get(currItem.getKey());
                if (addedAmount == null) {
                    addedItems.put(currItem.getKey(), currItem.getValue());
                    continue;
                }
                addedItems.put(currItem.getKey(), addedAmount + currItem.getValue());
            }
        }
        for (Map.Entry entry : addedItems.entrySet()) {
            int remaining = (Integer)entry.getValue() - this._orderManager.totalItemsCountInOrders((ItemIdentifier)entry.getKey());
            if (remaining < 1) continue;
            items.put((ItemIdentifier)entry.getKey(), remaining);
        }
    }

    @Override
    public LogisticsModule getLogisticsModule() {
        return null;
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public void startWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartWatchingPacket.class).setInteger(1).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    @Override
    public void stopWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopWatchingPacket.class).setInteger(1).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    private void updateInv(EntityPlayer player) {
        if (this.localModeWatchers.size() == 0 && player == null) {
            return;
        }
        this.displayList.clear();
        this.displayMap.clear();
        this.getAllItems(this.displayMap, new ArrayList<IFilter>(0));
        this.displayList.ensureCapacity(this.displayMap.size());
        for (Map.Entry<ItemIdentifier, Integer> item : this.displayMap.entrySet()) {
            this.displayList.add(new ItemIdentifierStack(item.getKey(), item.getValue()));
        }
        if (!this.oldList.equals(this.displayList)) {
            this.oldList.clear();
            this.oldList.ensureCapacity(this.displayList.size());
            this.oldList.addAll(this.displayList);
            MainProxy.sendToPlayerList(PacketHandler.getPacket(ChestContent.class).setIdentList(this.displayList).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), this.localModeWatchers);
        } else if (player != null) {
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(ChestContent.class).setIdentList(this.displayList).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), player);
        }
    }

    @Override
    public void listenedChanged() {
        this.doContentUpdate = true;
    }

    private void checkContentUpdate(EntityPlayer player) {
        this.doContentUpdate = false;
        LinkedList<ItemIdentifierStack> all = this._orderManager.getContentList(this.getWorld());
        if (!this.oldManagerList.equals(all)) {
            this.oldManagerList.clear();
            this.oldManagerList.addAll(all);
            MainProxy.sendToPlayerList(PacketHandler.getPacket(OrdererManagerContent.class).setIdentList(all).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), this.localModeWatchers);
        } else if (player != null) {
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(OrdererManagerContent.class).setIdentList(all).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), player);
        }
    }

    @Override
    public void playerStartWatching(EntityPlayer player, int mode) {
        if (mode == 1) {
            this.localModeWatchers.add(player);
            this.updateInv(player);
            this.checkContentUpdate(player);
        } else {
            super.playerStartWatching(player, mode);
        }
    }

    @Override
    public void playerStopWatching(EntityPlayer player, int mode) {
        super.playerStopWatching(player, mode);
        this.localModeWatchers.remove(player);
    }

    @Override
    public void setReceivedChestContent(Collection<ItemIdentifierStack> list) {
        this.displayList.clear();
        this.displayList.ensureCapacity(list.size());
        this.displayList.addAll(list);
    }

    @Override
    public IHeadUpDisplayRenderer getRenderer() {
        return this.HUD;
    }

    @Override
    public void setOrderManagerContent(Collection<ItemIdentifierStack> list) {
        this.itemListOrderer.clear();
        this.itemListOrderer.addAll(list);
    }

    @Override
    public Set<ItemIdentifier> getSpecificInterests() {
        WorldUtil wUtil = new WorldUtil(this.getWorld(), this.getX(), this.getY(), this.getZ());
        Set<ItemIdentifier> l1 = null;
        for (AdjacentTile tile : wUtil.getAdjacentTileEntities(true)) {
            if (!(tile.tile instanceof IInventory) || SimpleServiceLocator.pipeInformationManager.isItemPipe(tile.tile)) continue;
            IInventoryUtil inv = this.getAdaptedInventoryUtil(tile);
            Set<ItemIdentifier> items = inv.getItems();
            if (l1 == null) {
                l1 = items;
                continue;
            }
            l1.addAll(items);
        }
        return l1;
    }

    @Override
    public double getLoadFactor() {
        return (double)(this._orderManager.totalAmountCountInAllOrders() + 63) / 64.0;
    }

    @Override
    public void onWrenchClicked(EntityPlayer entityplayer) {
        entityplayer.openGui((Object)LogisticsPipes.instance, 12, this.getWorld(), this.getX(), this.getY(), this.getZ());
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(ProviderPipeMode.class).setInteger(this.getExtractionMode().ordinal()).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), entityplayer);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(ProviderPipeInclude.class).setInteger(this.isExcludeFilter() ? 1 : 0).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), entityplayer);
    }

    public ItemIdentifierInventory getprovidingInventory() {
        return this.providingInventory;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.providingInventory.readFromNBT(nbttagcompound, "");
        this._filterIsExclude = nbttagcompound.func_74767_n("filterisexclude");
        this._extractionMode = ExtractionMode.getMode(nbttagcompound.func_74762_e("extractionMode"));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.providingInventory.writeToNBT(nbttagcompound, "");
        nbttagcompound.func_74757_a("filterisexclude", this._filterIsExclude);
        nbttagcompound.func_74768_a("extractionMode", this._extractionMode.ordinal());
    }

    public boolean hasFilter() {
        return !this.providingInventory.isEmpty();
    }

    public boolean itemIsFiltered(ItemIdentifier item) {
        return this.providingInventory.containsItem(item);
    }

    public boolean isExcludeFilter() {
        return this._filterIsExclude;
    }

    public void setFilterExcluded(boolean isExcluded) {
        this._filterIsExclude = isExcluded;
    }

    public ExtractionMode getExtractionMode() {
        return this._extractionMode;
    }

    public void setExtractionMode(int id) {
        this._extractionMode = ExtractionMode.getMode(id);
    }

    public void nextExtractionMode() {
        this._extractionMode = this._extractionMode.next();
    }
}

