/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes.basic.debug;

import java.util.ArrayList;
import java.util.List;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.debug.SendNewLogLine;
import logisticspipes.network.packets.debug.SendNewLogWindow;
import logisticspipes.network.packets.debug.UpdateStatusEntries;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import logisticspipes.pipes.basic.debug.StatusEntry;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.PlayerCollectionList;
import net.minecraft.entity.player.EntityPlayer;

public class DebugLogController {
    private static int nextID = 0;
    private final int ID = nextID++;
    public final CoreUnroutedPipe pipe;
    public boolean debugThisPipe = false;
    private List<StatusEntry> oldList = new ArrayList<StatusEntry>();
    private PlayerCollectionList players = new PlayerCollectionList();

    public DebugLogController(CoreUnroutedPipe pipe) {
        this.pipe = pipe;
    }

    public void log(String info) {
        if (this.players.isEmptyWithoutCheck()) {
            return;
        }
        MainProxy.sendToPlayerList(PacketHandler.getPacket(SendNewLogLine.class).setWindowID(this.ID).setLine(info), this.players);
    }

    public void tick() {
        if (this.players.isEmpty()) {
            return;
        }
        this.generateStatus();
    }

    public void generateStatus() {
        ArrayList<StatusEntry> status = new ArrayList<StatusEntry>();
        this.pipe.addStatusInformation(status);
        if (!status.equals(this.oldList)) {
            MainProxy.sendToPlayerList(PacketHandler.getPacket(UpdateStatusEntries.class).setWindowID(this.ID).setStatus(status), this.players);
            this.oldList = status;
        }
    }

    public void openForPlayer(EntityPlayer player) {
        this.players.add(player);
        ArrayList<StatusEntry> status = new ArrayList<StatusEntry>();
        this.pipe.addStatusInformation(status);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(SendNewLogWindow.class).setWindowID(this.ID).setTitle(this.pipe.toString()), player);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(UpdateStatusEntries.class).setWindowID(this.ID).setStatus(status), player);
    }
}

