/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.specialinventoryhandler;

import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import logisticspipes.proxy.specialinventoryhandler.SpecialInventoryHandler;
import logisticspipes.utils.item.ItemIdentifier;
import mcp.mobius.betterbarrels.common.blocks.IBarrelStorage;
import mcp.mobius.betterbarrels.common.blocks.TileEntityBarrel;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class JABBAInventoryHandler
extends SpecialInventoryHandler {
    private final TileEntityBarrel _tile;
    private final IBarrelStorage _storage;
    private final boolean _hideOnePerStack;

    private JABBAInventoryHandler(TileEntity tile, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        this._tile = (TileEntityBarrel)tile;
        this._storage = this._tile.getStorage();
        this._hideOnePerStack = hideOnePerStack || hideOne;
    }

    public JABBAInventoryHandler() {
        this._tile = null;
        this._storage = null;
        this._hideOnePerStack = false;
    }

    @Override
    public boolean init() {
        return true;
    }

    @Override
    public boolean isType(TileEntity tile) {
        return tile instanceof TileEntityBarrel;
    }

    @Override
    public SpecialInventoryHandler getUtilForTile(TileEntity tile, ForgeDirection dir, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        return new JABBAInventoryHandler(tile, hideOnePerStack, hideOne, cropStart, cropEnd);
    }

    @Override
    public int itemCount(ItemIdentifier itemIdent) {
        ItemStack items = this._storage.getStoredItemType();
        if (items != null && ItemIdentifier.get(items).equals(itemIdent)) {
            return this._storage.isCreative() ? (int)Math.pow(2.0, 20.0) : items.field_77994_a - (this._hideOnePerStack ? 1 : 0);
        }
        return 0;
    }

    @Override
    public ItemStack getMultipleItems(ItemIdentifier itemIdent, int count) {
        ItemStack items = this._storage.getStoredItemType();
        if (items == null || !ItemIdentifier.get(items).equals(itemIdent)) {
            return null;
        }
        if (this._storage.isCreative()) {
            return itemIdent.makeNormalStack(count);
        }
        if (this._hideOnePerStack) {
            --items.field_77994_a;
        }
        if (count >= items.field_77994_a) {
            this._storage.setStoredItemCount(this._hideOnePerStack ? 1 : 0);
            this._tile.func_70296_d();
            return items;
        }
        ItemStack newItems = items.func_77979_a(count);
        this._storage.setStoredItemCount(items.field_77994_a + (this._hideOnePerStack ? 1 : 0));
        this._tile.func_70296_d();
        return newItems;
    }

    @Override
    public Set<ItemIdentifier> getItems() {
        TreeSet<ItemIdentifier> result = new TreeSet<ItemIdentifier>();
        ItemStack items = this._storage.getStoredItemType();
        if (items != null) {
            result.add(ItemIdentifier.get(items));
        }
        return result;
    }

    public HashMap<ItemIdentifier, Integer> getItemsAndCount() {
        HashMap<ItemIdentifier, Integer> result = new HashMap<ItemIdentifier, Integer>();
        ItemStack items = this._storage.getStoredItemType();
        if (items != null && items.field_77994_a > 0) {
            result.put(ItemIdentifier.get(items), this._storage.isCreative() ? (int)Math.pow(2.0, 20.0) : items.field_77994_a - (this._hideOnePerStack ? 1 : 0));
        }
        return result;
    }

    @Override
    public ItemStack getSingleItem(ItemIdentifier itemIdent) {
        return this.getMultipleItems(itemIdent, 1);
    }

    @Override
    public boolean containsItem(ItemIdentifier itemIdent) {
        ItemStack items = this._storage.getStoredItemType();
        return items != null && this._storage.sameItem(itemIdent.makeNormalStack(1));
    }

    @Override
    public boolean containsUndamagedItem(ItemIdentifier itemIdent) {
        ItemStack items = this._storage.getStoredItemType();
        return items != null && ItemIdentifier.get(items).getUndamaged().equals(itemIdent);
    }

    @Override
    public int roomForItem(ItemIdentifier item) {
        return this.roomForItem(item, 0);
    }

    @Override
    public int roomForItem(ItemIdentifier itemIdent, int count) {
        if (itemIdent.tag != null) {
            return 0;
        }
        ItemStack items = this._storage.getStoredItemType();
        if (items == null) {
            return this._storage.getMaxStoredCount();
        }
        if (this._storage.sameItem(itemIdent.makeNormalStack(1))) {
            if (this._storage.isVoid()) {
                return this._storage.getMaxStoredCount();
            }
            return this._storage.getMaxStoredCount() - items.field_77994_a;
        }
        return 0;
    }

    @Override
    public ItemStack add(ItemStack stack, ForgeDirection from, boolean doAdd) {
        ItemStack st = stack.func_77946_l();
        st.field_77994_a = 0;
        if (stack.func_77978_p() != null) {
            return st;
        }
        ItemStack items = this._storage.getStoredItemType();
        if (items == null || items.field_77994_a == 0) {
            if (stack.field_77994_a <= this._storage.getMaxStoredCount()) {
                this._storage.setStoredItemType(stack, stack.field_77994_a);
                st.field_77994_a = stack.field_77994_a;
                this._tile.func_70296_d();
                return st;
            }
            this._storage.setStoredItemType(stack, this._storage.getMaxStoredCount());
            st.field_77994_a = this._storage.getMaxStoredCount();
            this._tile.func_70296_d();
            return st;
        }
        if (!this._storage.sameItem(stack)) {
            return st;
        }
        if (stack.field_77994_a <= this._storage.getMaxStoredCount() - items.field_77994_a) {
            this._storage.setStoredItemCount(items.field_77994_a + stack.field_77994_a);
            st.field_77994_a = stack.field_77994_a;
            this._tile.func_70296_d();
            return st;
        }
        this._storage.setStoredItemCount(this._storage.getMaxStoredCount());
        st.field_77994_a = !this._storage.isVoid() ? this._storage.getMaxStoredCount() - items.field_77994_a : stack.field_77994_a;
        this._tile.func_70296_d();
        return st;
    }

    @Override
    public boolean isSpecialInventory() {
        return true;
    }

    @Override
    public int getSizeInventory() {
        return 1;
    }

    @Override
    public ItemStack getStackInSlot(int i) {
        if (i != 0) {
            return null;
        }
        return this._storage.getStoredItemType();
    }

    @Override
    public ItemStack decrStackSize(int i, int j) {
        if (i != 0) {
            return null;
        }
        return this.getMultipleItems(ItemIdentifier.get(this._storage.getStoredItemType()), j);
    }
}

