/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.specialinventoryhandler;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IVoidable;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.InvalidVersionSpecificationException;
import cpw.mods.fml.common.versioning.VersionRange;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import logisticspipes.proxy.specialinventoryhandler.SpecialInventoryHandler;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class StorageDrawersInventoryHandler
extends SpecialInventoryHandler {
    private final IDrawerGroup _drawer;
    private final boolean _hideOnePerStack;
    private final boolean _hideOnePerType;

    private StorageDrawersInventoryHandler(TileEntity tile, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        this._drawer = (IDrawerGroup)tile;
        this._hideOnePerStack = hideOnePerStack;
        this._hideOnePerType = hideOne;
    }

    public StorageDrawersInventoryHandler() {
        this._drawer = null;
        this._hideOnePerStack = false;
        this._hideOnePerType = false;
    }

    @Override
    public boolean init() {
        List modList = Loader.instance().getModList();
        int n = modList.size();
        for (int i = 0; i < n; ++i) {
            ModContainer mod = (ModContainer)modList.get(i);
            if (!mod.getModId().equals("StorageDrawers")) continue;
            try {
                VersionRange validVersions = VersionRange.createFromVersionSpec((String)"[1.3.4,)");
                DefaultArtifactVersion version = new DefaultArtifactVersion(mod.getVersion());
                return validVersions.containsVersion((ArtifactVersion)version);
            }
            catch (InvalidVersionSpecificationException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isType(TileEntity tile) {
        return tile instanceof IDrawerGroup;
    }

    @Override
    public SpecialInventoryHandler getUtilForTile(TileEntity tile, ForgeDirection dir, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        return new StorageDrawersInventoryHandler(tile, hideOnePerStack, hideOne, cropStart, cropEnd);
    }

    @Override
    public int itemCount(ItemIdentifier itemIdent) {
        int count = 0;
        boolean first = true;
        for (int i = 0; i < this._drawer.getDrawerCount(); ++i) {
            IDrawer drawer;
            if (!this._drawer.isDrawerEnabled(i) || (drawer = this._drawer.getDrawer(i)) == null || drawer.isEmpty() || !ItemIdentifier.get(drawer.getStoredItemPrototype()).equals(itemIdent)) continue;
            count += drawer.getStoredItemCount() - (this._hideOnePerStack || this._hideOnePerType && first ? 1 : 0);
            first = false;
        }
        return count;
    }

    @Override
    public ItemStack getMultipleItems(ItemIdentifier itemIdent, int count) {
        ItemStack stack = null;
        for (int i = 0; i < this._drawer.getDrawerCount(); ++i) {
            IDrawer drawer;
            if (!this._drawer.isDrawerEnabled(i) || (drawer = this._drawer.getDrawer(i)) == null || drawer.isEmpty() || !ItemIdentifier.get(drawer.getStoredItemPrototype()).equals(itemIdent)) continue;
            if (stack == null) {
                stack = drawer.getStoredItemCopy();
                stack.field_77994_a = 0;
            }
            int avail = Math.min(count, drawer.getStoredItemCount());
            drawer.setStoredItemCount(drawer.getStoredItemCount() - avail);
            stack.field_77994_a += avail;
            if ((count -= avail) <= 0) break;
        }
        return stack;
    }

    @Override
    public Set<ItemIdentifier> getItems() {
        TreeSet<ItemIdentifier> result = new TreeSet<ItemIdentifier>();
        for (int i = 0; i < this._drawer.getDrawerCount(); ++i) {
            IDrawer drawer;
            if (!this._drawer.isDrawerEnabled(i) || (drawer = this._drawer.getDrawer(i)) == null || drawer.isEmpty()) continue;
            result.add(ItemIdentifier.get(drawer.getStoredItemPrototype()));
        }
        return result;
    }

    public HashMap<ItemIdentifier, Integer> getItemsAndCount() {
        HashMap<ItemIdentifier, Integer> result = new HashMap<ItemIdentifier, Integer>();
        for (int i = 0; i < this._drawer.getDrawerCount(); ++i) {
            int count;
            IDrawer drawer;
            if (!this._drawer.isDrawerEnabled(i) || (drawer = this._drawer.getDrawer(i)) == null || drawer.isEmpty() || (count = drawer.getStoredItemCount()) <= 0) continue;
            ItemIdentifier ident = ItemIdentifier.get(drawer.getStoredItemPrototype());
            if (result.containsKey(ident)) {
                result.put(ident, result.get(ident) + count);
                continue;
            }
            result.put(ident, count);
        }
        return result;
    }

    @Override
    public ItemStack getSingleItem(ItemIdentifier itemIdent) {
        return this.getMultipleItems(itemIdent, 1);
    }

    @Override
    public boolean containsItem(ItemIdentifier itemIdent) {
        for (int i = 0; i < this._drawer.getDrawerCount(); ++i) {
            IDrawer drawer;
            if (!this._drawer.isDrawerEnabled(i) || (drawer = this._drawer.getDrawer(i)) == null || drawer.isEmpty() || !drawer.canItemBeStored(itemIdent.makeNormalStack(1))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsUndamagedItem(ItemIdentifier itemIdent) {
        for (int i = 0; i < this._drawer.getDrawerCount(); ++i) {
            IDrawer drawer;
            if (!this._drawer.isDrawerEnabled(i) || (drawer = this._drawer.getDrawer(i)) == null || drawer.isEmpty() || !ItemIdentifier.get(drawer.getStoredItemPrototype()).getUndamaged().equals(itemIdent)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int roomForItem(ItemIdentifier item) {
        return this.roomForItem(item, 0);
    }

    @Override
    public int roomForItem(ItemIdentifier itemIdent, int count) {
        int room = 0;
        for (int i = 0; i < this._drawer.getDrawerCount(); ++i) {
            IDrawer drawer;
            if (!this._drawer.isDrawerEnabled(i) || (drawer = this._drawer.getDrawer(i)) == null) continue;
            ItemStack protoStack = itemIdent.makeNormalStack(1);
            if (drawer.canItemBeStored(protoStack)) {
                room = drawer.isEmpty() ? (room += drawer.getMaxCapacity(protoStack)) : (drawer instanceof IVoidable && ((IVoidable)drawer).isVoid() ? (room += drawer.getMaxCapacity()) : (room += drawer.getRemainingCapacity()));
            }
            if (count == 0 || room < count) continue;
            return count;
        }
        return room;
    }

    @Override
    public ItemStack add(ItemStack stack, ForgeDirection from, boolean doAdd) {
        ItemStack st = stack.func_77946_l();
        st.field_77994_a = 0;
        for (int i = 0; i < this._drawer.getDrawerCount(); ++i) {
            IDrawer drawer;
            if (!this._drawer.isDrawerEnabled(i) || (drawer = this._drawer.getDrawer(i)) == null || !drawer.canItemBeStored(stack)) continue;
            int avail = 0;
            if (drawer.isEmpty()) {
                avail = Math.min(stack.field_77994_a, drawer.getMaxCapacity(stack));
                drawer.setStoredItem(stack.func_77946_l(), avail);
            } else {
                avail = Math.min(stack.field_77994_a, drawer.getRemainingCapacity());
                drawer.setStoredItemCount(drawer.getStoredItemCount() + avail);
            }
            if (drawer instanceof IVoidable && ((IVoidable)drawer).isVoid()) {
                return stack;
            }
            stack.field_77994_a -= avail;
            st.field_77994_a += avail;
            if (stack.field_77994_a <= 0) break;
        }
        return st;
    }

    @Override
    public boolean isSpecialInventory() {
        return true;
    }

    @Override
    public int getSizeInventory() {
        return this._drawer.getDrawerCount();
    }

    @Override
    public ItemStack getStackInSlot(int i) {
        if (!this._drawer.isDrawerEnabled(i)) {
            return null;
        }
        return this._drawer.getDrawer(i) != null ? this._drawer.getDrawer(i).getStoredItemCopy() : null;
    }

    @Override
    public ItemStack decrStackSize(int i, int j) {
        if (!this._drawer.isDrawerEnabled(i)) {
            return null;
        }
        IDrawer drawer = this._drawer.getDrawer(i);
        if (drawer == null || drawer.isEmpty()) {
            return null;
        }
        ItemStack stack = drawer.getStoredItemCopy();
        if (stack == null) {
            return null;
        }
        int avail = Math.min(j, drawer.getStoredItemCount());
        drawer.setStoredItemCount(drawer.getStoredItemCount() - avail);
        stack.field_77994_a = avail;
        return stack;
    }
}

