/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.td;

import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.TDDucts;
import cofh.thermaldynamics.duct.item.TileItemDuct;
import cofh.thermaldynamics.duct.item.TravelingItem;
import cofh.thermaldynamics.multiblock.IMultiBlock;
import java.util.ArrayList;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.ItemRoutingInformation;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import logisticspipes.utils.tuples.Triplet;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class LPItemDuct
extends TileItemDuct {
    public final LogisticsTileGenericPipe pipe;
    public final ForgeDirection dir;

    public LPItemDuct(LogisticsTileGenericPipe pipe, ForgeDirection orientation) {
        this.pipe = pipe;
        this.dir = orientation;
    }

    public TileItemDuct.RouteInfo canRouteItem(ItemStack arg0) {
        if (arg0 != null && this.pipe.pipe.isRoutedPipe() && SimpleServiceLocator.logisticsManager.hasDestination(ItemIdentifier.get(arg0), true, ((CoreRoutedPipe)this.pipe.pipe).getRouterId(), new ArrayList<Integer>()) != null) {
            return new TileItemDuct.RouteInfo(0, (byte)this.dir.getOpposite().ordinal());
        }
        return TileItemDuct.noRoute;
    }

    public void transferItem(TravelingItem item) {
        ItemRoutingInformation info = (ItemRoutingInformation)item.lpRoutingInformation;
        if (info != null) {
            info.setItem(ItemIdentifierStack.getFromStack(item.stack));
            LPTravelingItem.LPTravelingItemServer lpItem = new LPTravelingItem.LPTravelingItemServer(info);
            lpItem.setSpeed(info._transportMode == IRoutedItem.TransportMode.Active ? 0.3f : 0.2f);
            this.pipe.pipe.transport.injectItem(lpItem, ForgeDirection.getOrientation((int)item.direction));
        } else if (item.stack != null) {
            int consumed = this.pipe.injectItem(item.stack, true, this.dir);
            item.stack.field_77994_a -= consumed;
            if (item.stack.field_77994_a > 0) {
                this.pipe.pipe.transport._itemBuffer.add(new Triplet<ItemIdentifierStack, Pair<Integer, Integer>, Object>(ItemIdentifierStack.getFromStack(item.stack), new Pair<Integer, Integer>(40, 0), null));
            }
        }
    }

    public boolean isBlockedSide(int paramInt) {
        return this.isLPBlockedSide(paramInt, false);
    }

    public boolean isLPBlockedSide(int paramInt, boolean ignoreSystemDisconnect) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)paramInt);
        if (this.pipe.tilePart.hasBlockingPluggable(dir)) {
            return true;
        }
        if (this.pipe.pipe != null && this.pipe.pipe.isSideBlocked(dir, ignoreSystemDisconnect)) {
            return false;
        }
        return super.isBlockedSide(paramInt);
    }

    public Duct getDuctType() {
        if (this.duct == null) {
            this.duct = TDDucts.itemBasic;
        }
        return this.duct;
    }

    public void handleSideUpdate(int paramInt) {
        super.handleSideUpdate(paramInt);
        this.isOutput = true;
    }

    public IMultiBlock getConnectedSide(byte paramByte) {
        if (ForgeDirection.getOrientation((int)paramByte) != this.dir) {
            return null;
        }
        return super.getConnectedSide(paramByte);
    }

    public TileTDBase.NeighborTypes getCachedSideType(byte paramByte) {
        if (ForgeDirection.getOrientation((int)paramByte) != this.dir) {
            return null;
        }
        return super.getCachedSideType(paramByte);
    }

    public TileTDBase.ConnectionTypes getConnectionType(byte paramByte) {
        if (ForgeDirection.getOrientation((int)paramByte) != this.dir) {
            return null;
        }
        return super.getConnectionType(paramByte);
    }

    public IMultiBlock getCachedTile(byte paramByte) {
        if (ForgeDirection.getOrientation((int)paramByte) != this.dir) {
            return null;
        }
        return super.getCachedTile(paramByte);
    }

    public TileEntity getAdjTileEntitySafe(int ordinal) {
        if (ForgeDirection.getOrientation((int)ordinal) != this.dir) {
            return null;
        }
        return super.getAdjTileEntitySafe(ordinal);
    }
}

